/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.foundation.forms.impl.FormsUtil;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class FieldDescription {
    private String name;
    private boolean required = false;
    private String requiredMsg;
    private String constraintType;
    private String constraintMsg;
    private boolean readOnly = false;
    private boolean privateField = false;
    private boolean multiValue = false;
    private final Resource fieldResource;

    public FieldDescription(Resource rsrc) {
        this.fieldResource = rsrc;
    }

    public FieldDescription(Resource rsrc, String name) {
        this.fieldResource = rsrc;
        this.name = name;
    }

    public void update(Resource rsrc) {
        ValueMap props = ResourceUtil.getValueMap(rsrc);
        this.required = props.get("required", Boolean.FALSE);
        this.readOnly = props.get("readOnly", Boolean.FALSE);
        String name = props.get("name", "");
        if (name.length() == 0) {
            name = ResourceUtil.getName(rsrc);
            name = FormsUtil.filterElementName((String)name);
        }
        this.name = name;
        String msg = props.get("requiredMessage", "");
        if (msg.length() == 0) {
            msg = "This field is required";
        }
        this.requiredMsg = msg;
        String constraint = props.get("constraintType", "");
        if (constraint.length() > 0) {
            if (constraint.indexOf(47) == -1) {
                constraint = "foundation/components/form/constraints/" + constraint;
            }
        } else {
            constraint = null;
        }
        this.constraintType = constraint;
        msg = props.get("constraintMessage", "");
        if (msg.length() == 0) {
            msg = null;
        }
        this.constraintMsg = msg;
    }

    public Resource getFieldResource() {
        return this.fieldResource;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getRequiredMessage() {
        return this.requiredMsg;
    }

    public void setRequiredMessage(String requiredMsg) {
        this.requiredMsg = requiredMsg;
    }

    public String getConstraintType() {
        return this.constraintType;
    }

    public void setConstraintType(String constraintType) {
        this.constraintType = constraintType;
    }

    public String getConstraintMessage() {
        return this.constraintMsg;
    }

    public void setConstraintMessage(String constraintMsg) {
        this.constraintMsg = constraintMsg;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isPrivate() {
        return this.privateField;
    }

    public void setPrivateField(boolean flag) {
        this.privateField = flag;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public void setMultiValue(boolean flag) {
        this.multiValue = flag;
    }
}

