/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.rewriter.htmlparser.HtmlParser;
import com.day.cq.wcm.foundation.Table;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TableXMLBuilder
extends DefaultHandler {
    private static final Set<String> TABLE_TAGS = new HashSet<String>(Arrays.asList("TABLE", "/TABLE", "TR", "/TR", "TD", "/TD", "TH", "/TH", "CAPTION", "/CAPTION", "COL"));
    private Table table;
    private int rowNr = -1;
    private int colNr;
    private Table.Cell cell = null;
    private Table.Tag caption;

    public Table parse(Reader r) throws IOException {
        this.table = new Table();
        this.rowNr = -1;
        this.colNr = 0;
        this.cell = null;
        HtmlParser parser = new HtmlParser();
        parser.setTagInclusionSet(TABLE_TAGS);
        parser.setContentHandler(this);
        IOUtils.copy(r, (Writer)parser);
        parser.close();
        parser.finished();
        return this.table;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name = localName.toLowerCase();
        if (name.equals("table")) {
            TableXMLBuilder.addAttributes(this.table, attributes);
        } else if (name.equals("tr")) {
            ++this.rowNr;
            this.colNr = 0;
        } else if (name.equals("td") || name.equals("th")) {
            this.cell = this.table.getCell(this.rowNr, this.colNr, true);
            while (this.cell.isInSpan()) {
                this.cell = this.table.getCell(this.rowNr, ++this.colNr, true);
            }
            this.cell.setHeader(name.equals("th"));
            TableXMLBuilder.addAttributes(this.cell, attributes);
        } else if (name.equals("caption")) {
            this.caption = this.table.setCaption("");
            TableXMLBuilder.addAttributes(this.caption, attributes);
        }
    }

    private static void addAttributes(Table.Cell cell, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getLocalName(i);
            if (name.equals("quotes")) continue;
            String value = attrs.getValue(i);
            cell.setAttribute(name, value);
        }
    }

    private static void addAttributes(Table.Tag tag, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getLocalName(i);
            if (name.equals("quotes")) continue;
            String value = attrs.getValue(i);
            tag.setAttribute(name, value);
        }
    }

    private static void addAttributes(Table tag, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getLocalName(i);
            if (name.equals("quotes")) continue;
            String value = attrs.getValue(i);
            tag.setAttribute(name, value);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String name = localName.toLowerCase();
        if (name.equals("tr")) {
            this.cell = null;
        } else if (name.equals("td") || name.equals("th")) {
            ++this.colNr;
            this.cell = null;
        } else if (name.equals("caption")) {
            this.caption = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.cell != null) {
            this.cell.appendText(ch, start, length);
        } else if (this.caption != null) {
            this.caption.appendInnerHtml(ch, start, length);
        }
    }
}

