/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.designimporter.parser.taghandlers.DefaultTagHandler;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class ImgTagHandler
extends DefaultTagHandler {
    private String title;
    private String alt;
    private String width;
    private String height;
    private String usemap;
    public XSSAPI xssAPI;
    private String rawSrc;
    private String normalizedSrc;
    private boolean normalizationRequired = true;
    private String normalizationPrefix;
    private Logger logger = LoggerFactory.getLogger(ImgTagHandler.class);

    public String getTitle() {
        return this.title;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getUsemap() {
        return this.usemap;
    }

    public String getRawSrc() {
        return this.rawSrc;
    }

    public boolean isRawSrcAbsolute() {
        return this.isAbsoluteUrl(this.rawSrc);
    }

    public void setNormalizationPrefix(String normalizationPrefix) {
        this.normalizationPrefix = normalizationPrefix;
    }

    public boolean isNormalizationRequired() {
        return this.normalizationRequired;
    }

    public void setNormalizationRequired(boolean normalizationRequired) {
        this.normalizationRequired = normalizationRequired;
    }

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        super.beginHandling(uri, localName, qName, atts);
        this.width = atts.getValue("width");
        this.height = atts.getValue("height");
        this.alt = atts.getValue("alt");
        this.title = atts.getValue("title");
        this.usemap = atts.getValue("usemap");
        this.normalizedSrc = this.rawSrc = atts.getValue("src");
        if (this.normalizationPrefix == null) {
            this.normalizationPrefix = this.getDesignPath() + "/";
        }
    }

    @Override
    protected String getStartTag(String uri, String localName, String qName, Attributes atts) {
        if (this.rawSrc != null && !this.isRawSrcAbsolute() && this.isNormalizationRequired()) {
            this.normalizedSrc = this.normalizationPrefix + this.rawSrc;
        }
        String startTag = "<" + localName.toLowerCase();
        String att = "";
        for (int i = 0; i < atts.getLength(); ++i) {
            String attrName = atts.getLocalName(i);
            String attrValue = atts.getValue(i);
            att = "src".equalsIgnoreCase(attrName) ? att + " " + attrName + "=\"" + this.normalizedSrc + "\"" : att + " " + attrName + "=\"" + attrValue + "\"";
        }
        startTag = startTag + att;
        startTag = startTag + "/>";
        try {
            if (this.rawSrc != null && !this.designImporterContext.designNode.hasNode(this.rawSrc)) {
                this.designImporterContext.importWarnings.add("Could not locate the referenced image '" + this.rawSrc + "' in the design package");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return startTag;
    }

    protected boolean isAbsoluteUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private String getDesignPath() {
        try {
            String designPath = this.designImporterContext.designNode.getPath();
            if (this.xssAPI != null) {
                designPath = this.xssAPI.getValidHref(designPath);
            }
            return designPath;
        }
        catch (RepositoryException e) {
            this.logger.error("Error occurred while trying to access the path of the design node", e);
            return "";
        }
    }

    public void setXssAPI(XSSAPI xssAPI) {
        this.xssAPI = xssAPI;
    }
}

