/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.designimporter.api.CanvasBuilder;
import com.day.cq.wcm.designimporter.util.ComponentSuffixGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.BundleContext;

public class DesignImporterContext {
    public Node designNode;
    public Page page;
    public Page currentPage;
    public ComponentSuffixGenerator componentSuffixGenerator;
    public CanvasBuilder canvasBuilder;
    public String htmlName;
    public BundleContext bundleContext;
    @Deprecated
    public SlingHttpServletRequest slingHttpServletRequest;
    private Resource importer;
    private ArrayList<String> extractedResources;
    private Set<String> resourcesToRemove;
    public static final String CHAR_ENCODING_KEY = "_character_encoding";
    public List<String> importWarnings = new ArrayList<String>();
    private Map<Object, Object> attributes = new HashMap<Object, Object>();

    public DesignImporterContext(Page page, Node designNode) {
        this(page, designNode, null);
    }

    public DesignImporterContext(Page page, Node designNode, String htmlName) {
        this(page, designNode, htmlName, null);
    }

    public DesignImporterContext(Page page, Node designNode, String htmlName, CanvasBuilder canvasBuilder) {
        this(page, designNode, htmlName, canvasBuilder, null, new ArrayList<String>());
    }

    public DesignImporterContext(Page page, Node designNode, String htmlName, CanvasBuilder canvasBuilder, BundleContext bundleContext) {
        this(page, designNode, htmlName, canvasBuilder, bundleContext, new ArrayList<String>());
    }

    public DesignImporterContext(Page page, Node designNode, String htmlName, CanvasBuilder canvasBuilder, BundleContext bundleContext, ArrayList<String> extractedResources) {
        this.page = this.currentPage = page;
        this.designNode = designNode;
        this.htmlName = htmlName;
        this.canvasBuilder = canvasBuilder;
        this.bundleContext = bundleContext;
        this.extractedResources = extractedResources;
        this.resourcesToRemove = new HashSet<String>();
        this.componentSuffixGenerator = new ComponentSuffixGenerator();
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public void setImporter(Resource importer) {
        this.importer = importer;
    }

    public Resource getImporter() {
        return this.importer;
    }

    public ArrayList<String> getExtractedResources() {
        return this.extractedResources;
    }

    public void addResourcesToRemove(Set<String> resources) {
        this.resourcesToRemove.addAll(resources);
    }

    public Set<String> getResourcesToRemove() {
        return this.resourcesToRemove;
    }
}

