/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.core.contentfinder;

import com.day.cq.commons.ListInfoProvider;
import com.day.cq.commons.servlets.AbstractPredicateServlet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
@Reference(referenceInterface=ListInfoProvider.class, name="listInfoProvider", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
public abstract class ContentFinderListInfoProviderHelper
extends AbstractPredicateServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ContentFinderListInfoProviderHelper.class);
    private static final long serialVersionUID = 7018564321415615254L;
    private ComponentContext componentContext;
    private List<ServiceReference> listInfoProviders = new CopyOnWriteArrayList<ServiceReference>();

    protected void pingCallbacksWithItem(SlingHttpServletRequest request, JSONObject jsonObject, Resource resource) {
        for (ServiceReference ref : this.listInfoProviders) {
            ListInfoProvider listInfoProvider = (ListInfoProvider)this.componentContext.locateService("listInfoProvider", ref);
            if (listInfoProvider == null) continue;
            try {
                listInfoProvider.updateListItemInfo(request, jsonObject, resource);
            }
            catch (JSONException e) {
                LOG.error("Unable to update jsonObject", e);
            }
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    protected void deactivate(ComponentContext componentContext) {
        this.componentContext = null;
    }

    protected void bindListInfoProvider(ServiceReference ref) {
        this.listInfoProviders.add(ref);
    }

    protected void unbindListInfoProvider(ServiceReference ref) {
        this.listInfoProviders.remove(ref);
    }
}

