/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons.status;

import com.adobe.granite.resourcestatus.ResourceStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EditorResourceStatus
implements ResourceStatus {
    private String type;
    private String title;
    private String message;
    private Integer priority;
    private Variant variant;
    private String icon;
    private Map<String, Object> data;
    private List<Action> actions;

    public EditorResourceStatus(@Nonnull String type, @Nonnull String title, @Nonnull String message, @Nullable Integer priority, @Nullable Variant variant, @Nullable String icon, @Nullable List<Action> actions, @Nullable Map<String, Object> data) {
        this.type = type;
        this.title = title;
        this.message = message;
        this.priority = priority;
        this.variant = variant;
        this.icon = icon;
        this.actions = new LinkedList<Action>();
        if (actions != null) {
            this.actions.addAll(actions);
        }
        this.data = new HashMap<String, Object>();
        if (data != null) {
            this.data.putAll(data);
        }
    }

    private EditorResourceStatus(Builder builder) {
        this(builder.type, builder.title, builder.message, builder.priority, builder.variant, builder.icon, builder.actions, builder.data);
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        if (this.priority != null) {
            return this.priority;
        }
        Variant variant = this.getVariant();
        if (variant.equals((Object)Variant.ERROR)) {
            return 30000;
        }
        if (variant.equals((Object)Variant.WARNING)) {
            return 20000;
        }
        if (variant.equals((Object)Variant.INFO)) {
            return 10000;
        }
        return 0;
    }

    @Override
    @Nullable
    public Map<String, Object> getData() {
        List<Action> actions;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.putAll(this.getAdditionalData());
        data.put("title", this.getTitle());
        data.put("message", this.getMessage());
        data.put("variant", this.getVariant().toString().toLowerCase());
        if (this.getIcon() != null) {
            this.data.put("icon", this.getIcon());
        }
        if (!(actions = this.getActions()).isEmpty()) {
            String[] ids = new String[actions.size()];
            String[] labels = new String[actions.size()];
            int i = 0;
            for (Action action : actions) {
                ids[i] = action.getId();
                labels[i] = action.getLabel();
                ++i;
            }
            data.put("actionIds", ids);
            data.put("actionLabels", labels);
        }
        return Collections.unmodifiableMap(data);
    }

    @Override
    @Nullable
    public String getResourceType() {
        return null;
    }

    @Override
    @Nullable
    public String getResourceSuperType() {
        return null;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public Variant getVariant() {
        if (this.variant == null) {
            return Variant.INFO;
        }
        return this.variant;
    }

    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        return Collections.unmodifiableMap(this.data);
    }

    @Nonnull
    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public static class Builder {
        private String type;
        private String title;
        private String message;
        private Integer priority;
        private Variant variant;
        private String icon;
        private Map<String, Object> data;
        private List<Action> actions;

        public Builder(@Nonnull String type, @Nonnull String title, @Nonnull String message) {
            this.type = type;
            this.title = title;
            this.message = message;
            this.data = new HashMap<String, Object>();
            this.actions = new LinkedList<Action>();
        }

        @Nonnull
        public Builder setPriority(@Nullable Integer priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public Builder setVariant(@Nullable Variant variant) {
            this.variant = variant;
            return this;
        }

        @Nonnull
        public Builder setIcon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        public Builder addData(String key, Object value) {
            this.data.put(key, value);
            return this;
        }

        public Builder addAction(String id, String label) {
            this.actions.add(new Action(id, label));
            return this;
        }

        public EditorResourceStatus build() {
            return new EditorResourceStatus(this);
        }
    }

    public static class Action {
        private String id;
        private String label;

        private Action(String id, String label) {
            this.id = id;
            this.label = label;
        }

        @Nonnull
        public String getId() {
            return this.id;
        }

        @Nonnull
        public String getLabel() {
            return this.label;
        }
    }

    public static enum Variant {
        SUCCESS,
        INFO,
        WARNING,
        ERROR;

    }
}

