/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.facets.extractors;

import com.day.cq.search.facets.FacetExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;

public abstract class PropertyFacetExtractor
implements FacetExtractor {
    protected static final List<Property> EMPTY_PROPERTY_LIST = Collections.emptyList();
    protected final String propertyRelPath;

    public PropertyFacetExtractor(String propertyRelPath) {
        this.propertyRelPath = propertyRelPath;
    }

    protected abstract void handleValue(Value var1) throws RepositoryException;

    protected abstract List<Value> filter(List<Value> var1, ValueFactory var2) throws RepositoryException;

    @Override
    public void handleNode(Node node) throws RepositoryException {
        List<Value> values = this.getValues(node);
        for (Value value : values) {
            this.handleValue(value);
        }
    }

    protected List<Value> getValues(Node node) throws RepositoryException {
        ValueFactory vf = node.getSession().getValueFactory();
        ArrayList<Value> values = null;
        Iterator<Property> props = PropertyFacetExtractor.getProperties(node, this.propertyRelPath);
        if (props.hasNext()) {
            boolean isBinary = false;
            values = new ArrayList();
            while (props.hasNext()) {
                Property p = props.next();
                if (p.getType() == 2) {
                    isBinary = true;
                    long[] lengths = p.getDefinition().isMultiple() ? p.getLengths() : new long[]{p.getLength()};
                    for (long len : lengths) {
                        values.add(vf.createValue(len));
                    }
                    continue;
                }
                if (p.getDefinition().isMultiple()) {
                    values.addAll(Arrays.asList(p.getValues()));
                    continue;
                }
                values.add(p.getValue());
            }
            if (isBinary) {
                return values;
            }
        } else {
            try {
                if (node.hasNode(this.propertyRelPath)) {
                    values = new ArrayList();
                    values.add(node.getSession().getValueFactory().createValue(node.getNode(this.propertyRelPath).getPath()));
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        if (values == null) {
            values = Collections.emptyList();
        }
        return this.filter(values, vf);
    }

    private static Iterator<Property> getProperties(Node node, String pathPattern) throws RepositoryException {
        if (pathPattern == null || pathPattern.equals(".")) {
            return EMPTY_PROPERTY_LIST.iterator();
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Property> properties = new ArrayList<Property>();
        nodes.add(node);
        String[] namePattern = pathPattern.split("/");
        for (int i = 0; i < namePattern.length; ++i) {
            if (i == namePattern.length - 1) {
                for (Node n : nodes) {
                    PropertyIterator pIt = n.getProperties(namePattern[i]);
                    while (pIt.hasNext()) {
                        properties.add(pIt.nextProperty());
                    }
                }
                continue;
            }
            ArrayList<Node> children = new ArrayList<Node>();
            for (Node n : nodes) {
                NodeIterator nIt = n.getNodes(namePattern[i]);
                while (nIt.hasNext()) {
                    children.add(nIt.nextNode());
                }
            }
            nodes = children;
        }
        return properties.iterator();
    }
}

