/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.facets.extractors;

import com.day.cq.search.Predicate;
import com.day.cq.search.facets.Facet;
import com.day.cq.search.facets.buckets.SimpleBucket;
import com.day.cq.search.facets.extractors.FacetImpl;
import com.day.cq.search.facets.extractors.PropertyFacetExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;

public class DistinctValuesFacetExtractor
extends PropertyFacetExtractor {
    private final String valueFilter;
    private final Pattern valuePattern;
    private Predicate predicateTemplate;
    private String valueParameterName;
    private Map<String, SimpleBucket> bucketMap = new HashMap<String, SimpleBucket>();

    public DistinctValuesFacetExtractor(String propertyRelPath, String valueFilter, Predicate predicateTemplate, String valueParameterName) {
        super(propertyRelPath);
        this.predicateTemplate = predicateTemplate;
        this.valueParameterName = valueParameterName;
        if (valueFilter == null) {
            this.valueFilter = null;
            this.valuePattern = null;
        } else {
            this.valueFilter = valueFilter;
            this.valuePattern = Pattern.compile(this.valueFilter);
        }
    }

    @Override
    public Facet getFacet() {
        if (this.bucketMap.size() == 0) {
            return null;
        }
        return new FacetImpl(this.bucketMap.values());
    }

    @Override
    protected void handleValue(Value value) throws RepositoryException {
        String val = this.getBucketValue(value.getString());
        if (val == null) {
            return;
        }
        SimpleBucket b = this.bucketMap.get(val);
        if (b == null) {
            Predicate p = this.predicateTemplate.clone();
            p.set(this.valueParameterName, val);
            b = new SimpleBucket(p, val);
            this.bucketMap.put(val, b);
        }
        b.increment();
    }

    protected String getBucketValue(String value) {
        return value;
    }

    @Override
    protected List<Value> filter(List<Value> values, ValueFactory vf) throws RepositoryException {
        if (this.valuePattern == null) {
            return values;
        }
        ArrayList<Value> filtered = new ArrayList<Value>(values.size());
        for (Value value : values) {
            Matcher m = this.valuePattern.matcher(value.getString());
            if (!m.matches()) continue;
            for (int g = 1; g <= m.groupCount(); ++g) {
                String s = m.group(g);
                if (s == null) continue;
                filtered.add(vf.createValue(s));
            }
        }
        return filtered;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DistinctValuesFacetExtractor other = (DistinctValuesFacetExtractor)obj;
        if (this.propertyRelPath != other.propertyRelPath && !this.propertyRelPath.equals(other.propertyRelPath)) {
            return false;
        }
        return this.valueFilter == other.valueFilter || this.valueFilter.equals(other.valueFilter);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.propertyRelPath == null ? 0 : this.propertyRelPath.hashCode());
        hash = 31 * hash + (this.valueFilter == null ? 0 : this.valueFilter.hashCode());
        return hash;
    }
}

