/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.reporting;

import com.day.cq.reporting.CellValue;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRow {
    private final Logger log = LoggerFactory.getLogger(DataRow.class);
    private final Map<String, CellValue> cellData;
    private boolean isCompacted;

    public DataRow(int colCnt) {
        this.cellData = new HashMap<String, CellValue>(colCnt);
        this.isCompacted = false;
    }

    protected void ensureMutable() {
        if (this.isCompacted) {
            throw new IllegalStateException("Report data is already compacted and therefore immutable.");
        }
    }

    protected void compact() {
        this.ensureMutable();
        this.isCompacted = true;
    }

    public void add(String property, CellValue value) {
        this.ensureMutable();
        this.log.debug("Setting property '{}' to value '{}'", (Object)property, (Object)value);
        this.cellData.put(property, value);
    }

    public CellValue get(String property) {
        return this.cellData.get(property);
    }

    public String toString() {
        StringBuilder dump = new StringBuilder(128);
        boolean isFirst = true;
        for (String key : this.cellData.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                dump.append("; ");
            }
            dump.append("[ ").append(key).append(" = (");
            dump.append(this.cellData.get(key));
            dump.append(") ]");
        }
        return dump.toString();
    }
}

