/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication;

import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import java.util.List;

public class CompositeReplicationAction {
    private final List<ReplicationAction> actions;
    private final String[] paths;
    private boolean hasTestAction = false;

    public CompositeReplicationAction(List<ReplicationAction> actions) {
        this.actions = actions;
        if (actions.size() == 0) {
            throw new RuntimeException("cannot build an empty multiple action");
        }
        this.paths = new String[actions.size()];
        int i = 0;
        ReplicationAction sample = actions.get(0);
        for (ReplicationAction action : actions) {
            this.paths[i] = action.getPath();
            if (!sample.getType().equals((Object)action.getType())) {
                throw new RuntimeException("all composing actions of a multiple action must have same type");
            }
            if (ReplicationActionType.TEST.equals((Object)action.getType())) {
                this.hasTestAction = true;
            }
            ++i;
        }
    }

    public List<ReplicationAction> getActions() {
        return this.actions;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public boolean hasTestAction() {
        return this.hasTestAction;
    }

    public ReplicationAction asAction() {
        ReplicationAction delegate = this.actions.get(0);
        return new ReplicationAction(delegate.getType(), this.paths, delegate.getTime(), delegate.getUserId(), delegate.getRevision());
    }
}

