/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.settings.SlingSettingsService;

public class ContextSessionPersistence {
    private static final String DEFAULT_COOKIE_NAME = "SessionPersistence";

    public static String get(SlingHttpServletRequest request, String key, SlingSettingsService settingsService) {
        return ContextSessionPersistence.get(request, key);
    }

    public static String get(SlingHttpServletRequest request, String key) {
        return ContextSessionPersistence.get(request, key, ContextSessionPersistence.getCookieName());
    }

    public static String get(SlingHttpServletRequest request, String key, String cookieName) {
        int index;
        String pairsMap = ContextSessionPersistence.getMap(request, cookieName);
        String value = "";
        if (pairsMap != null && (index = pairsMap.indexOf(key + ":=")) != -1) {
            int end = pairsMap.indexOf("|", index + 2);
            if (end == -1) {
                end = pairsMap.length();
            }
            value = pairsMap.substring(index + (key + ":=").length(), end);
        }
        value = value == null || "null".equals(value) ? "" : value;
        return Text.unescape(value);
    }

    public static String getMap(SlingHttpServletRequest request, SlingSettingsService settingsService) {
        return ContextSessionPersistence.getMap(request);
    }

    public static String getMap(SlingHttpServletRequest request) {
        return ContextSessionPersistence.getMap(request, ContextSessionPersistence.getCookieName());
    }

    public static String getMap(SlingHttpServletRequest request, String cookieName) {
        String pairsMap;
        Cookie cookie = request.getCookie(cookieName);
        if (cookie != null && (pairsMap = request.getCookie(cookieName).getValue()) != null) {
            return Text.unescape(pairsMap);
        }
        return "";
    }

    public static void put(SlingHttpServletRequest request, SlingHttpServletResponse response, String key, String value, SlingSettingsService settingsService) {
        ContextSessionPersistence.put(request, response, key, value);
    }

    public static void put(SlingHttpServletRequest request, SlingHttpServletResponse response, String key, String value) {
        ContextSessionPersistence.put(request, response, key, value, ContextSessionPersistence.getCookieName());
    }

    public static void put(SlingHttpServletRequest request, SlingHttpServletResponse response, String key, String value, String cookieName) {
        Cookie cookie = request.getCookie(cookieName);
        if (cookie == null) {
            cookie = new Cookie(cookieName, "");
        }
        ContextSessionPersistence.internalAddCookie(request, response, ContextSessionPersistence.internalPut(request, response, key, value, cookie));
    }

    private static Cookie internalPut(SlingHttpServletRequest request, SlingHttpServletResponse response, String key, String value, Cookie cookie) {
        if (cookie == null) {
            return null;
        }
        String pairsMap = cookie.getValue();
        if (pairsMap == null) {
            pairsMap = "";
        } else {
            int index = (pairsMap = Text.unescape(pairsMap)).indexOf(key + ":=");
            if (index != -1) {
                int end = pairsMap.indexOf("|", index + 2);
                pairsMap = end == -1 ? pairsMap.substring(0, index) : pairsMap.substring(0, index) + pairsMap.substring(end + 1, pairsMap.length());
            }
        }
        if (pairsMap.length() > 0 && !pairsMap.endsWith("|")) {
            pairsMap = pairsMap + "|";
        }
        pairsMap = pairsMap + key + ":=" + Text.escape(value) + "|";
        pairsMap = Text.escape(pairsMap);
        cookie.setValue(pairsMap);
        return cookie;
    }

    private static Map<String, String> parse(String str) {
        HashMap<String, String> obj = new HashMap<String, String>();
        if (str != null) {
            String[] array;
            for (String t : array = str.split(",")) {
                String[] entry = t.split("=");
                if (entry.length != 2) continue;
                obj.put(entry[0], entry[1]);
            }
        }
        return obj;
    }

    private static String serialize(Map<String, String> store) {
        String result = "";
        String[] keys = store.keySet().toArray(new String[store.size()]);
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + keys[i] + "=" + store.get(keys[i]);
        }
        return result;
    }

    public static Map<String, String> getStore(SlingHttpServletRequest request, String key, SlingSettingsService settingsService) {
        return ContextSessionPersistence.getStore(request, key);
    }

    public static Map<String, String> getStore(SlingHttpServletRequest request, String key) {
        return ContextSessionPersistence.getStore(request, key, ContextSessionPersistence.getCookieName());
    }

    public static Map<String, String> getStore(SlingHttpServletRequest request, String key, String cookieName) {
        return ContextSessionPersistence.parse(ContextSessionPersistence.get(request, key, cookieName));
    }

    public static void putStore(SlingHttpServletRequest request, SlingHttpServletResponse response, String key, Map<String, String> store, SlingSettingsService settingsService) {
        ContextSessionPersistence.putStore(request, response, key, store);
    }

    public static void putStore(SlingHttpServletRequest request, SlingHttpServletResponse response, String key, Map<String, String> store) {
        HashMap<String, Map<String, String>> stores = new HashMap<String, Map<String, String>>();
        stores.put(key, store);
        ContextSessionPersistence.putStores(request, response, stores, ContextSessionPersistence.getCookieName());
    }

    public static void putStores(SlingHttpServletRequest request, SlingHttpServletResponse response, Map<String, Map<String, String>> stores, String cookieName) {
        Cookie cookie = request.getCookie(cookieName);
        if (cookie == null) {
            cookie = new Cookie(cookieName, "");
        }
        for (String key : stores.keySet()) {
            cookie = ContextSessionPersistence.internalPut(request, response, key, ContextSessionPersistence.serialize(stores.get(key)), cookie);
        }
        ContextSessionPersistence.internalAddCookie(request, response, cookie);
    }

    private static void internalAddCookie(SlingHttpServletRequest request, SlingHttpServletResponse response, Cookie cookie) {
        String contextPath;
        if (request.isSecure()) {
            cookie.setSecure(true);
        }
        String cookiePath = (contextPath = request.getContextPath()) == null || contextPath.length() == 0 ? "/" : contextPath;
        cookie.setPath(cookiePath);
        response.addCookie(cookie);
    }

    public static String getCookieName() {
        return DEFAULT_COOKIE_NAME;
    }

    public static String getCookieName(SlingSettingsService settingsService) {
        return ContextSessionPersistence.getCookieName();
    }

    public static String getCookieName(String cookiePrefix, SlingSettingsService settingsService) {
        return cookiePrefix;
    }
}

