/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;

public class Scene7PresetRenditionPicker
implements RenditionPicker {
    private String presetHandle = "";

    public Scene7PresetRenditionPicker(String presetHandle) {
        this.presetHandle = presetHandle;
    }

    @Override
    public Rendition getRendition(Asset asset) {
        Iterator<Rendition> renditions = asset.listRenditions();
        while (renditions.hasNext()) {
            Rendition rendition = renditions.next();
            String renditionPresetId = rendition.getProperties().get("scene7.presetHandle", "");
            String searchRenditionId = this.getPresetIdFromPresetHandle(this.presetHandle);
            if (!StringUtils.isNotBlank(renditionPresetId) || !searchRenditionId.equals(renditionPresetId)) continue;
            return rendition;
        }
        return null;
    }

    private String getPresetIdFromPresetHandle(String presetHandle) {
        String presetId = "";
        if (StringUtils.isNotBlank(presetHandle)) {
            presetId = presetHandle.replace("ps|", "");
        }
        return presetId;
    }
}

