/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.core.impl.ui.preview.AssetDrivenFolderPreviewGenerator;
import com.day.cq.dam.core.impl.ui.preview.FolderPreviewUpdater;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Update Folder Thumbnail Process"})
public class UpdateFolderThumbnailProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(UpdateFolderThumbnailProcess.class);
    @Reference
    private FolderPreviewUpdater folderPreviewUpdater;

    public void updateFolderThumbnail(Asset asset, Node assetNode, FolderPreviewUpdater folderPreviewUpdater) throws RepositoryException {
        boolean success;
        AssetDrivenFolderPreviewGenerator generator;
        Resource resource = asset.adaptTo(Resource.class);
        Resource parentFolderResource = resource.getParent();
        Node parentFolderNode = assetNode.getParent();
        String folderPath = parentFolderNode.getPath();
        if (parentFolderNode.isNodeType("nt:folder") && !folderPath.equals("/content/dam") && folderPreviewUpdater.shouldUpdateFolderPreview() && (generator = new AssetDrivenFolderPreviewGenerator(asset, parentFolderResource, false, folderPreviewUpdater.getFolderPreviewRenditionRegex())).isFolderThumbnailNeedToBeUpdated() && !(success = folderPreviewUpdater.initiateFolderPreviewUpdate(asset.getPath()))) {
            log.error("Folder thumbnail update couldn't be initiated for assset {}", (Object)asset.getPath());
        }
    }

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
        if (asset != null) {
            Node assetNode = asset.adaptTo(Node.class);
            try {
                this.updateFolderThumbnail(asset, assetNode, this.folderPreviewUpdater);
            }
            catch (Exception e) {
                log.error("Error while updating folder thumbnail of asset {}", (Object)asset.getPath(), (Object)e);
            }
        } else {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot update folder thumbnail, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
    }

    protected void bindFolderPreviewUpdater(FolderPreviewUpdater folderPreviewUpdater) {
        this.folderPreviewUpdater = folderPreviewUpdater;
    }

    protected void unbindFolderPreviewUpdater(FolderPreviewUpdater folderPreviewUpdater) {
        if (this.folderPreviewUpdater == folderPreviewUpdater) {
            this.folderPreviewUpdater = null;
        }
    }
}

