/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.commons.Externalizer;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.mailer.MessageGatewayService;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="service.description", value={"Send download asset email notification."}), @Property(name="process.label", value={"Send Download Asset Email Notification"})})
public class SendDownloadAssetEmailProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SendDownloadAssetEmailProcess.class);
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final String EMAIL_TEMPLATE_LEGACY_BUCKET = "/etc";
    private static final String EMAIL_TEMPLATE_CACONFIG_BUCKET = "settings";
    private static final String SERVICE_USER_ID = "assetidhelper";
    @Reference(policy=ReferencePolicy.STATIC)
    private MessageGatewayService messageGatewayService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private Externalizer externalizer;
    @Reference
    private ConfigurationResourceResolver configResolver;
    @Reference
    private SlingRepository repository;

    @Override
    public void execute(WorkItem workItem, WorkflowSession session, MetaDataMap metaData) throws WorkflowException {
        block9: {
            MetaDataMap workflowMetaDataMap = workItem.getWorkflowData().getMetaDataMap();
            ResourceResolver resolver = this.getResourceResolver(session.getSession());
            if (this.messageGatewayService != null && this.messageGatewayService.getGateway(HtmlEmail.class) != null) {
                try {
                    ArrayList<InternetAddress> emailRecipients = this.getEmailRecipients(workflowMetaDataMap);
                    if (workflowMetaDataMap != null) {
                        String downloadUrl;
                        String string = downloadUrl = workflowMetaDataMap.containsKey("downloadUrl") ? workflowMetaDataMap.get("downloadUrl").toString() : null;
                        if (emailRecipients != null && !emailRecipients.isEmpty() && downloadUrl != null) {
                            String template = this.getEmailTemplate(metaData, resolver);
                            if (template != null) {
                                String zipFileName = downloadUrl.substring(downloadUrl.lastIndexOf(47) + 1);
                                HashMap<String, String> valuesMap = new HashMap<String, String>();
                                String hostPrefix = this.getHostPrefix(workItem, resolver);
                                valuesMap.put("host.prefix", hostPrefix);
                                valuesMap.put("zipFileName", zipFileName);
                                String encodedFileName = null;
                                try {
                                    encodedFileName = URLEncoder.encode(zipFileName, "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    log.error("Encode the file name failed before sending email in workflow", e);
                                }
                                valuesMap.put("downloadurl", downloadUrl.substring(0, downloadUrl.lastIndexOf(47) + 1) + encodedFileName);
                                StrSubstitutor substitutor = new StrSubstitutor(valuesMap);
                                HtmlEmail email = this.createEmail(template, substitutor);
                                email.setTo(emailRecipients);
                                this.messageGatewayService.getGateway(HtmlEmail.class).send(email);
                                log.info("Email was sent.");
                                break block9;
                            }
                            log.warn("Did not send email. No email template defined");
                            break block9;
                        }
                        log.warn("Did not send email. No recipient addresses or assets download URL available.");
                        break block9;
                    }
                    log.warn("Did not send email. No workflow metadata is null.");
                }
                catch (EmailException e) {
                    e.printStackTrace();
                    log.error("Fatal error while sending email in workflow", e);
                }
            } else {
                log.warn("cannot send email, mail service unavailable. Please configure Gateway in OSGi Console");
            }
        }
    }

    private ArrayList<InternetAddress> getEmailRecipients(MetaDataMap workflowMetaDataMap) {
        ArrayList<InternetAddress> emailRecipients = null;
        String recipients = workflowMetaDataMap.get("emailTo", new String());
        try {
            recipients = URLDecoder.decode(recipients, "UTF-8");
            List<String> recipientList = Arrays.asList(recipients.split(","));
            emailRecipients = new ArrayList<InternetAddress>();
            for (String recipient : recipientList) {
                if (StringUtils.isEmpty(recipient)) continue;
                emailRecipients.add(new InternetAddress(recipient));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Cannot decode the recipient email address: " + e.getMessage());
        }
        catch (AddressException e) {
            log.error("Cannot get the recipient email address: " + e.getMessage());
        }
        return emailRecipients;
    }

    private String getEmailTemplate(MetaDataMap workflowMetaDataMap, ResourceResolver resolver) {
        String template = (String)((Object)workflowMetaDataMap.get("template", String.class));
        if (template == null) {
            String templatePath = (String)((Object)workflowMetaDataMap.get("templatePath", String.class));
            template = templatePath.startsWith("/") ? this.loadTemplate(resolver.adaptTo(Session.class), templatePath) : this.loadTemplate(resolver, templatePath);
        }
        log.debug("Loaded template: {}", (Object)template);
        return template;
    }

    private HtmlEmail createEmail(String template, StrSubstitutor substitutor) {
        HtmlEmail email = new HtmlEmail();
        String NEW_LINE = ".*\n";
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            String previousHeader = null;
            Matcher matcher = Pattern.compile(NEW_LINE).matcher(template);
            while (matcher.find() && !matcher.group().equals("\n")) {
                String name;
                String line = matcher.group();
                template = template.replace(line, "");
                int colonIndex = line.indexOf(":");
                if (previousHeader != null && (line.startsWith("\t") || line.startsWith(" "))) {
                    headers.put(previousHeader, (String)headers.get(previousHeader) + line.replace("\n", ""));
                    continue;
                }
                if (colonIndex <= -1) continue;
                previousHeader = name = line.substring(0, colonIndex);
                String value = line.substring(colonIndex + 1, line.length()).replaceAll("\n", "").trim();
                log.debug("Header: {} = {}", (Object)name, (Object)value);
                headers.put(name, value);
            }
            String templateBody = template;
            email.setCharset(DEFAULT_CHARSET);
            String value = (String)headers.remove("subject");
            String subject = value == null ? "" : value;
            log.info("Email subject: " + subject);
            if (!StringUtils.isEmpty(subject)) {
                email.setSubject(substitutor.replace(subject));
            }
            templateBody = substitutor.replace(templateBody);
            log.debug("Substituted mail body: {}", (Object)templateBody);
            email.setMsg(templateBody);
        }
        catch (Exception e) {
            log.error("Create email: ", (Object)e.getMessage());
        }
        return email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String loadTemplate(Session session, String path) {
        InputStream is = null;
        try {
            log.warn("Reading content of email-templates given template-absolute-paths is deprecated");
            Node content = session.getNode(path + "/" + "jcr:content");
            is = content.getProperty("jcr:data").getBinary().getStream();
            InputStreamReader r = new InputStreamReader(is, DEFAULT_CHARSET);
            StringWriter w = new StringWriter();
            IOUtils.copy((Reader)r, (Writer)w);
            String string = w.toString();
            IOUtils.closeQuietly(is);
            return string;
        }
        catch (Exception e) {
            log.error("Error while loading mail template {}:{}", (Object)path, (Object)e.toString());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTemplate(ResourceResolver resolver, String path) {
        InputStream is = null;
        try {
            Resource resource = resolver.getResource("/etc/" + path);
            if (null == resource) {
                Resource tenantAssetRootResource = resolver.getResource(DamUtil.getTenantAssetsRoot(resolver));
                resource = this.configResolver.getResource(tenantAssetRootResource, EMAIL_TEMPLATE_CACONFIG_BUCKET, path);
            }
            Node content = resource.adaptTo(Node.class).getNode("jcr:content");
            is = content.getProperty("jcr:data").getBinary().getStream();
            InputStreamReader r = new InputStreamReader(is, DEFAULT_CHARSET);
            StringWriter w = new StringWriter();
            IOUtils.copy((Reader)r, (Writer)w);
            String string = w.toString();
            IOUtils.closeQuietly(is);
            return string;
        }
        catch (Exception e) {
            log.error("Error while loading mail template {}:{}", (Object)path, (Object)e.toString());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    private String getHostPrefix(WorkItem workItem, ResourceResolver resolver) {
        ResourceResolver resolverForExternalizer = this.getResolverForExternalizer(workItem, resolver);
        String externalizerHost = this.externalizer.externalLink(resolverForExternalizer, "local", "");
        if (externalizerHost != null && externalizerHost.endsWith("/")) {
            return externalizerHost.substring(0, externalizerHost.length() - 1);
        }
        return externalizerHost;
    }

    private ResourceResolver getResolverForExternalizer(WorkItem workItem, ResourceResolver workFlowResourceResolver) {
        String initiator = workItem.getWorkflow().getInitiator();
        Session initiatorSession = this.getUserSession(initiator);
        ResourceResolver initiatorResolver = this.getResourceResolver(initiatorSession);
        if (initiatorResolver != null) {
            return initiatorResolver;
        }
        return workFlowResourceResolver;
    }

    private Session getUserSession(String userId) {
        SimpleCredentials credentials = new SimpleCredentials(userId, new char[0]);
        try {
            return this.repository.impersonateFromService(SERVICE_USER_ID, credentials, null);
        }
        catch (Exception e) {
            log.info("Impersonation of user '{}' failed", (Object)userId, (Object)e);
            return null;
        }
    }

    protected void bindMessageGatewayService(MessageGatewayService messageGatewayService) {
        this.messageGatewayService = messageGatewayService;
    }

    protected void unbindMessageGatewayService(MessageGatewayService messageGatewayService) {
        if (this.messageGatewayService == messageGatewayService) {
            this.messageGatewayService = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindConfigResolver(ConfigurationResourceResolver configurationResourceResolver) {
        this.configResolver = configurationResourceResolver;
    }

    protected void unbindConfigResolver(ConfigurationResourceResolver configurationResourceResolver) {
        if (this.configResolver == configurationResourceResolver) {
            this.configResolver = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

