/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.metadata.SimpleXmpToJcrMetadataBuilder;
import com.day.cq.dam.commons.util.AssetCache;
import com.day.cq.dam.commons.util.DamMimeUtil;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractor {
    private static final Logger log = LoggerFactory.getLogger(MetadataExtractor.class);
    private static final String JCR_CONTENT_METADATA = "jcr:content/metadata";
    private static final String JCR_CONTENT_JCR_DATA = "jcr:content/jcr:data";
    private SimpleXmpToJcrMetadataBuilder metadataBuilder;

    @Deprecated
    public MetadataExtractor() {
        log.warn("Deprecated constructor invoked. Please instantiate MetadataExtractor object providing com.day.cq.dam.commons.metadata.SimpleXmpToJcrMetadataBuilder as argument");
        this.metadataBuilder = new SimpleXmpToJcrMetadataBuilder();
    }

    public MetadataExtractor(SimpleXmpToJcrMetadataBuilder metadataBuilder) {
        this.metadataBuilder = metadataBuilder;
    }

    public void extractMetadata(Session session, Asset asset, AssetHandler assetHandler, boolean sha1Enabled, MimeTypeService mimeTypeService) throws RepositoryException, IOException {
        this.extractMetadata(session, asset, assetHandler, sha1Enabled, true, mimeTypeService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractMetadata(Session session, Asset asset, AssetHandler assetHandler, boolean sha1Enabled, boolean damSizeEnabled, MimeTypeService mimeTypeService) throws RepositoryException, IOException {
        AssetCache cache = DamUtil.getAssetCache();
        try {
            Node originalBinary;
            Resource assetResource = asset.adaptTo(Resource.class);
            ResourceResolver resolver = assetResource.getResourceResolver();
            Resource metadataResource = resolver.getResource(assetResource, JCR_CONTENT_METADATA);
            ExtractedMetadata metadata = assetHandler.extractMetadata(asset);
            metadata.setMetaDataProperty("dam:extracted", Calendar.getInstance().getTime());
            Rendition originalRendition = asset.getOriginal();
            if (sha1Enabled) {
                String sha1 = DigestUtils.shaHex(cache.getStream(originalRendition, false));
                metadata.setMetaDataProperty("dam:sha1", sha1);
            }
            if (damSizeEnabled && (originalBinary = originalRendition.adaptTo(Node.class)).hasProperty(JCR_CONTENT_JCR_DATA)) {
                metadata.setMetaDataProperty("dam:size", originalBinary.getProperty(JCR_CONTENT_JCR_DATA).getBinary().getSize());
            }
            this.resetMimetype(asset, metadata, mimeTypeService);
            this.saveMetadata(asset, metadata, metadataResource);
        }
        finally {
            cache.release();
        }
    }

    protected void saveMetadata(Asset asset, ExtractedMetadata metadata, Resource metadataResource) {
        if (null != metadataResource) {
            try {
                this.metadataBuilder.storeAsXmp(metadata, asset, false);
            }
            catch (Exception e) {
                log.error("saveMetadata: error while saving metdata for asset [{}]: ", (Object)asset.getPath(), (Object)e);
            }
        } else {
            log.error("execute: cannot save metdata for asset [{}], doesn't have metdata node.", (Object)asset.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMimetype(Asset asset, ExtractedMetadata metadata, MimeTypeService mimeTypeService) {
        AssetCache cache = DamUtil.getAssetCache();
        String mimeType = null;
        try {
            if (DamMimeUtil.getDetectMimeFromContent()) {
                InputStream is = cache.getOriginalStream(asset, false);
                if (!is.markSupported()) {
                    is = new BufferedInputStream(is);
                }
                mimeType = ((ContentAwareMimeTypeService)mimeTypeService).getMimeType(asset.getName(), is);
            } else {
                mimeType = mimeTypeService.getMimeType(asset.getName());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            cache.release();
        }
        if (StringUtils.isNotEmpty(mimeType)) {
            metadata.setMetaDataProperty("dc:format", mimeType);
        }
    }
}

