/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Delete Asset"})
public class DeleteAssetProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(DeleteAssetProcess.class);

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        String binaryPath = workItem.getWorkflowData().getPayload().toString();
        if (this.getNodeFromPayload(workItem, workflowSession.getSession()) == null) {
            if (this.getAssetManager(workflowSession.getSession()).removeAssetForBinary(binaryPath)) {
                log.debug("execute: successfully removed asset [{}] for binary [{}].", (Object)DamUtil.binaryToAssetPath(binaryPath), (Object)binaryPath);
            } else {
                log.error("execute: failed to remove asset [{}] for binary [{}].", (Object)DamUtil.binaryToAssetPath(binaryPath), (Object)binaryPath);
            }
        }
    }
}

