/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.renditions.RenditionMaker;
import com.day.cq.dam.api.renditions.RenditionTemplate;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.AssetUpdate;
import com.day.cq.dam.commons.util.AssetUpdateMonitor;
import com.day.cq.dam.core.impl.CommandLineProcessTimeOutException;
import com.day.cq.dam.core.process.CreateThumbnailProcess;
import com.day.cq.dam.core.process.CreateWebEnabledImageProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Command Line"})
@ProviderType
public class CommandLineProcess
extends AbstractAssetWorkflowProcess {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    protected RenditionMaker renditionMaker;
    @Reference
    private AssetUpdateMonitor monitor;
    private static final String defaultCommandLineProcessTimeOut = "300000";
    private static final String defaultNumberOfRetries = "0";
    private CreateWebEnabledImageProcess webEnabledImageCreator = new CreateWebEnabledImageProcess();

    @Override
    public void execute(final WorkItem workItem, WorkflowSession wfsession, final MetaDataMap args) throws WorkflowException {
        AssetUpdate update = this.monitor.startUpdate(workItem, this.getResourceResolver(wfsession.getSession()), this);
        final String[] arguments = this.buildArguments(args);
        String input = (String)((Object)args.get(Arguments.TIMEOUT.name(), String.class));
        final int commandLineProcessTimeOut = StringUtils.isNotBlank(input) ? Integer.parseInt(input) : Integer.parseInt(defaultCommandLineProcessTimeOut);
        input = (String)((Object)args.get(Arguments.RETRIES.name(), String.class));
        final int numberOfRetries = StringUtils.isNotBlank(input) ? Integer.parseInt(input) : Integer.parseInt(defaultNumberOfRetries);
        update.checkAndRun(new AssetUpdate.AssetCheck(){

            @Override
            public boolean isAcceptable(Asset asset) throws WorkflowException {
                LinkedList<String> mimeTypes = new LinkedList<String>();
                String assetMimeType = asset.getMimeType();
                for (String str : arguments) {
                    if (!str.startsWith(Arguments.MIME_TYPES.getArgumentPrefix())) continue;
                    String mt = str.substring(Arguments.MIME_TYPES.getArgumentPrefix().length()).trim();
                    CommandLineProcess.this.log.debug("execute: accepted mime type [{}] for asset [{}].", (Object)mt, (Object)asset.getPath());
                    mimeTypes.add(mt);
                }
                if (!mimeTypes.contains(assetMimeType)) {
                    CommandLineProcess.this.log.info("execute: mime type [{}] of asset [{}] is not in list of accepted mime types [" + mimeTypes + "], ignoring.", (Object)assetMimeType, (Object)asset.getPath());
                    return false;
                }
                return true;
            }

            @Override
            public boolean isNullAcceptable() throws WorkflowException {
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                String message = "execute: cannot extract metadata, create references and apply processing profile, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                throw new WorkflowException(message);
            }
        }, new AssetUpdate.Runner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(Asset asset, AssetUpdate update) throws WorkflowException, Exception {
                File tmpDir = null;
                InputStream is = null;
                OutputStream os = null;
                try {
                    tmpDir = File.createTempFile("cqdam", null);
                    tmpDir.delete();
                    tmpDir.mkdir();
                    Rendition original = asset.getOriginal();
                    String assetName = asset.getName();
                    String assetExtension = FilenameUtils.getExtension(assetName);
                    String assetBaseName = FilenameUtils.getBaseName(assetName);
                    String tmpFileBaseName = UUID.randomUUID().toString();
                    String tmpFileName = tmpFileBaseName + "." + assetExtension;
                    final File tmpFile = new File(tmpDir, tmpFileName);
                    FileOutputStream fos = new FileOutputStream(tmpFile);
                    InputStream in = null;
                    try {
                        in = original.getStream();
                        IOUtils.copy(in, (OutputStream)fos);
                    }
                    finally {
                        IOUtils.closeQuietly(is);
                        IOUtils.closeQuietly(fos);
                    }
                    String commandDescription = "";
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("filename", tmpFileName);
                    parameters.put("file", tmpFile.getAbsolutePath());
                    parameters.put("directory", tmpDir.getAbsolutePath());
                    parameters.put("basename", tmpFileBaseName);
                    parameters.put("extension", assetExtension);
                    try {
                        for (String argument : arguments) {
                            if (!argument.startsWith(Arguments.COMMANDS.getArgumentPrefix())) continue;
                            String cmd = argument.substring(Arguments.COMMANDS.getArgumentPrefix().length()).trim();
                            CommandLine commandLine = CommandLine.parse(cmd, parameters);
                            commandDescription = "execute command line " + commandLine.toString() + " for asset " + asset.getPath() + ".";
                            CommandLineProcess.this.runCommandLineProcess(commandLine, tmpDir, commandLineProcessTimeOut, numberOfRetries, commandDescription);
                        }
                    }
                    catch (Exception e) {
                        CommandLineProcess.this.log.error("execute: failed to " + commandDescription, e);
                    }
                    for (File result : tmpDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return !pathname.equals(tmpFile);
                        }
                    })) {
                        String renditionName = result.getName().replace(tmpFileBaseName, assetBaseName);
                        Rendition rendition = asset.addRendition(renditionName, (InputStream)new FileInputStream(result), CommandLineProcess.this.recheck(renditionName));
                        HashSet<ThumbnailConfig> thumbnailConfigs = new HashSet<ThumbnailConfig>();
                        for (String str : arguments) {
                            int indexOf = str.indexOf(Arguments.THUMBNAILS.getArgumentPrefix());
                            if (indexOf <= -1) continue;
                            ThumbnailConfig config = CreateThumbnailProcess.parseThumbnailArguments(str.substring(indexOf + Arguments.THUMBNAILS.getArgumentPrefix().length()));
                            if (null != config) {
                                thumbnailConfigs.add(config);
                                CommandLineProcess.this.log.debug("execute: thumbnail dimensions [{}] for asset [{}].", (Object)str, (Object)asset.getPath());
                                continue;
                            }
                            CommandLineProcess.this.log.error("execute: cannot add invalid thumbnail config [{}] for asset [{}].", (Object)str, (Object)asset.getPath());
                        }
                        List templates = CommandLineProcess.this.createRenditionTemplates(rendition, thumbnailConfigs.toArray(new ThumbnailConfig[0]));
                        CommandLineProcess.this.log.debug("thumbnail template created at [{}] with [{}] thumbnails for [" + asset.getPath() + "].", (Object)rendition.getPath(), (Object)templates.size());
                        Boolean createWebRend = (Boolean)((Object)args.get(Arguments.GENERATE_WEB_RENDITION.name(), Boolean.class));
                        if (createWebRend != null && createWebRend.booleanValue()) {
                            CreateWebEnabledImageProcess.Config config = CommandLineProcess.this.webEnabledImageCreator.parseConfig(args);
                            RenditionTemplate webRendTemp = CommandLineProcess.this.renditionMaker.createWebRenditionTemplate(rendition, config.width, config.height, config.quality, config.mimeType, config.mimeTypesToKeep);
                            templates.add(webRendTemp);
                            CommandLineProcess.this.log.debug("Web rendition template created at [{}] with [{}] thumbnails for [" + asset.getPath() + "].", (Object)rendition.getPath());
                        }
                        CommandLineProcess.this.renditionMaker.generateRenditions(asset, templates.toArray(new RenditionTemplate[0]));
                        Boolean delCommRend = (Boolean)((Object)args.get(Arguments.DELETE_COMMAND_RENDITION.name(), Boolean.class));
                        if (delCommRend == null || !delCommRend.booleanValue()) continue;
                        asset.removeRendition(rendition.getName());
                    }
                }
                finally {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(os);
                    if (tmpDir != null) {
                        try {
                            FileUtils.deleteDirectory(tmpDir);
                        }
                        catch (IOException e) {
                            throw new WorkflowException(e);
                        }
                    }
                }
            }
        });
    }

    protected void createThumbnails(Asset asset, Rendition rendition, Collection<ThumbnailConfig> configs) throws Exception {
        String mimeType = rendition.getMimeType();
        AssetHandler handler = this.getAssetHandler(mimeType);
        if (handler == null) {
            throw new IOException("No AssetHandler found for mimetype " + mimeType);
        }
        this.log.debug("createThumbnails: generating thumbnails for rendition [{}] with mime type [{}]...", (Object)asset.getPath(), (Object)mimeType);
        handler.createThumbnails(asset, rendition, configs);
    }

    protected String recheck(String fileName) throws RepositoryException {
        if (this.mimeTypeService.getMimeType(fileName.toLowerCase()) != null) {
            return this.mimeTypeService.getMimeType(fileName.toLowerCase());
        }
        return "application/octet-stream";
    }

    protected void runCommandLineProcess(CommandLine commandLine, File binariesFolder, long commandLineProcessTimeout, int maxRetries, String commandDescription) throws CommandLineProcessTimeOutException, ExecuteException, IOException {
        int exitValue = 0;
        int iteration = 0;
        DefaultExecutor exec = new DefaultExecutor();
        do {
            if (exitValue != 0) {
                this.log.debug("Retrying to " + commandDescription + ". Retry Count = " + iteration);
            }
            exitValue = -1;
            exec.setWorkingDirectory(binariesFolder);
            this.log.info("execute: " + commandDescription);
            exec.setExitValue(0);
            ExecuteWatchdog watchDog = new ExecuteWatchdog(commandLineProcessTimeout);
            exec.setWatchdog(watchDog);
            exec.setStreamHandler(new PumpStreamHandler(System.out, System.err));
            exec.setProcessDestroyer(new ShutdownHookProcessDestroyer());
            try {
                exitValue = exec.execute(commandLine);
            }
            catch (ExecuteException e) {
                this.log.debug("execute: failed to " + commandDescription, e);
                if (watchDog.killedProcess()) {
                    if (iteration < maxRetries) {
                        this.log.debug("Command Line process timed out after " + commandLineProcessTimeout / 1000L + " seconds and was killed by watchdog.");
                        continue;
                    }
                    throw new CommandLineProcessTimeOutException(e.getMessage(), (Throwable)e);
                }
                throw e;
            }
        } while (exec.isFailure(exitValue) && iteration++ < maxRetries);
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String[] thumbnails;
        String[] mimetypes;
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String[] commands = (String[])metaData.get(Arguments.COMMANDS.name(), String[].class);
        if (commands != null) {
            for (String command : commands) {
                StringBuilder builder = new StringBuilder();
                builder.append(Arguments.COMMANDS.getArgumentPrefix()).append(command);
                arguments.add(builder.toString());
            }
        }
        if ((mimetypes = (String[])metaData.get(Arguments.MIME_TYPES.name(), String[].class)) != null) {
            for (String mimetype : mimetypes) {
                StringBuilder builder = new StringBuilder();
                builder.append(Arguments.MIME_TYPES.getArgumentPrefix()).append(mimetype);
                arguments.add(builder.toString());
            }
        }
        if ((thumbnails = (String[])metaData.get(Arguments.THUMBNAILS.name(), String[].class)) != null) {
            for (String thumbnail : thumbnails) {
                StringBuilder builder = new StringBuilder();
                builder.append(Arguments.THUMBNAILS.getArgumentPrefix()).append(thumbnail);
                arguments.add(builder.toString());
            }
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private List<RenditionTemplate> createRenditionTemplates(Rendition rendition, ThumbnailConfig[] thumbnails) {
        ArrayList<RenditionTemplate> templates = new ArrayList<RenditionTemplate>(thumbnails.length);
        for (int i = 0; i < thumbnails.length; ++i) {
            ThumbnailConfig thumb = thumbnails[i];
            templates.add(this.renditionMaker.createThumbnailTemplate(rendition, thumb.getWidth(), thumb.getHeight(), thumb.doCenter()));
        }
        return templates;
    }

    protected void bindRenditionMaker(RenditionMaker renditionMaker) {
        this.renditionMaker = renditionMaker;
    }

    protected void unbindRenditionMaker(RenditionMaker renditionMaker) {
        if (this.renditionMaker == renditionMaker) {
            this.renditionMaker = null;
        }
    }

    protected void bindMonitor(AssetUpdateMonitor assetUpdateMonitor) {
        this.monitor = assetUpdateMonitor;
    }

    protected void unbindMonitor(AssetUpdateMonitor assetUpdateMonitor) {
        if (this.monitor == assetUpdateMonitor) {
            this.monitor = null;
        }
    }

    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        MIME_TYPES("mime"),
        THUMBNAILS("tn"),
        COMMANDS("cmd"),
        GENERATE_WEB_RENDITION("genWebRendition"),
        DELETE_COMMAND_RENDITION("deleteCommandRendition"),
        TIMEOUT("timeOut"),
        RETRIES("retries");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

