/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=false)
public abstract class AbstractAssetWorkflowProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(AbstractAssetWorkflowProcess.class);
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    protected static final String APPLICATION_OCTET_STREAM_MIMETYPE = "application/octet-stream";
    @Reference(policy=ReferencePolicy.STATIC)
    protected MimeTypeService mimeTypeService;
    @Reference(policy=ReferencePolicy.STATIC)
    private AssetStore store;
    @Reference(policy=ReferencePolicy.STATIC)
    protected ResourceResolverFactory resourceResolverFactory;

    protected Asset getAssetFromPayload(WorkItem item, Session session) {
        Asset asset = null;
        if (item.getWorkflowData().getPayloadType().equals(TYPE_JCR_PATH)) {
            String path = item.getWorkflowData().getPayload().toString();
            Resource resource = this.getResourceResolver(session).getResource(path);
            if (null != resource) {
                asset = DamUtil.resolveToAsset(resource);
            } else {
                log.error("getAssetFromPaylod: asset [{}] in payload of workflow [{}] does not exist.", (Object)path, (Object)item.getWorkflow().getId());
            }
        }
        return asset;
    }

    protected Node getNodeFromPayload(WorkItem item, Session session) {
        Node asset = null;
        if (item.getWorkflowData().getPayloadType().equals(TYPE_JCR_PATH)) {
            String path = item.getWorkflowData().getPayload().toString();
            try {
                if (session.itemExists(path)) {
                    asset = (Node)session.getItem(path);
                } else {
                    log.warn("getNodeFromPayload: payload node [{}] for work item [" + item.getId() + "] does not exist anymore", (Object)path);
                }
            }
            catch (RepositoryException e) {
                log.error("getNodeFromPayload: error while getting payload node [{}] for work item [" + item.getId() + "]: ", (Object)path, (Object)e);
            }
        }
        return asset;
    }

    protected String getMimetype(Node file) {
        String mimetype = null;
        try {
            if (file.isNodeType("nt:file") && file.hasNode("jcr:content") && file.hasProperty("jcr:content/jcr:mimeType")) {
                mimetype = file.getProperty("jcr:content/jcr:mimeType").getString();
            } else if (file.isNodeType("dam:Asset") && file.hasProperty("jcr:content/renditions/original/jcr:content/jcr:mimeType")) {
                mimetype = file.getProperty("jcr:content/renditions/original/jcr:content/jcr:mimeType").getString();
            }
            mimetype = this.recheck(mimetype, file);
        }
        catch (RepositoryException e) {
            log.error("getMimetype: error while getting mime type for file [{}]: ", (Object)this.safeGetPath(file), (Object)e);
        }
        return mimetype;
    }

    protected boolean isNotReadyForProcessing(Node asset) throws RepositoryException {
        if (asset.hasProperty("jcr:content/jcr:data")) {
            Property data = asset.getProperty("jcr:content/jcr:data");
            if (data.getLength() == 0L) {
                log.info("asset not ready for processing: is 0 bytes: {}", (Object)asset.getPath());
                return true;
            }
            try {
                int numRetries = 1;
                while (asset.isLocked()) {
                    log.info("asset not ready for processing {}: is locked...retry {}/4", (Object)asset.getPath(), (Object)numRetries);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (++numRetries <= 4) continue;
                    log.info("asset not ready for processing: is locked: {}", (Object)asset.getPath());
                    return true;
                }
            }
            catch (UnsupportedRepositoryOperationException e) {
                log.info("isNotReadyForProcessing: repository does not support locking; asset: [{}]: ", (Object)this.safeGetPath(asset), (Object)e);
            }
            return false;
        }
        return true;
    }

    protected List<String> getValuesFromArgs(String key, String[] arguments) {
        LinkedList<String> values = new LinkedList<String>();
        for (String str : arguments) {
            if (!str.startsWith(key + ":")) continue;
            String mt = str.substring((key + ":").length()).trim();
            values.add(mt);
        }
        return values;
    }

    protected String recheck(String mimeType, Node file) throws RepositoryException {
        String name;
        String mType = mimeType;
        if ((mimeType == null || mimeType.equals(APPLICATION_OCTET_STREAM_MIMETYPE)) && this.mimeTypeService.getMimeType(name = file.getName().toLowerCase()) != null) {
            mType = this.mimeTypeService.getMimeType(name);
        }
        return mType;
    }

    protected String safeGetPath(Node node) {
        try {
            return node.getPath();
        }
        catch (RepositoryException e) {
            log.warn("safeGetPath: error while getting path from node: ", e);
            return "(unknown)";
        }
    }

    protected ResourceResolver getResourceResolver(Session session) {
        try {
            return this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
        }
        catch (LoginException e) {
            log.error("failed to get resource resolver", e);
            return null;
        }
    }

    protected AssetManager getAssetManager(Session session) {
        return this.getResourceResolver(session).adaptTo(AssetManager.class);
    }

    protected AssetHandler getAssetHandler(String mimeType) {
        return this.store.getAssetHandler(mimeType);
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindStore(AssetStore assetStore) {
        this.store = assetStore;
    }

    protected void unbindStore(AssetStore assetStore) {
        if (this.store == assetStore) {
            this.store = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

