/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.handler;

import com.adobe.xmp.core.XMPMetadata;
import com.adobe.xmp.core.serializer.RDFXMLSerializer;
import com.adobe.xmp.core.serializer.RDFXMLSerializerContext;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.xmp.XMPHandler;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.commons.util.AssetCache;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.jcr.RepositoryException;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.GenericImageMetadata;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=true)
@Service
public class StandardImageHandler
extends AbstractAssetHandler {
    protected final Logger log = LoggerFactory.getLogger(StandardImageHandler.class);
    public static final String CONFIG_LARGE_FILE_THRESHOLD = "large_file_threshold";
    private static final long DEFAULT_LARGE_FILE_THRESHOLD = 0L;
    public static final String CONFIG_LARGE_COMMENT_THRESHOLD = "large_comment_threshold";
    private static final long DEFAULT_LARGE_COMMENT_THRESHOLD = 5000L;
    public static final String METADATA_IGNORE_LIST = "metadata_ignore_list";
    private static final String[] DEFAULT_METADATA_IGNORE_LIST = new String[]{"Image Description", "Artist", "Copyright"};
    @Property(longValue={0L}, name="large_file_threshold", label="Threshold size to use intermediate temporary file", description="Asset size greater than threshold use temporary file instead of memory buffer to avoid OutOfMemoryError. Value of -1 means that the use of temporary file is disabled. 0 means it is enabled for all sizes.")
    private long largeFileThreshold = 0L;
    @Property(longValue={5000L}, name="large_comment_threshold", label="Threshold size to skip comments being stored", description="Comment size greater than threshold will not be stored. Value of -1 means that all comments would be stored irrespective of their size.")
    private long largeCommentThreshold = 5000L;
    @Property(unbounded=PropertyUnbounded.ARRAY, propertyPrivate=true, value={"Image Description", "Artist", "Copyright"}, name="metadata_ignore_list", label="List of metadata tags to be ignored from extraction")
    private List<String> metadataIgnoreList = Arrays.asList(DEFAULT_METADATA_IGNORE_LIST);
    public static final String GIF_MIMETYPE = "image/gif";
    public static final String PNG1_MIMETYPE = "image/png";
    public static final String PNG2_MIMETYPE = "image/x-png";
    public static final String JPEG_MIMETYPE = "image/jpeg";
    public static final String PJPEG_MIMETYPE = "image/pjpeg";
    public static final String TIFF_MIMETYPE = "image/tiff";
    public static final String TIFF1_MIMETYPE = "image/x-tiff";
    public static final String BMP1_MIMETYPE = "image/x-ms-bmp";
    public static final String BMP2_MIMETYPE = "image/bmp";
    public static final String RAW1_MIMETYPE = "image/x-raw-adobe";
    public static final String RAW2_MIMETYPE = "image/x-raw-hasselblad";
    public static final String RAW3_MIMETYPE = "image/x-raw-fuji";
    public static final String RAW4_MIMETYPE = "image/x-raw-canon";
    public static final String RAW5_MIMETYPE = "image/x-raw-kodak";
    public static final String RAW6_MIMETYPE = "image/x-raw-minolta";
    public static final String RAW7_MIMETYPE = "image/x-raw-nikon";
    public static final String RAW8_MIMETYPE = "image/x-raw-olympus";
    public static final String RAW9_MIMETYPE = "image/x-raw-pentax";
    public static final String RAW10_MIMETYPE = "image/x-raw-sony";
    public static final String RAW11_MIMETYPE = "image/x-raw-sigma";
    public static final String RAW12_MIMETYPE = "image/x-raw-epson";
    public static final String RAW13_MIMETYPE = "image/x-raw-mamiya";
    public static final String RAW14_MIMETYPE = "image/x-raw-leaf";
    public static final String RAW15_MIMETYPE = "image/x-raw-panasonic";
    public static final String RAW16_MIMETYPE = "image/x-raw-phaseone";
    public static final String RAW17_MIMETYPE = "image/x-raw-red";
    public static final String RAW18_MIMETYPE = "image/x-raw-imacon";
    public static final String RAW19_MIMETYPE = "image/x-raw-logitech";
    public static final String RAW20_MIMETYPE = "image/x-raw-casio";
    public static final String RAW21_MIMETYPE = "image/x-raw-rawzor";
    public static final String RAW22_MIMETYPE = "image/x-canon-cr2";
    public static final String RAW23_MIMETYPE = "image/x-nikon-nef";
    public static final String DNG_MIMETYPE = "image/dng";
    protected static final String[] MIME_TYPES = new String[]{"image/gif", "image/png", "image/x-png", "image/tiff", "image/x-tiff", "image/x-ms-bmp", "image/bmp", "image/x-raw-adobe", "image/x-raw-hasselblad", "image/x-raw-fuji", "image/x-raw-canon", "image/x-raw-kodak", "image/x-raw-minolta", "image/x-raw-nikon", "image/x-raw-olympus", "image/x-raw-pentax", "image/x-raw-sony", "image/x-raw-sigma", "image/x-raw-epson", "image/x-raw-mamiya", "image/x-raw-leaf", "image/x-raw-panasonic", "image/x-raw-phaseone", "image/x-raw-red", "image/x-raw-imacon", "image/x-raw-logitech", "image/x-raw-casio", "image/x-raw-rawzor", "image/x-canon-cr2", "image/x-nikon-nef", "image/dng"};
    @Property(boolValue={false})
    protected static final String ENABLE_BINARY_META_EXTRACTION = "cq.dam.enable.ext.meta.extraction";
    protected boolean enableExtMetaExtraction = false;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected XMPHandler xmpHandler;

    protected synchronized void bindXmpHandler(XMPHandler handler) {
        this.xmpHandler = handler;
        this.log.debug("binding xmp handler");
    }

    protected synchronized void unbindXmpHandler(XMPHandler handler) {
        this.xmpHandler = null;
        this.log.debug("un-binding xmp handler");
    }

    @Override
    public String[] getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata = new ExtractedMetadata();
        try {
            this.extractMetadata(asset, metadata);
            this.setMimetype(metadata, asset);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("extractMetadata: error while extracting metadata for asset [{}]: ", (Object)asset.getPath(), (Object)e);
            }
            this.log.warn("extractMetadata: error while extracting metadata for asset [{}]: ", (Object)asset.getPath());
        }
        return metadata;
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(Rendition rendition, Dimension maxDimension) throws IOException {
        block16: {
            AssetCache cache = DamUtil.getAssetCache();
            try {
                BufferedImage bufferedImage;
                if (this.isGif(rendition) || this.isPng(rendition) || this.isRaw(rendition)) {
                    BufferedImage bufferedImage2 = new Layer(cache.getStream(rendition, false), maxDimension).getImage();
                    return bufferedImage2;
                }
                FileInputStream iis = null;
                File imageTmpFile = null;
                Object assetTempFile = null;
                Object fos = null;
                try {
                    BufferedImage bufImage = null;
                    imageTmpFile = File.createTempFile("image", ".tmp");
                    long startTime = System.currentTimeMillis();
                    if (this.doFileBuffering(rendition)) {
                        bufImage = Imaging.getBufferedImage(cache.getFile(rendition));
                        ImageIO.write((RenderedImage)bufImage, "png", imageTmpFile);
                    } else {
                        bufImage = Imaging.getBufferedImage(cache.getStream(rendition, false));
                        Imaging.writeImage(bufImage, imageTmpFile, (ImageFormat)ImageFormats.PNG, null);
                    }
                    long endTime = System.currentTimeMillis();
                    this.log.debug("time taken to convert to png = " + (endTime - startTime) + " ms");
                    iis = FileUtils.openInputStream(imageTmpFile);
                    bufferedImage = new Layer((InputStream)iis, maxDimension).getImage();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly(iis);
                        FileUtils.deleteQuietly(imageTmpFile);
                        throw throwable;
                    }
                    catch (ImageReadException e) {
                        this.log.warn("getImage: error while reading image at path [{}]: ", (Object)rendition.getPath(), (Object)e);
                        break block16;
                    }
                    catch (ImageWriteException e) {
                        this.log.warn("getImage: error while writing image at path [{}]: ", (Object)rendition.getPath(), (Object)e);
                        break block16;
                    }
                    catch (IOException e) {
                        this.log.warn("getImage: error while reading image at path [{}]: ", (Object)rendition.getPath(), (Object)e);
                        break block16;
                    }
                }
                IOUtils.closeQuietly(iis);
                FileUtils.deleteQuietly(imageTmpFile);
                return bufferedImage;
            }
            finally {
                cache.release();
            }
        }
        return null;
    }

    private boolean doFileBuffering(Rendition r) {
        return this.largeFileThreshold != -1L && this.largeFileThreshold <= r.getSize();
    }

    private boolean doAddComment(int commentSize) {
        return this.largeCommentThreshold == -1L || this.largeCommentThreshold != -1L && this.largeCommentThreshold >= (long)commentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Serializable> extractImageInfo(Asset asset) {
        AssetCache cache = DamUtil.getAssetCache();
        try {
            Rendition original = asset.getOriginal();
            ByteSource bs = cache.getByteSource(original, this.doFileBuffering(original));
            ImageParser imageParser = this.getImageParser(bs);
            Map<String, Serializable> map = this.extractImageInfo(asset.getPath(), bs, imageParser);
            return map;
        }
        catch (ImageReadException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("extractImageInfo: error while reading metadata from image [{}]: ", (Object)asset.getPath(), (Object)e);
            } else {
                this.log.warn("extractImageInfo: error while reading metadata from image [{}]: ", (Object)asset.getPath());
            }
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("extractImageInfo: error while reading info from image [{}]: ", (Object)asset.getPath(), (Object)e);
            } else {
                this.log.warn("extractImageInfo: error while reading info from image [{}]: ", (Object)asset.getPath());
            }
        }
        finally {
            cache.release();
        }
        return new HashMap<String, Serializable>();
    }

    private Map<String, Serializable> extractImageInfo(String path, ByteSource bsis, ImageParser ip) {
        try {
            return this.extractImageInfo(path, ip.getImageInfo(bsis));
        }
        catch (ImageReadException e) {
            this.log.warn("extractImageInfo: error while reading metadata from image [{}]: ", (Object)path, (Object)e);
        }
        catch (IOException e) {
            this.log.warn("extractImageInfo: error while reading info from image [{}]: ", (Object)path, (Object)e);
        }
        return new HashMap<String, Serializable>();
    }

    private Map<String, Serializable> extractImageInfo(String path, ImageInfo imageInfo) {
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        int numberOfImages = imageInfo.getNumberOfImages();
        if (numberOfImages < 0) {
            numberOfImages = 1;
        }
        metadata.put("File format", (Serializable)((Object)imageInfo.getFormat().getName()));
        metadata.put("MIME type", (Serializable)((Object)imageInfo.getMimeType()));
        metadata.put("Image Width", Integer.valueOf(imageInfo.getWidth()));
        metadata.put("Image Length", Integer.valueOf(imageInfo.getHeight()));
        metadata.put("Bits per pixel", Integer.valueOf(imageInfo.getBitsPerPixel()));
        metadata.put("Progressive", (Serializable)((Object)(imageInfo.isProgressive() ? "yes" : "no")));
        metadata.put("Number of images", Integer.valueOf(numberOfImages));
        metadata.put("Physical width in dpi", Integer.valueOf(imageInfo.getPhysicalWidthDpi()));
        metadata.put("Physical height in dpi", Integer.valueOf(imageInfo.getPhysicalHeightDpi()));
        metadata.put("Physical width in inches", Double.valueOf(imageInfo.getPhysicalWidthInch()));
        metadata.put("Physical height in inches", Double.valueOf(imageInfo.getPhysicalHeightInch()));
        List<String> comments = imageInfo.getComments();
        int numComments = comments == null ? 0 : comments.size();
        int commentsStored = 0;
        if (numComments > 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < numComments; ++i) {
                if (comments == null || !this.doAddComment(comments.get(i).length())) continue;
                buffer.append(comments.get(i)).append('\n');
                ++commentsStored;
            }
            metadata.put("Comments", (Serializable)((Object)buffer.toString()));
        }
        metadata.put("Number of textual comments", Integer.valueOf(commentsStored));
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractMetadata(Asset asset, ExtractedMetadata metadata) throws IOException, ImageReadException {
        AssetCache cache = DamUtil.getAssetCache();
        Object data = null;
        try {
            ByteSource bs;
            block19: {
                Rendition original;
                block21: {
                    ByteArrayInputStream xmps;
                    block18: {
                        block17: {
                            original = asset.getOriginal();
                            bs = cache.getByteSource(original, this.doFileBuffering(original));
                            ImageParser imageParser = null;
                            try {
                                this.log.debug("extractMetadata, imageParser.getMetadata()");
                                imageParser = this.getImageParser(bs);
                                if (imageParser instanceof TiffImageParser) {
                                    this.extractMetadataTiff(metadata, bs, asset.getPath(), imageParser);
                                } else {
                                    this.extractMetadataGeneric(metadata, bs, asset.getPath(), imageParser);
                                }
                            }
                            catch (Exception e) {
                                Map<String, Serializable> imageDimensionData;
                                this.log.warn("extractMetadata: cannot read metadata from image [{}]: ", (Object)asset.getPath(), (Object)e);
                                if (!(e instanceof ImageReadException) || bs == null || imageParser == null || (imageDimensionData = this.getDimensionMetadata(asset.getPath(), bs, imageParser)).isEmpty()) break block17;
                                metadata.addMetadataProperties(imageDimensionData);
                            }
                        }
                        if (this.enableExtMetaExtraction) {
                            this.extractImageXMP(bs, metadata);
                        }
                        if (this.xmpHandler == null) break block21;
                        xmps = null;
                        try {
                            XMPMetadata xmpMetadata = this.xmpHandler.readXmpMetadata(asset);
                            if (xmpMetadata == null) break block18;
                            byte[] xmpBytes = new RDFXMLSerializer().serializeToBuffer(xmpMetadata, new RDFXMLSerializerContext());
                            xmps = new ByteArrayInputStream(xmpBytes);
                            metadata.setXmp(xmps);
                        }
                        catch (Exception e) {
                            try {
                                if (this.log.isDebugEnabled()) {
                                    this.log.error("Couldn't extract metadata using XMPhandler, attempting brute-force extraction", e);
                                } else {
                                    this.log.warn("Couldn't extract metadata using XMPhandler, attempting brute-force extraction");
                                }
                                this.execGenericProcessor(cache.getStream(original, this.doFileBuffering(original)), metadata);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(xmps);
                                throw throwable;
                            }
                            IOUtils.closeQuietly(xmps);
                            break block19;
                        }
                    }
                    IOUtils.closeQuietly(xmps);
                    break block19;
                }
                this.execGenericProcessor(cache.getStream(original, this.doFileBuffering(original)), metadata);
            }
            if (metadata.getXmp() == null && !this.enableExtMetaExtraction) {
                this.extractImageXMP(bs, metadata);
            }
        }
        catch (Exception e) {
            this.log.warn("extractMetadata: cannot read metadata from image [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        finally {
            cache.release();
            this.log.debug("extractMetadata, done");
        }
    }

    private void extractMetadataGeneric(ExtractedMetadata metadata, ByteSource bs, String path, ImageParser imageParser) throws Exception {
        ImageMetadata data = imageParser.getMetadata(bs);
        this.log.debug("extractMetadata, got ImageMetadata");
        if (data != null && data instanceof JpegImageMetadata) {
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)data;
            JpegPhotoshopMetadata jpegphotoshopMetadata = jpegMetadata.getPhotoshop();
            if (jpegphotoshopMetadata != null) {
                for (ImageMetadata.ImageMetadataItem item : jpegphotoshopMetadata.getItems()) {
                    this.setPhotoshopItemValue(item, metadata);
                }
            }
            data = jpegMetadata.getExif();
        }
        this.log.debug("extractMetadata, extract ImageInfo");
        Map<String, Serializable> imageData = this.extractImageInfo(path, bs, imageParser);
        metadata.addMetadataProperties(imageData);
    }

    private void extractMetadataTiff(ExtractedMetadata metadata, ByteSource bs, String path, ImageParser imageParser) throws Exception {
        TiffReader reader = new TiffReader(false);
        TiffContents contents = reader.readContents(bs, null, FormatCompliance.getDefault());
        this.log.debug("extractMetadata, extract ImageInfo");
        Map<String, Serializable> imageData = this.extractImageInfo(path, this.getImageInfo(contents));
        metadata.addMetadataProperties(imageData);
        for (TiffDirectory dir : contents.directories) {
            for (TiffField tf : dir.getDirectoryEntries()) {
                if (tf.getDirectoryType() == 1) continue;
                String tagName = tf.getTagName();
                FieldType fieldType = tf.getFieldType();
                if (!(!this.enableExtMetaExtraction && (fieldType.equals(FieldType.BYTE) || fieldType.equals(FieldType.UNDEFINED)) || tagName.equals(TiffTagConstants.TIFF_TAG_XMP.name) || this.metadataIgnoreList.contains(tagName))) {
                    this.log.debug("name =" + tagName + ", type=" + tf.getFieldTypeName());
                    metadata.setMetaDataProperty(tagName, this.trimValue(tf));
                    continue;
                }
                this.log.debug("Skipping XMP tag [" + tagName + "],  of type [" + fieldType.getName() + "] XMP is scanned by CQ generic XMP scanner", (Object)tagName);
            }
        }
        this.log.debug("extractMetadata, got ImageMetadata");
    }

    private ImageInfo getImageInfo(TiffContents contents) throws ImageReadException, IOException {
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        TiffField widthField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, true);
        TiffField heightField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, true);
        if (widthField != null && heightField != null) {
            ImageInfo.CompressionAlgorithm ca;
            int height = heightField.getIntValue();
            int width = widthField.getIntValue();
            TiffField resolutionUnitField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_RESOLUTION_UNIT);
            int resolutionUnit = 2;
            if (resolutionUnitField != null && resolutionUnitField.getValue() != null) {
                resolutionUnit = resolutionUnitField.getIntValue();
            }
            double unitsPerInch = -1.0;
            switch (resolutionUnit) {
                default: {
                    break;
                }
                case 2: {
                    unitsPerInch = 1.0;
                    break;
                }
                case 3: {
                    unitsPerInch = 2.54;
                }
            }
            TiffField xResolutionField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_XRESOLUTION);
            TiffField yResolutionField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_YRESOLUTION);
            int physicalWidthDpi = -1;
            float physicalWidthInch = -1.0f;
            int physicalHeightDpi = -1;
            float physicalHeightInch = -1.0f;
            if (unitsPerInch > 0.0) {
                double bitsPerSampleField;
                if (xResolutionField != null && xResolutionField.getValue() != null) {
                    bitsPerSampleField = xResolutionField.getDoubleValue();
                    physicalWidthDpi = (int)Math.round(bitsPerSampleField * unitsPerInch);
                    physicalWidthInch = (float)((double)width / (bitsPerSampleField * unitsPerInch));
                }
                if (yResolutionField != null && yResolutionField.getValue() != null) {
                    bitsPerSampleField = yResolutionField.getDoubleValue();
                    physicalHeightDpi = (int)Math.round(bitsPerSampleField * unitsPerInch);
                    physicalHeightInch = (float)((double)height / (bitsPerSampleField * unitsPerInch));
                }
            }
            TiffField var38 = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE);
            int bitsPerSample = 1;
            if (var38 != null && var38.getValue() != null) {
                bitsPerSample = var38.getIntValueOrArraySum();
            }
            ArrayList<String> comments = new ArrayList<String>();
            List entries = directory.entries;
            for (int format = 0; format < entries.size(); ++format) {
                TiffField formatName = (TiffField)entries.get(format);
                String mimeType = formatName.toString();
                comments.add(mimeType);
            }
            int numberOfImages = contents.directories.size();
            String formatDetails = "Tiff v." + contents.header.tiffVersion;
            boolean usesPalette = false;
            TiffField colorMapField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_COLOR_MAP);
            if (colorMapField != null) {
                usesPalette = true;
            }
            boolean colorType = true;
            int compression = 0xFFFF & directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_COMPRESSION);
            ImageInfo.ColorType ctype = ImageInfo.ColorType.UNKNOWN;
            switch (compression) {
                case 1: {
                    ca = ImageInfo.CompressionAlgorithm.NONE;
                    break;
                }
                case 2: {
                    ca = ImageInfo.CompressionAlgorithm.CCITT_1D;
                    break;
                }
                case 3: {
                    ca = ImageInfo.CompressionAlgorithm.CCITT_GROUP_3;
                    break;
                }
                case 4: {
                    ca = ImageInfo.CompressionAlgorithm.CCITT_GROUP_4;
                    break;
                }
                case 5: {
                    ca = ImageInfo.CompressionAlgorithm.LZW;
                    break;
                }
                case 6: {
                    ca = ImageInfo.CompressionAlgorithm.JPEG;
                    break;
                }
                case 32771: {
                    ca = ImageInfo.CompressionAlgorithm.NONE;
                    break;
                }
                case 32773: {
                    ca = ImageInfo.CompressionAlgorithm.PACKBITS;
                    break;
                }
                default: {
                    ca = ImageInfo.CompressionAlgorithm.UNKNOWN;
                }
            }
            ImageInfo result = new ImageInfo(formatDetails, bitsPerSample, comments, ImageFormats.TIFF, "TIFF Tag-based Image File Format", height, TIFF_MIMETYPE, numberOfImages, physicalHeightDpi, physicalHeightInch, physicalWidthDpi, physicalWidthInch, width, false, false, usesPalette, ctype, ca);
            return result;
        }
        throw new ImageReadException("TIFF image missing size info.");
    }

    private Map<String, Serializable> getDimensionMetadata(String path, ByteSource bsis, ImageParser ip) {
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        try {
            Dimension d = ip.getImageSize(bsis, null);
            if (d != null) {
                metadata.put("Image Width", Integer.valueOf((int)d.getWidth()));
                metadata.put("Image Length", Integer.valueOf((int)d.getHeight()));
            }
        }
        catch (ImageReadException e) {
            this.log.warn("getDimensionMetadata - imageParser.getImageSize() fallback attempt: error while reading metadata from image [{}]: ", (Object)path, (Object)e);
        }
        catch (IOException e) {
            this.log.warn("getDimensionMetadata - imageParser.getImageSize() fallback attempt: error while reading info from image [{}]: ", (Object)path, (Object)e);
        }
        return metadata;
    }

    private void extractImageXMP(ByteSource bs, ExtractedMetadata metadata) {
        try {
            String xmpStr = Imaging.getXmpXml(bs, null);
            this.log.debug("extracted xmp string is {}", (Object)xmpStr);
            if (xmpStr != null) {
                metadata.setXmp(new ByteArrayInputStream(xmpStr.getBytes("utf-8")));
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("could not extract XMP from the image", e);
            }
            this.log.warn("could not extract XMP from the image");
        }
    }

    private void setPhotoshopItemValue(ImageMetadata.ImageMetadataItem item, ExtractedMetadata extractedMetadata) {
        if (item instanceof GenericImageMetadata.GenericImageMetadataItem) {
            GenericImageMetadata.GenericImageMetadataItem imageItem = (GenericImageMetadata.GenericImageMetadataItem)item;
            String keyword = imageItem.getKeyword();
            String text = imageItem.getText();
            Object existingVal = extractedMetadata.getMetaDataProperty(keyword);
            if (existingVal != null) {
                if (existingVal instanceof String) {
                    ArrayList<String> newVal = new ArrayList<String>();
                    newVal.add((String)existingVal);
                    newVal.add(text);
                    extractedMetadata.setMetaDataProperty(keyword, newVal);
                } else if (existingVal instanceof List) {
                    ((List)existingVal).add(text);
                }
            } else {
                extractedMetadata.setMetaDataProperty(keyword, text);
            }
        }
    }

    private ImageParser getImageParser(ByteSource byteSrc) throws ImageReadException, IOException {
        ImageFormat format = Imaging.guessFormat(byteSrc);
        if (!format.equals(ImageFormats.UNKNOWN)) {
            ImageParser[] imageParsers;
            for (ImageParser imageParser : imageParsers = ImageParser.getAllImageParsers()) {
                if (!imageParser.canAcceptType(format)) continue;
                return imageParser;
            }
        }
        throw new ImageReadException("Can't parse this format.");
    }

    private Object trimValue(TiffField field) throws ImageReadException {
        Object fieldValue = field.getValue();
        if (fieldValue instanceof String) {
            fieldValue = StringUtils.trimToEmpty(fieldValue.toString());
        }
        if (fieldValue instanceof RationalNumber && ((RationalNumber)fieldValue).toString().indexOf(44) > 0) {
            fieldValue = ((RationalNumber)fieldValue).numerator / ((RationalNumber)fieldValue).divisor;
        }
        return fieldValue;
    }

    private boolean isPng(Rendition rendition) {
        return rendition.getMimeType().startsWith(PNG1_MIMETYPE) || rendition.getMimeType().startsWith(PNG2_MIMETYPE);
    }

    private boolean isGif(Rendition rendition) {
        return rendition.getMimeType().startsWith(GIF_MIMETYPE);
    }

    private boolean isRaw(Rendition rendition) {
        return rendition.getMimeType().startsWith("image/x-raw-");
    }

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
        this.enableExtMetaExtraction = PropertiesUtil.toBoolean(context.getProperties().get(ENABLE_BINARY_META_EXTRACTION), false);
        this.largeFileThreshold = PropertiesUtil.toLong(context.getProperties().get(CONFIG_LARGE_FILE_THRESHOLD), 0L);
        this.largeCommentThreshold = PropertiesUtil.toLong(context.getProperties().get(CONFIG_LARGE_COMMENT_THRESHOLD), 5000L);
        this.metadataIgnoreList = Arrays.asList(PropertiesUtil.toStringArray(context.getProperties().get(METADATA_IGNORE_LIST), DEFAULT_METADATA_IGNORE_LIST));
    }
}

