/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.handler;

import com.day.cq.dam.api.Context;
import com.day.cq.dam.api.FormatHandler;
import com.day.cq.dam.api.Processor;
import com.day.cq.dam.api.ProcessorException;
import com.day.cq.dam.commons.handler.SimpleContext;
import com.day.cq.dam.commons.handler.XMPProcessor;
import com.day.cq.dam.commons.thumbnail.XapThumbnailsProcessor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

public class DefaultFormatHandler
implements FormatHandler {
    @Override
    public boolean accepts(byte[] data, int off, int len) {
        return true;
    }

    protected Processor[] getThumbnailProcessors(Context context) {
        return new Processor[]{new XapThumbnailsProcessor(context)};
    }

    protected Processor[] getMetadataProcessors(Context context) {
        return new Processor[]{new XMPProcessor(context)};
    }

    protected Processor[] getAllProcessors(Context context) {
        Processor[] t = this.getThumbnailProcessors(context);
        Processor[] m = this.getMetadataProcessors(context);
        Processor[] result = new Processor[t.length + m.length];
        System.arraycopy(t, 0, result, 0, t.length);
        System.arraycopy(m, 0, result, t.length, m.length);
        return result;
    }

    @Override
    public final void process(InputStream in, Context context) throws IOException {
        int len;
        Processor[] processors = this.getAllProcessors(context);
        byte[] data = new byte[8192];
        while ((len = in.read(data)) > 0) {
            for (Processor processor : processors) {
                processor.process(data, 0, len);
            }
        }
    }

    @Override
    public BufferedImage getThumbnailImage(InputStream in) throws IOException, ProcessorException {
        int len;
        SimpleContext context = new SimpleContext();
        Processor[] processors = this.getThumbnailProcessors(context);
        byte[] data = new byte[8192];
        while ((len = in.read(data)) > 0) {
            for (Processor processor : processors) {
                processor.process(data, 0, len);
            }
        }
        BufferedImage[] thumbnails = context.getThumbnails();
        if (thumbnails != null && thumbnails.length > 0) {
            return thumbnails[0];
        }
        ProcessorException[] exceptions = context.getExceptions();
        if (exceptions != null) {
            throw exceptions[exceptions.length - 1];
        }
        return null;
    }

    @Override
    public InputStream getMetadata(InputStream in) throws IOException, ProcessorException {
        int len;
        SimpleContext context = new SimpleContext();
        Processor[] processors = this.getMetadataProcessors(context);
        byte[] data = new byte[8192];
        while ((len = in.read(data)) > 0) {
            for (Processor processor : processors) {
                processor.process(data, 0, len);
            }
        }
        InputStream[] metadata = context.getMetadata();
        if (metadata != null && metadata.length > 0) {
            return metadata[0];
        }
        ProcessorException[] exceptions = context.getExceptions();
        if (exceptions != null) {
            throw exceptions[exceptions.length - 1];
        }
        return null;
    }

    protected int locate(byte[] pattern, byte[] data, int off, int len) {
        int i = 0;
        while (i < pattern.length && off < len) {
            i = pattern[i] == data[off] ? ++i : 0;
            ++off;
        }
        return i == pattern.length ? off : -1;
    }

    protected boolean matchPrefix(byte[] expected, byte[] actual) throws IOException {
        if (actual.length < expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            return false;
        }
        return true;
    }
}

