/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.handler;

import com.adobe.granite.asset.api.AssetRelation;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetHandlerException;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.ProcessorException;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.cache.BufferedImageCache;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.api.renditions.RenditionMaker;
import com.day.cq.dam.api.renditions.RenditionTemplate;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.cq.dam.commons.handler.XMPProcessor;
import com.day.cq.dam.commons.thumbnail.ThumbnailConfigImpl;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=false)
public abstract class AbstractAssetHandler
implements AssetHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractAssetHandler.class);
    public static String PROPERTY_DEACTIVATED_MIME_TYPES = "dam.assethandler.deactivateMimeTypes";
    @Reference(policy=ReferencePolicy.STATIC)
    private ResourceResolverFactory jcrResolverFactory;
    @Reference(policy=ReferencePolicy.STATIC)
    private BufferedImageCache imageCache;
    @Reference
    private RenditionMaker renditionMaker;

    @Override
    public void createThumbnails(Asset asset, Collection<ThumbnailConfig> configs) throws IOException {
        this.createThumbnails(asset, asset.getOriginal(), configs);
    }

    @Override
    public void createThumbnails(Asset asset) throws IOException {
        this.createThumbnails(asset, asset.getOriginal(), this.getThumbnailConfigs(asset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createThumbnails(Asset asset, Rendition rendition, Collection<ThumbnailConfig> configs) throws IOException {
        if (rendition == null) {
            throw new IOException("cannot create  thumbnail for for asset [" + asset.getPath() + "]: rendition doesn't exist.");
        }
        BufferedImageCache.Entry image = this.imageCache.getImage(rendition, this);
        try {
            if (image != null && image.getImage() != null) {
                RenditionTemplate[] templates = this.createRenditionTemplates(asset, configs.toArray(new ThumbnailConfig[0]), this.renditionMaker);
                this.renditionMaker.generateRenditions(asset, templates);
            } else {
                log.error("createThumbnails: cannot create thumbnails for asset [{}], failed loading graphical representation for rendition [{}].", (Object)asset.getPath(), (Object)rendition.getPath());
            }
        }
        finally {
            if (image != null) {
                image.release();
            }
        }
    }

    private RenditionTemplate[] createRenditionTemplates(Asset asset, ThumbnailConfig[] thumbnails, RenditionMaker renditionMaker) {
        RenditionTemplate[] templates = new RenditionTemplate[thumbnails.length];
        for (int i = 0; i < thumbnails.length; ++i) {
            ThumbnailConfig thumb = thumbnails[i];
            templates[i] = renditionMaker.createThumbnailTemplate(asset, thumb.getWidth(), thumb.getHeight(), thumb.doCenter());
        }
        return templates;
    }

    @Override
    public boolean canHandleSubAssets() {
        return false;
    }

    @Override
    public List<String> processSubAssets(Asset asset) {
        log.debug("processSubAssets: no subassets to process for asset [{}].", (Object)asset.getPath());
        return new ArrayList<String>();
    }

    @Override
    public Iterator<? extends AssetRelation> processRelated(Asset asset) {
        log.debug("processReferences: no references to process for asset [{}].", (Object)asset.getPath());
        return Collections.emptyList().iterator();
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return null;
    }

    @Override
    public BufferedImage getImage(Rendition rendition, Dimension maxDimension) throws IOException {
        return this.getImage(rendition);
    }

    @Override
    public void exportAsset(Asset asset, OutputStream stream) throws AssetHandlerException {
        InputStream is = null;
        try {
            is = asset.getOriginal().getStream();
            IOUtils.copy(is, stream);
        }
        catch (Exception e) {
            throw new AssetHandlerException("Cannot export asset: " + e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    protected ResourceResolver getResourceResolver(Session session) {
        try {
            return this.jcrResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
        }
        catch (LoginException e) {
            throw new RuntimeException("can not create resolver from session", e);
        }
    }

    protected AssetManager getAssetManager(Session session) {
        return this.getResourceResolver(session).adaptTo(AssetManager.class);
    }

    protected InputStream getInputStream(Node file) {
        try {
            String dataPath;
            String string = dataPath = file.isNodeType("dam:Asset") ? "jcr:content/renditions/original/jcr:content/jcr:data" : "jcr:content/jcr:data";
            if (file.hasProperty(dataPath)) {
                return file.getProperty(dataPath).getBinary().getStream();
            }
        }
        catch (RepositoryException e) {
            log.warn("getInputStream: repository error while getting stream for file [{}]: ", (Object)this.safeGetPath(file), (Object)e);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    protected void setMimetype(ExtractedMetadata metadata, Asset asset) {
        Rendition original = asset.getOriginal();
        if (original != null) {
            metadata.setMetaDataProperty("dc:format", original.getMimeType());
        }
    }

    protected String safeGetPath(Node node) {
        try {
            return node.getPath();
        }
        catch (RepositoryException e) {
            log.warn("safeGetPath: error while getting path from node: ", e);
            return "(unknown)";
        }
    }

    protected Collection<ThumbnailConfig> getThumbnailConfigs(Asset asset) {
        HashSet<ThumbnailConfig> set = new HashSet<ThumbnailConfig>();
        List<Rendition> renditions = asset.getRenditions();
        for (Rendition rendition : renditions) {
            ThumbnailConfigImpl config;
            String name = rendition.getName();
            if (!name.startsWith("cq5dam.thumbnail.")) continue;
            String[] fragments = name.split("\\.");
            Integer width = Integer.valueOf(fragments[0]);
            Integer height = Integer.valueOf(fragments[1]);
            boolean doCenter = false;
            if (fragments.length > 2) {
                doCenter = Boolean.valueOf(fragments[2]);
            }
            if (null != (config = new ThumbnailConfigImpl(width, height, doCenter))) {
                set.add(config);
                continue;
            }
            log.error("getThumbnailConfigs: cannot add invalid config [{}] for asset [{}].", (Object)name, (Object)asset.getPath());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execGenericProcessor(InputStream is, ExtractedMetadata metadata) {
        try {
            InputStream xmp = XMPProcessor.process(is);
            if (xmp != null) {
                metadata.setXmp(xmp);
            }
        }
        catch (IOException e) {
            log.error("I/O error while getting metadata", e);
        }
        catch (ProcessorException e) {
            log.error("Failed to extract metadata : {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("Stack trace.", e);
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    protected void bindJcrResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.jcrResolverFactory = resourceResolverFactory;
    }

    protected void unbindJcrResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.jcrResolverFactory == resourceResolverFactory) {
            this.jcrResolverFactory = null;
        }
    }

    protected void bindImageCache(BufferedImageCache bufferedImageCache) {
        this.imageCache = bufferedImageCache;
    }

    protected void unbindImageCache(BufferedImageCache bufferedImageCache) {
        if (this.imageCache == bufferedImageCache) {
            this.imageCache = null;
        }
    }

    protected void bindRenditionMaker(RenditionMaker renditionMaker) {
        this.renditionMaker = renditionMaker;
    }

    protected void unbindRenditionMaker(RenditionMaker renditionMaker) {
        if (this.renditionMaker == renditionMaker) {
            this.renditionMaker = null;
        }
    }
}

