/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.inherit;

import com.day.cq.commons.ValueMapWrapper;
import com.day.cq.commons.inherit.InheritanceValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class HierarchyNodeInheritanceValueMap
extends ValueMapWrapper
implements InheritanceValueMap {
    private Resource resource;

    public HierarchyNodeInheritanceValueMap(Resource resource) {
        super(ResourceUtil.getValueMap(resource));
        this.resource = resource;
    }

    public HierarchyNodeInheritanceValueMap(ValueMap map) {
        super(map);
        this.resource = null;
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        if (type == null) {
            return (T)this.get(name);
        }
        return (T)super.get(name, type);
    }

    @Override
    public <T> T getInherited(String name, Class<T> type) {
        T value = this.get(name, type);
        if (value == null) {
            value = this.getParentPageValue(HierarchyNodeInheritanceValueMap.getInnerPath(this.resource), name, type);
        }
        return value;
    }

    @Override
    public <T> T getInherited(String name, T defaultValue) {
        Class<?> type = defaultValue == null ? null : defaultValue.getClass();
        Class<Object> value = this.getInherited(name, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    protected <T> T getParentPageValue(String innerPath, String name, Class<T> type) {
        Resource innerResource;
        Class<T> value;
        ResourceResolver resolver;
        Resource content;
        if (this.resource == null) {
            return null;
        }
        Resource parent = ResourceUtil.getParent(this.resource);
        boolean isContentNode = ResourceUtil.getName(this.resource).equals("jcr:content");
        if (parent == null) {
            parent = HierarchyNodeInheritanceValueMap.getNextExistingParent(this.resource);
            if (parent == null) {
                return null;
            }
            isContentNode = false;
        }
        if (!isContentNode && (content = (resolver = parent.getResourceResolver()).getResource(parent, "jcr:content")) != null && (value = ResourceUtil.getValueMap(innerResource = resolver.getResource(content, innerPath)).get(name, type)) != null) {
            return (T)value;
        }
        return new HierarchyNodeInheritanceValueMap(parent).getParentPageValue(innerPath, name, type);
    }

    protected static String getInnerPath(Resource resource) {
        if (resource == null) {
            return ".";
        }
        String resPath = resource.getPath();
        int pos = resPath.indexOf("jcr:content/");
        if (pos <= 0) {
            return ".";
        }
        return resPath.substring(pos + "jcr:content".length() + 1);
    }

    protected static Resource getNextExistingParent(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        String path = resource.getPath();
        do {
            if ((path = ResourceUtil.getParent(path)) != null) continue;
            return null;
        } while ((resource = resolver.getResource(path)) == null);
        return resource;
    }
}

