/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.path;

public class XMPPathSegment {
    private final Type type;
    private final String namespace;
    private final String name;
    private final String value;
    private final int index;

    private XMPPathSegment(Type type, String namespace, String name) {
        this(type, namespace, name, null, -1);
    }

    private XMPPathSegment(Type type, String namespace, String name, String value) {
        this(type, namespace, name, value, -1);
    }

    private XMPPathSegment(Type type, String namespace, String name, int index) {
        this(type, namespace, name, null, index);
    }

    private XMPPathSegment(Type type, String namespace, String name, String value, int index) {
        this.type = type;
        this.namespace = namespace;
        this.name = name;
        this.value = value;
        this.index = index;
    }

    public static XMPPathSegment createPropertySegment(String namespace, String name) {
        return new XMPPathSegment(Type.PROPERTY, namespace, name);
    }

    public static XMPPathSegment createArrayIndexSegment(String namespace, int index) {
        return new XMPPathSegment(Type.ARRAY_INDEX, namespace, null, index);
    }

    public static XMPPathSegment createQualifierSegment(String namespace, String name) {
        return new XMPPathSegment(Type.QUALIFIER, namespace, name);
    }

    public static XMPPathSegment createQualifierSelectorSegment(String namespace, String name, String value) {
        return new XMPPathSegment(Type.QUALIFIER_SELECTOR, namespace, name, value);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMPPathSegment other = (XMPPathSegment)obj;
        if (this.type != other.type) {
            return false;
        }
        switch (this.type) {
            case QUALIFIER_SELECTOR: {
                if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                    return false;
                }
            }
            case PROPERTY: 
            case QUALIFIER: {
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                if (!(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace))) break;
                return false;
            }
            case ARRAY_INDEX: {
                if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
                    return false;
                }
                if (this.index == other.index) break;
                return false;
            }
        }
        return true;
    }

    public static enum Type {
        PROPERTY,
        ARRAY_INDEX,
        QUALIFIER,
        QUALIFIER_SELECTOR;

    }
}

