/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.wspolicy;

import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.wspolicy.Policy;
import com.adobe.xfa.wspolicy.PrimitiveAssertion;

public class CompoundAssertion
extends Policy {
    CompoundAssertion(Document oDestDoc, Element oSrcNode, int eType) {
        super(oDestDoc, oSrcNode);
        this.setAssertionType(eType);
        for (Node oChild = oSrcNode.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            Policy poChildPolicy;
            if (!(oChild instanceof Element) || (poChildPolicy = Policy.loadPolicy(oDestDoc, (Element)oChild)) == null) continue;
            this.addPolicy(poChildPolicy);
        }
    }

    CompoundAssertion(Document oDestDoc, String aNameSpaceURI, String aLocalName) {
        super(oDestDoc, aNameSpaceURI, aLocalName);
        if (aLocalName == "Policy" || aLocalName == "All") {
            this.setAssertionType(1);
        } else if (aLocalName == "ExactlyOne") {
            this.setAssertionType(2);
        }
    }

    public PrimitiveAssertion getPrimitiveAssertion(String aNameSpaceURI, String aLocalName, int nOccurrence) {
        int nIndex = 0;
        for (Policy poChild = this.getFirstPolicyChild(); poChild != null; poChild = poChild.getNextPolicySibling()) {
            assert (poChild instanceof PrimitiveAssertion);
            if (poChild.getNS() != aNameSpaceURI || poChild.getLocalName() != aLocalName) continue;
            if (nIndex == nOccurrence) {
                return (PrimitiveAssertion)poChild;
            }
            ++nIndex;
        }
        return null;
    }

    public PrimitiveAssertion addPrimitiveAssertion(String aNameSpaceURI, String aLocalName) {
        Document oDestDoc = this.getDomNode().getOwnerDocument();
        PrimitiveAssertion poPrimitive = new PrimitiveAssertion(oDestDoc, aNameSpaceURI, aLocalName);
        this.addPolicy(poPrimitive);
        return poPrimitive;
    }

    public CompoundAssertion addChoicePolicy() {
        Document oDestDoc = this.getDomNode().getOwnerDocument();
        CompoundAssertion poChoice = new CompoundAssertion(oDestDoc, "http://schemas.xmlsoap.org/ws/2004/09/policy", "ExactlyOne");
        this.addPolicy(poChoice);
        return poChoice;
    }
}

