/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.wsdl;

import com.adobe.xfa.Element;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.wsdl.WSDLDocument;
import com.adobe.xfa.wsdl.WSDLMessage;
import com.adobe.xfa.wsdl.WSDLNode;
import java.util.ArrayList;
import java.util.List;

public class WSDLOperation
extends WSDLNode {
    public static final int OP_TYPE_UNKNOWN = 1;
    public static final int OP_TYPE_ONE_WAY = 2;
    public static final int OP_TYPE_REQUEST_RESPONSE = 3;
    public static final int OP_TYPE_SOLICIT_RESPONSE = 4;
    public static final int OP_TYPE_NOTIFICATION = 5;
    private int meOperationType = 1;
    private List<WSDLNode> mBindingOperationNodes;

    public WSDLOperation(WSDLDocument poDocument, Element oSrc) {
        super(poDocument, oSrc, 6);
    }

    public int getOperationType() {
        return this.meOperationType;
    }

    void setOperationType(int operationType) {
        this.meOperationType = operationType;
    }

    public String getInputName() {
        return this.getInOutName(11, "Request", "Response");
    }

    public WSDLMessage getInputMessage() {
        WSDLNode oNode = this.getWSDLChildNode(11, "");
        if (oNode == null) {
            return null;
        }
        String sMessage = oNode.getWSDLAttribute(2);
        WSDLNode oDefinitions = this.getWSDLOwnerDocument().getDefinitionsNode();
        WSDLNode oMessage = oDefinitions.getWSDLChildNode(4, sMessage);
        return oMessage instanceof WSDLMessage ? (WSDLMessage)oMessage : null;
    }

    public String getOutputName() {
        return this.getInOutName(12, "Response", "Solicit");
    }

    public WSDLMessage getOutputMessage() {
        WSDLNode oNode = this.getWSDLChildNode(12, "");
        if (oNode == null) {
            return null;
        }
        String sMessage = oNode.getWSDLAttribute(2);
        WSDLNode oDefinitions = this.getWSDLOwnerDocument().getDefinitionsNode();
        WSDLNode oMessage = oDefinitions.getWSDLChildNode(4, sMessage);
        return oMessage instanceof WSDLMessage ? (WSDLMessage)oMessage : null;
    }

    public List<WSDLNode> getBindingOperationNodes() {
        return this.mBindingOperationNodes;
    }

    void addBindingOperation(WSDLNode operation) {
        if (this.mBindingOperationNodes == null) {
            this.mBindingOperationNodes = new ArrayList<WSDLNode>();
        }
        this.mBindingOperationNodes.add(operation);
    }

    private String getInOutName(int childType, String requestAppend, String SolicitAppend) {
        WSDLNode child = this.getWSDLChildNode(childType, null);
        if (child == null) {
            return "";
        }
        String sName = child.getWSDLName();
        if (StringUtils.isEmpty(sName)) {
            sName = this.getWSDLName();
            String appendText = null;
            switch (this.meOperationType) {
                case 3: {
                    appendText = requestAppend;
                    break;
                }
                case 4: {
                    appendText = SolicitAppend;
                }
            }
            if (appendText != null) {
                StringBuilder builder = new StringBuilder(sName);
                builder.append(appendText);
                sName = builder.toString();
            }
        }
        return sName;
    }
}

