/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.Peer;

public final class PeerImpl {
    private static final int REALLOC_SIZE = 4;
    private boolean mbDeaf;
    private boolean mbMute;
    private Peer[] mPeeredNodeList;
    private Peer[] mPeerList;
    private final Peer mSrc;

    public PeerImpl(Peer src) {
        this.mSrc = src;
    }

    public void addPeer(Peer peerNode) {
        if (peerNode != null) {
            peerNode.addPeeredNode(this.mSrc);
            this.mPeerList = this.addToList(peerNode, this.mPeerList);
        }
    }

    public void addPeeredNode(Peer peer) {
        this.mPeeredNodeList = this.addToList(peer, this.mPeeredNodeList);
    }

    private Peer[] addToList(Peer peer, Peer[] peerList) {
        if (peerList == null) {
            peerList = new Peer[4];
            peerList[0] = peer;
            return peerList;
        }
        int nCnt = peerList.length;
        for (int i = 0; i < nCnt; ++i) {
            if (peerList[i] != null) continue;
            peerList[i] = peer;
            return peerList;
        }
        Peer[] newList = new Peer[nCnt + 4];
        System.arraycopy(peerList, 0, newList, 0, nCnt);
        newList[nCnt] = peer;
        return newList;
    }

    public void clearPeers() {
        Peer peer;
        int i;
        if (this.mPeeredNodeList != null) {
            for (i = this.mPeeredNodeList.length - 1; i >= 0; --i) {
                peer = this.mPeeredNodeList[i];
                if (peer == null) continue;
                peer.removePeer(this.mSrc);
            }
        }
        if (this.mPeerList != null) {
            for (i = 0; i < this.mPeerList.length; ++i) {
                peer = this.mPeerList[i];
                if (peer == null) continue;
                peer.removePeeredNode(this.mSrc);
                this.mPeerList[i] = null;
            }
        }
    }

    public void deafen() {
        this.mbDeaf = true;
    }

    public Peer getPeer(int nPeer) {
        if (this.mPeerList != null && nPeer < this.mPeerList.length) {
            return this.mPeerList[nPeer];
        }
        return null;
    }

    public boolean isDeaf() {
        return this.mbDeaf;
    }

    public boolean isMute() {
        return this.mbMute;
    }

    public void mute() {
        this.mbMute = true;
    }

    public void notifyPeers(int eventType, String arg1, Object arg2) {
        Peer peer;
        if (this.mbMute) {
            return;
        }
        if (this.mPeerList == null) {
            return;
        }
        for (int i = 0; i < this.mPeerList.length && (peer = this.mPeerList[i]) != null; ++i) {
            if (peer.isDeaf()) continue;
            peer.updateFromPeer(this.mSrc, eventType, arg1, arg2);
        }
    }

    public void removeFromList(Peer peer, Peer[] peerList) {
        if (peerList != null) {
            int nCnt = peerList.length;
            for (int i = 0; i < nCnt && peerList[i] != null; ++i) {
                if (peerList[i] != peer) continue;
                System.arraycopy(peerList, i + 1, peerList, i, nCnt - i - 1);
                peerList[nCnt - 1] = null;
                return;
            }
        }
    }

    public void removePeer(Peer peerNode) {
        if (peerNode != null) {
            this.removeFromList(peerNode, this.mPeerList);
            peerNode.removePeeredNode(this.mSrc);
        }
    }

    public void removePeeredNode(Peer peer) {
        this.removeFromList(peer, this.mPeeredNodeList);
        this.mSrc.peerRemoved(peer);
    }

    public void unDeafen() {
        this.mbDeaf = false;
    }

    public void unMute() {
        this.mbMute = false;
    }
}

