/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.DateTimeUtil;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.StringUtils;
import java.util.Calendar;
import java.util.TimeZone;

public class LcDate {
    public static final String DATE_FMT1 = "YYYYMMDD";
    public static final String DATE_FMT2 = "YYYY-MM-DD";
    public static final String DATE_PICTURE_SYMBOLS = "DJMEeYWwGgt";
    public static final int DEFAULT_CENTURY_SPLIT = 30;
    public static final String DEFAULT_DATE_FMT = "MMM D, YYYY";
    static final CJKTable[] gCnEra = new CJKTable[]{new CJKTable(1, 26, new String[]{"\u5149\u7eea"}), new CJKTable(3288, 1, new String[]{"\u5ba3\u7edf"}), new CJKTable(4383, 1, new String[]{"\u6c11\u56fd"}), new CJKTable(18171, 1949, new String[]{""})};
    static final CJKTable[] gHkEra = new CJKTable[]{new CJKTable(1, 26, new String[]{"\u5149\u7dd2"}), new CJKTable(3288, 1, new String[]{"\u5ba3\u7d71"}), new CJKTable(4383, 1, new String[]{"\u6c11\u570b"}), new CJKTable(18171, 1949, new String[]{""})};
    static final CJKTable[] gJpEra = new CJKTable[]{new CJKTable(1, 33, new String[]{"M", "\uff2d", "\u660e", "\u660e\u6cbb", "\u00dfe"}), new CJKTable(4594, 1, new String[]{"T", "\uff34", "\u5927", "\u5927\u6b63", "\u337d"}), new CJKTable(9855, 1, new String[]{"S", "\uff33", "\u662d", "\u662d\u548c", "\u337c"}), new CJKTable(32515, 1, new String[]{"H", "\uff28", "\u5e73", "\u5e73\u6210", "\u337b"})};
    static final CJKTable[] gKrEra = new CJKTable[]{new CJKTable(1, 4233, new String[]{"\ub2e8\uae30", "\u6a80\u7d00"})};
    static final CJKTable[] gThEra = new CJKTable[]{new CJKTable(1, 2442, new String[]{"B.E.", "\u0e1e.\u0e28.", "\u0e1e\u0e38\u0e17\u0e18\u0e28\u0e31\u0e01\u0e23\u0e32\u0e0a"})};
    static final CJKTable[] gTwEra = new CJKTable[]{new CJKTable(1, 26, new String[]{"\u5149\u7dd2"}), new CJKTable(3288, 1, new String[]{"\u5ba3\u7d71"}), new CJKTable(4383, 1, new String[]{"\u6c11\u570b"})};
    static final int[] monthDays = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    int m2DigitYear;
    int mAdjustment;
    int mAltEra;
    boolean mbISOWeekSeen;
    int mCenturySplit;
    int mDayOfMonth;
    int mDayOfWeek;
    int mDayOfYear;
    int mDays;
    int mEra;
    protected LcLocale mLocale;
    int mMonthOfYear;
    final Symbols mSymbols = new Symbols();
    boolean mValid;
    int mWeekOfMonth;
    int mWeekOfYear;
    int mYearOfEra;

    private static CJKTable[] getAltEraTable(LcLocale locale) {
        if (locale.isJapanese()) {
            return gJpEra;
        }
        if (locale.isKorean()) {
            return gKrEra;
        }
        if (locale.isTraditionalChinese()) {
            return gTwEra;
        }
        if (locale.getName().equals("zh_HK")) {
            return gHkEra;
        }
        if (locale.isChinese()) {
            return gCnEra;
        }
        if (locale.isThai()) {
            return gThEra;
        }
        return null;
    }

    public static String getDateFormat(int style, String locale) {
        return new LcData(locale).getDateFormat(style);
    }

    private static int getEpochEra(CJKTable[] pEraTbl, int eraStart) {
        assert (pEraTbl != null);
        for (int i = 0; i < pEraTbl.length; ++i) {
            if (pEraTbl[i].nEraStart != eraStart) continue;
            return pEraTbl[i].nEpochStart;
        }
        return 0;
    }

    public static String getLocalDateFormat(int style, String locale) {
        return new LcData(locale).getLocalDateFormat(style);
    }

    private static int getNextEra(CJKTable[] pEraTbl, int eraStart) {
        assert (pEraTbl != null);
        for (int i = 0; i < pEraTbl.length; ++i) {
            if (pEraTbl[i].nEraStart <= eraStart) continue;
            return pEraTbl[i].nEraStart;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isLeap(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static int P(int y) {
        return y + y / 4 - y / 100 + y / 400;
    }

    private static int startOfYear(int year) {
        if (year == 0) {
            return 0;
        }
        int days = year * 365 + (year - 1) / 4 - (year - 1) / 100 + (year + 299) / 400;
        return days;
    }

    public LcDate(int days, String locale, int centurySplit) {
        String sLocale = StringUtils.isEmpty(locale) ? LcLocale.getLocale() : locale;
        this.mLocale = new LcLocale(sLocale);
        if (!this.mLocale.isValid()) {
            this.mLocale = new LcLocale("en_US");
        }
        this.setDateSymbols(this.mLocale.getIsoName());
        this.mCenturySplit = centurySplit;
        this.mAdjustment = 0;
        this.mDays = days;
        this.mValid = this.mDays > 0;
    }

    public LcDate(String locale, int centurySplit) {
        Calendar today = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int day = today.get(5);
        int month = today.get(2) + 1;
        int year = today.get(1);
        String sLocale = StringUtils.isEmpty(locale) ? LcLocale.getLocale() : locale;
        this.mLocale = new LcLocale(sLocale);
        if (!this.mLocale.isValid()) {
            this.mLocale = new LcLocale("en_US");
        }
        this.setDateSymbols(this.mLocale.getIsoName());
        this.mCenturySplit = centurySplit;
        this.mAdjustment = 0;
        this.mDays = this.epoch(day, month, year - 1900);
        this.mValid = this.mDays > 0;
    }

    public LcDate(String date, String pat, String locale, int centurySplit) {
        String sLocale = StringUtils.isEmpty(locale) ? LcLocale.getLocale() : locale;
        this.mLocale = new LcLocale(sLocale);
        if (!this.mLocale.isValid()) {
            this.mLocale = new LcLocale("en_US");
        }
        this.setDateSymbols(this.mLocale.getIsoName());
        this.mCenturySplit = centurySplit;
        this.mAdjustment = 0;
        if (this.parse(date, pat)) {
            CJKTable[] pEraTbl = null;
            if (this.mAltEra >= 0) {
                pEraTbl = LcDate.getAltEraTable(this.mLocale);
                LcDate oEra = new LcDate(this.mAltEra, this.mLocale.getIsoName(), this.mCenturySplit);
                if (this.mYearOfEra == 1 && 0 <= this.mDayOfYear && this.mDayOfYear < oEra.getYearDay()) {
                    this.mDayOfYear += 366;
                }
                this.mYearOfEra += oEra.getYear();
                int nEpoch = LcDate.getEpochEra(pEraTbl, this.mAltEra);
                if (this.m2DigitYear >= 0) {
                    this.mYearOfEra += nEpoch / 100 * 100;
                }
                this.mYearOfEra -= nEpoch;
                if (this.mLocale.isThai()) {
                    if (this.m2DigitYear >= 0 && this.mYearOfEra % 100 < this.mCenturySplit) {
                        this.mYearOfEra += 100;
                    }
                    if (this.mYearOfEra > 1940 || this.mYearOfEra <= 1940 && this.mMonthOfYear > 3) {
                        --this.mYearOfEra;
                    }
                }
                this.mYearOfEra -= 1900;
            } else if (this.m2DigitYear >= 0 && this.mYearOfEra < 100 && this.mCenturySplit == 0) {
                this.mYearOfEra += 100;
            } else if (this.m2DigitYear >= 0 && this.mYearOfEra < this.mCenturySplit) {
                this.mYearOfEra += 100;
            } else if (this.mYearOfEra >= 100) {
                this.mYearOfEra -= 1900;
            }
            this.mDays = this.mDayOfYear >= 0 && this.mYearOfEra >= 0 ? this.epoch(this.mDayOfYear, this.mYearOfEra) : (this.mDayOfWeek >= 0 && this.mWeekOfYear >= 0 && this.mYearOfEra >= 0 ? this.epochWeekYear((this.mDayOfWeek + 5) % 7 + 1, this.mWeekOfYear, this.mYearOfEra) : (this.mWeekOfMonth >= 0 && this.mMonthOfYear >= 0 && this.mYearOfEra >= 0 ? this.epochWeekMonth(this.mDayOfWeek, this.mWeekOfMonth, this.mMonthOfYear, this.mYearOfEra) : this.epoch(this.mDayOfMonth, this.mMonthOfYear, this.mYearOfEra)));
            if (this.mAltEra >= 0) {
                if (this.mDays >= LcDate.getNextEra(pEraTbl, this.mAltEra)) {
                    this.mDays = 0;
                } else if (this.mDays < this.mAltEra) {
                    this.mDays = 0;
                }
            }
        } else {
            this.mDays = 0;
        }
        this.mValid = this.mDays > 0;
    }

    public LcDate add(int nDays) {
        if (this.mValid) {
            this.mDays += nDays;
        }
        this.mValid = this.mDays > 0;
        return this;
    }

    private int epoch(int day, int year) {
        if (year < 0) {
            return 0;
        }
        if (day < 1 || 366 < day) {
            return 0;
        }
        if (!LcDate.isLeap(year + 1900) && day == 366) {
            return 0;
        }
        return LcDate.startOfYear(year) + day;
    }

    int epoch(int day, int month, int year) {
        if (year < 0) {
            return 0;
        }
        if (month < 1 || 12 < month) {
            return 0;
        }
        int monthEnd = monthDays[month] - monthDays[month - 1];
        if (month == 2 && LcDate.isLeap(year + 1900)) {
            ++monthEnd;
        }
        if (day < 1 || monthEnd < day) {
            return 0;
        }
        int days = LcDate.startOfYear(year) + monthDays[month - 1] + day;
        if (month > 2 && LcDate.isLeap(year + 1900)) {
            ++days;
        }
        return days;
    }

    private int epochWeekMonth(int day, int week, int month, int year) {
        int dow;
        if (year < 0) {
            return 0;
        }
        if (month < 1 || 12 < month) {
            return 0;
        }
        if (week < 0 || 5 < week) {
            return 0;
        }
        int fdm = LcDate.startOfYear(year) + monthDays[month - 1];
        if (month > 2 && LcDate.isLeap(1900 + year)) {
            ++fdm;
        }
        int sunday = (dow = fdm % 7 + 1) >= 4 ? 8 - dow : 1 - dow;
        int d = sunday + (week - 1) * 7;
        if (day > 0) {
            d += day - 1;
        }
        return fdm + d;
    }

    private int epochWeekYear(int ISOday, int ISOweek, int ISOyear) {
        int days;
        if (ISOyear < 0) {
            return 0;
        }
        if (ISOweek < 1 || 53 < ISOweek) {
            return 0;
        }
        if (ISOday < 1 || 7 < ISOday) {
            return 0;
        }
        int y = 1900 + ISOyear;
        if (ISOweek == 53 && LcDate.P(y) % 7 != 4 && LcDate.P(y - 1) % 7 != 3) {
            return 0;
        }
        int Y = (y - 1) % 100;
        int C = y - 1 - Y;
        int G = Y + Y / 4;
        int Jan1 = 1 + (C / 100 % 4 * 5 + G) % 7;
        if (ISOweek == 1 && Jan1 <= 4 && ISOday < Jan1) {
            days = LcDate.startOfYear(ISOyear - 1) + monthDays[11] + 32 - (Jan1 - ISOday);
            if (LcDate.isLeap(y - 1)) {
                ++days;
            }
        } else {
            int doy = (ISOweek - 1) * 7;
            doy = Jan1 <= 4 ? (doy += ISOday - (Jan1 - 1)) : (doy += ISOday + (8 - Jan1));
            int eoy = LcDate.isLeap(y) ? 366 : 365;
            days = doy > eoy ? LcDate.startOfYear(ISOyear + 1) + (doy - eoy) : LcDate.startOfYear(ISOyear) + doy;
        }
        return days;
    }

    public String format(String pat) {
        if (!this.mValid) {
            return "";
        }
        this.mbISOWeekSeen = false;
        this.scan(pat);
        this.mAltEra = -1;
        StringBuilder sBuf = new StringBuilder();
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int patLen = pat.length();
        for (int i = 0; i < patLen; ++i) {
            String sub;
            char chr = pat.charAt(i);
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    sBuf.append(chr);
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                } else {
                    sBuf.append(chr);
                }
                ++chrCnt;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    sub = this.subFormat(prevChr, chrCnt);
                    if (sub.length() == 0) {
                        return "";
                    }
                    if (!sub.equals("\u001f")) {
                        sBuf.append(sub);
                    }
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr(DATE_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (chr != prevChr) {
                    if (chrCnt > 0) {
                        sub = this.subFormat(prevChr, chrCnt);
                        if (sub.length() == 0) {
                            return "";
                        }
                        if (!sub.equals("\u001f")) {
                            sBuf.append(sub);
                        }
                        chrCnt = 0;
                    }
                    prevChr = chr;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                sub = this.subFormat(prevChr, chrCnt);
                if (sub.length() == 0) {
                    return "";
                }
                if (!sub.equals("\u001f")) {
                    sBuf.append(sub);
                }
                chrCnt = 0;
            }
            prevChr = '\u0000';
            if (chr == '?' || chr == '*' || chr == '+') {
                sBuf.append(' ');
                continue;
            }
            sBuf.append(chr);
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            return "";
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            String sub = this.subFormat(prevChr, chrCnt);
            if (sub.length() == 0) {
                return "";
            }
            if (!sub.equals("\u001f")) {
                sBuf.append(sub);
            }
        }
        return sBuf.toString();
    }

    public int getDays() {
        return this.mDays + this.mAdjustment;
    }

    public int getISOWeek() {
        int ISOweek;
        if (!this.mValid) {
            return -1;
        }
        int year = this.getYear();
        int doy = this.getDays() - LcDate.startOfYear(year - 1900);
        int Y = (year - 1) % 100;
        int C = year - 1 - Y;
        int G = Y + Y / 4;
        int Jan1 = 1 + (C / 100 % 4 * 5 + G) % 7;
        int h = doy + (Jan1 - 1);
        int ISOday = 1 + (h - 1) % 7;
        if (doy <= 8 - Jan1 && Jan1 > 4) {
            ISOweek = Jan1 == 5 || Jan1 == 6 && LcDate.isLeap(year - 1) ? 53 : 52;
        } else if ((LcDate.isLeap(year) ? 366 : 365) - doy < 4 - ISOday) {
            ISOweek = 1;
        } else {
            ISOweek = (doy + (7 - ISOday) + (Jan1 - 1)) / 7;
            if (Jan1 > 4) {
                --ISOweek;
            }
        }
        return ISOweek;
    }

    public int getISOYear() {
        int ISOyear;
        if (!this.mValid) {
            return -1;
        }
        int year = this.getYear();
        int doy = this.getDays() - LcDate.startOfYear(year - 1900);
        int Y = (year - 1) % 100;
        int C = year - 1 - Y;
        int G = Y + Y / 4;
        int Jan1 = 1 + (C / 100 % 4 * 5 + G) % 7;
        int h = doy + (Jan1 - 1);
        int ISOday = 1 + (h - 1) % 7;
        if (doy <= 8 - Jan1 && Jan1 > 4) {
            ISOyear = year - 1;
        } else {
            ISOyear = year;
            if ((LcDate.isLeap(year) ? 366 : 365) - doy < 4 - ISOday) {
                ISOyear = year + 1;
            }
        }
        return ISOyear;
    }

    public int getMonth() {
        if (!this.mValid) {
            return -1;
        }
        int year = this.getYear();
        int leapCorrector = LcDate.isLeap(year) ? 1 : 0;
        int daysInYear = this.getDays() - LcDate.startOfYear(year - 1900);
        int month = 12;
        while (daysInYear <= monthDays[month - 1] + leapCorrector) {
            if (--month > 2) continue;
            leapCorrector = 0;
        }
        return month;
    }

    public int getMonthDay() {
        if (!this.mValid) {
            return -1;
        }
        int year = this.getYear();
        int month = this.getMonth();
        int daysInYear = this.getDays() - LcDate.startOfYear(year - 1900);
        int day = daysInYear - monthDays[month - 1];
        if (month > 2 && LcDate.isLeap(year)) {
            --day;
        }
        return day;
    }

    public int getWeekDay() {
        if (!this.mValid) {
            return -1;
        }
        return this.getDays() % 7 + 1;
    }

    public int getWeekMonth() {
        int dow;
        if (!this.mValid) {
            return -1;
        }
        int dom = this.getMonthDay();
        int sunday = (dom - (dow = this.getWeekDay())) % 7 + 1;
        if (sunday <= 0) {
            sunday += 7;
        }
        int week = (dom - sunday + 7) / 7;
        if (sunday > 4) {
            ++week;
        }
        return week;
    }

    public int getYear() {
        int daysInYear;
        if (!this.mValid) {
            return -1;
        }
        int year = 1900;
        for (int day = this.getDays(); day > (daysInYear = LcDate.isLeap(year) ? 366 : 365); day -= daysInYear) {
            ++year;
        }
        return year;
    }

    public int getYearDay() {
        if (!this.mValid) {
            return -1;
        }
        int year = this.getYear();
        int daysInYear = this.getDays() - LcDate.startOfYear(year - 1900);
        return daysInYear;
    }

    public boolean isValid() {
        return this.mValid;
    }

    boolean parse(String str, String pat) {
        int parseRes;
        int strPos = 0;
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int strLen = str.length();
        int patLen = pat.length();
        this.mDayOfWeek = -1;
        this.mDayOfMonth = -1;
        this.mDayOfYear = -1;
        this.mMonthOfYear = -1;
        this.mYearOfEra = -1;
        this.mWeekOfMonth = -1;
        this.mWeekOfYear = -1;
        this.m2DigitYear = -1;
        this.mEra = -1;
        this.mAltEra = -1;
        int i = 0;
        while (i < patLen) {
            boolean fw;
            char chr = pat.charAt(i);
            ++i;
            boolean bl = fw = '\uff01' <= chr && chr <= '\uff5e';
            if (strPos >= strLen) {
                if (inQuoted && chr == '\'') {
                    inQuoteQuoted = true;
                    break;
                }
                return false;
            }
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    if (!DateTimeUtil.matchChr(str, strPos, chr, fw)) {
                        return false;
                    }
                    ++strPos;
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                } else {
                    if (!DateTimeUtil.matchChr(str, strPos, chr, fw)) {
                        return false;
                    }
                    ++strPos;
                }
                ++chrCnt;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    parseRes = this.subParse(str, strPos, prevChr, chrCnt);
                    if (parseRes < 0) {
                        return false;
                    }
                    strPos = parseRes;
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr(DATE_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (chr != prevChr) {
                    if (chrCnt > 0) {
                        parseRes = this.subParse(str, strPos, prevChr, chrCnt);
                        if (parseRes < 0) {
                            return false;
                        }
                        strPos = parseRes;
                        chrCnt = 0;
                    }
                    prevChr = chr;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                parseRes = this.subParse(str, strPos, prevChr, chrCnt);
                if (parseRes < 0) {
                    return false;
                }
                strPos = parseRes;
                chrCnt = 0;
                prevChr = '\u0000';
            }
            if (chr == '?') {
                if (strPos >= strLen || !Character.isDefined(str.charAt(strPos))) continue;
                ++strPos;
                continue;
            }
            if (chr == '+') {
                if (strPos >= strLen || !Character.isWhitespace(str.charAt(strPos))) {
                    return false;
                }
                ++strPos;
                while (strPos < strLen && Character.isWhitespace(str.charAt(strPos))) {
                    ++strPos;
                }
                continue;
            }
            if (chr == '*') {
                while (strPos < strLen && Character.isWhitespace(str.charAt(strPos))) {
                    ++strPos;
                }
                continue;
            }
            if (strPos < strLen && str.charAt(strPos) == chr) {
                ++strPos;
                continue;
            }
            return false;
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            return false;
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            parseRes = this.subParse(str, strPos, prevChr, chrCnt);
            if (parseRes < 0) {
                return false;
            }
            strPos = parseRes;
        }
        if (strPos != strLen) {
            return false;
        }
        if (this.mDayOfYear < 0 && this.mDayOfMonth < 0) {
            this.mDayOfMonth = 1;
        }
        if (this.mDayOfWeek < 0) {
            int n = this.mDayOfWeek = this.mWeekOfYear < 0 ? 1 : 2;
        }
        if (!(this.mDayOfYear >= 0 && this.mYearOfEra >= 0 || this.mDayOfWeek >= 0 && this.mWeekOfYear >= 0 && this.mYearOfEra >= 0 || this.mDayOfMonth >= 0 && this.mMonthOfYear >= 0 && this.mYearOfEra >= 0)) {
            return false;
        }
        if (this.mLocale.isSimplifiedChinese() && this.mAltEra >= 18171) {
            this.mAltEra = -1;
        }
        return this.mAltEra < 0 || this.mYearOfEra >= 1;
    }

    private boolean scan(String pat) {
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int patLen = pat.length();
        int i = 0;
        while (i < patLen) {
            char chr = pat.charAt(i);
            ++i;
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                }
                ++chrCnt;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    if (!this.subScan(prevChr, chrCnt)) {
                        return false;
                    }
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr(DATE_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (chr != prevChr) {
                    if (chrCnt > 0) {
                        if (!this.subScan(prevChr, chrCnt)) {
                            return false;
                        }
                        chrCnt = 0;
                    }
                    prevChr = chr;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt <= 0) continue;
            if (!this.subScan(prevChr, chrCnt)) {
                return false;
            }
            chrCnt = 0;
            prevChr = '\u0000';
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            return false;
        }
        return prevChr <= '\u0000' || chrCnt <= 0 || this.subScan(prevChr, chrCnt);
    }

    void setDateSymbols(String locale) {
        int i;
        LcData oData = new LcData(locale);
        for (i = 0; i < 12; ++i) {
            this.mSymbols.abbrMonthName[i] = oData.getAbbrMonthName(i);
            this.mSymbols.monthName[i] = oData.getMonthName(i);
        }
        for (i = 0; i < 7; ++i) {
            this.mSymbols.abbrWeekdayName[i] = oData.getAbbrWeekdayName(i);
            this.mSymbols.weekdayName[i] = oData.getWeekDayName(i);
        }
        for (i = 0; i < 2; ++i) {
            this.mSymbols.eraName[i] = oData.getEraName(i);
        }
        this.mSymbols.zeroDigit = oData.getZeroSymbol().charAt(0);
    }

    public void setGMDate() {
        Calendar today = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int day = today.get(5);
        int month = today.get(2) + 1;
        int year = today.get(1);
        this.mAdjustment = this.epoch(day, month, year) - this.mDays;
    }

    public void setLocalDate() {
        this.mAdjustment = 0;
    }

    String subFormat(char chr, int chrCnt) {
        StringBuilder sBuf = new StringBuilder();
        boolean fw = '\uff01' <= chr && chr <= '\uff5e';
        int tr = 0;
        int d = 0;
        int nEraStyle = 0;
        CJKTable[] pEraTbl = LcDate.getAltEraTable(this.mLocale);
        if (chr == 'g' || chr == '\uff47') {
            if (this.mLocale.isJapanese()) {
                if (chrCnt == 1) {
                    nEraStyle = fw ? 1 : 0;
                } else if (chrCnt == 2) {
                    nEraStyle = fw ? 4 : 2;
                } else if (chrCnt == 3) {
                    nEraStyle = 3;
                }
            } else {
                nEraStyle = this.mLocale.isKoreanHani() ? 1 : (this.mLocale.isThai() ? (chrCnt == 3 ? 2 : (chrCnt == 2 ? 1 : 0)) : 0);
            }
            if (pEraTbl == null || pEraTbl[0].sEraSyms[nEraStyle] == null) {
                chr = (char)71;
                chrCnt = 1;
            }
        }
        char[] pCJK_Num = null;
        if (this.mLocale.isJapanese()) {
            pCJK_Num = DateTimeUtil.Kanji_Num;
        } else if (this.mLocale.isTraditionalChinese()) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.getName().equals("zh_HK")) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.isChinese()) {
            pCJK_Num = DateTimeUtil.Kanji_Num;
        } else if (this.mLocale.isKoreanHani()) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.isKorean()) {
            pCJK_Num = DateTimeUtil.Hangul_Num;
        }
        int value = 0;
        switch (chr) {
            case '\uff24': {
                value = this.getMonthDay();
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4 ? -1 : 0;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                        } else if (this.mLocale.isChinese()) {
                            tr = 1;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(2, value, pCJK_Num, tr));
                    }
                }
            }
            case 'D': {
                if (chr == 'D') {
                    value = this.getMonthDay();
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case 'J': 
            case '\uff2a': {
                value = this.getYearDay();
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(3, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 3: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case 'E': 
            case '\uff25': {
                value = this.getWeekDay();
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 3: {
                        sBuf.append(DateTimeUtil.fmtStr(this.mSymbols.abbrWeekdayName[value - 1], false));
                        break;
                    }
                    case 4: {
                        sBuf.append(DateTimeUtil.fmtStr(this.mSymbols.weekdayName[value - 1], false));
                    }
                }
                break;
            }
            case 'e': 
            case '\uff45': {
                value = (this.getWeekDay() + 5) % 7 + 1;
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case '\uff2d': {
                value = this.getMonth();
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4 ? -1 : 0;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                        } else if (this.mLocale.isChinese()) {
                            tr = 1;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(2, value, pCJK_Num, tr));
                    }
                }
            }
            case 'M': {
                if (chr == 'M') {
                    value = this.getMonth();
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 3: {
                        if (chr != 'M') break;
                        sBuf.append(DateTimeUtil.fmtStr(this.mSymbols.abbrMonthName[value - 1], false));
                        break;
                    }
                    case 4: {
                        if (chr != 'M') break;
                        sBuf.append(DateTimeUtil.fmtStr(this.mSymbols.monthName[value - 1], false));
                    }
                }
                break;
            }
            case 'w': 
            case '\uff57': {
                value = this.getWeekMonth();
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(1, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case 'W': 
            case '\uff37': {
                value = this.getISOWeek();
                switch (chrCnt) {
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case '\uff39': {
                LcDate oEra;
                int n = value = this.mbISOWeekSeen ? this.getISOYear() : this.getYear();
                if (this.mAltEra >= 0) {
                    oEra = new LcDate(this.mAltEra, this.mLocale.getIsoName(), this.mCenturySplit);
                    value += LcDate.getEpochEra(pEraTbl, this.mAltEra) - oEra.getYear();
                }
                switch (chrCnt) {
                    case 3: 
                    case 5: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 5 ? -1 : 0;
                            d = this.mAltEra >= 0 ? 2 : 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = -1;
                            d = 4;
                        } else if (this.mLocale.isTraditionalChinese()) {
                            tr = this.mAltEra >= 0 ? 1 : 0;
                            d = 4;
                        } else if (this.mLocale.isChinese()) {
                            tr = this.mAltEra >= 0 && this.getDays() < 18171 ? 1 : 0;
                            d = 4;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(d, value, pCJK_Num, tr));
                        if (!sBuf.toString().equals("\u4e00")) break;
                        sBuf.setLength(0);
                        sBuf.append("\u5143");
                    }
                }
            }
            case 'Y': {
                LcDate oEra;
                if (chr == 'Y') {
                    int n = value = this.mbISOWeekSeen ? this.getISOYear() : this.getYear();
                    if (this.mAltEra >= 0) {
                        oEra = new LcDate(this.mAltEra, this.mLocale.getIsoName(), this.mCenturySplit);
                        if (this.mLocale.isThai() && ((value += LcDate.getEpochEra(pEraTbl, this.mAltEra) - oEra.getYear()) > 2482 || value <= 2482 && this.getMonth() > 3)) {
                            ++value;
                        }
                    }
                }
                if (this.mAltEra >= 0) {
                    if (this.mLocale.isJapanese()) {
                        if (chrCnt == 4) {
                            chrCnt = 2;
                        }
                        if (value > 99) {
                            chrCnt = 0;
                        }
                    } else if (this.mLocale.isKorean()) {
                        if (0 < chrCnt && chrCnt < 3) {
                            chrCnt = 4;
                        }
                        if (value > 9999) {
                            chrCnt = 0;
                        }
                    } else if (this.mLocale.isTraditionalChinese()) {
                        if (chrCnt == 2 || chrCnt == 4) {
                            chrCnt = value > 99 ? 4 : 2;
                        } else if (chrCnt == 1) {
                            chrCnt = value > 99 ? 4 : (value > 9 ? 2 : 1);
                        }
                    } else if (this.mLocale.isChinese() && chrCnt == 4) {
                        chrCnt = value > 99 ? 4 : 2;
                    }
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtPlainNum(2, value %= 1000, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 2: {
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value %= 100, fw, this.mSymbols.zeroDigit));
                        break;
                    }
                    case 4: {
                        if (this.mLocale.isTraditionalChinese()) {
                            chrCnt = value > 999 ? 4 : 3;
                        }
                        sBuf.append(DateTimeUtil.fmtNum(chrCnt, value, fw, this.mSymbols.zeroDigit));
                    }
                }
                break;
            }
            case 'G': {
                if (this.mAltEra >= 0) {
                    this.mAltEra = -1;
                }
                switch (chrCnt) {
                    case 1: {
                        sBuf.append(DateTimeUtil.fmtStr(this.mSymbols.eraName[1], fw));
                    }
                }
                break;
            }
            case 'g': 
            case '\uff47': {
                switch (chrCnt) {
                    case 1: 
                    case 2: 
                    case 3: {
                        value = this.getDays();
                        for (int i = 0; i < pEraTbl.length; ++i) {
                            if (pEraTbl[i].nEraStart > value) continue;
                            this.mAltEra = pEraTbl[i].nEraStart;
                            sBuf.setLength(0);
                            sBuf.append(DateTimeUtil.fmtStr(pEraTbl[i].sEraSyms[nEraStyle], fw));
                            if (sBuf.length() != 0) continue;
                            sBuf.append('\u001f');
                        }
                        break;
                    }
                }
                break;
            }
            case 't': {
                while (chrCnt-- > 0) {
                    sBuf.append('\t');
                }
                break;
            }
            default: {
                sBuf.append(chr);
            }
        }
        return sBuf.toString();
    }

    int subParse(String src, int srcPos, char chr, int chrCnt) {
        int curPos = srcPos;
        boolean fw = '\uff01' <= chr && chr <= '\uff5e';
        boolean tr = false;
        int nEraStyle = 0;
        CJKTable[] pEraTbl = LcDate.getAltEraTable(this.mLocale);
        if (chr == 'g' || chr == '\uff47') {
            if (this.mLocale.isJapanese()) {
                if (chrCnt == 1) {
                    nEraStyle = fw ? 1 : 0;
                } else if (chrCnt == 2) {
                    nEraStyle = fw ? 4 : 2;
                } else if (chrCnt == 3) {
                    nEraStyle = 3;
                }
            } else {
                nEraStyle = this.mLocale.isKoreanHani() ? 1 : (this.mLocale.isThai() ? (chrCnt == 3 ? 2 : (chrCnt == 2 ? 1 : 0)) : 0);
            }
            if (pEraTbl == null || pEraTbl[0].sEraSyms.length <= nEraStyle) {
                chr = (char)71;
                chrCnt = 1;
            } else {
                int nEras = pEraTbl.length;
                assert (nEras <= this.mSymbols.altEraName.length);
                for (int i = 0; i < nEras; ++i) {
                    this.mSymbols.altEraName[i] = pEraTbl[i].sEraSyms[nEraStyle];
                }
            }
        }
        char[] pCJK_Num = null;
        if (this.mLocale.isJapanese()) {
            pCJK_Num = DateTimeUtil.Kanji_Num;
        } else if (this.mLocale.isTraditionalChinese()) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.getName().equals("zh_HK")) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.isChinese()) {
            pCJK_Num = DateTimeUtil.Kanji_Num;
        } else if (this.mLocale.isKoreanHani()) {
            pCJK_Num = DateTimeUtil.Hanja_Num;
        } else if (this.mLocale.isKorean()) {
            pCJK_Num = DateTimeUtil.Hangul_Num;
        }
        block0 : switch (chr) {
            case '\uff24': {
                int len;
                if (this.mDayOfMonth >= 0 || this.mDayOfYear >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isChinese()) {
                            tr = true;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mDayOfMonth = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        srcPos = curPos;
                    }
                }
            }
            case 'D': {
                int len;
                if (chr == 'D' && (this.mDayOfMonth >= 0 || this.mDayOfYear >= 0)) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mDayOfMonth = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break block0;
                    }
                }
                if (chr != 'Y') break;
                return -1;
            }
            case 'J': 
            case '\uff2a': {
                int len;
                if (this.mDayOfYear >= 0 || this.mDayOfMonth >= 0 || this.mMonthOfYear >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 3, fw, this.mSymbols.zeroDigit);
                        if (len > 0) break;
                        return -1;
                    }
                    case 3: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 3, fw, this.mSymbols.zeroDigit);
                        if (len == 3) break;
                        return -1;
                    }
                    default: {
                        return -1;
                    }
                }
                curPos = DateTimeUtil.incPos(src, srcPos, len);
                this.mDayOfYear = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                srcPos = curPos;
                break;
            }
            case 'E': 
            case '\uff25': {
                if (this.mDayOfWeek >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: {
                        int len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mDayOfWeek = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        break;
                    }
                    case 3: {
                        int idx = DateTimeUtil.matchName(src, srcPos, this.mSymbols.abbrWeekdayName, true);
                        if (idx < 0) {
                            return -1;
                        }
                        this.mDayOfWeek = idx;
                        curPos += this.mSymbols.abbrWeekdayName[idx].length();
                        break;
                    }
                    case 4: {
                        int idx = DateTimeUtil.matchName(src, srcPos, this.mSymbols.weekdayName, true);
                        if (idx < 0) {
                            return -1;
                        }
                        this.mDayOfWeek = idx;
                        curPos += this.mSymbols.weekdayName[idx].length();
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                srcPos = curPos;
                break;
            }
            case 'e': 
            case '\uff45': {
                if (this.mDayOfWeek >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: {
                        int len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mDayOfWeek = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        this.mDayOfWeek = this.mDayOfWeek % 7 + 1;
                        srcPos = curPos;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                srcPos = curPos;
                break;
            }
            case '\uff2d': {
                int len;
                if (this.mMonthOfYear >= 0 || this.mDayOfYear >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 4: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 4;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isChinese()) {
                            tr = true;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mMonthOfYear = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        srcPos = curPos;
                    }
                }
            }
            case 'M': {
                int len;
                if (chr == 'M' && (this.mMonthOfYear >= 0 || this.mDayOfYear >= 0)) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mMonthOfYear = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break block0;
                    }
                    case 3: {
                        if (chr != 'M') break block0;
                        int idx = DateTimeUtil.matchName(src, srcPos, this.mSymbols.abbrMonthName, true);
                        if (idx < 0) {
                            return -1;
                        }
                        this.mMonthOfYear = idx + 1;
                        srcPos = curPos += this.mSymbols.abbrMonthName[idx].length();
                        break block0;
                    }
                    case 4: {
                        if (chr != 'M') break block0;
                        int idx = DateTimeUtil.matchName(src, srcPos, this.mSymbols.monthName, true);
                        if (idx < 0) {
                            return -1;
                        }
                        this.mMonthOfYear = idx + 1;
                        srcPos = curPos += this.mSymbols.monthName[idx].length();
                        break block0;
                    }
                    default: {
                        return -1;
                    }
                }
            }
            case 'w': 
            case '\uff57': {
                int len;
                if (this.mWeekOfMonth >= 0 || this.mWeekOfYear >= 0) {
                    return -1;
                }
                if (this.mDayOfYear >= 0 || this.mDayOfMonth >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len > 0) break;
                        return -1;
                    }
                    default: {
                        return -1;
                    }
                }
                curPos = DateTimeUtil.incPos(src, srcPos, len);
                this.mWeekOfMonth = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                srcPos = curPos;
                break;
            }
            case 'W': 
            case '\uff37': {
                int len;
                if (this.mWeekOfYear >= 0 || this.mWeekOfMonth >= 0) {
                    return -1;
                }
                if (this.mDayOfYear >= 0 || this.mDayOfMonth >= 0 || this.mMonthOfYear >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 2: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit);
                        if (len == 2) break;
                        return -1;
                    }
                    default: {
                        return -1;
                    }
                }
                curPos = DateTimeUtil.incPos(src, srcPos, len);
                this.mWeekOfYear = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                srcPos = curPos;
                break;
            }
            case '\uff39': {
                int len;
                if (this.mYearOfEra >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 3: 
                    case 5: {
                        if (this.mLocale.isJapanese()) {
                            tr = chrCnt == 5;
                        } else if (this.mLocale.isKorean()) {
                            tr = true;
                        } else if (this.mLocale.isTraditionalChinese()) {
                            tr = this.mAltEra >= 0;
                        } else if (this.mLocale.isChinese()) {
                            tr = 0 <= this.mAltEra && this.mAltEra < 18171;
                        }
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 4, pCJK_Num, tr);
                        if (len <= 0) {
                            return -1;
                        }
                        curPos = srcPos;
                        if (len == 1 && src.charAt(curPos++) == '\u5143') {
                            this.mYearOfEra = 1;
                        } else {
                            curPos = DateTimeUtil.incPos(src, srcPos, len);
                            this.mYearOfEra = DateTimeUtil.getNum(src, srcPos, curPos, pCJK_Num, tr);
                        }
                        srcPos = curPos;
                    }
                }
            }
            case 'Y': {
                int len;
                if (chr == 'Y' && this.mYearOfEra >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: {
                        len = this.mLocale.isTraditionalChinese() && this.mAltEra >= 4383 ? DateTimeUtil.matchNum(src, srcPos, srcPos + 3, fw, this.mSymbols.zeroDigit) : (this.mLocale.isSimplifiedChinese() && this.mAltEra >= 18171 ? DateTimeUtil.matchNum(src, srcPos, srcPos + 4, fw, this.mSymbols.zeroDigit) : DateTimeUtil.matchNum(src, srcPos, srcPos + 2, fw, this.mSymbols.zeroDigit));
                        if (len < chrCnt) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mYearOfEra = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        ++this.m2DigitYear;
                        break block0;
                    }
                    case 4: {
                        len = DateTimeUtil.matchNum(src, srcPos, srcPos + 4, fw, this.mSymbols.zeroDigit);
                        if (len <= 0 || len < chrCnt && this.mAltEra < 0) {
                            return -1;
                        }
                        curPos = DateTimeUtil.incPos(src, srcPos, len);
                        this.mYearOfEra = DateTimeUtil.getNum(src, srcPos, curPos, fw, this.mSymbols.zeroDigit);
                        srcPos = curPos;
                        break block0;
                    }
                }
                if (chr != 'Y') break;
                return -1;
            }
            case 'G': {
                int len;
                if (this.mEra >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: {
                        int idx = DateTimeUtil.matchName(src, srcPos, this.mSymbols.eraName, true);
                        if (idx != 1) {
                            return -1;
                        }
                        this.mEra = idx;
                        len = this.mSymbols.eraName[idx].length();
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                srcPos += len;
                break;
            }
            case 'g': 
            case '\uff47': {
                if (this.mAltEra >= 0) {
                    return -1;
                }
                switch (chrCnt) {
                    case 1: 
                    case 2: 
                    case 3: {
                        int idx = DateTimeUtil.matchName(src, srcPos, this.mSymbols.altEraName, false);
                        if (idx < 0) {
                            return -1;
                        }
                        this.mAltEra = pEraTbl[idx].nEraStart;
                        int len = this.mSymbols.altEraName[idx].length();
                        srcPos += len;
                        break block0;
                    }
                }
                return -1;
            }
            case 't': {
                while (chrCnt-- > 0) {
                    if (src.charAt(srcPos) != '\t') {
                        return -1;
                    }
                    ++srcPos;
                }
                break;
            }
            default: {
                if (!DateTimeUtil.matchChr(src, srcPos, chr, fw)) {
                    return -1;
                }
                ++srcPos;
            }
        }
        return srcPos;
    }

    private boolean subScan(char chr, int chrCnt) {
        block0 : switch (chr) {
            case 'W': 
            case '\uff37': {
                switch (chrCnt) {
                    case 2: {
                        this.mbISOWeekSeen = true;
                        break block0;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.format(DEFAULT_DATE_FMT);
    }

    static class Symbols {
        final String[] abbrMonthName = new String[12];
        final String[] abbrWeekdayName = new String[7];
        final String[] altEraName = new String[4];
        final String[] eraName = new String[2];
        final String[] monthName = new String[12];
        final String[] weekdayName = new String[7];
        char zeroDigit;

        Symbols() {
        }
    }

    private static class CJKTable {
        final int nEpochStart;
        final int nEraStart;
        final String[] sEraSyms;

        CJKTable(int nEra, int nEpoch, String[] sSyms) {
            this.nEraStart = nEra;
            this.nEpochStart = nEpoch;
            this.sEraSyms = sSyms;
        }
    }
}

