/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.ut.UnitSpan;

public final class Units {
    static float toFloat(int pt1000) {
        return (float)pt1000 / 1000.0f;
    }

    static float toFloat(UnitSpan us) {
        return Units.toFloat(Units.toInt(us));
    }

    static int toInt(float pts) {
        return Math.round(pts * 1000.0f);
    }

    static int toInt(UnitSpan us) {
        return UnitSpan.convertUnit(19, us.units(), us.value());
    }

    static UnitSpan toUnitSpan(int pt1000) {
        return Units.toUnitSpan(19, pt1000);
    }

    static UnitSpan toUnitSpan(float pts) {
        return Units.toUnitSpan(3, Units.toInt(pts));
    }

    static UnitSpan forceUnitSpan(float f) {
        return new UnitSpan(3, Units.forceInt(f));
    }

    static int forceInt(float f) {
        int result = Units.toInt(f);
        float reconvert = Units.toFloat(result);
        if (reconvert < f) {
            ++result;
        }
        return result;
    }

    public static String doubleToString(double value, int decimals) {
        int i;
        StringBuilder result = new StringBuilder();
        for (i = 0; i < decimals; ++i) {
            value *= 10.0;
        }
        long rounded = Math.round(value);
        Units.prependZeros(result, Long.toString(rounded), decimals, true);
        int decimalPos = result.length() - decimals;
        int lastZero = result.length();
        while (lastZero > decimalPos && result.charAt(i = lastZero - 1) == '0') {
            lastZero = i;
        }
        result.delete(lastZero, result.length());
        if (lastZero > decimalPos) {
            result.insert(decimalPos, '.');
        }
        return result.toString();
    }

    static String toString(int pt1000) {
        return Units.toUnitSpan(pt1000).toString();
    }

    static String toString(float pts) {
        return Units.toUnitSpan(pts).toString();
    }

    static String intToString(int value, int minDigits, boolean zeroFill) {
        StringBuilder result = new StringBuilder();
        Units.prependZeros(result, Integer.toString(value), minDigits, zeroFill);
        return result.toString();
    }

    static String intToString(int value, int minDigits) {
        return Units.intToString(value, minDigits, false);
    }

    static String intToString(int value, boolean zerofill) {
        return Units.intToString(value, 5, zerofill);
    }

    static String intToString(int value) {
        return Units.intToString(value, 5, false);
    }

    static String hexToString(int hex, int minDigits, String prefix) {
        StringBuilder result = new StringBuilder(prefix);
        Units.prependZeros(result, Integer.toHexString(hex), minDigits, true);
        return result.toString();
    }

    static String hexToString(int hex, int minDigits) {
        return Units.hexToString(hex, minDigits, "\\x");
    }

    static String hexToString(int hex) {
        return Units.hexToString(hex, 4, "\\x");
    }

    private static UnitSpan toUnitSpan(int units, int pt1000) {
        return new UnitSpan(units, pt1000);
    }

    private static void prependZeros(StringBuilder result, String formatted, int minDigits, boolean zeroFill) {
        char fill = zeroFill ? (char)'0' : ' ';
        for (int i = formatted.length(); i < minDigits; ++i) {
            result.append(fill);
        }
        result.append(formatted);
    }
}

