/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.RegionFrame;
import com.adobe.xfa.text.TextDispStr;
import com.adobe.xfa.ut.UnitSpan;

public class TextRegion
extends TextDispStr {
    public TextRegion() {
        this.setTraditionalFrame(new RegionFrame());
    }

    public TextRegion(String sSource) {
        super(sSource);
        this.setTraditionalFrame(new RegionFrame());
    }

    public UnitSpan getMinWidth() {
        return this.minWidth();
    }

    public void setMinWidth(UnitSpan oNewWidth) {
        if (oNewWidth.equals(this.minWidth())) {
            return;
        }
        this.getRegionFrame().setMinWidth(oNewWidth);
        if (!this.enforceJustifyWidth()) {
            this.updateDisplay(true);
        }
    }

    public UnitSpan getMinHeight() {
        return this.minHeight();
    }

    public void setMinHeight(UnitSpan oNewHeight) {
        if (oNewHeight.equals(this.minHeight())) {
            return;
        }
        this.getRegionFrame().setMinHeight(oNewHeight);
        if (!this.enforceJustifyHeight()) {
            this.updateDisplay(true);
        }
    }

    public UnitSpan getMaxWidth() {
        return this.maxWidth();
    }

    public void setMaxWidth(UnitSpan oNewWidth) {
        if (oNewWidth.equals(this.maxWidth())) {
            return;
        }
        boolean bUpdateDisplay = false;
        if (oNewWidth.value() < 0) {
            bUpdateDisplay = true;
        } else if (!this.unlimitedWidth() && oNewWidth.gt(this.maxWidth())) {
            bUpdateDisplay = true;
        } else if (oNewWidth.lt(this.extent().width())) {
            bUpdateDisplay = true;
        }
        this.getRegionFrame().setMaxWidth(oNewWidth);
        if (bUpdateDisplay) {
            this.updateDisplay();
        }
    }

    public UnitSpan getMaxHeight() {
        return this.maxHeight();
    }

    public void setMaxHeight(UnitSpan oNewHeight) {
        if (oNewHeight.equals(this.maxHeight())) {
            return;
        }
        boolean bUpdateDisplay = false;
        if (oNewHeight.value() < 0) {
            bUpdateDisplay = true;
        } else if (!this.unlimitedHeight() && oNewHeight.gt(this.maxHeight())) {
            bUpdateDisplay = true;
        } else if (oNewHeight.lt(this.extent().height())) {
            bUpdateDisplay = true;
        }
        this.getRegionFrame().setMaxHeight(oNewHeight);
        if (bUpdateDisplay) {
            this.updateDisplay(true);
        }
    }

    public void setJustifyHeight(UnitSpan oJustifyHeight) {
        if (this.enforceJustifyHeight() && oJustifyHeight.equals(this.justifyHeight())) {
            return;
        }
        this.getRegionFrame().setAlignmentHeight(oJustifyHeight);
        this.updateDisplay(true);
    }

    public void setJustifyWidth(UnitSpan oJustifyWidth) {
        if (this.enforceJustifyWidth() && oJustifyWidth.equals(this.justifyWidth())) {
            return;
        }
        this.getRegionFrame().setAlignmentWidth(oJustifyWidth);
        this.updateDisplay(true);
    }

    public void setJustifyExtents(UnitSpan oJustifyWidth, UnitSpan oJustifyHeight) {
        if (this.enforceJustifyHeight() && oJustifyHeight.equals(this.justifyHeight()) && this.enforceJustifyWidth() && oJustifyWidth.equals(this.justifyWidth())) {
            return;
        }
        this.getRegionFrame().setAlignmentWidth(oJustifyWidth);
        this.getRegionFrame().setAlignmentHeight(oJustifyHeight);
        this.updateDisplay(true);
    }

    public boolean enforceSize() {
        return this.getRegionFrame().testFitSize();
    }

    public void enforceSize(boolean bNewEnforce) {
        this.getRegionFrame().setTestFitSize(bNewEnforce);
    }

    public void copyFrom(TextRegion oSource) {
        if (this != oSource) {
            super.copyFrom(oSource);
            this.getRegionFrame().copyFrom(oSource.getRegionFrame());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextRegion cmp = (TextRegion)object;
        return this.getRegionFrame().equals(cmp.getRegionFrame());
    }

    @Override
    public int hashCode() {
        int hash = 61;
        hash = hash * 31 ^ super.hashCode();
        hash = hash * 31 ^ this.getRegionFrame().hashCode();
        return hash;
    }

    public boolean notEqual(TextRegion oCompare) {
        return !this.equals(oCompare);
    }

    private RegionFrame getRegionFrame() {
        return (RegionFrame)this.getTraditionalFrame();
    }
}

