/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

public final class TextIntArray {
    public static final int MIN_ALLOC = 4;
    private int[] mArray;
    private int mSize;

    public int[] getArray() {
        return this.mArray;
    }

    public int getSize() {
        return this.mSize;
    }

    public int[] setSize(int size, boolean preserve) {
        this.allocate(size, preserve);
        this.mSize = size;
        return this.mArray;
    }

    public int[] setSize(int size) {
        return this.setSize(size, false);
    }

    private int[] allocate(int newSize, boolean preserve) {
        if (this.mArray == null || newSize > this.mArray.length) {
            int alloc;
            for (alloc = 4; alloc < newSize; alloc *= 2) {
            }
            int[] newArray = new int[alloc];
            if (preserve && this.mArray != null) {
                System.arraycopy(this.mArray, 0, newArray, 0, this.mSize);
            }
            this.mArray = newArray;
        }
        return this.mArray;
    }

    public int get(int index) {
        return this.mArray[index];
    }

    public void add(int value) {
        int index = this.mSize;
        this.setSize(this.mSize + 1, true);
        this.mArray[index] = value;
    }

    public void set(int index, int value) {
        if (index >= this.mSize) {
            this.setSize(index + 1, true);
        }
        this.mArray[index] = value;
    }

    public void copyFrom(TextIntArray source) {
        this.setSize(source.mSize);
        for (int i = 0; i < this.mSize; ++i) {
            this.mArray[i] = source.mArray[i];
        }
    }
}

