/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.Pkg;
import com.adobe.xfa.text.StrItem;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextGfxSource;
import com.adobe.xfa.text.markup.MarkupOut;
import com.adobe.xfa.ut.UniCharIterator;

class StrText
extends StrItem {
    private final StringBuilder msText;
    private final UniCharIterator mIterator;
    private int mnCharIndex;

    StrText(String sNewText) {
        super(2);
        this.msText = new StringBuilder(sNewText);
        this.mIterator = new UniCharIterator(this.msText);
        int charCount = 0;
        int cPrev = 0;
        int c = this.mIterator.next();
        while (c != 0) {
            if (cPrev == 13 && c == 10) {
                this.mIterator.prev();
                this.mIterator.prev();
                this.msText.deleteCharAt(this.mIterator.getIndex());
                this.mIterator.attach(this.msText, this.mIterator.getIndex());
                this.mIterator.next();
            } else {
                ++charCount;
            }
            cPrev = c;
            c = this.mIterator.next();
        }
        this.setCount(charCount);
        this.mIterator.setIndex(0);
        this.mnCharIndex = 0;
    }

    @Override
    TextAttr markup(MarkupOut oMarkup, int nStart, int nSize, boolean bFlattenFields, TextAttr poPrevAttr) {
        int nStartU16 = this.findChar(nStart);
        int nAfterU16 = this.findChar(nStart + nSize);
        if (nStartU16 == 0 && nAfterU16 == this.msText.length()) {
            oMarkup.text(this.msText.toString());
        } else {
            oMarkup.text(this.msText.substring(nStartU16, nAfterU16));
        }
        return poPrevAttr;
    }

    @Override
    int charAt(int nIndex) {
        this.findChar(nIndex);
        int c = this.mIterator.next();
        if (c == 0) assert (false);
        ++this.mnCharIndex;
        return c;
    }

    @Override
    boolean isEqual(StrItem poCompare) {
        if (!(poCompare instanceof StrText)) {
            return false;
        }
        StrText poText = (StrText)poCompare;
        return this.msText.equals(poText.msText);
    }

    @Override
    StrItem[] split(int nIndex) {
        int nU16 = this.findChar(nIndex);
        StrItem[] pair = new StrItem[]{new StrText(this.msText.substring(0, nU16)), new StrText(this.msText.substring(nU16))};
        return pair;
    }

    @Override
    boolean coalesce(StrItem poAfter, int nIndex) {
        StrText poTextItem = (StrText)poAfter;
        this.msText.append((CharSequence)poTextItem.msText);
        this.setCount(this.count() + poTextItem.count());
        this.mIterator.attach(this.msText);
        this.mnCharIndex = 0;
        return false;
    }

    @Override
    boolean canCoalesce(StrItem poAfter) {
        return true;
    }

    @Override
    void delete(int nStart, int nSize) {
        int nStartU16 = this.findChar(nStart);
        int nAfterU16 = this.findChar(nStart + nSize);
        this.msText.delete(nStartU16, nAfterU16);
        this.setCount(this.count() - nSize);
        this.mnCharIndex = nStart;
        this.mIterator.attach(this.msText, nStartU16);
    }

    @Override
    StrItem cloneItem(TextGfxSource oGfxSource) {
        return new StrText(this.msText.toString());
    }

    @Override
    StrItem clonePart(TextGfxSource oGfxSource, int nStart, int nSize) {
        int nStartU16 = this.findChar(nStart);
        int nAfterU16 = this.findChar(nStart + nSize);
        if (nStartU16 == 0 && nAfterU16 == this.msText.length()) {
            return new StrText(this.msText.toString());
        }
        return new StrText(this.msText.substring(nStartU16, nAfterU16));
    }

    @Override
    void debug(int indent) {
        String prefix = Pkg.doIndent(indent + 1);
        if (this.msText.length() == 0) {
            System.out.println(prefix + "Text");
        } else {
            System.out.print(prefix + "Text \"");
            for (int i = 0; i < this.msText.length(); ++i) {
                char c = this.msText.charAt(i);
                if (c >= ' ' && c < '\u007f') {
                    System.out.print(c);
                    continue;
                }
                int ic = c & 0xFFFF;
                String s = Integer.toHexString(ic + 65536);
                System.out.print("\\u" + s.substring(1));
            }
            System.out.println("\"");
        }
    }

    private int findChar(int nIndex) {
        int nU16;
        int nChar;
        boolean bForward;
        assert (nIndex <= this.count());
        if (nIndex < this.mnCharIndex) {
            if (nIndex <= this.mnCharIndex / 2) {
                bForward = true;
                nChar = 0;
                nU16 = 0;
            } else {
                bForward = false;
                nChar = this.mnCharIndex;
                nU16 = this.mIterator.getIndex();
            }
        } else {
            int nAfter = this.count() - this.mnCharIndex;
            if (nIndex <= this.mnCharIndex + nAfter / 2) {
                bForward = true;
                nChar = this.mnCharIndex;
                nU16 = this.mIterator.getIndex();
            } else {
                bForward = false;
                nChar = this.count();
                nU16 = this.msText.length();
            }
        }
        this.mIterator.setIndex(nU16);
        if (bForward) {
            while (nChar < nIndex) {
                this.mIterator.next();
                ++nChar;
            }
        } else {
            while (nChar > nIndex) {
                this.mIterator.prev();
                --nChar;
            }
        }
        this.mnCharIndex = nChar;
        return this.mIterator.getIndex();
    }
}

