/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.ABXY;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.FrameCaret;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextSparseStream;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.ut.CoordPair;

class FrameCaretPosn
extends FrameCaret {
    private TextStream mpoSearchStream;
    private CoordPair moSearchPoint;
    private boolean mbAllowDescendents;
    private TextPosnBase mpoResult;

    FrameCaretPosn(TextSparseStream poStream, TextStream poSearchStream, CoordPair oSearchPoint, boolean bAllowDescendents, TextPosnBase poResult) {
        super(poStream, 0);
        this.mpoSearchStream = poSearchStream;
        this.moSearchPoint = oSearchPoint;
        this.mbAllowDescendents = bAllowDescendents;
        this.mpoResult = poResult;
    }

    @Override
    protected int processCaretLine(DispLineWrapped poLine) {
        TextFrame poFrame = this.getFrame();
        int nCurrentFrame = this.getFrameIndex();
        int nCurrentLine = this.getLineIndex();
        CoordPair oSearch = new CoordPair(this.moSearchPoint.x(), this.moSearchPoint.y().subtract(this.getOffset()));
        oSearch = ABXY.toAB(poLine.getXYOrigin(), oSearch, poFrame.getLayoutOrientation());
        if ((nCurrentFrame > 0 || nCurrentLine > 0) && oSearch.y().value() < 0) {
            return 0;
        }
        if ((nCurrentFrame + 1 < poFrame.getStream().getFrameCount() || nCurrentLine + 1 < poFrame.getLineCount()) && oSearch.y().gt(poLine.getBExtent())) {
            return 0;
        }
        return poLine.getCaretPosn(this.mpoSearchStream, oSearch.x(), this.mpoResult, this.mbAllowDescendents);
    }
}

