/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispLine;
import com.adobe.xfa.text.DispMapItem;
import com.adobe.xfa.text.DispPosn;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.TextPosn;

class DispMapSpan {
    private DispLine mpoLine;
    private DispMapItem moItem;
    private int mnStart;

    DispMapSpan(DispLine poLine) {
        this.mpoLine = poLine;
    }

    DispMapSpan(DispLine poLine, DispMapItem oSource) {
        this.mpoLine = poLine;
        this.moItem = oSource.cloneMapItem();
    }

    DispLine getLine() {
        return this.mpoLine;
    }

    int length() {
        return this.mpoLine.getCharCount() - this.mnStart;
    }

    void flush(boolean bForce) {
        int nLength = this.length();
        if (nLength > 0 || bForce) {
            assert (this.moItem != null);
            this.moItem.add(this.mpoLine, this.mnStart, nLength);
            this.mnStart = this.mpoLine.getCharCount();
        }
    }

    void flush() {
        this.flush(false);
    }

    void reset(DispMapItem oSource, boolean bForce) {
        this.flush(bForce);
        if (this.moItem == null) {
            this.moItem = oSource.cloneMapItem();
        } else {
            this.moItem.copyFrom(oSource);
        }
    }

    void reset(DispMapItem oSource) {
        this.reset(oSource, false);
    }

    DispPosn p() {
        assert (this.moItem instanceof DispPosn);
        return (DispPosn)this.moItem;
    }

    TextPosn pp() {
        assert (this.moItem instanceof DispPosn);
        DispPosn p = (DispPosn)this.moItem;
        return p.pp();
    }

    DispRun r() {
        assert (this.moItem instanceof DispRun);
        return (DispRun)this.moItem;
    }

    void copyFrom(DispMapItem source) {
        if (this.moItem == null) {
            this.moItem = source.cloneMapItem();
        } else {
            this.moItem.copyFrom(source);
        }
    }
}

