/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontItem;
import com.adobe.xfa.text.AFEAttrMap;
import com.adobe.xfa.text.AFEAttrSet;
import com.adobe.xfa.text.AFEFixedAttr;
import com.adobe.xfa.text.AFEVarAttr;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextEmbed;
import com.adobe.xfa.text.Units;
import java.util.Set;

class AFEElement {
    private static final int STATE_INITIAL_CHAR = 0;
    private static final int STATE_FIRST_GLYPH = 1;
    private static final int STATE_OTHER_GLYPH = 2;
    private static final int STATE_EMBED = 2;
    private final AFEAttrMap mAFEAttrMap;
    private TextEmbed mEmbed;
    private int mElement;
    private int mElementState;
    private AFEFixedAttr mFixedAttrs;
    private AFEVarAttr mVarAttrs;
    private double mXPlacement;
    private double mYPlacement;
    private double mXAdvance;
    private double mYAdvance;
    private int mMapIndex;
    private int mMapLength;
    private boolean mRunBreak;
    private boolean mInMultiple;
    private boolean mIsRTL;
    private boolean mIsGlyph;
    private boolean mAllowKerning;

    AFEElement(AFEElement source) {
        this.mAFEAttrMap = source.mAFEAttrMap;
        this.mElement = source.mElement;
        this.mElementState = 2;
        this.mFixedAttrs = source.mFixedAttrs;
        this.mVarAttrs = source.mVarAttrs;
        this.mXPlacement = source.mXPlacement;
        this.mYPlacement = source.mYPlacement;
        this.mXAdvance = source.mXAdvance;
        this.mYAdvance = source.mYAdvance;
        this.mMapIndex = source.mMapIndex;
        this.mMapLength = 1;
        this.mInMultiple = source.mInMultiple;
        this.mIsRTL = source.mIsRTL;
        this.mIsGlyph = source.mIsGlyph;
        this.mAllowKerning = source.mAllowKerning;
    }

    AFEElement(TextContext context, int elementChar, int mapIndex) {
        this.mAFEAttrMap = context.getAFEAttrMap();
        this.mVarAttrs = this.mAFEAttrMap.getEmptyVarAttr();
        this.mElement = elementChar;
        this.mElementState = 0;
        this.mMapIndex = mapIndex;
        this.mMapLength = 1;
    }

    AFEElement(TextContext context, TextEmbed embed, int mapIndex) {
        this.mAFEAttrMap = context.getAFEAttrMap();
        this.mVarAttrs = this.mAFEAttrMap.getEmptyVarAttr();
        this.mEmbed = embed;
        this.mElementState = 2;
        this.mMapIndex = mapIndex;
        this.mMapLength = 1;
        this.mRunBreak = true;
    }

    void populateChar(AFEElement prevElement, DispRun dispRun, DispRun prevRun, int bidiLevel) {
        assert (this.mEmbed == null);
        TextAttr textAttr = dispRun.getAttr();
        TextAttr prevAttr = prevRun == null ? null : prevRun.getAttr();
        boolean sameAttrs = TextAttr.match(textAttr, prevAttr);
        this.mAllowKerning = dispRun.allowKerning();
        if (sameAttrs) {
            assert (prevElement != null);
            this.mFixedAttrs = prevElement.mFixedAttrs;
        } else {
            this.mFixedAttrs = this.mAFEAttrMap.mapFixedAttr(dispRun, bidiLevel);
            if (textAttr == null || prevAttr == null) {
                this.mRunBreak = true;
            } else if (!FontInstance.match(textAttr.fontInstance(), prevAttr.fontInstance())) {
                this.mRunBreak = true;
            } else if (dispRun.allowKerning() != prevRun.allowKerning()) {
                this.mRunBreak = true;
            }
        }
        this.mIsRTL = (bidiLevel & 1) != 0;
    }

    void populateEmbed(DispRun dispRun, int bidiLevel) {
        this.mFixedAttrs = this.mAFEAttrMap.mapFixedAttr(dispRun, bidiLevel);
        this.mRunBreak = true;
        this.mIsRTL = (bidiLevel & 1) != 0;
    }

    TextEmbed getEmbed() {
        return this.mEmbed;
    }

    float getScaledXAdvance() {
        return this.mEmbed != null ? Units.toFloat(this.mEmbed.width()) : this.ctLegacyScale(this.mFixedAttrs.getCTXScale(), this.mXAdvance);
    }

    float getScaledXPlacement() {
        return this.mEmbed != null ? 0.0f : this.ctLegacyScale(this.mFixedAttrs.getCTXScale(), this.mXPlacement);
    }

    float getScaledYAdvance() {
        return this.mEmbed != null ? 0.0f : (float)(this.mFixedAttrs.getFontYScale() * this.mYAdvance);
    }

    float getScaledYPlacement() {
        return this.mEmbed != null ? 0.0f : (float)(this.mFixedAttrs.getFontYScale() * this.mYPlacement);
    }

    int getMapIndex() {
        return this.mMapIndex;
    }

    int getMapLength() {
        return this.mMapLength;
    }

    void setMapLength(int mapLength) {
        this.mMapLength = mapLength;
    }

    boolean isInMultiple() {
        return this.mInMultiple;
    }

    void setInMultiple(boolean inMultiple) {
        this.mInMultiple = inMultiple;
    }

    boolean getRunBreak() {
        return this.mRunBreak;
    }

    boolean isRTL() {
        return this.mIsRTL;
    }

    boolean allowKerning() {
        return this.mAllowKerning;
    }

    AFEAttrSet getAttrSet() {
        return this.mFixedAttrs;
    }

    boolean matchAttr(AFEElement compare, Object attribute) {
        assert (this.mEmbed == null);
        if (attribute == ElementAttribute.isGlyph) {
            return this.mIsGlyph == compare.mIsGlyph;
        }
        if (AFEAttrSet.isFixedAttr(attribute)) {
            return this.mFixedAttrs.matchAttr(compare.mFixedAttrs, attribute);
        }
        return this.mVarAttrs.matchAttr(compare.mVarAttrs, attribute);
    }

    boolean matchAttr(AFEElement compare, Set attributes) {
        assert (this.mEmbed == null);
        for (Object attribute : attributes) {
            if (this.matchAttr(compare, attribute)) continue;
            return false;
        }
        return true;
    }

    boolean renderByGlyphID() {
        return this.mElementState == 2;
    }

    void setBIDILevel(int bidiLevel) {
        this.mIsRTL = (bidiLevel & 1) != 0;
    }

    void adjustPlacementAndAdvance(double xPlacementDelta, double yPlacementDelta, double xAdvanceDelta, double yAdvanceDelta) {
        assert (this.mEmbed == null);
        this.mXPlacement += xPlacementDelta;
        this.mYPlacement -= yPlacementDelta;
        this.mXAdvance += xAdvanceDelta;
        this.mYAdvance -= yAdvanceDelta;
    }

    int elementAt() {
        return this.mElement;
    }

    Object getElementStyle(Object attribute) {
        assert (this.mEmbed == null);
        if (attribute == ElementAttribute.isGlyph) {
            return this.mIsGlyph;
        }
        if (AFEAttrSet.isFixedAttr(attribute)) {
            return this.mFixedAttrs.getAttr(attribute);
        }
        return this.mVarAttrs.getAttr(attribute);
    }

    double getElementXAdvance() {
        assert (this.mEmbed == null);
        return this.mXAdvance;
    }

    double getElementXPlacement() {
        assert (this.mEmbed == null);
        return this.mXPlacement;
    }

    double getElementYAdvance() {
        assert (this.mEmbed == null);
        return this.mYAdvance;
    }

    double getElementYPlacement() {
        assert (this.mEmbed == null);
        return this.mYPlacement;
    }

    Object getInterElementStyleBefore(InterElementAttribute attribute) {
        assert (this.mEmbed == null);
        return this.getElementStyle(attribute);
    }

    void setElement(int element, boolean isComplexSet) {
        assert (this.mEmbed == null);
        if (isComplexSet) {
            this.mElementState = 2;
        } else {
            switch (this.mElementState) {
                case 0: {
                    this.mElementState = 1;
                    FontInstance fontInstance = this.mFixedAttrs.getFontInstance();
                    if (fontInstance == null) break;
                    fontInstance.mapGlyph(this.mElement, element);
                    break;
                }
                case 1: {
                    this.mElementState = 2;
                }
            }
        }
        this.mElement = element;
    }

    void setElementPlacementAndAdvance(double xPlacement, double yPlacement, double xAdvance, double yAdvance) {
        assert (this.mEmbed == null);
        this.mXPlacement = xPlacement;
        this.mYPlacement = -yPlacement;
        this.mXAdvance = xAdvance;
        this.mYAdvance = -yAdvance;
    }

    void setElementStyle(Object attribute, Object value) {
        assert (this.mEmbed == null);
        if (attribute == ElementAttribute.isGlyph) {
            assert (value instanceof Boolean);
            Boolean bool = (Boolean)value;
            this.mIsGlyph = bool;
        } else {
            assert (!AFEAttrSet.isFixedAttr(attribute));
            this.mVarAttrs = this.mAFEAttrMap.mapVarAttr(this.mVarAttrs, attribute, value);
            this.mVarAttrs.setAttr(attribute, value);
        }
    }

    void setInterElementStyleBefore(InterElementAttribute attribute, Object value) {
        assert (this.mEmbed == null);
        this.setElementStyle(attribute, value);
    }

    void startWorkingWithPositions() {
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Element: ");
        if (this.mEmbed != null) {
            result.append("embed: (");
            result.append(this.mEmbed.toString());
            result.append("), XAdvance: ");
            result.append(this.mEmbed.width().toString());
        } else {
            result.append(Integer.toString(this.mElement));
            result.append(", XPlacement: ");
            result.append(Double.toString(this.mXPlacement * this.mFixedAttrs.getFontXScale()));
            result.append(", YPlacement: ");
            result.append(Double.toString(this.mYPlacement * this.mFixedAttrs.getFontYScale()));
            result.append(", XAdvance: ");
            result.append(Double.toString(this.mXAdvance * this.mFixedAttrs.getFontXScale()));
            result.append(", YAdvance: ");
            result.append(Double.toString(this.mYAdvance * this.mFixedAttrs.getFontYScale()));
            result.append(", Attributes: (");
            result.append(this.mFixedAttrs.toString());
            result.append(")");
        }
        return result.toString();
    }

    private float ctLegacyScale(double emScale, double advance) {
        double result = FontItem.ctLegacyScale(emScale, advance);
        return (float)(result *= this.mFixedAttrs.getFontSize());
    }
}

