/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.soap;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Chars;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.protocol.HttpForm;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SOAP {
    public static final int SOAP_UNKNOWN = 0;
    public static final int SOAP_BODY = 1;
    public static final int SOAP_ENVELOPE = 2;
    public static final int SOAP_HEADER = 3;
    public static final int SOAP_FAULT = 4;
    private static final String BODY = "Body";
    private static final String ENVELOPE = "Envelope";
    private static final String ENVELOPE_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String ENVELOPE_QUAL = "soap:Envelope";
    private static final String FAULT = "Fault";
    private static final String FAULT_ACTOR = "faultactor";
    private static final String FAULT_CODE = "faultcode";
    private static final String FAULT_DETAIL = "detail";
    private static final String FAULT_STRING = "faultstring";
    private static final String HEADER = "Header";
    private static final String[] mEnvelopeNamespaces = new String[]{"xmlns:xsi", "xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd", "xsd", "http://www.w3.org/2001/XMLSchema", "xmlns:SOAP-ENC", "SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/"};
    private static final int ENVELOPE_NS_STRINGS = 3;
    private Element mEnvelopeNode;
    private Element mBodyNode;
    private Element mHeaderNode;
    private Element mFaultNode;
    private Map<String, String> mNamespaces;
    private Document mDomDocument;
    private String mLastErrorText;

    public static SOAP createFromXMLStreams(InputStream headerStream, InputStream bodyStream, String loadOptions) {
        Element envelope;
        Document document;
        SOAP soap;
        block5: {
            soap = new SOAP();
            document = null;
            envelope = null;
            try {
                AppModel appModel = new AppModel(null);
                document = appModel.getDocument();
                envelope = soap.createEnvelopeDomNode(document);
                appModel.appendChild(envelope);
                if (headerStream != null) {
                    soap.createChildAndContentDomNode(document, HEADER, envelope, headerStream);
                }
                if (bodyStream != null) {
                    soap.createChildAndContentDomNode(document, BODY, envelope, bodyStream);
                }
            }
            catch (ExFull oEx) {
                int resId = oEx.firstResId();
                if (resId == ResId.EXPAT_ERROR) break block5;
                throw oEx;
            }
        }
        if (document == null) {
            return null;
        }
        soap.mDomDocument = document;
        soap.loadDocument(envelope);
        return soap;
    }

    public static boolean exportContentsToXML(Element element, OutputStream outputStream) {
        Element child;
        int nodeType = SOAP.getNodeType(element);
        if (nodeType != 3 && nodeType != 1) {
            return false;
        }
        for (child = element.getFirstXMLChildElement(); child != null && child.getNS() == ENVELOPE_NS && child.getLocalName() != FAULT; child = child.getNextXMLSiblingElement()) {
        }
        if (child == null) {
            return false;
        }
        DOMSaveOptions saveOptions = new DOMSaveOptions();
        saveOptions.setDisplayFormat(2);
        element.getOwnerDocument().saveAs(outputStream, child, saveOptions);
        return true;
    }

    public static final int getNodeType(Node node) {
        if (!(node instanceof Element)) {
            return 0;
        }
        Element element = (Element)node;
        String localName = element.getLocalName();
        if (localName == BODY) {
            return 1;
        }
        if (localName == ENVELOPE) {
            return 2;
        }
        if (localName == FAULT) {
            return 4;
        }
        if (localName == HEADER) {
            return 3;
        }
        return 0;
    }

    public static SOAP loadFromStream(InputStream stream, String loadOptions) {
        Element bogusRoot;
        Document document;
        AppModel appModel;
        SOAP soap;
        block4: {
            soap = new SOAP();
            appModel = new AppModel(null);
            document = appModel.getDocument();
            bogusRoot = null;
            try {
                bogusRoot = document.loadIntoDocument(stream);
            }
            catch (ExFull oEx) {
                int resId = oEx.firstResId();
                if (resId == ResId.EXPAT_ERROR) break block4;
                throw oEx;
            }
        }
        if (bogusRoot == null) {
            return null;
        }
        Element envelope = bogusRoot.getFirstXMLChildElement();
        if (envelope == null) {
            return null;
        }
        appModel.appendChild(envelope);
        soap.mDomDocument = document;
        soap.loadDocument(envelope);
        return soap;
    }

    private static final Element getChildDomNode(Element node, String inNodeName) {
        for (Element child = node.getFirstXMLChildElement(); child != null; child = child.getNextXMLSiblingElement()) {
            if (child.getLocalName() != inNodeName) continue;
            return child;
        }
        return null;
    }

    private static final String getChildDomNodeTextValue(Element startNode) {
        for (Node child = startNode.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Chars)) continue;
            Chars chars = (Chars)child;
            return chars.getText();
        }
        return "";
    }

    private static final String getChildDomNodeValue(Element node, String inNodeName) {
        Element child = SOAP.getChildDomNode(node, inNodeName);
        return child == null ? "" : SOAP.getChildDomNodeTextValue(child);
    }

    private SOAP() {
    }

    public Element getBodyNode() {
        return this.mBodyNode;
    }

    public Element getEnvelopeNode() {
        return this.mEnvelopeNode;
    }

    public Node getFaultActor() {
        return SOAP.getChildDomNode(this.mFaultNode, FAULT_ACTOR);
    }

    public String getFaultCode() {
        return SOAP.getChildDomNodeValue(this.mFaultNode, FAULT_CODE);
    }

    public Node getFaultDetail() {
        return SOAP.getChildDomNode(this.mFaultNode, FAULT_DETAIL);
    }

    public Element getFaultNode() {
        return this.mFaultNode;
    }

    public String getFaultString() {
        return SOAP.getChildDomNodeValue(this.mFaultNode, FAULT_STRING);
    }

    public Element getHeaderNode() {
        return this.mHeaderNode;
    }

    public String getLastError() {
        return this.mLastErrorText;
    }

    public void saveAs(OutputStream outputStream) {
        if (this.mEnvelopeNode != null && this.mDomDocument != null) {
            DOMSaveOptions saveOptions = new DOMSaveOptions();
            saveOptions.setDisplayFormat(2);
            this.mDomDocument.saveAs(outputStream, this.mEnvelopeNode, saveOptions);
        }
    }

    public SOAP sendRequest(String inSOAPAddress, String inSOAPAction) {
        this.mLastErrorText = null;
        HttpForm httpForm = new HttpForm();
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        this.saveAs(memStream);
        byte[] sent = memStream.toByteArray();
        memStream = null;
        httpForm.setEncodingType(HttpForm.PostEncodingType.USER_ENCODING);
        httpForm.addEncodedData(sent, "text/xml", "utf-8");
        sent = null;
        httpForm.addHeaderData("SOAPAction", inSOAPAction);
        ExFull receivedException = null;
        String errorString = null;
        String stringReturnedByServer = null;
        SOAP responseModel = null;
        try {
            httpForm.post(inSOAPAddress);
        }
        catch (ExFull exception) {
            if (exception.hasResId(ResId.PROTOCOL_ERR_SYS)) {
                int numExceptions = exception.count();
                for (int i = 0; i < numExceptions; ++i) {
                    int resID = exception.getResId(i);
                    if (resID == ResId.PROTOCOL_ERR_POST) {
                        errorString = exception.item(i).text();
                        continue;
                    }
                    if (resID != ResId.PROTOCOL_ERR_SYS) continue;
                    stringReturnedByServer = exception.item(i).text();
                }
                receivedException = exception;
            }
            throw exception;
        }
        byte[] response = null;
        if (errorString != null || stringReturnedByServer != null) {
            if (errorString != null) {
                this.mLastErrorText = errorString;
            } else if (stringReturnedByServer != null) {
                this.mLastErrorText = stringReturnedByServer;
            }
            if (stringReturnedByServer != null) {
                try {
                    response = stringReturnedByServer.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ignored) {}
            }
        } else {
            response = httpForm.getResponse();
        }
        if (response != null) {
            try {
                responseModel = SOAP.loadFromStream(new ByteArrayInputStream(response), "");
            }
            catch (ExFull loadException) {
                receivedException = loadException;
            }
        }
        if (responseModel == null && receivedException != null) {
            throw receivedException;
        }
        return responseModel;
    }

    private Node createChildAndContentDomNode(Document inDoc, String inNodeName, Element inParentNode, InputStream inContentStream) {
        Element contentNode = inDoc.loadIntoDocument(inContentStream);
        Node oContentChild = contentNode.getFirstXMLChild();
        if (oContentChild instanceof Element && ((Element)oContentChild).getLocalName().equals(inNodeName)) {
            inParentNode.appendChild(oContentChild);
            return oContentChild;
        }
        Element oDomNode = inDoc.createElementNS(ENVELOPE_NS, inNodeName, inParentNode);
        oDomNode.appendChild(oContentChild);
        return oDomNode;
    }

    private Element createEnvelopeDomNode(Document inDoc) {
        Element envelope = inDoc.createElementNS(ENVELOPE_NS, ENVELOPE_QUAL, null);
        for (int i = 0; i < mEnvelopeNamespaces.length; i += 3) {
            envelope.setAttribute(null, mEnvelopeNamespaces[i], mEnvelopeNamespaces[i + 1], mEnvelopeNamespaces[i + 2]);
        }
        return envelope;
    }

    private boolean findFault(Element root) {
        for (Element child = root.getFirstXMLChildElement(); child != null; child = child.getNextXMLSiblingElement()) {
            if (SOAP.getNodeType(child) == 4) {
                this.mFaultNode = child;
                return true;
            }
            if (!this.findFault(child)) continue;
            return true;
        }
        return false;
    }

    private void loadDocument(Element startNode) {
        if (startNode == null || !startNode.getLocalName().equals(ENVELOPE)) {
            return;
        }
        this.mEnvelopeNode = startNode;
        int numAttrs = this.mEnvelopeNode.getNumAttrs();
        for (int i = 0; i < numAttrs; ++i) {
            Attribute attr = this.mEnvelopeNode.getAttr(i);
            if (!attr.isNameSpaceAttr()) continue;
            if (this.mNamespaces == null) {
                this.mNamespaces = new HashMap<String, String>();
            }
            this.mNamespaces.put(attr.getLocalName(), attr.getAttrValue());
        }
        block6: for (Element child = this.mEnvelopeNode.getFirstXMLChildElement(); child != null; child = child.getNextXMLSiblingElement()) {
            switch (SOAP.getNodeType(child)) {
                case 1: {
                    this.mBodyNode = child;
                    this.findFault(child);
                    continue block6;
                }
                case 4: {
                    this.mFaultNode = child;
                    continue block6;
                }
                case 3: {
                    this.mHeaderNode = child;
                    this.findFault(child);
                }
            }
        }
    }
}

