/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.protocol;

import com.adobe.xfa.ut.CharacterHolder;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.StringHolder;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public abstract class AuthenticationHandler
extends Authenticator {
    protected HandlerType meHandlerType = HandlerType.CLIENT;
    private String msUserID = null;
    private CharacterHolder maPassword = null;
    private String msHint = null;
    private AuthenticationType meTransportAuthType = AuthenticationType.NONE;
    private String msURL = null;
    private String msHost = null;
    private String msType = null;
    private String msRealm = null;
    private ConnectStatus meTransportStatus = ConnectStatus.NOTSET;
    private AuthenticationType meSOAPAuthType = AuthenticationType.NONE;
    private String msSOAPAddress = null;
    private String msSOAPOperation = null;
    private String msConnectionName = null;
    private SOAPRequestStatus meSOAPStatus = SOAPRequestStatus.SOAPNOTSET;
    private String msSOAPFault = null;
    private String msSOAPFaultCode = null;

    public AuthenticationHandler(HandlerType eType) {
        this.meHandlerType = eType;
    }

    public abstract boolean checkAuthenticationStatus();

    public abstract boolean checkSOAPAuthenticationStatus();

    public abstract AuthenticationHandler clone();

    public abstract boolean getBasicCredentials(String var1, String var2, StringHolder var3, CharacterHolder var4);

    public abstract boolean getBasicSOAPCredentials(String var1, String var2, String var3, StringHolder var4, CharacterHolder var5);

    public abstract boolean getCertificateCredentials(String var1, CharacterHolder var2, IntegerHolder var3, ObjectHolder<byte[]> var4, StringHolder var5);

    public abstract boolean isCertificateAuthorityValid(String var1);

    public String getConnectionName() {
        return this.msConnectionName;
    }

    public ConnectStatus getConnectStatus() {
        return this.meTransportStatus;
    }

    public HandlerType getHandlerType() {
        return this.meHandlerType;
    }

    public String getHint() {
        return this.msHint;
    }

    public String getHost() {
        return this.msHost;
    }

    public CharacterHolder getPassword() {
        return this.maPassword;
    }

    public String getRealm() {
        return this.msRealm;
    }

    public String getSOAPAddress() {
        return this.msSOAPAddress;
    }

    public AuthenticationType getSOAPAuthType() {
        return this.meSOAPAuthType;
    }

    public String getSOAPFaultCode() {
        return this.msSOAPFaultCode;
    }

    public String getSOAPFaultString() {
        return this.msSOAPFault;
    }

    public String getSOAPOperation() {
        return this.msSOAPOperation;
    }

    public SOAPRequestStatus getSOAPRequestStatus() {
        return this.meSOAPStatus;
    }

    public String getURL() {
        return this.msURL;
    }

    public AuthenticationType getTransportAuthType() {
        return this.meTransportAuthType;
    }

    public String getType() {
        return this.msType;
    }

    public String getUserID() {
        return this.msUserID;
    }

    public void logMessage(MsgFormatPos oError) {
    }

    public void reset() {
        this.msUserID = "";
        this.maPassword = new CharacterHolder();
        this.msHint = "";
        this.meTransportAuthType = AuthenticationType.NONE;
        this.msURL = "";
        this.msHost = "";
        this.msType = "";
        this.msRealm = "";
        this.meTransportStatus = ConnectStatus.NOTSET;
        this.meSOAPAuthType = AuthenticationType.NONE;
        this.msSOAPAddress = "";
        this.msSOAPOperation = "";
        this.msConnectionName = "";
        this.meSOAPStatus = SOAPRequestStatus.SOAPNOTSET;
        this.msSOAPFault = "";
        this.msSOAPFaultCode = "";
    }

    public void setConnectionName(String sConnectionName) {
        this.msConnectionName = sConnectionName;
    }

    public void setConnectStatus(ConnectStatus eStatus) {
        this.meTransportStatus = eStatus;
    }

    public void setHandlerType(HandlerType eHandlerType) {
        this.meHandlerType = eHandlerType;
    }

    public void setHint(String sHint) {
        this.msHint = sHint;
    }

    public void setHost(String sHost) {
        this.msHost = sHost;
    }

    public void setPassword(CharacterHolder aPassword) {
        this.maPassword = aPassword;
    }

    public void setRealm(String sRealm) {
        this.msRealm = sRealm;
    }

    public void setSOAPAddress(String sSOAPAddress) {
        this.msSOAPAddress = sSOAPAddress;
    }

    public void setSOAPAuthType(AuthenticationType eAuthType) {
        this.meSOAPAuthType = eAuthType;
    }

    public void setSOAPFaultCode(String sSOAPFaultCode) {
        this.msSOAPFaultCode = sSOAPFaultCode;
    }

    public void setSOAPFaultString(String sSOAPFault) {
        this.msSOAPFault = sSOAPFault;
    }

    public void setSOAPOperation(String sSOAPOperation) {
        this.msSOAPOperation = sSOAPOperation;
    }

    public void setSOAPRequestStatus(SOAPRequestStatus eSOAPStatus) {
        this.meSOAPStatus = eSOAPStatus;
    }

    public void setTransportAuthType(AuthenticationType eAuthType) {
        this.meTransportAuthType = eAuthType;
    }

    public void setType(String sType) {
        this.msType = sType;
    }

    public void setURL(String sURL) {
        this.msURL = sURL;
    }

    public void setUserID(String sUserID) {
        this.msUserID = sUserID;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }

    public static enum SOAPRequestStatus {
        SOAPNOTSET,
        SOAPSUCCESS,
        SOAPFAULT;

    }

    public static enum HandlerType {
        CLIENT,
        SERVER;

    }

    public static enum ConnectStatus {
        NOTSET(0),
        CONNECTED(200),
        CONNECTIONERROR(300),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        FILENOTFOUND(404),
        CLIENTAUTHCERTNEEDED(12044),
        INVALIDCA(12045);

        private int code;

        private ConnectStatus(int c) {
            this.code = c;
        }
    }

    public static enum AuthenticationType {
        NONE,
        BASIC,
        DIGEST,
        CERTIFICATE;

    }
}

