/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.qrcodepmp.denso;

import com.adobe.xfa.pmp.common.IntegerHolder;

public class QRC {
    private static final int JOINT_MODE = 3;
    private static final int NUMBER_MODE = 1;
    private static final int ALNUM_MODE = 2;
    private static final int BINARY_MODE = 4;
    private static final int KANJI_MODE = 8;
    private static final int MAXCHARMODE = 4;
    private static final int NUMBER = 0;
    private static final int ALNUM = 1;
    private static final int BINARY = 2;
    private static final int KANJI = 3;
    private static final int MAXVER = 40;
    private static final int MAXVER1 = 14;
    private static final int MAXVER2 = 40;
    private static final int TTLENOFST = 0;
    private static final int NDATAOFST = 1;
    private static final int DIVIDOFST = 5;
    private static final int MODEL1 = 0;
    public static final int MODEL2 = 1;
    private static final int PATTERN12 = 8;
    private static final int CVER_ALP = 1;
    private static final int CVER_VINFO = 6;
    private static final int VERSIONLO = 9;
    private static final int VERSIONMI = 26;
    private static final int SMAX = 181;
    private static final int CMAX = 3808;
    private static final int AMAX = 256;
    private static final int EMAX = 68;
    private static final int HMAX = 254;
    private static final int MAXCOEF = 31;
    private static final int BLKMAX = 2000;
    private static final int DATAMAX = 7366;
    private IntegerHolder Jmode = new IntegerHolder(0);
    private IntegerHolder joint_data = new IntegerHolder(0);
    private IntegerHolder parity = new IntegerHolder(0);
    public int modelNo;
    public char[] cdata = new char[7367];
    public qrdata[] qdata = new qrdata[2000];
    private static final int DPATTERN = 60433;
    private char[] Ccode;
    private char[] iCcode;
    public int Clvl;
    private int Clen;
    private int Cver;
    public int Csize;
    private int Selmsk;
    private int vinfoTOTAL;
    private int vinfoNDATA;
    private int vinfoDIVID;
    private static final char[][] nch_indicate = new char[][]{{'\n', '\t', '\b', '\b'}, {'\f', '\u000b', '\u0010', '\n'}, {'\u000e', '\r', '\u0010', '\f'}};
    private static final int[][][] vinfo = new int[][][]{new int[][]{{26, 18, 15, 12, 8, 1, 1, 1, 1}, {46, 35, 29, 23, 15, 1, 1, 1, 1}, {72, 56, 43, 35, 23, 1, 1, 1, 1}, {100, 79, 59, 49, 33, 1, 1, 1, 1}, {134, 107, 81, 67, 45, 1, 1, 1, 2}, {170, 135, 105, 85, 57, 1, 2, 2, 2}, {212, 169, 131, 107, 71, 1, 2, 2, 3}, {256, 207, 159, 127, 86, 2, 2, 2, 3}, {306, 245, 185, 155, 101, 2, 2, 3, 3}, {358, 289, 221, 182, 123, 2, 2, 3, 4}, {416, 335, 255, 207, 144, 2, 4, 4, 5}, {476, 383, 291, 243, 164, 2, 4, 4, 5}, {542, 431, 331, 275, 191, 3, 4, 4, 6}, {610, 488, 367, 309, 209, 3, 4, 5, 6}, {684, 551, 411, 347, 230, 3, 4, 6, 7}, {760, 608, 459, 383, 263, 3, 5, 6, 8}, {842, 671, 509, 419, 296, 4, 5, 7, 9}, {926, 739, 563, 471, 319, 4, 6, 8, 10}, {1016, 815, 617, 509, 351, 4, 6, 10, 11}, {1108, 884, 671, 549, 383, 5, 7, 11, 12}, {1206, 964, 727, 599, 407, 5, 7, 12, 12}, {1306, 1049, 791, 649, 441, 6, 8, 13, 13}, {1412, 1133, 863, 701, 479, 6, 9, 13, 15}, {1520, 1217, 919, 764, 524, 6, 10, 15, 15}, {1634, 1308, 989, 831, 543, 7, 10, 16, 16}, {1750, 1399, 1088, 881, 593, 7, 11, 18, 18}, {1872, 1503, 1121, 935, 647, 8, 11, 18, 18}, {1996, 1607, 1223, 1006, 692, 8, 12, 19, 21}, {2126, 1709, 1286, 1079, 734, 9, 13, 20, 21}, {2258, 1799, 1357, 1149, 781, 9, 14, 23, 23}, {2396, 1929, 1441, 1195, 827, 10, 14, 23, 23}, {2536, 2029, 1567, 1287, 863, 10, 16, 23, 32}, {2682, 2147, 1673, 1374, 909, 12, 18, 25, 26}, {2830, 2267, 1745, 1427, 979, 14, 18, 28, 28}, {2984, 2399, 1842, 1487, 991, 12, 19, 31, 31}, {3140, 2508, 1939, 1599, 1087, 13, 20, 32, 32}, {3302, 2651, 2036, 1649, 1121, 13, 21, 33, 33}, {3466, 2785, 2120, 1748, 1154, 14, 21, 33, 35}, {3636, 2909, 2253, 1835, 1259, 15, 23, 36, 36}, {3808, 3071, 2299, 1899, 1291, 16, 25, 38, 38}}, new int[][]{{26, 19, 16, 13, 9, 1, 1, 1, 1}, {44, 34, 28, 22, 16, 1, 1, 1, 1}, {70, 55, 44, 34, 26, 1, 1, 2, 2}, {100, 80, 64, 48, 36, 1, 2, 2, 4}, {134, 108, 86, 62, 46, 1, 2, 4, 4}, {172, 136, 108, 76, 60, 2, 4, 4, 4}, {196, 156, 124, 88, 66, 2, 4, 6, 5}, {242, 194, 154, 110, 86, 2, 4, 6, 6}, {292, 232, 182, 132, 100, 2, 5, 8, 8}, {346, 274, 216, 154, 122, 4, 5, 8, 8}, {404, 324, 254, 180, 140, 4, 5, 8, 11}, {466, 370, 290, 206, 158, 4, 8, 10, 11}, {532, 428, 334, 244, 180, 4, 9, 12, 16}, {581, 461, 365, 261, 197, 4, 9, 16, 16}, {655, 523, 415, 295, 223, 6, 10, 12, 18}, {733, 589, 453, 325, 253, 6, 10, 17, 16}, {815, 647, 507, 367, 283, 6, 11, 16, 19}, {901, 721, 563, 397, 313, 6, 13, 18, 21}, {991, 795, 627, 445, 341, 7, 14, 21, 25}, {1085, 861, 669, 485, 385, 8, 16, 20, 25}, {1156, 932, 714, 512, 406, 8, 17, 23, 25}, {1258, 1006, 782, 568, 442, 9, 17, 23, 34}, {1364, 1094, 860, 614, 464, 9, 18, 25, 30}, {1474, 1174, 914, 664, 514, 10, 20, 27, 32}, {1588, 1276, 1000, 718, 538, 12, 21, 29, 35}, {1706, 1370, 1062, 754, 596, 12, 23, 34, 37}, {1828, 1468, 1128, 808, 628, 12, 25, 34, 40}, {1921, 1531, 1193, 871, 661, 13, 26, 35, 42}, {2051, 1631, 1267, 911, 701, 14, 28, 38, 45}, {2185, 1735, 1373, 985, 745, 15, 29, 40, 48}, {2323, 1843, 1455, 1033, 793, 16, 31, 43, 51}, {2465, 1955, 1541, 1115, 845, 17, 33, 45, 54}, {2611, 2071, 1631, 1171, 901, 18, 35, 48, 57}, {2761, 2191, 1725, 1231, 961, 19, 37, 51, 60}, {2876, 2306, 1812, 1286, 986, 19, 38, 53, 63}, {3034, 2434, 1914, 1354, 1054, 20, 40, 56, 66}, {3196, 2566, 1992, 1426, 1096, 21, 43, 59, 70}, {3362, 2702, 2102, 1502, 1142, 22, 45, 62, 74}, {3532, 2812, 2216, 1582, 1222, 24, 47, 65, 77}, {3706, 2956, 2334, 1666, 1276, 25, 49, 68, 81}}};
    private static final int[] numrem = new int[]{0, 4, 7};
    private int Blksu;
    private static final char[] bcwtbl = new char[]{'$', '\u0000', '\u0000', '\u0000', '%', '&', '\u0000', '\u0000', '\u0000', '\u0000', '\'', '(', '\u0000', ')', '*', '+', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', ',', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#'};
    private int CodeWordLen;
    private char[] dividend;
    private int[] divisor;
    private int pinfoNDTDivid;
    private int pinfoNRSDivid;
    private int pinfoNDTItr1;
    private int pinfoNDTItr2;
    private static final char[] alpha = new char[]{'\u0001', '\u0002', '\u0004', '\b', '\u0010', ' ', '@', '\u0080', '\u001d', ':', 't', '\u00e8', '\u00cd', '\u0087', '\u0013', '&', 'L', '\u0098', '-', 'Z', '\u00b4', 'u', '\u00ea', '\u00c9', '\u008f', '\u0003', '\u0006', '\f', '\u0018', '0', '`', '\u00c0', '\u009d', '\'', 'N', '\u009c', '%', 'J', '\u0094', '5', 'j', '\u00d4', '\u00b5', 'w', '\u00ee', '\u00c1', '\u009f', '#', 'F', '\u008c', '\u0005', '\n', '\u0014', '(', 'P', '\u00a0', ']', '\u00ba', 'i', '\u00d2', '\u00b9', 'o', '\u00de', '\u00a1', '_', '\u00be', 'a', '\u00c2', '\u0099', '/', '^', '\u00bc', 'e', '\u00ca', '\u0089', '\u000f', '\u001e', '<', 'x', '\u00f0', '\u00fd', '\u00e7', '\u00d3', '\u00bb', 'k', '\u00d6', '\u00b1', '\u007f', '\u00fe', '\u00e1', '\u00df', '\u00a3', '[', '\u00b6', 'q', '\u00e2', '\u00d9', '\u00af', 'C', '\u0086', '\u0011', '\"', 'D', '\u0088', '\r', '\u001a', '4', 'h', '\u00d0', '\u00bd', 'g', '\u00ce', '\u0081', '\u001f', '>', '|', '\u00f8', '\u00ed', '\u00c7', '\u0093', ';', 'v', '\u00ec', '\u00c5', '\u0097', '3', 'f', '\u00cc', '\u0085', '\u0017', '.', '\\', '\u00b8', 'm', '\u00da', '\u00a9', 'O', '\u009e', '!', 'B', '\u0084', '\u0015', '*', 'T', '\u00a8', 'M', '\u009a', ')', 'R', '\u00a4', 'U', '\u00aa', 'I', '\u0092', '9', 'r', '\u00e4', '\u00d5', '\u00b7', 's', '\u00e6', '\u00d1', '\u00bf', 'c', '\u00c6', '\u0091', '?', '~', '\u00fc', '\u00e5', '\u00d7', '\u00b3', '{', '\u00f6', '\u00f1', '\u00ff', '\u00e3', '\u00db', '\u00ab', 'K', '\u0096', '1', 'b', '\u00c4', '\u0095', '7', 'n', '\u00dc', '\u00a5', 'W', '\u00ae', 'A', '\u0082', '\u0019', '2', 'd', '\u00c8', '\u008d', '\u0007', '\u000e', '\u001c', '8', 'p', '\u00e0', '\u00dd', '\u00a7', 'S', '\u00a6', 'Q', '\u00a2', 'Y', '\u00b2', 'y', '\u00f2', '\u00f9', '\u00ef', '\u00c3', '\u009b', '+', 'V', '\u00ac', 'E', '\u008a', '\t', '\u0012', '$', 'H', '\u0090', '=', 'z', '\u00f4', '\u00f5', '\u00f7', '\u00f3', '\u00fb', '\u00eb', '\u00cb', '\u008b', '\u000b', '\u0016', ',', 'X', '\u00b0', '}', '\u00fa', '\u00e9', '\u00cf', '\u0083', '\u001b', '6', 'l', '\u00d8', '\u00ad', 'G', '\u008e', '\u0001', '\u0000'};
    private static final short[] trans = new short[]{256, 0, 1, 25, 2, 50, 26, 198, 3, 223, 51, 238, 27, 104, 199, 75, 4, 100, 224, 14, 52, 141, 239, 129, 28, 193, 105, 248, 200, 8, 76, 113, 5, 138, 101, 47, 225, 36, 15, 33, 53, 147, 142, 218, 240, 18, 130, 69, 29, 181, 194, 125, 106, 39, 249, 185, 201, 154, 9, 120, 77, 228, 114, 166, 6, 191, 139, 98, 102, 221, 48, 253, 226, 152, 37, 179, 16, 145, 34, 136, 54, 208, 148, 206, 143, 150, 219, 189, 241, 210, 19, 92, 131, 56, 70, 64, 30, 66, 182, 163, 195, 72, 126, 110, 107, 58, 40, 84, 250, 133, 186, 61, 202, 94, 155, 159, 10, 21, 121, 43, 78, 212, 229, 172, 115, 243, 167, 87, 7, 112, 192, 247, 140, 128, 99, 13, 103, 74, 222, 237, 49, 197, 254, 24, 227, 165, 153, 119, 38, 184, 180, 124, 17, 68, 146, 217, 35, 32, 137, 46, 55, 63, 209, 91, 149, 188, 207, 205, 144, 135, 151, 178, 220, 252, 190, 97, 242, 86, 211, 171, 20, 42, 93, 158, 132, 60, 57, 83, 71, 109, 65, 162, 31, 45, 67, 216, 183, 123, 164, 118, 196, 23, 73, 236, 127, 12, 111, 246, 108, 161, 59, 82, 41, 157, 85, 170, 251, 96, 134, 177, 187, 204, 62, 90, 203, 89, 95, 176, 156, 169, 160, 81, 11, 245, 22, 235, 122, 117, 44, 215, 79, 174, 213, 233, 230, 231, 173, 232, 116, 214, 244, 234, 168, 80, 88, 175};
    private static final char[] coef7 = new char[]{'W', '\u00e5', '\u0092', '\u0095', '\u00ee', 'f', '\u0015'};
    private static final char[] coef10 = new char[]{'\u00fb', 'C', '.', '=', 'v', 'F', '@', '^', ' ', '-'};
    private static final char[] coef13 = new char[]{'J', '\u0098', '\u00b0', 'd', 'V', 'd', 'j', 'h', '\u0082', '\u00da', '\u00ce', '\u008c', 'N'};
    private static final char[] coef15 = new char[]{'\b', '\u00b7', '=', '[', '\u00ca', '%', '3', ':', ':', '\u00ed', '\u008c', '|', '\u0005', 'c', 'i'};
    private static final char[] coef16 = new char[]{'x', 'h', 'k', 'm', 'f', '\u00a1', 'L', '\u0003', '[', '\u00bf', '\u0093', '\u00a9', '\u00b6', '\u00c2', '\u00e1', 'x'};
    private static final char[] coef17 = new char[]{'+', '\u008b', '\u00ce', 'N', '+', '\u00ef', '{', '\u00ce', '\u00d6', '\u0093', '\u0018', 'c', '\u0096', '\'', '\u00f3', '\u00a3', '\u0088'};
    private static final char[] coef18 = new char[]{'\u00d7', '\u00ea', '\u009e', '^', '\u00b8', 'a', 'v', '\u00aa', 'O', '\u00bb', '\u0098', '\u0094', '\u00fc', '\u00b3', '\u0005', 'b', '`', '\u0099'};
    private static final char[] coef20 = new char[]{'\u0011', '<', 'O', '2', '=', '\u00a3', '\u001a', '\u00bb', '\u00ca', '\u00b4', '\u00dd', '\u00e1', 'S', '\u00ef', '\u009c', '\u00a4', '\u00d4', '\u00d4', '\u00bc', '\u00be'};
    private static final char[] coef22 = new char[]{'\u00d2', '\u00ab', '\u00f7', '\u00f2', ']', '\u00e6', '\u000e', 'm', '\u00dd', '5', '\u00c8', 'J', '\b', '\u00ac', 'b', 'P', '\u00db', '\u0086', '\u00a0', 'i', '\u00a5', '\u00e7'};
    private static final char[] coef24 = new char[]{'\u00e5', 'y', '\u0087', '0', '\u00d3', 'u', '\u00fb', '~', '\u009f', '\u00b4', '\u00a9', '\u0098', '\u00c0', '\u00e2', '\u00e4', '\u00da', 'o', '\u0000', 'u', '\u00e8', 'W', '`', '\u00e3', '\u0015'};
    private static final char[] coef26 = new char[]{'\u00ad', '}', '\u009e', '\u0002', 'g', '\u00b6', 'v', '\u0011', '\u0091', '\u00c9', 'o', '\u001c', '\u00a5', '5', '\u00a1', '\u0015', '\u00f5', '\u008e', '\r', 'f', '0', '\u00e3', '\u0099', '\u0091', '\u00da', 'F'};
    private static final char[] coef28 = new char[]{'\u00a8', '\u00df', '\u00c8', 'h', '\u00e0', '\u00ea', 'l', '\u00b4', 'n', '\u00be', '\u00c3', '\u0093', '\u00cd', '\u001b', '\u00e8', '\u00c9', '\u0015', '+', '\u00f5', 'W', '*', '\u00c3', '\u00d4', 'w', '\u00f2', '%', '\t', '{'};
    private static final char[] coef30 = new char[]{')', '\u00ad', '\u0091', '\u0098', '\u00d8', '\u001f', '\u00b3', '\u00b6', '2', '0', 'n', 'V', '\u00ef', '`', '\u00de', '}', '*', '\u00ad', '\u00e2', '\u00c1', '\u00e0', '\u0082', '\u009c', '%', '\u00fb', '\u00d8', '\u00ee', '(', '\u00c0', '\u00b4'};
    private static final char[] coef32 = new char[]{'\n', '\u0006', 'j', '\u00be', '\u00f9', '\u00a7', '\u0004', 'C', '\u00d1', '\u008a', '\u008a', ' ', '\u00f2', '{', 'Y', '\u001b', 'x', '\u00b9', 'P', '\u009c', '&', 'E', '\u00ab', '<', '\u001c', '\u00de', 'P', '4', '\u00fe', '\u00b9', '\u00dc', '\u00f1'};
    private static final char[] coef34 = new char[]{'o', 'M', '\u0092', '^', '\u001a', '\u0015', 'l', '\u0013', 'i', '^', 'q', '\u00c1', 'V', '\u008c', '\u00a3', '}', ':', '\u009e', '\u00e5', '\u00ef', '\u00da', 'g', '8', 'F', 'r', '=', '\u00b7', '\u0081', '\u00a7', '\r', 'b', '>', '\u0081', '3'};
    private static final char[] coef36 = new char[]{'\u00c8', '\u00b7', 'b', '\u0010', '\u00ac', '\u001f', '\u00f6', '\u00ea', '<', '\u0098', 's', '\u0000', '\u00a7', '\u0098', 'q', '\u00f8', '\u00ee', 'k', '\u0012', '?', '\u00da', '%', 'W', '\u00d2', 'i', '\u00b1', 'x', 'J', 'y', '\u00c4', 'u', '\u00fb', 'q', '\u00e9', '\u001e', 'x'};
    private static final char[] coef40 = new char[]{';', 't', 'O', '\u00a1', '\u00fc', 'b', '\u0080', '\u00cd', '\u0080', '\u00a1', '\u00f7', '9', '\u00a3', '8', '\u00eb', 'j', '5', '\u001a', '\u00bb', '\u00ae', '\u00e2', 'h', '\u00aa', '\u0007', '\u00af', '#', '\u00b5', 'r', 'X', ')', '/', '\u00a3', '}', '\u0086', 'H', '\u0014', '\u00e8', '5', '#', '\u000f'};
    private static final char[] coef42 = new char[]{'\u00fa', 'g', '\u00dd', '\u00e6', '\u0019', '\u0012', '\u0089', '\u00e7', '\u0000', '\u0003', ':', '\u00f2', '\u00dd', '\u00bf', 'n', 'T', '\u00e6', '\b', '\u00bc', 'j', '`', '\u0093', '\u000f', '\u0083', '\u008b', '\"', 'e', '\u00df', '\'', 'e', '\u00d5', '\u00c7', '\u00ed', '\u00fe', '\u00c9', '{', '\u00ab', '\u00a2', '\u00c2', 'u', '2', '`'};
    private static final char[] coef44 = new char[]{'\u00be', '\u0007', '=', 'y', 'G', '\u00f6', 'E', '7', '\u00a8', '\u00bc', 'Y', '\u00f3', '\u00bf', '\u0019', 'H', '{', '\t', '\u0091', '\u000e', '\u00f7', '\u0001', '\u00ee', ',', 'N', '\u008f', '>', '\u00e0', '~', 'v', 'r', 'D', '\u00a3', '4', '\u00c2', '\u00d9', '\u0093', '\u00cc', '\u00a9', '%', '\u0082', 'q', 'f', 'I', '\u00b5'};
    private static final char[] coef46 = new char[]{'p', '^', 'X', 'p', '\u00fd', '\u00e0', '\u00ca', 's', '\u00bb', 'c', 'Y', '\u0005', '6', 'q', '\u0081', ',', ':', '\u0010', '\u0087', '\u00d8', '\u00a9', '\u00d3', '$', '\u0001', '\u0004', '`', '<', '\u00f1', 'I', 'h', '\u00ea', '\b', '\u00f9', '\u00f5', 'w', '\u00ae', '4', '\u0019', '\u009d', '\u00e0', '+', '\u00ca', '\u00df', '\u0013', 'R', '\u000f'};
    private static final char[] coef48 = new char[]{'\u00e4', '\u0019', '\u00c4', '\u0082', '\u00d3', '\u0092', '<', '\u0018', '\u00fb', 'Z', '\'', 'f', '\u00f0', '=', '\u00b2', '?', '.', '{', 's', '\u0012', '\u00dd', 'o', '\u0087', '\u00a0', '\u00b6', '\u00cd', 'k', '\u00ce', '_', '\u0096', 'x', '\u00b8', '[', '\u0015', '\u00f7', '\u009c', '\u008c', '\u00ee', '\u00bf', '\u000b', '^', '\u00e3', 'T', '2', '\u00a3', '\'', '\"', 'l'};
    private static final char[] coef50 = new char[]{'\u00e8', '}', '\u009d', '\u00a1', '\u00a4', '\t', 'v', '.', '\u00d1', 'c', '\u00cb', '\u00c1', '#', '\u0003', '\u00d1', 'o', '\u00c3', '\u00f2', '\u00cb', '\u00e1', '.', '\r', ' ', '\u00a0', '~', '\u00d1', '\u0082', '\u00a0', '\u00f2', '\u00d7', '\u00f2', 'K', 'M', '*', '\u00bd', ' ', 'q', 'A', '|', 'E', '\u00e4', 'r', '\u00eb', '\u00af', '|', '\u00aa', '\u00d7', '\u00e8', '\u0085', '\u00cd'};
    private static final char[] coef52 = new char[]{'t', '2', 'V', '\u00ba', '2', '\u00dc', '\u00fb', 'Y', '\u00c0', '.', 'V', '\u007f', '|', '\u0013', '\u00b8', '\u00e9', '\u0097', '\u00d7', '\u0016', '\u000e', ';', '\u0091', '%', '\u00f2', '\u00cb', '\u0086', '\u00fe', 'Y', '\u00be', '^', ';', 'A', '|', 'q', 'd', '\u00e9', '\u00eb', 'y', '\u0016', 'L', 'V', 'a', '\'', '\u00f2', '\u00c8', '\u00dc', 'e', '!', '\u00ef', '\u00fe', 't', '3'};
    private static final char[] coef54 = new char[]{'\u00b7', '\u001a', '\u00c9', 'W', '\u00d2', '\u00dd', 'q', '\u0015', '.', 'A', '-', '2', '\u00ee', '\u00b8', '\u00f9', '\u00e1', 'f', ':', '\u00d1', '\u00da', 'm', '\u00a5', '\u001a', '_', '\u00b8', '\u00c0', '4', '\u00f5', '#', '\u00fe', '\u00ee', '\u00af', '\u00ac', 'O', '{', '\u0019', 'z', '+', 'x', 'l', '\u00d7', 'P', '\u0080', '\u00c9', '\u00eb', '\b', '\u0099', ';', 'e', '\u001f', '\u00c6', 'L', '\u001f', '\u009c'};
    private static final char[] coef56 = new char[]{'j', 'x', 'k', '\u009d', '\u00a4', '\u00d8', 'p', 't', '\u0002', '[', '\u00f8', '\u00a3', '$', '\u00c9', '\u00ca', '\u00e5', '\u0006', '\u0090', '\u00fe', '\u009b', '\u0087', '\u00d0', '\u00aa', '\u00d1', '\f', '\u008b', '\u007f', '\u008e', '\u00b6', '\u00f9', '\u00b1', '\u00ae', '\u00be', '\u001c', '\n', 'U', '\u00ef', '\u00b8', 'e', '|', '\u0098', '\u00ce', '`', '\u0017', '\u00a3', '=', '\u001b', '\u00c4', '\u00f7', '\u0097', '\u009a', '\u00ca', '\u00cf', '\u0014', '=', '\n'};
    private static final char[] coef58 = new char[]{'R', 't', '\u001a', '\u00f7', 'B', '\u001b', '>', 'k', '\u00fc', '\u00b6', '\u00c8', '\u00b9', '\u00eb', '7', '\u00fb', '\u00f2', '\u00d2', '\u0090', '\u009a', '\u00ed', '\u00b0', '\u008d', '\u00c0', '\u00f8', '\u0098', '\u00f9', '\u00ce', 'U', '\u00fd', '\u008e', 'A', '\u00a5', '}', '\u0017', '\u0018', '\u001e', 'z', '\u00f0', '\u00d6', '\u0006', '\u0081', '\u00da', '\u001d', '\u0091', '\u007f', '\u0086', '\u00ce', '\u00f5', 'u', '\u001d', ')', '?', '\u009f', '\u008e', '\u00e9', '}', '\u0094', '{'};
    private static final char[] coef60 = new char[]{'k', '\u008c', '\u001a', '\f', '\t', '\u008d', '\u00f3', '\u00c5', '\u00e2', '\u00c5', '\u00db', '-', '\u00d3', 'e', '\u00db', 'x', '\u001c', '\u00b5', '\u007f', '\u0006', 'd', '\u00f7', '\u0002', '\u00cd', '\u00c6', '9', 's', '\u00db', 'e', 'm', '\u00a0', 'R', '%', '&', '\u00ee', '1', '\u00a0', '\u00d1', 'y', 'V', '\u000b', '|', '\u001e', '\u00b5', 'T', '\u0019', '\u00c2', 'W', 'A', 'f', '\u00be', '\u00dc', 'F', '\u001b', '\u00d1', '\u0010', 'Y', '\u0007', '!', '\u00f0'};
    private static final char[] coef62 = new char[]{'A', '\u00ca', 'q', 'b', 'G', '\u00df', '\u00f8', 'v', '\u00d6', '^', '\u0000', 'z', '%', '\u0017', '\u0002', '\u00e4', ':', 'y', '\u0007', 'i', '\u0087', 'N', '\u00f3', 'v', 'F', 'L', '\u00df', 'Y', 'H', '2', 'F', 'o', '\u00c2', '\u0011', '\u00d4', '~', '\u00b5', '#', '\u00dd', 'u', '\u00eb', '\u000b', '\u00e5', '\u0095', '\u0093', '{', '\u00d5', '(', 's', '\u0006', '\u00c8', 'd', '\u001a', '\u00f6', '\u00b6', '\u00da', '\u007f', '\u00d7', '$', '\u00ba', 'n', 'j'};
    private static final char[] coef64 = new char[]{'-', '3', '\u00af', '\t', '\u0007', '\u009e', '\u009f', '1', 'D', 'w', '\\', '{', '\u00b1', '\u00cc', '\u00bb', '\u00fe', '\u00c8', 'N', '\u008d', '\u0095', 'w', '\u001a', '\u007f', '5', '\u00a0', ']', '\u00c7', '\u00d4', '\u001d', '\u0018', '\u0091', '\u009c', '\u00d0', '\u0096', '\u00da', '\u00d1', '\u0004', '\u00d8', '[', '/', '\u00b8', '\u0092', '/', '\u008c', '\u00c3', '\u00c3', '}', '\u00f2', '\u00ee', '?', 'c', 'l', '\u008c', '\u00e6', '\u00f2', '\u001f', '\u00cc', '\u000b', '\u00b2', '\u00f3', '\u00d9', '\u009c', '\u00d5', '\u00e7'};
    private static final char[] coef66 = new char[]{'\u0005', 'v', '\u00de', '\u00b4', '\u0088', '\u0088', '\u00a2', '3', '.', 'u', '\r', '\u00d7', 'Q', '\u0011', '\u008b', '\u00f7', '\u00c5', '\u00ab', '_', '\u00ad', 'A', '\u0089', '\u00b2', 'D', 'o', '_', 'e', ')', 'H', '\u00d6', '\u00a9', '\u00c5', '_', '\u0007', ',', '\u009a', 'M', 'o', '\u00ec', '(', 'y', '\u008f', '?', 'W', 'P', '\u00fd', '\u00f0', '~', '\u00d9', 'M', '\"', '\u00e8', 'j', '2', '\u00a8', 'R', 'L', '\u0092', 'C', 'j', '\u00ab', '\u0019', '\u0084', ']', '-', 'i'};
    private static final char[] coef68 = new char[]{'\u00f7', '\u009f', '\u00df', '!', '\u00e0', ']', 'M', 'F', 'Z', '\u00a0', ' ', '\u00fe', '+', '\u0096', 'T', 'e', '\u00be', '\u00cd', '\u0085', '4', '<', '\u00ca', '\u00a5', '\u00dc', '\u00cb', '\u0097', ']', 'T', '\u000f', 'T', '\u00fd', '\u00ad', '\u00a0', 'Y', '\u00e3', '4', '\u00c7', 'a', '_', '\u00e7', '4', '\u00b1', ')', '}', '\u0089', '\u00f1', '\u00a6', '\u00e1', 'v', '\u0002', '6', ' ', 'R', '\u00d7', '\u00af', '\u00c6', '+', '\u00ee', '\u00eb', '\u001b', 'e', '\u00b8', '\u007f', '\u0003', '\u0005', '\b', '\u00a3', '\u00ee'};
    private static final cftb[] coef_tbl = new cftb[]{new cftb(7, coef7), new cftb(10, coef10), new cftb(13, coef13), new cftb(15, coef15), new cftb(16, coef16), new cftb(17, coef17), new cftb(18, coef18), new cftb(20, coef20), new cftb(22, coef22), new cftb(24, coef24), new cftb(26, coef26), new cftb(28, coef28), new cftb(30, coef30), new cftb(32, coef32), new cftb(34, coef34), new cftb(36, coef36), new cftb(40, coef40), new cftb(42, coef42), new cftb(44, coef44), new cftb(46, coef46), new cftb(48, coef48), new cftb(50, coef50), new cftb(52, coef52), new cftb(54, coef54), new cftb(56, coef56), new cftb(58, coef58), new cftb(60, coef60), new cftb(62, coef62), new cftb(64, coef64), new cftb(66, coef66), new cftb(68, coef68)};
    private static final int POLY = 1335;
    private static final int N = 15;
    private static final int K = 5;
    private static final int PAT_MODEL1 = 10277;
    private static final int PAT_MODEL2 = 21522;
    private static final char[] bitpos = new char[]{'\u0001', '\u0002', '\u0004', '\b', '\u0010', ' ', '@', '\u0080'};
    private static final long[] verInfo = new long[]{7973L, 8559L, 15946L, 17118L, 24059L, 25521L, 31892L, 34236L, 39577L, 42195L, 48118L, 51042L, 55367L, 58893L, 63784L, 68472L, 70749L, 76311L, 79154L, 84390L, 87683L, 92361L, 96236L, 102084L, 102881L, 110507L, 110734L, 117786L, 119615L, 126325L, 127568L, 133589L, 136944L, 141498L, 145311L, 150283L, 152622L, 158308L, 161089L, 167017L};
    private static final int SPAT = 3;
    private static final int BM_RATIO = 10;
    private static final int BM_PROH = 40;
    private static final int BM_LONG1 = 3;
    private static final int BM_BLOCK = 3;
    private static final int BND_LOW_LNG1 = 5;
    private static final int DEF_LONG5 = 12;
    private static final int DEF_LONG7 = 12;
    private static final int DEF_LONG8 = 6;
    private static final int DEF_BLOCK_W = 0;
    private static final int DEF_BLOCK_B = 12;
    private static final int DEF_PROHI = 18;
    private int full_mark;
    private int pat_num;
    private int data_cell;
    private int[] point;
    private char[][] icell;
    private static final char[] m_ptn_d0 = new char[]{'U', '\u00aa'};
    private static final char m_ptn_d1 = '\u00ff';
    private static final char[] m_ptn_d2 = new char[]{'I', '\u0092', '$'};
    private static final char[][] m_ptn_d3 = new char[][]{{'I', '\u0092', '$'}, {'$', 'I', '\u0092'}, {'\u0092', '$', 'I'}};
    private static final char[][] m_ptn_d4 = new char[][]{{'\u00c7', 'q', '\u001c'}, {'\u00c7', 'q', '\u001c'}, {'8', '\u008e', '\u00e3'}, {'8', '\u008e', '\u00e3'}};
    private static final char[][] m_ptn_d5 = new char[][]{{'\u00ff', '\u00ff', '\u00ff'}, {'A', '\u0010', '\u0004'}, {'I', '\u0092', '$'}, {'U', 'U', 'U'}, {'I', '\u0092', '$'}, {'A', '\u0010', '\u0004'}};
    private static final char[][] m_ptn_d6 = new char[][]{{'\u00ff', '\u00ff', '\u00ff'}, {'\u00c7', 'q', '\u001c'}, {'\u00db', '\u00b6', 'm'}, {'U', 'U', 'U'}, {'m', '\u00db', '\u00b6'}, {'q', '\u001c', '\u00c7'}};
    private static final char[][] m_ptn_d7 = new char[][]{{'U', 'U', 'U'}, {'8', '\u008e', '\u00e3'}, {'q', '\u001c', '\u00c7'}, {'\u00aa', '\u00aa', '\u00aa'}, {'\u00c7', 'q', '\u001c'}, {'\u008e', '\u00e3', '8'}};
    private char[][] cell;
    private char[][] mcell;
    private int END_DATA_MODE;
    private qrdata[] tQRmode;
    private qrdata[] qrdp;
    private int qrdpi;
    private static final int[] c_byte = new int[]{1, 1, 1, 2, 0};
    private static final char[] antble = new char[]{'\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'};

    public QRC() {
        for (int j = 0; j < 2000; ++j) {
            this.qdata[j] = new qrdata();
        }
        this.Ccode = new char[3808];
        this.iCcode = new char[3808];
        this.Selmsk = -1;
        this.dividend = new char[254];
        this.divisor = new int[68];
        this.point = new int[8];
        this.icell = new char[181][23];
        this.cell = new char[181][23];
        this.mcell = new char[181][23];
        this.END_DATA_MODE = 4;
        this.tQRmode = new qrdata[4];
        for (int i = 0; i < 4; ++i) {
            this.tQRmode[i] = new qrdata();
            this.tQRmode[i].bmode = (char)4;
        }
        this.qrdpi = 0;
    }

    private void blkcell(int x, int y) {
        char[] cArray = this.cell[y];
        int n = x / 8;
        cArray[n] = (char)(cArray[n] | bitpos[x & 7]);
    }

    private void witcell(int x, int y) {
        char[] cArray = this.cell[y];
        int n = x / 8;
        cArray[n] = (char)(cArray[n] & ~bitpos[x & 7]);
    }

    public int mtstcell(int x, int y) {
        return this.mcell[y][x >> 3] & bitpos[x & 7];
    }

    private void iwitcell(int x, int y) {
        char[] cArray = this.icell[y];
        int n = x >> 3;
        cArray[n] = (char)(cArray[n] & ~bitpos[x & 7]);
    }

    private int itstcell(int x, int y) {
        return this.icell[y][x / 8] & bitpos[x & 7];
    }

    private int getversion12(int blksu, qrdata[] p, int level) {
        char mode;
        int i;
        int pi = 0;
        int nbit = 0;
        int maxVer = 0;
        switch (this.modelNo) {
            case 0: {
                nbit = 0;
                maxVer = 14;
                break;
            }
            case 1: {
                nbit = 4;
                maxVer = 40;
            }
        }
        if (this.Jmode.getValue() != 0) {
            nbit += 20;
        }
        for (i = 0; i < blksu; ++i) {
            mode = p[pi].bmode;
            int length = p[pi].blen;
            switch (mode) {
                case '\u0000': {
                    nbit += length / 3 * 10 + numrem[length % 3];
                    break;
                }
                case '\u0001': {
                    nbit += length / 2 * 11 + length % 2 * 6;
                    break;
                }
                case '\u0002': {
                    nbit += length * 8;
                    break;
                }
                case '\u0003': {
                    nbit += (length + 1) / 2 * 13;
                }
            }
            nbit += nch_indicate[0][mode];
            ++pi;
        }
        if ((nbit += (blksu - 1) * 4) / 8 > vinfo[this.modelNo][8][level + 1]) {
            pi -= blksu;
            for (i = 0; i < blksu; ++i) {
                mode = p[pi++].bmode;
                nbit += nch_indicate[1][mode] - nch_indicate[0][mode];
            }
            if (nbit / 8 > vinfo[this.modelNo][25][level + 1]) {
                pi -= blksu;
                for (i = 0; i < blksu; ++i) {
                    mode = p[pi++].bmode;
                    nbit += nch_indicate[2][mode] - nch_indicate[1][mode];
                }
            }
        }
        int nch = (nbit + 7) / 8;
        for (i = 0; i < maxVer && nch > vinfo[this.modelNo][i][level + 1]; ++i) {
        }
        if (i >= maxVer || nch > vinfo[this.modelNo][maxVer - 1][level + 1]) {
            return -1;
        }
        return i;
    }

    private int getModeBitLen(int ver) {
        int j = 0;
        switch (this.modelNo) {
            case 0: 
            case 1: {
                j = 4;
            }
        }
        return j;
    }

    private int getModeBitData(int mode) {
        int j = 0;
        int[] Model12_Mode = new int[]{1, 2, 4, 8};
        switch (this.modelNo) {
            case 0: 
            case 1: {
                j = Model12_Mode[mode];
            }
        }
        return j;
    }

    private int getNumcharBitLen(int ver, int mode) {
        int c3 = 0;
        switch (this.modelNo) {
            case 0: 
            case 1: {
                c3 = ver <= 8 ? nch_indicate[0][mode] : (ver <= 25 ? nch_indicate[1][mode] : nch_indicate[2][mode]);
            }
        }
        return c3;
    }

    private int convnum(char[] sdata, char[] bdata, int bdatai, IntegerHolder pos, int ver, int slen, int sdatai) {
        int c4;
        int len = 0;
        long i = bdata[bdatai];
        int j = this.getModeBitLen(ver);
        if (pos.getValue() < j) {
            i = i << j - pos.getValue() | (long)this.getModeBitData(0);
            c4 = 8 + (j - pos.getValue());
        } else {
            i = i >> pos.getValue() - j | (long)this.getModeBitData(0);
            c4 = 8 - (pos.getValue() - j);
        }
        int c3 = this.getNumcharBitLen(ver, 0);
        i = i << c3 | (long)slen;
        c3 += c4;
        while (c3 >= 8) {
            bdata[bdatai++] = (char)(i >> (c3 -= 8));
            ++len;
            i &= (long)(~(-1 << c3));
        }
        for (j = 0; j < slen / 3; ++j) {
            i = (i << 10) + (long)((sdata[sdatai] - 48) * 100 + (sdata[sdatai + 1] - 48) * 10 + sdata[sdatai + 2] - 48);
            sdatai += 3;
            c3 += 10;
            while (c3 >= 8) {
                bdata[bdatai++] = (char)(i >> (c3 -= 8));
                ++len;
                i &= (long)(~(-1 << c3));
            }
        }
        if (slen % 3 != 0) {
            if (slen % 3 == 2) {
                i = (i << 7) + (long)((sdata[sdatai] - 48) * 10 + (sdata[sdatai + 1] - 48));
                c3 += 7;
            } else {
                i = (i << 4) + (long)(sdata[sdatai] - 48);
                c3 += 4;
            }
        }
        while (c3 >= 8) {
            bdata[bdatai++] = (char)(i >> (c3 -= 8));
            ++len;
            i &= (long)(~(-1 << c3));
        }
        if (c3 != 0) {
            bdata[bdatai++] = (char)(i << 8 - c3);
        }
        pos.setValue(8 - c3);
        return len;
    }

    private int convalnum(char[] sdata, char[] bdata, int bdatai, IntegerHolder pos, int ver, int slen, int sdatai) {
        int c4;
        int len = 0;
        long i = bdata[bdatai];
        int j = this.getModeBitLen(ver);
        if (pos.getValue() < j) {
            i = i << j - pos.getValue() | (long)this.getModeBitData(1);
            c4 = 8 + (j - pos.getValue());
        } else {
            i = i >> pos.getValue() - j | (long)this.getModeBitData(1);
            c4 = 8 - (pos.getValue() - j);
        }
        int c3 = this.getNumcharBitLen(ver, 1);
        i = i << c3 | (long)slen;
        c3 += c4;
        while (c3 >= 8) {
            bdata[bdatai++] = (char)(i >> (c3 -= 8));
            ++len;
            i &= (long)(~(-1 << c3));
        }
        for (j = 0; j < slen / 2; ++j) {
            char c1 = bcwtbl[Character.toUpperCase(sdata[sdatai]) - 32];
            char c2 = sdata[sdatai + 1];
            if (c2 != '\u0000') {
                c2 = bcwtbl[Character.toUpperCase((int)c2) - 32];
            }
            i = (i << 11) + (long)(c1 * 45 + c2);
            sdatai += 2;
            c3 += 11;
            while (c3 >= 8) {
                bdata[bdatai++] = (char)(i >> (c3 -= 8));
                ++len;
                i &= (long)(~(-1 << c3));
            }
        }
        if (slen % 2 != 0) {
            i = i << 6 | (long)bcwtbl[Character.toUpperCase(sdata[sdatai]) - 32];
            c3 += 6;
        }
        while (c3 >= 8) {
            bdata[bdatai++] = (char)(i >> (c3 -= 8));
            ++len;
            i &= (long)(~(-1 << c3));
        }
        if (c3 != 0) {
            bdata[bdatai++] = (char)(i << 8 - c3);
        }
        pos.setValue(8 - c3);
        return len;
    }

    private int convbin(char[] sdata, char[] bdata, int bdatai, IntegerHolder pos, int ver, int slen, int sdatai) {
        int c4;
        int len = 0;
        long i = bdata[bdatai];
        int j = this.getModeBitLen(ver);
        if (pos.getValue() < j) {
            i = i << j - pos.getValue() | (long)this.getModeBitData(2);
            c4 = 8 + (j - pos.getValue());
        } else {
            i = i >> pos.getValue() - j | (long)this.getModeBitData(2);
            c4 = 8 - (pos.getValue() - j);
        }
        int c3 = this.getNumcharBitLen(ver, 2);
        i = i << c3 | (long)slen;
        c3 += c4;
        while (c3 >= 8) {
            bdata[bdatai++] = (char)(i >> (c3 -= 8));
            ++len;
            i &= (long)(~(-1 << c3));
        }
        for (j = 0; j < slen; ++j) {
            i = (i << 8) + (long)sdata[sdatai];
            ++sdatai;
            c3 += 8;
            while (c3 >= 8) {
                bdata[bdatai++] = (char)(i >> (c3 -= 8));
                ++len;
                i &= (long)(~(-1 << c3));
            }
        }
        while (c3 >= 8) {
            bdata[bdatai++] = (char)(i >> (c3 -= 8));
            ++len;
            i &= (long)(~(-1 << c3));
        }
        if (c3 != 0) {
            bdata[bdatai++] = (char)(i << 8 - c3);
        }
        pos.setValue(8 - c3);
        return len;
    }

    private int convknj(char[] sdata, char[] bdata, int bdatai, IntegerHolder pos, int ver, int slen, int sdatai) {
        int c4;
        int len = 0;
        long i = bdata[bdatai];
        int j = this.getModeBitLen(ver);
        if (pos.getValue() < j) {
            i = i << j - pos.getValue() | (long)this.getModeBitData(3);
            c4 = 8 + (j - pos.getValue());
        } else {
            i = i >> pos.getValue() - j | (long)this.getModeBitData(3);
            c4 = 8 - (pos.getValue() - j);
        }
        int c3 = this.getNumcharBitLen(ver, 3);
        i = i << c3 | (long)slen;
        c3 += c4;
        while (c3 >= 8) {
            bdata[bdatai++] = (char)(i >> (c3 -= 8));
            ++len;
            i &= (long)(~(-1 << c3));
        }
        for (j = 0; j < slen; ++j) {
            int c1 = sdata[sdatai];
            c1 = c1 < 160 ? (c1 -= 129) : (c1 -= 193);
            i = (i << 13) + (long)(c1 * 192) + (long)sdata[sdatai + 1] - 64L;
            sdatai += 2;
            c3 += 13;
            while (c3 >= 8) {
                bdata[bdatai++] = (char)(i >> (c3 -= 8));
                ++len;
                i &= (long)(~(-1 << c3));
            }
        }
        if (c3 != 0) {
            bdata[bdatai++] = (char)(i << 8 - c3);
        }
        pos.setValue(8 - c3);
        return len;
    }

    private int conv2bin(int c, qrdata[] pqr, char[] bdata, int ver) {
        int pqri = 0;
        int len = 0;
        IntegerHolder pos = new IntegerHolder(0);
        switch (this.modelNo) {
            case 0: {
                if (this.Jmode.getValue() != 0) {
                    bdata[0] = 3;
                    bdata[1] = (char)this.joint_data.getValue();
                    bdata[2] = (char)this.parity.getValue();
                    pos.setValue(8);
                    len = 3;
                    break;
                }
                bdata[0] = '\u0000';
                pos.setValue(4);
                len = 0;
                break;
            }
            case 1: {
                if (this.Jmode.getValue() != 0) {
                    bdata[0] = (char)(48 + (this.joint_data.getValue() >> 4));
                    bdata[1] = (char)((this.joint_data.getValue() << 4 & 0xF0) + (this.parity.getValue() >> 4));
                    bdata[2] = (char)(this.parity.getValue() << 4 & 0xF0);
                    pos.setValue(4);
                    len = 2;
                    break;
                }
                pos.setValue(8);
                len = 0;
            }
        }
        for (int i = 0; i < c; ++i) {
            char mode = pqr[pqri].bmode;
            int slen = pqr[pqri].blen;
            char[] sdata = pqr[pqri].fdatap;
            int sdatai = pqr[pqri].fdatapi;
            switch (mode) {
                case '\u0000': {
                    len += this.convnum(sdata, bdata, len, pos, ver, slen, sdatai);
                    break;
                }
                case '\u0001': {
                    len += this.convalnum(sdata, bdata, len, pos, ver, slen, sdatai);
                    break;
                }
                case '\u0002': {
                    len += this.convbin(sdata, bdata, len, pos, ver, slen, sdatai);
                    break;
                }
                case '\u0003': {
                    len += this.convknj(sdata, bdata, len, pos, ver, slen / 2, sdatai);
                }
            }
            ++pqri;
        }
        switch (this.modelNo) {
            case 0: 
            case 1: {
                if (pos.getValue() < 4) {
                    bdata[++len] = '\u0000';
                } else if (pos.getValue() == 8) {
                    bdata[len] = '\u0000';
                }
                ++len;
            }
        }
        return len;
    }

    public int qrcode(qrdata[] pqr, int cVerFlag) {
        int i;
        int ucpi = 0;
        char[] ucp = this.Ccode;
        for (i = 0; i < 3808; ++i) {
            ucp[ucpi++] = '\u0000';
        }
        switch (this.modelNo) {
            case 0: 
            case 1: {
                if (this.Cver < 0) {
                    this.Cver = this.getversion12(this.Blksu, pqr, this.Clvl);
                }
                if (cVerFlag != 0) {
                    this.Cver = cVerFlag > this.Cver ? cVerFlag - 1 : -1;
                }
                this.Csize = (this.Cver + 1) * 4 + 17;
            }
        }
        if (this.Cver >= 0 && this.Cver < 40) {
            this.vinfoTOTAL = vinfo[this.modelNo][this.Cver][0];
            this.vinfoNDATA = vinfo[this.modelNo][this.Cver][this.Clvl + 1];
            this.vinfoDIVID = vinfo[this.modelNo][this.Cver][this.Clvl + 5];
            this.Clen = this.conv2bin(this.Blksu, pqr, this.Ccode, this.Cver);
            this.CodeWordLen = this.vinfoTOTAL;
            i = 8;
            while (this.Clen < this.vinfoNDATA + 1) {
                this.Ccode[this.Clen++] = (char)(60433 >> i & 0xFF);
                if (i > 0) {
                    i = 0;
                    continue;
                }
                i = 8;
            }
            this.add_correction_code();
            this.set_pattern();
            this.estimate_pattern(this.Selmsk);
        } else {
            this.Csize = 0;
        }
        return this.Csize;
    }

    private void add_correction_code() {
        int ucpi = 0;
        int udpi = 0;
        int idpi = 0;
        switch (this.modelNo) {
            case 0: {
                int j;
                int k;
                int i;
                int div = this.vinfoDIVID;
                int trslen = this.vinfoTOTAL - this.vinfoNDATA - 1;
                int rsofst = this.vinfoNDATA + 1;
                int tinfo = rsofst / div;
                trslen /= div;
                for (i = 0; i < 31 && trslen != coef_tbl[i].nmenb; ++i) {
                }
                if (i == 31) {
                    throw new RuntimeException("error: COEF not founded !!\n");
                }
                char[] ucp = coef_tbl[i].tbladr;
                int[] idp = this.divisor;
                idpi = 0;
                for (i = 0; i < trslen; ++i) {
                    idp[idpi++] = ucp[ucpi++];
                }
                for (k = 0; k < div; ++k) {
                    ucp = this.Ccode;
                    ucpi = tinfo * k;
                    char[] udp = this.dividend;
                    udpi = 0;
                    for (i = 0; i < tinfo; ++i) {
                        udp[udpi++] = ucp[ucpi++];
                    }
                    while (i <= tinfo + trslen) {
                        udp[udpi++] = '\u0000';
                        ++i;
                    }
                    for (i = 0; i < tinfo; ++i) {
                        short m_num = trans[this.dividend[i]];
                        if (m_num == 256) continue;
                        for (j = 0; j < trslen; ++j) {
                            int arg;
                            if (this.divisor[j] == 256) {
                                arg = 256;
                            } else {
                                arg = this.divisor[j] + m_num;
                                arg %= 255;
                            }
                            int n = i + j + 1;
                            this.dividend[n] = (char)(this.dividend[n] ^ alpha[arg]);
                        }
                    }
                    ucp = this.dividend;
                    ucpi = tinfo;
                    udp = this.Ccode;
                    udpi = trslen * k + rsofst;
                    for (i = 0; i < trslen; ++i) {
                        udp[udpi++] = (char)(ucp[ucpi++] & 0xFF);
                    }
                }
                k = (this.vinfoTOTAL - this.vinfoNDATA - 1) / div;
                k = k * div + this.vinfoNDATA + 1;
                int DPATTERN = 60433;
                j = 8;
                for (i = k; i < this.vinfoTOTAL; ++i) {
                    this.Ccode[i] = (char)(DPATTERN >> j & 0xFF);
                    j = j > 0 ? 0 : 8;
                }
                break;
            }
            case 1: {
                int i;
                int div = this.vinfoDIVID;
                int trslen = this.vinfoTOTAL - this.vinfoNDATA;
                int rsofst = this.vinfoNDATA;
                this.pinfoNRSDivid = trslen /= div;
                this.pinfoNDTDivid = this.vinfoNDATA / div;
                this.pinfoNDTItr2 = this.vinfoNDATA - this.pinfoNDTDivid * div;
                this.pinfoNDTItr1 = div - this.pinfoNDTItr2;
                for (i = 0; i < 31 && trslen != coef_tbl[i].nmenb; ++i) {
                }
                if (i == 31) {
                    throw new RuntimeException("error: COEF not founded !!\n");
                }
                char[] ucp = coef_tbl[i].tbladr;
                int[] idp = this.divisor;
                idpi = 0;
                for (i = 0; i < trslen; ++i) {
                    idp[idpi++] = ucp[ucpi++];
                }
                for (int k = 0; k < div; ++k) {
                    int tinfo;
                    if (k < this.pinfoNDTItr1) {
                        tinfo = this.pinfoNDTDivid;
                        ucp = this.Ccode;
                        ucpi = tinfo * k;
                    } else {
                        tinfo = this.pinfoNDTDivid + 1;
                        ucp = this.Ccode;
                        ucpi = tinfo * k - this.pinfoNDTItr1;
                    }
                    char[] udp = this.dividend;
                    udpi = 0;
                    for (i = 0; i < tinfo; ++i) {
                        udp[udpi++] = ucp[ucpi++];
                    }
                    while (i < tinfo + trslen) {
                        udp[udpi++] = '\u0000';
                        ++i;
                    }
                    for (i = 0; i < tinfo; ++i) {
                        short m_num = trans[this.dividend[i]];
                        if (m_num == 256) continue;
                        for (int j = 0; j < trslen; ++j) {
                            int arg;
                            if (this.divisor[j] == 256) {
                                arg = 256;
                            } else {
                                arg = this.divisor[j] + m_num;
                                arg %= 255;
                            }
                            int n = i + j + 1;
                            this.dividend[n] = (char)(this.dividend[n] ^ alpha[arg]);
                        }
                    }
                    ucp = this.dividend;
                    ucpi = tinfo;
                    udp = this.Ccode;
                    udpi = trslen * k + rsofst;
                    for (i = 0; i < trslen; ++i) {
                        udp[udpi++] = (char)(ucp[ucpi++] & 0xFF);
                    }
                }
                break;
            }
        }
    }

    private void k1mark(int xx, int yy) {
        int i = 0;
        int x = xx;
        while (i < 7) {
            this.blkcell(x, yy);
            ++i;
            ++x;
        }
        i = 0;
        x = xx;
        int y = yy + 6;
        while (i < 7) {
            this.blkcell(x, y);
            ++i;
            ++x;
        }
        i = 0;
        y = yy + 1;
        while (i < 6) {
            this.blkcell(xx, y);
            ++i;
            ++y;
        }
        i = 0;
        x = xx + 6;
        y = yy + 1;
        while (i < 6) {
            this.blkcell(x, y);
            ++i;
            ++y;
        }
        i = 0;
        x = xx + 2;
        y = yy + 2;
        while (i < 3) {
            this.blkcell(x, y);
            this.blkcell(x, y + 1);
            this.blkcell(x, y + 2);
            ++i;
            ++x;
        }
    }

    private void k3mark() {
        int i;
        int n = this.Csize;
        this.k1mark(0, 0);
        this.k1mark(0, n - 7);
        this.k1mark(n - 7, 0);
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.iwitcell(i, j);
                this.iwitcell(i, n - j - 1);
                this.iwitcell(n - i - 1, j);
            }
        }
        for (i = 8; i <= n - 8; i += 2) {
            this.blkcell(i, 6);
            this.blkcell(6, i);
        }
        for (i = 8; i < n - 8; ++i) {
            this.iwitcell(i, 6);
            this.iwitcell(6, i);
        }
        for (i = 0; i < 8; ++i) {
            this.iwitcell(i, 8);
            this.iwitcell(8, i);
            this.iwitcell(8, n - 1 - i);
            this.iwitcell(n - 1 - i, 8);
        }
        this.blkcell(8, n - 8);
        this.iwitcell(8, 8);
    }

    private void alpmark(int i, int k) {
        int x;
        int y;
        for (y = i - 4; y <= i; ++y) {
            this.blkcell(k, y);
            this.blkcell(k - 4, y);
        }
        for (x = k - 3; x < k; ++x) {
            this.blkcell(x, i);
            this.blkcell(x, i - 4);
        }
        this.blkcell(i - 2, k - 2);
        for (x = i - 4; x <= i; ++x) {
            for (y = k - 4; y <= k; ++y) {
                this.iwitcell(x, y);
            }
        }
    }

    private void clrcell() {
        char[] r_bit = new char[]{'\u0000', '\u0001', '\u0003', '\u0007', '\u000f', '\u001f', '?', '\u007f'};
        int n = this.Csize / 8;
        for (int i = 0; i < this.Csize; ++i) {
            int j;
            for (j = 0; j < (this.Csize + 7) / 8; ++j) {
                this.cell[i][j] = '\u0000';
            }
            for (j = 0; j < n; ++j) {
                this.icell[i][j] = 255;
            }
            this.icell[i][j] = r_bit[this.Csize & 7];
        }
    }

    private void make_inst() {
        int n = this.Csize;
        switch (this.modelNo) {
            case 0: {
                this.k3mark();
                this.blkcell(n - 1, n - 1);
                this.iwitcell(n - 1, n - 1);
                this.iwitcell(n - 1, n - 2);
                this.iwitcell(n - 2, n - 1);
                this.iwitcell(n - 2, n - 2);
                for (int i = n - 9; i > 12; i -= 8) {
                    for (int j = 0; j < 4; ++j) {
                        this.iwitcell(n - 1, i - j);
                        this.iwitcell(n - 2, i - j);
                        this.iwitcell(i - j, n - 1);
                        this.iwitcell(i - j, n - 2);
                    }
                }
                break;
            }
            case 1: {
                int j;
                this.k3mark();
                if (this.Cver < 1) break;
                int i = (n - 14) / 28 + 1;
                int m = (((n - i - 13) * 2 / i + 1) / 4 + 1) * 2;
                for (j = n - 7; j >= 12; j -= m) {
                    for (i = n - 7; i >= 12; i -= m) {
                        if (j == 5 || i == 5) continue;
                        this.alpmark(i + 2, j + 2);
                    }
                }
                for (j = n - 7 - m; j >= 7 + m / 2; j -= m) {
                    this.alpmark(8, j + 2);
                    this.alpmark(j + 2, 8);
                }
                if (this.Cver < 6) break;
                long vinfo = verInfo[this.Cver];
                for (j = 0; j < 6; ++j) {
                    for (i = n - 11; i < n - 8; ++i) {
                        this.iwitcell(i, j);
                        this.iwitcell(j, i);
                        if ((vinfo & 1L) != 0L) {
                            this.blkcell(i, j);
                            this.blkcell(j, i);
                        }
                        vinfo >>= 1;
                    }
                }
                break;
            }
        }
    }

    private void add_mask(int p_num) {
        int i;
        int r;
        int ham = 0;
        int[] lvlno = new int[]{1, 0, 3, 2};
        int[] PAT_pattern = new int[]{10277, 21522};
        int[] non_mask = new int[]{0, 0, 0, 0};
        if (p_num < 8) {
            switch (this.modelNo) {
                case 0: 
                case 1: {
                    ham = lvlno[this.Clvl] << 3 | p_num;
                }
            }
            r = ham << 5;
            for (i = 0; i < 5; ++i) {
                if ((r & 0x200) != 0) {
                    r = r << 1 ^ 0x537;
                    continue;
                }
                r <<= 1;
            }
            ham = ham << 10 ^ r;
            ham ^= PAT_pattern[this.modelNo];
        } else {
            ham = non_mask[this.Clvl];
        }
        switch (this.modelNo) {
            case 0: 
            case 1: {
                r = 1;
                for (i = 0; i < 9; ++i) {
                    if (i == 6) continue;
                    if ((ham & r) != 0) {
                        this.blkcell(8, i);
                    } else {
                        this.witcell(8, i);
                    }
                    r <<= 1;
                }
                for (i = 0; i < 8; ++i) {
                    if (i == 1) continue;
                    if ((ham & r) != 0) {
                        this.blkcell(7 - i, 8);
                    } else {
                        this.witcell(7 - i, 8);
                    }
                    r <<= 1;
                }
                r = 1;
                for (i = 0; i < 8; ++i) {
                    if ((ham & r) != 0) {
                        this.blkcell(this.Csize - i - 1, 8);
                    } else {
                        this.witcell(this.Csize - i - 1, 8);
                    }
                    r <<= 1;
                }
                for (i = 0; i < 7; ++i) {
                    if ((ham & r) != 0) {
                        this.blkcell(8, this.Csize - 7 + i);
                    } else {
                        this.witcell(8, this.Csize - 7 + i);
                    }
                    r <<= 1;
                }
                break;
            }
        }
    }

    private void set_Vptn(char c, int x, int y) {
        for (int i = 0; i < 8; ++i) {
            if ((c & 0x80) != 0) {
                this.blkcell(x - i % 2, y - i / 2);
            }
            c = (char)(c << 1);
        }
    }

    private void set_Hptn(char c, int x, int y) {
        for (int i = 0; i < 8; ++i) {
            if ((c & 0x80) != 0) {
                this.blkcell(x - i % 4, y - i / 4);
            }
            c = (char)(c << 1);
        }
    }

    private void interLeave() {
        int j;
        char[] usp;
        int i;
        int udpi = 0;
        int uspi = 0;
        char[] udp = this.iCcode;
        for (i = 0; i < this.pinfoNDTDivid; ++i) {
            usp = this.Ccode;
            uspi = i;
            for (j = 0; j < this.vinfoDIVID; ++j) {
                udp[udpi++] = usp[uspi];
                uspi += this.pinfoNDTDivid + (j < this.pinfoNDTItr1 ? 0 : 1);
            }
        }
        usp = this.Ccode;
        uspi = this.pinfoNDTDivid * (this.pinfoNDTItr1 + 1);
        for (j = 0; j < this.pinfoNDTItr2; ++j) {
            udp[udpi++] = usp[uspi];
            uspi += this.pinfoNDTDivid + 1;
        }
        for (i = 0; i < this.pinfoNRSDivid; ++i) {
            usp = this.Ccode;
            uspi = i + this.vinfoNDATA;
            for (j = 0; j < this.vinfoDIVID; ++j) {
                udp[udpi++] = usp[uspi];
                uspi += this.pinfoNRSDivid;
            }
        }
    }

    private void set_pattern() {
        this.clrcell();
        this.make_inst();
        switch (this.modelNo) {
            case 0: {
                int y;
                int i = 0;
                int x = this.Csize - 1;
                for (y = this.Csize - 1; y > 8; y -= 4) {
                    if (y != this.Csize - 1 && y > 12 && ((this.Csize - 1 - y) / 4 & 1) == 0) {
                        this.set_Vptn('\u00aa', x, y);
                        continue;
                    }
                    this.set_Vptn(this.Ccode[i++], x, y);
                }
                x -= 2;
                for (y = this.Csize - 1; y > 8; y -= 4) {
                    this.set_Vptn(this.Ccode[i++], x, y);
                }
                x -= 2;
                for (y = this.Csize - 1; y > 8; y -= 2) {
                    this.set_Hptn(this.Ccode[i++], x, y);
                }
                x -= 4;
                while (x > 8) {
                    if (x > 12 && ((this.Csize - 1 - x) / 4 & 1) == 0) {
                        this.set_Hptn('\u00f0', x, this.Csize - 1);
                    } else {
                        this.set_Hptn(this.Ccode[i++], x, this.Csize - 1);
                    }
                    for (y = this.Csize - 3; y > 0; y -= 2) {
                        if (y == 6) {
                            --y;
                        }
                        this.set_Hptn(this.Ccode[i++], x, y);
                    }
                    x -= 4;
                }
                while (x > 0) {
                    if (x == 6) {
                        --x;
                    }
                    for (y = this.Csize - 9; y > 8; y -= 4) {
                        this.set_Vptn(this.Ccode[i++], x, y);
                    }
                    x -= 2;
                }
                break;
            }
            case 1: {
                this.interLeave();
                int x = this.Csize - 1;
                int y = this.Csize - 1;
                int sx = -1;
                int sy = -1;
                for (int j = 0; j < this.CodeWordLen; ++j) {
                    int n = this.iCcode[j];
                    for (int i = 0; i < 8; ++i) {
                        if ((n & 0x80) != 0) {
                            this.blkcell(x, y);
                        }
                        n <<= 1;
                        do {
                            x += sx;
                            if (sx < 0) {
                                if (x < 0) {
                                    return;
                                }
                                sx = 1;
                                continue;
                            }
                            if ((y += sy) < 0) {
                                y = 0;
                                if ((x -= 2) == 6) {
                                    x = 5;
                                }
                                sy = 1;
                            } else if (y >= this.Csize) {
                                y = this.Csize - 1;
                                x -= 2;
                                sy = -1;
                            }
                            sx = -1;
                        } while (this.itstcell(x, y) == 0);
                    }
                }
                break;
            }
        }
    }

    private void mkmask_pattern(int ptn) {
        int j;
        int i;
        int n = (this.Csize + 7) / 8;
        for (i = 0; i < this.Csize; ++i) {
            for (j = 0; j < n; ++j) {
                this.mcell[i][j] = '\u0000';
            }
        }
        switch (ptn) {
            case 0: {
                for (i = 0; i < this.Csize; ++i) {
                    for (j = 0; j < n; ++j) {
                        this.mcell[i][j] = (char)(m_ptn_d0[i & 1] & this.icell[i][j]);
                    }
                }
                break;
            }
            case 1: {
                for (i = 0; i < this.Csize; i += 2) {
                    for (j = 0; j < n; ++j) {
                        this.mcell[i][j] = (char)(0xFF & this.icell[i][j]);
                    }
                }
                break;
            }
            case 2: {
                for (i = 0; i < this.Csize; ++i) {
                    for (j = 0; j < n; ++j) {
                        this.mcell[i][j] = (char)(m_ptn_d2[j % 3] & this.icell[i][j]);
                    }
                }
                break;
            }
            case 3: {
                for (i = 0; i < this.Csize; ++i) {
                    for (j = 0; j < n; ++j) {
                        this.mcell[i][j] = (char)(m_ptn_d3[i % 3][j % 3] & this.icell[i][j]);
                    }
                }
                break;
            }
            case 4: {
                for (i = 0; i < this.Csize; ++i) {
                    for (j = 0; j < n; ++j) {
                        this.mcell[i][j] = (char)(m_ptn_d4[i & 3][j % 3] & this.icell[i][j]);
                    }
                }
                break;
            }
            case 5: {
                for (i = 0; i < this.Csize; ++i) {
                    for (j = 0; j < n; ++j) {
                        this.mcell[i][j] = (char)(m_ptn_d5[i % 6][j % 3] & this.icell[i][j]);
                    }
                }
                break;
            }
            case 6: {
                for (i = 0; i < this.Csize; ++i) {
                    for (j = 0; j < n; ++j) {
                        this.mcell[i][j] = (char)(m_ptn_d6[i % 6][j % 3] & this.icell[i][j]);
                    }
                }
                break;
            }
            case 7: {
                for (i = 0; i < this.Csize; ++i) {
                    for (j = 0; j < n; ++j) {
                        this.mcell[i][j] = (char)(m_ptn_d7[i % 6][j % 3] & this.icell[i][j]);
                    }
                }
                break;
            }
        }
    }

    private void make_pattern(int ptn, int maskNo) {
        this.add_mask(maskNo);
        this.mkmask_pattern(ptn);
        int ss = (this.Csize + 7) / 8;
        for (int i = 0; i < this.Csize; ++i) {
            for (int j = 0; j < ss; ++j) {
                char[] cArray = this.mcell[i];
                int n = j;
                cArray[n] = (char)(cArray[n] ^ this.cell[i][j]);
            }
        }
    }

    private int check_block() {
        class Pdata {
            Lpdata bytel;
            int word;

            Pdata() {
                class Lpdata {
                    char l;
                    char h;

                    Lpdata() {
                    }
                }
                this.bytel = new Lpdata();
            }
        }
        Pdata d1 = new Pdata();
        Pdata d2 = new Pdata();
        char[] s_bit = new char[]{'\u0003', '\u0006', '\f', '\u0018', '0', '`', '\u00c0'};
        int n = (this.Csize - 1) / 8;
        int m = this.Csize - 1 & 7;
        int sum = 0;
        for (int i = 0; i < this.Csize - 1; ++i) {
            int j;
            for (j = 0; j < n; ++j) {
                d1.bytel.h = (char)(this.mcell[i][j + 1] & this.mcell[i + 1][j + 1]);
                d2.bytel.h = (char)(this.mcell[i][j + 1] | this.mcell[i + 1][j + 1]);
                d1.bytel.l = (char)(this.mcell[i][j] & this.mcell[i + 1][j]);
                d2.bytel.l = (char)(this.mcell[i][j] | this.mcell[i + 1][j]);
                d1.word = d1.bytel.h * 256 + d1.bytel.l;
                d2.word = d2.bytel.h * 256 + d2.bytel.l;
                if ((d1.word & 3) == 3 || (d2.word & 3) == 0) {
                    ++sum;
                }
                if ((d1.word & 6) == 6 || (d2.word & 6) == 0) {
                    ++sum;
                }
                if ((d1.word & 0xC) == 12 || (d2.word & 0xC) == 0) {
                    ++sum;
                }
                if ((d1.word & 0x18) == 24 || (d2.word & 0x18) == 0) {
                    ++sum;
                }
                if ((d1.word & 0x30) == 48 || (d2.word & 0x30) == 0) {
                    ++sum;
                }
                if ((d1.word & 0x60) == 96 || (d2.word & 0x60) == 0) {
                    ++sum;
                }
                if ((d1.word & 0xC0) == 192 || (d2.word & 0xC0) == 0) {
                    ++sum;
                }
                if ((d1.word & 0x180) != 384 && (d2.word & 0x180) != 0) continue;
                ++sum;
            }
            for (j = 0; j < m; ++j) {
                if ((d1.bytel.h & s_bit[j]) != s_bit[j] && (d2.bytel.h | ~s_bit[j]) != ~s_bit[j]) continue;
                ++sum;
            }
        }
        return sum;
    }

    private void estimate_pattern(int sel) {
        int[][] max = new int[][]{{0, Short.MIN_VALUE}, {0, Short.MIN_VALUE}, {0, Short.MIN_VALUE}};
        switch (this.modelNo) {
            case 0: 
            case 1: {
                if (sel < 0) {
                    int i;
                    this.data_cell = this.Csize * this.Csize;
                    int maxpoint = Short.MIN_VALUE;
                    this.full_mark = 20888;
                    for (i = 0; i < 8; ++i) {
                        this.make_pattern(i, i);
                        this.point[i] = this.full_mark - this.check_block() * 3;
                        if (max[0][1] < this.point[i]) {
                            max[2][0] = max[1][0];
                            max[2][1] = max[1][1];
                            max[1][0] = max[0][0];
                            max[1][1] = max[0][1];
                            max[0][0] = i;
                            max[0][1] = this.point[i];
                            continue;
                        }
                        if (max[1][1] < this.point[i]) {
                            max[2][0] = max[1][0];
                            max[2][1] = max[1][1];
                            max[1][0] = i;
                            max[1][1] = this.point[i];
                            continue;
                        }
                        if (max[2][1] >= this.point[i]) continue;
                        max[2][0] = i;
                        max[2][1] = this.point[i];
                    }
                    for (i = 0; i < 3; ++i) {
                        this.make_pattern(max[i][0], max[i][0]);
                        int[] nArray = max[i];
                        nArray[1] = nArray[1] - this.check_pattern(max[i][0]);
                    }
                    for (i = 0; i < 3; ++i) {
                        if (maxpoint >= max[i][1]) continue;
                        maxpoint = max[i][1];
                        this.pat_num = max[i][0];
                    }
                    this.make_pattern(this.pat_num, this.pat_num);
                    break;
                }
                this.make_pattern(sel, sel);
            }
        }
    }

    private int check_pattern(int n) {
        int j;
        int fl;
        int k;
        int cell_no_change;
        int i;
        int[] num_long = new int[182];
        char[] buff = new char[183];
        int dpi = 0;
        char[] b_flag = new char[2];
        int bmark = 0;
        int num_prohibit = 0;
        for (i = 0; i <= (this.Csize - 5) / 3; ++i) {
            num_long[i] = 0;
        }
        int cell_black = 0;
        char cbit = '\u0001';
        b_flag[0] = '\u0000';
        b_flag[1] = '\u0001';
        for (i = 0; i < this.Csize; ++i) {
            cell_no_change = 0;
            char[] dp = this.mcell[i];
            dpi = 0;
            k = 0;
            fl = 0;
            char data = dp[dpi++];
            buff[0] = '\u0000';
            if ((data & '\u0001') != 0) {
                ++k;
                fl = 1;
            }
            for (j = 1; j <= this.Csize; ++j) {
                if ((data & cbit) == b_flag[fl]) {
                    ++cell_no_change;
                } else {
                    if (fl != 0) {
                        cell_black += cell_no_change;
                    }
                    buff[k++] = (char)cell_no_change;
                    cell_no_change = 1;
                    fl = (char)(fl ^ 1);
                }
                data = (char)(data >> 1);
                if ((j & 7) != 0) continue;
                data = dp[dpi++];
            }
            buff[k] = (char)cell_no_change;
            for (j = 0; j <= k; ++j) {
                if (buff[j] < '\u0005') continue;
                bmark += 3 + (buff[j] - 5);
                int n2 = (buff[j] - 5) / 3;
                num_long[n2] = num_long[n2] + 1;
            }
            if (fl != 0) {
                ++k;
            }
            buff[0] = 127;
            buff[k] = 127;
            for (j = 1; j <= k - 5; j += 2) {
                if (buff[j + 1] != buff[j] || buff[j + 2] != buff[j] * 3 || buff[j + 3] != buff[j] || buff[j + 4] != buff[j] || buff[j - 1] < buff[j] * 4 && buff[j + 5] < buff[j] * 4) continue;
                ++num_prohibit;
            }
        }
        for (i = 0; i < this.Csize; ++i) {
            cell_no_change = 0;
            int m = i / 8;
            k = 0;
            fl = 0;
            buff[0] = '\u0000';
            b_flag[1] = cbit = bitpos[i & 7];
            if ((this.mcell[0][m] & cbit) != 0) {
                ++k;
                fl = 1;
            }
            for (j = 0; j < this.Csize; ++j) {
                if ((this.mcell[j][m] & cbit) == b_flag[fl]) {
                    ++cell_no_change;
                    continue;
                }
                buff[k++] = (char)cell_no_change;
                cell_no_change = 1;
                fl = (char)(fl ^ 1);
            }
            buff[k] = (char)cell_no_change;
            for (j = 0; j <= k; ++j) {
                if (buff[j] < '\u0005') continue;
                bmark += 3 + (buff[j] - 5);
                int n3 = (buff[j] - 5) / 3;
                num_long[n3] = num_long[n3] + 1;
            }
            if (fl != 0) {
                ++k;
            }
            buff[0] = 127;
            buff[k] = 127;
            for (j = 1; j <= k - 5; j += 2) {
                if (buff[j + 1] != buff[j] || buff[j + 2] != buff[j] * 3 || buff[j + 3] != buff[j] || buff[j + 4] != buff[j] || buff[j - 1] < buff[j] * 4 && buff[j + 5] < buff[j] * 4) continue;
                ++num_prohibit;
            }
        }
        bmark += 40 * num_prohibit;
        int ratio = cell_black / (this.data_cell / 100);
        int rn = (ratio - 50) / 5;
        return bmark += 10 * Math.abs(rn);
    }

    private char chk_mode(char[] cdp, char[] pEndBound, int pEndBoundi, int cdpi) {
        int mode;
        char c = cdp[cdpi];
        if (c >= '0' && c <= '9') {
            mode = 0;
        } else if (c >= ' ' && c <= 'Z' && antble[c - 32] != '\u0000') {
            mode = 1;
        } else if (c >= '\u0081' && c <= '\u009f' || c >= '\u00e0' && c <= '\u00eb') {
            int c2 = cdp.length > cdpi + 1 ? cdp[cdpi + 1] : 255;
            mode = c != '\u00eb' && c2 >= 64 && c2 <= 252 && c2 != 127 || c == '\u00eb' && c2 >= 64 && c2 <= 191 && c2 != 127 ? 3 : 2;
        } else {
            mode = 2;
        }
        return (char)mode;
    }

    private int bit_indicator(char mode) {
        int nbit = 0;
        switch (this.modelNo) {
            case 0: 
            case 1: {
                int niBit = this.Cver < 9 ? 0 : (this.Cver < 26 ? 1 : 2);
                nbit = nch_indicate[niBit][mode] + 4;
            }
        }
        return nbit;
    }

    private int bit_calc(char mode, int length) {
        int nbit = 0;
        switch (mode) {
            case '\u0000': {
                nbit = length / 3 * 10 + numrem[length % 3];
                break;
            }
            case '\u0001': {
                nbit = length / 2 * 11 + length % 2 * 6;
                break;
            }
            case '\u0002': {
                nbit = length * 8;
                break;
            }
            case '\u0003': {
                nbit = (length + 1) / 2 * 13;
            }
        }
        return nbit += this.bit_indicator(mode);
    }

    private char gouseiMode(char m1, char m2) {
        int m12 = m1 > m2 ? m1 : m2;
        if (m12 == 3 && m1 != m2) {
            m12 = 2;
        }
        return (char)m12;
    }

    private void save_d_inf(int level, char cmode, char[] savep, int index) {
        if (this.tQRmode[level + 1] == null) {
            this.tQRmode[level + 1] = new qrdata();
        }
        this.tQRmode[level + 1].bmode = cmode;
        this.tQRmode[level + 1].fdatap = savep;
        this.tQRmode[level + 1].fdatapi = index - c_byte[cmode];
        this.tQRmode[level].blen = this.tQRmode[level + 1].fdatapi - this.tQRmode[level].fdatapi;
    }

    private void data_copy(qrdata rdata, qrdata sdata) {
        rdata.bmode = sdata.bmode;
        rdata.fdatap = sdata.fdatap;
        rdata.blen = sdata.blen;
        rdata.fdatapi = sdata.fdatapi;
    }

    private void tQRmode0_decide() {
        if (this.qrdp[this.qrdpi] == null) {
            this.qrdp[this.qrdpi] = new qrdata();
        }
        this.data_copy(this.qrdp[this.qrdpi++], this.tQRmode[0]);
        this.data_copy(this.tQRmode[0], this.tQRmode[1]);
        this.data_copy(this.tQRmode[1], this.tQRmode[2]);
        this.data_copy(this.tQRmode[2], this.tQRmode[3]);
        ++this.Blksu;
    }

    private int eval_L1() {
        if (this.tQRmode[1].bmode == this.END_DATA_MODE) {
            this.tQRmode0_decide();
            return 0;
        }
        return 1;
    }

    private int eval_L2() {
        if (this.tQRmode[2].bmode == this.END_DATA_MODE) {
            int isolate;
            char gmd = this.gouseiMode(this.tQRmode[0].bmode, this.tQRmode[1].bmode);
            int gousei = this.bit_calc(gmd, this.tQRmode[0].blen + this.tQRmode[1].blen);
            if (gousei <= (isolate = this.bit_calc(this.tQRmode[0].bmode, this.tQRmode[0].blen) + this.bit_calc(this.tQRmode[1].bmode, this.tQRmode[1].blen))) {
                this.tQRmode[0].bmode = gmd;
                this.tQRmode[0].blen += this.tQRmode[1].blen;
                this.data_copy(this.tQRmode[1], this.tQRmode[2]);
            } else {
                this.tQRmode0_decide();
            }
            return this.eval_L1();
        }
        return 2;
    }

    private int eval_L3() {
        if (this.tQRmode[2].bmode == this.END_DATA_MODE) {
            return this.eval_L2();
        }
        int g0 = this.bit_calc(this.tQRmode[0].bmode, this.tQRmode[0].blen);
        int g1 = this.bit_calc(this.tQRmode[1].bmode, this.tQRmode[1].blen);
        int g2 = this.bit_calc(this.tQRmode[2].bmode, this.tQRmode[2].blen);
        char md01 = this.gouseiMode(this.tQRmode[0].bmode, this.tQRmode[1].bmode);
        int g01 = this.bit_calc(md01, this.tQRmode[0].blen + this.tQRmode[1].blen);
        char md12 = this.gouseiMode(this.tQRmode[1].bmode, this.tQRmode[2].bmode);
        int g12 = this.bit_calc(md12, this.tQRmode[1].blen + this.tQRmode[2].blen);
        char md012 = this.gouseiMode(md01, md12);
        int g012 = this.bit_calc(md012, this.tQRmode[0].blen + this.tQRmode[1].blen + this.tQRmode[2].blen);
        if (g012 <= g01 + g2) {
            if (g12 < g1 + g2 && g012 <= g0 + g12 || g12 >= g1 + g2 && g012 <= g0 + g1 + g2) {
                if (md012 == '\u0002' && g12 <= g1 + g2 && this.gouseiMode(md12, this.tQRmode[3].bmode) == '\u0001') {
                    this.tQRmode[1].bmode = md12;
                    this.tQRmode[1].blen += this.tQRmode[2].blen;
                    this.data_copy(this.tQRmode[2], this.tQRmode[3]);
                } else {
                    this.tQRmode[0].bmode = md01;
                    this.tQRmode[0].blen += this.tQRmode[1].blen;
                    this.data_copy(this.tQRmode[1], this.tQRmode[2]);
                    this.data_copy(this.tQRmode[2], this.tQRmode[3]);
                }
            } else if (md12 != '\u0002' && g12 <= g1 + g2) {
                this.tQRmode[1].bmode = md12;
                this.tQRmode[1].blen += this.tQRmode[2].blen;
                this.data_copy(this.tQRmode[2], this.tQRmode[3]);
            } else {
                this.tQRmode0_decide();
            }
        } else if (g12 < g1 + g2 && g01 + g2 <= g0 + g12 || g12 >= g1 + g2 && g01 <= g0 + g1) {
            this.tQRmode[0].bmode = md01;
            this.tQRmode[0].blen += this.tQRmode[1].blen;
            this.data_copy(this.tQRmode[1], this.tQRmode[2]);
            this.data_copy(this.tQRmode[2], this.tQRmode[3]);
        } else if (md12 != '\u0002' && g12 <= g1 + g2) {
            this.tQRmode[1].bmode = md12;
            this.tQRmode[1].blen += this.tQRmode[2].blen;
            this.data_copy(this.tQRmode[2], this.tQRmode[3]);
        } else {
            this.tQRmode0_decide();
        }
        return this.eval_L2();
    }

    public int auto_conv(qrdata[] sqrdp, char[] sfdp, char[] scdp, int datasu) {
        int s = 0;
        int fdpi = 0;
        int cdpi = 0;
        int fdpendi = 0;
        switch (this.modelNo) {
            case 0: 
            case 1: {
                this.Cver = 0;
            }
        }
        for (int i = 0; i < 4; ++i) {
            int oldCver = this.Cver;
            int level = 0;
            this.Blksu = 0;
            this.qrdp = sqrdp;
            this.qrdpi = 0;
            char[] fdp = sfdp;
            fdpi = 0;
            char[] fdpEnd = fdp;
            fdpendi = fdpi + datasu;
            char[] cdp = scdp;
            cdpi = 0;
            int cnt = datasu;
            for (int u = 0; u < 4; ++u) {
                this.tQRmode[u] = new qrdata();
                this.tQRmode[u].bmode = (char)4;
            }
            if (this.tQRmode[0] == null) {
                this.tQRmode[0] = new qrdata();
            }
            this.tQRmode[0].fdatap = cdp;
            this.tQRmode[0].fdatapi = cdpi;
            char cmode = this.chk_mode(fdp, fdpEnd, fdpendi, cdpi);
            --cnt;
            ++cdpi;
            if (cmode == '\u0003') {
                if (fdpi < fdp.length) {
                    ++cdpi;
                    ++fdpi;
                    --cnt;
                } else {
                    cmode = '\u0002';
                }
            }
            this.tQRmode[0].bmode = cmode;
            for (s = 1; cnt > 0 && s < 7366 && this.Blksu < 2000; ++s) {
                cmode = this.chk_mode(fdp, fdpEnd, fdpendi, cdpi);
                --cnt;
                ++cdpi;
                if (cmode == '\u0003') {
                    if (fdpi < fdp.length) {
                        ++cdpi;
                        ++fdpi;
                        --cnt;
                    } else {
                        cmode = '\u0002';
                    }
                }
                if (this.tQRmode[level].bmode == cmode) continue;
                this.save_d_inf(level, cmode, cdp, cdpi);
                level = (char)(level + 1);
                if (level != 3) continue;
                level = (char)this.eval_L3();
            }
            this.save_d_inf(level, (char)this.END_DATA_MODE, cdp, cdpi);
            level = (char)(level + 1);
            switch (level) {
                case 1: {
                    this.tQRmode0_decide();
                    break;
                }
                case 2: {
                    this.eval_L2();
                    break;
                }
                case 3: {
                    this.eval_L3();
                }
            }
            switch (this.modelNo) {
                case 0: 
                case 1: {
                    this.Cver = this.getversion12(this.Blksu, sqrdp, this.Clvl);
                    if (this.Cver < 9) {
                        oldCver = this.Cver;
                        break;
                    }
                    if (this.Cver < 26) {
                        if (oldCver < 9) break;
                        oldCver = this.Cver;
                        break;
                    }
                    if (oldCver < 26) break;
                    oldCver = this.Cver;
                }
            }
            if (oldCver == this.Cver || this.Cver < 0) break;
        }
        return s;
    }

    private static class cftb {
        private int nmenb;
        private char[] tbladr;

        cftb(int nmenb, char[] tbladr) {
            this.nmenb = nmenb;
            this.tbladr = tbladr;
        }
    }

    private static class qrdata {
        public char bmode;
        public int blen;
        public char[] fdatap;
        public int fdatapi = 0;

        private qrdata() {
        }
    }
}

