/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.adobepdf417pmp;

import com.adobe.xfa.pmp.adobepdf417pmp.PDF417SpecialCode;
import java.util.ArrayList;
import java.util.List;

class PDF417TextCompactor {
    static final String alphaSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ ";
    static final String lowerSet = "abcdefghijklmnopqrstuvwxyz ";
    static final String mixedSet = "0123456789&\r\t,:#-.$/+%*=^ ";
    static final String punctuationSet = ";<>@[\\]_`~!\r\t,:\n-.$/\"|*()?{}'";

    PDF417TextCompactor() {
    }

    static void compact(List<Character> message, List<Integer> compactedMessage) {
        ArrayList<Integer> data = new ArrayList<Integer>();
        SetType subMode = SetType.ALPHA;
        String pCurrentSet = alphaSet;
        int idx = 0;
        block6: for (idx = 0; idx < message.size(); ++idx) {
            char c = message.get(idx).charValue();
            int index = pCurrentSet.indexOf(c);
            if (index >= 0) {
                if (subMode == SetType.MIXED && index == 25) {
                    index = 26;
                }
                data.add(index);
                continue;
            }
            SubModeAndIndex subModeAndIndex = PDF417TextCompactor.getSubModeAndIndex(c);
            if (subModeAndIndex == null) {
                throw new IllegalArgumentException("SubMode and index information can't be found");
            }
            SetType newSubMode = subModeAndIndex.subMode;
            index = subModeAndIndex.index;
            List<Integer> subModeSwitch = PDF417TextCompactor.getSubModeSwitch(subMode, newSubMode);
            int jdx = 0;
            for (jdx = 0; jdx < subModeSwitch.size(); ++jdx) {
                int v = subModeSwitch.get(jdx);
                data.add(v);
            }
            data.add(index);
            subMode = newSubMode;
            switch (subMode) {
                case ALPHA: {
                    pCurrentSet = alphaSet;
                    continue block6;
                }
                case LOWER: {
                    pCurrentSet = lowerSet;
                    continue block6;
                }
                case MIXED: {
                    pCurrentSet = mixedSet;
                    continue block6;
                }
                case PUNCTUATION: {
                    pCurrentSet = punctuationSet;
                }
            }
        }
        if (data.size() % 2 != 0) {
            data.add(29);
        }
        compactedMessage.add(PDF417SpecialCode.TextCompactionLatch.getValue());
        for (idx = 0; idx < data.size(); idx += 2) {
            int H = (Integer)data.get(idx);
            int L = (Integer)data.get(idx + 1);
            int codeWord = 30 * H + L;
            compactedMessage.add(codeWord);
        }
    }

    static SubModeAndIndex getSubModeAndIndex(char c) {
        SubModeAndIndex subModeAndIndex = new SubModeAndIndex();
        int index = lowerSet.indexOf(c);
        if (index >= 0) {
            subModeAndIndex.index = index;
            subModeAndIndex.subMode = SetType.LOWER;
            return subModeAndIndex;
        }
        index = alphaSet.indexOf(c);
        if (index >= 0) {
            subModeAndIndex.index = index;
            subModeAndIndex.subMode = SetType.ALPHA;
            return subModeAndIndex;
        }
        index = mixedSet.indexOf(c);
        if (index >= 0) {
            if (index == 25) {
                index = 26;
            }
            subModeAndIndex.index = index;
            subModeAndIndex.subMode = SetType.MIXED;
            return subModeAndIndex;
        }
        index = punctuationSet.indexOf(c);
        if (index >= 0) {
            subModeAndIndex.index = index;
            subModeAndIndex.subMode = SetType.PUNCTUATION;
            return subModeAndIndex;
        }
        return null;
    }

    static List<Integer> getSubModeSwitch(SetType subMode, SetType newSubMode) {
        ArrayList<Integer> sunModeSwitch = new ArrayList<Integer>();
        block0 : switch (subMode) {
            case ALPHA: {
                switch (newSubMode) {
                    case ALPHA: {
                        break;
                    }
                    case LOWER: {
                        sunModeSwitch.add(27);
                        break;
                    }
                    case MIXED: {
                        sunModeSwitch.add(28);
                        break;
                    }
                    case PUNCTUATION: {
                        sunModeSwitch.add(28);
                        sunModeSwitch.add(25);
                    }
                }
                break;
            }
            case LOWER: {
                switch (newSubMode) {
                    case ALPHA: {
                        sunModeSwitch.add(28);
                        sunModeSwitch.add(28);
                        break;
                    }
                    case LOWER: {
                        break;
                    }
                    case MIXED: {
                        sunModeSwitch.add(28);
                        break;
                    }
                    case PUNCTUATION: {
                        sunModeSwitch.add(28);
                        sunModeSwitch.add(25);
                    }
                }
                break;
            }
            case MIXED: {
                switch (newSubMode) {
                    case ALPHA: {
                        sunModeSwitch.add(28);
                        break;
                    }
                    case LOWER: {
                        sunModeSwitch.add(27);
                        break;
                    }
                    case MIXED: {
                        break;
                    }
                    case PUNCTUATION: {
                        sunModeSwitch.add(25);
                    }
                }
                break;
            }
            case PUNCTUATION: {
                switch (newSubMode) {
                    case ALPHA: {
                        sunModeSwitch.add(29);
                        break block0;
                    }
                    case LOWER: {
                        sunModeSwitch.add(29);
                        sunModeSwitch.add(27);
                        break block0;
                    }
                    case MIXED: {
                        sunModeSwitch.add(29);
                        sunModeSwitch.add(28);
                        break block0;
                    }
                }
            }
        }
        return sunModeSwitch;
    }

    static boolean canHandle(char value) {
        return alphaSet.indexOf(value) >= 0 || lowerSet.indexOf(value) >= 0 || mixedSet.indexOf(value) >= 0 || punctuationSet.indexOf(value) >= 0;
    }

    static class SubModeAndIndex {
        SetType subMode;
        int index;

        SubModeAndIndex() {
        }
    }

    static enum SetType {
        ALPHA(0),
        LOWER(1),
        MIXED(2),
        PUNCTUATION(3);

        private int value;

        private SetType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

