/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.adobepdf417pmp;

import com.adobe.xfa.pmp.adobepdf417pmp.PDF417SpecialCode;
import java.util.List;

class PDF417ByteCompactor {
    PDF417ByteCompactor() {
    }

    static void compact(List<Character> message, List<Integer> compactedMessage) {
        compactedMessage.add(0);
        char[] base256 = new char[6];
        int[] base900 = new int[5];
        int srcIdx = 0;
        while (srcIdx + 6 <= message.size()) {
            base256[0] = message.get(srcIdx++).charValue();
            base256[1] = message.get(srcIdx++).charValue();
            base256[2] = message.get(srcIdx++).charValue();
            base256[3] = message.get(srcIdx++).charValue();
            base256[4] = message.get(srcIdx++).charValue();
            base256[5] = message.get(srcIdx++).charValue();
            PDF417ByteCompactor.base256ToBase900(base256, base900);
            compactedMessage.add(base900[0]);
            compactedMessage.add(base900[1]);
            compactedMessage.add(base900[2]);
            compactedMessage.add(base900[3]);
            compactedMessage.add(base900[4]);
        }
        if (srcIdx != message.size()) {
            compactedMessage.set(0, PDF417SpecialCode.ByteCompactionLatch0.getValue());
            while (srcIdx < message.size()) {
                compactedMessage.add(Integer.valueOf(message.get(srcIdx++).charValue()));
            }
        } else {
            compactedMessage.set(0, PDF417SpecialCode.ByteCompactionLatch1.getValue());
        }
    }

    static void base256ToBase900(char[] in, int[] out) {
        long v1 = in[0];
        v1 <<= 40;
        long v2 = in[1];
        v2 <<= 32;
        long v3 = in[2];
        long v4 = in[3];
        long v5 = in[4];
        long v6 = in[5];
        long v = v1 | v2 | (v3 <<= 24) | (v4 <<= 16) | (v5 <<= 8) | v6;
        for (int idx = 4; idx >= 0; --idx) {
            int c = (int)(v % 900L);
            v /= 900L;
            out[idx] = c;
        }
    }
}

