/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.Obj;
import com.adobe.xfa.formcalc.BuiltinLogical;
import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.FormCalcUtil;
import com.adobe.xfa.formcalc.Frame;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Locale;

public final class Instruction {
    static final Method gStop = Instruction.getDeclaredMethod("Stop");
    static final Method gOr = Instruction.getDeclaredMethod("Or");
    static final Method gAnd = Instruction.getDeclaredMethod("And");
    static final Method gEq = Instruction.getDeclaredMethod("Eq");
    static final Method gNe = Instruction.getDeclaredMethod("Ne");
    static final Method gGt = Instruction.getDeclaredMethod("Gt");
    static final Method gGe = Instruction.getDeclaredMethod("Ge");
    static final Method gLt = Instruction.getDeclaredMethod("Lt");
    static final Method gLe = Instruction.getDeclaredMethod("Le");
    static final Method gAdd = Instruction.getDeclaredMethod("Add");
    static final Method gSub = Instruction.getDeclaredMethod("Sub");
    static final Method gMul = Instruction.getDeclaredMethod("Mul");
    static final Method gDiv = Instruction.getDeclaredMethod("Div");
    static final Method gUminus = Instruction.getDeclaredMethod("Uminus");
    static final Method gUplus = Instruction.getDeclaredMethod("Uplus");
    static final Method gNot = Instruction.getDeclaredMethod("Not");
    static final Method gNoop = Instruction.getDeclaredMethod("Noop");
    static final Method gDeref = Instruction.getDeclaredMethod("Deref");
    static final Method gLoad = Instruction.getDeclaredMethod("Load");
    static final Method gGbl = Instruction.getDeclaredMethod("Gbl");
    static final Method gFunc = Instruction.getDeclaredMethod("Func");
    static final Method gCall = Instruction.getDeclaredMethod("Call");
    static final Method gRet = Instruction.getDeclaredMethod("Ret");
    static final Method gForm = Instruction.getDeclaredMethod("Form");
    static final Method gAsgn = Instruction.getDeclaredMethod("Asgn");
    static final Method gAsgn2 = Instruction.getDeclaredMethod("Asgn2");
    static final Method gDot = Instruction.getDeclaredMethod("Dot");
    static final Method gDotdot = Instruction.getDeclaredMethod("Dotdot");
    static final Method gDothash = Instruction.getDeclaredMethod("Dothash");
    static final Method gDotstar = Instruction.getDeclaredMethod("Dotstar");
    static final Method gIndex = Instruction.getDeclaredMethod("Index");
    static final Method gList = Instruction.getDeclaredMethod("List");
    static final Method gForeach = Instruction.getDeclaredMethod("Foreach");
    static final Method gFor = Instruction.getDeclaredMethod("For");
    static final Method gWhile = Instruction.getDeclaredMethod("While");
    static final Method gIf = Instruction.getDeclaredMethod("If");
    static final Method gIfFunc = Instruction.getDeclaredMethod("IfFunc");
    static final Method gBreak = Instruction.getDeclaredMethod("Break");
    static final Method gCont = Instruction.getDeclaredMethod("Cont");
    static final Method gEnter = Instruction.getDeclaredMethod("Enter");
    static final Method gExit = Instruction.getDeclaredMethod("Exit");
    Object[] moCodeBase;
    private int mnProgCtr;
    private int mnProgBase;
    private int mnProgEnd;
    private int mnCodePtr;
    private int mnCodeSize;

    Instruction() {
    }

    private static Method getDeclaredMethod(String name) {
        try {
            return Instruction.class.getDeclaredMethod(name, CalcParser.class);
        }
        catch (NoSuchMethodException ignored) {
            assert (false);
            return null;
        }
    }

    int create(int nCodeSize) {
        this.mnCodeSize = nCodeSize;
        this.moCodeBase = new Object[this.mnCodeSize];
        this.mnProgBase = this.mnProgCtr = (this.mnCodePtr = 0);
        this.mnProgEnd = this.mnProgCtr;
        return 1;
    }

    void init(CalcParser oParser) {
        this.mnCodePtr = oParser.mbSyntaxErrorSeen ? this.mnProgBase : (oParser.mbWasInSaveMode ? this.mnProgEnd : 0);
        this.mnProgCtr = this.mnCodePtr;
        this.mnProgBase = this.mnCodePtr;
    }

    int getCodeStart() {
        return 0;
    }

    int getProgStart() {
        return this.mnProgBase;
    }

    void setProgStart() {
        this.mnProgBase = this.mnCodePtr;
    }

    int getCodeSize() {
        return this.mnCodeSize;
    }

    int generate() {
        return this.mnCodePtr;
    }

    int generate(Object nInstruction) {
        if (this.mnCodePtr >= this.mnCodeSize) {
            int nProgEndOffset = this.mnProgEnd;
            int nCodeSize = this.mnCodePtr;
            int nProgSize = this.mnProgBase;
            int nProgCtrSize = this.mnProgCtr;
            this.mnCodeSize <<= 1;
            Object[] oNewBase = new Object[this.mnCodeSize];
            System.arraycopy(this.moCodeBase, 0, oNewBase, 0, this.mnCodeSize >> 1);
            this.moCodeBase = oNewBase;
            this.mnCodePtr = nCodeSize;
            this.mnProgCtr = nProgCtrSize;
            this.mnProgBase = nProgSize;
            this.mnProgEnd = nProgEndOffset;
        }
        int pInstruction = this.mnCodePtr;
        this.moCodeBase[this.mnCodePtr++] = nInstruction;
        return pInstruction;
    }

    void execute(CalcParser oParser, int nStartAddr) {
        assert (this.mnCodePtr > 0);
        this.mnProgCtr = nStartAddr;
        while (this.moCodeBase[this.mnProgCtr] != gStop) {
            if (null != oParser.moScriptHost && oParser.moScriptHost.cancelActionOccured()) {
                oParser.mbCancelStatus = true;
                if (!oParser.mbCancelStatus) continue;
                break;
            }
            Object oObj = this.moCodeBase[this.mnProgCtr++];
            try {
                Method func = (Method)oObj;
                func.invoke(null, oParser);
            }
            catch (IllegalAccessException e) {
                assert (e != null);
            }
            catch (InvocationTargetException e) {
                assert (e != null);
            }
        }
    }

    void release(CalcParser oParser, int nStartAddr) {
        int nInstruction = nStartAddr;
        Object[] oBase = oParser.moCode.moCodeBase;
        while (nInstruction < this.mnCodePtr) {
            if (oBase[nInstruction] == gLoad) {
                CalcSymbol oSym = (CalcSymbol)oBase[nInstruction + 1];
                if (oSym != null) {
                    switch (oSym.getType()) {
                        case 5: 
                        case 7: {
                            break;
                        }
                        case 6: {
                            break;
                        }
                        default: {
                            CalcSymbol.delete(oSym, oParser);
                        }
                    }
                }
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gCall) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gForm) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gFor) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gForeach) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gIf) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gIfFunc) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gWhile) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gFunc) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gGbl) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gEnter) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            if (oBase[nInstruction] == gExit) {
                oBase[nInstruction++] = gStop;
                oBase[nInstruction++] = gStop;
                continue;
            }
            oBase[nInstruction++] = gStop;
        }
    }

    void relocate(CalcParser oParser) {
        int oDstInstr = 0;
        int oSrcInstr = 0;
        Object[] oBase = oParser.moCode.moCodeBase;
        oBase[oDstInstr++] = oBase[oSrcInstr++];
        oBase[oDstInstr++] = oBase[oSrcInstr++];
        int nSavedDecl = 0;
        while (oSrcInstr < this.mnCodePtr) {
            if (oBase[oSrcInstr] == gGbl) {
                int nEnd = oSrcInstr + (Integer)oBase[oSrcInstr + 1];
                while (oSrcInstr < nEnd) {
                    oBase[oDstInstr++] = oBase[oSrcInstr++];
                }
                ++nSavedDecl;
                continue;
            }
            if (oBase[oSrcInstr] == gFunc) {
                CalcSymbol oSym = (CalcSymbol)oBase[oSrcInstr + 1];
                if (oSym != null && oSym.getType() == 8) {
                    oSym.setAddr(oDstInstr);
                }
                int nEnd = oSrcInstr + (Integer)oBase[oSrcInstr + 2];
                while (oSrcInstr < nEnd) {
                    oBase[oDstInstr++] = oBase[oSrcInstr++];
                }
                ++nSavedDecl;
                continue;
            }
            if (oBase[oSrcInstr] == gLoad) {
                CalcSymbol oSym = (CalcSymbol)oBase[oSrcInstr + 1];
                if (oSym != null && oSym.getType() != 5 && oSym.getType() != 6 && oSym.getType() != 7) {
                    CalcSymbol.delete(oSym, oParser);
                }
                oSrcInstr += 2;
                continue;
            }
            if (oBase[oSrcInstr] == gCall) {
                oSrcInstr += 3;
                continue;
            }
            if (oBase[oSrcInstr] == gForm) {
                oSrcInstr += 3;
                continue;
            }
            ++oSrcInstr;
        }
        this.mnProgEnd = oDstInstr;
        oBase[oDstInstr++] = gExit;
        oBase[oDstInstr++] = 1;
        while (oDstInstr < this.mnCodePtr) {
            oBase[oDstInstr++] = gStop;
        }
        this.mnCodePtr = this.mnProgEnd + 2;
        oParser.mnSavedDecl = oParser.mnSavedDecl + (nSavedDecl > 0 ? 1 : 0);
    }

    public boolean debugBreakPoint(int nScriptID, int nLine, boolean bSet) {
        return false;
    }

    public boolean debugCommand(CalcParser oParser, int eCmd) {
        return false;
    }

    static void Stop(CalcParser oParser) {
    }

    static void Or(CalcParser oParser) {
        Instruction.Binary(oParser, gOr);
    }

    static void And(CalcParser oParser) {
        Instruction.Binary(oParser, gAnd);
    }

    static void Eq(CalcParser oParser) {
        Instruction.Relational(oParser, gEq);
    }

    static void Ne(CalcParser oParser) {
        Instruction.Relational(oParser, gNe);
    }

    static void Gt(CalcParser oParser) {
        Instruction.Relational(oParser, gGt);
    }

    static void Ge(CalcParser oParser) {
        Instruction.Relational(oParser, gGe);
    }

    static void Lt(CalcParser oParser) {
        Instruction.Relational(oParser, gLt);
    }

    static void Le(CalcParser oParser) {
        Instruction.Relational(oParser, gLe);
    }

    static void Add(CalcParser oParser) {
        Instruction.Binary(oParser, gAdd);
    }

    static void Sub(CalcParser oParser) {
        Instruction.Binary(oParser, gSub);
    }

    static void Mul(CalcParser oParser) {
        Instruction.Binary(oParser, gMul);
    }

    static void Div(CalcParser oParser) {
        Instruction.Binary(oParser, gDiv);
    }

    static void List(CalcParser oParser) {
        Instruction.Binary(oParser, gList);
    }

    static void Uminus(CalcParser oParser) {
        Instruction.Unary(oParser, gUminus);
    }

    static void Uplus(CalcParser oParser) {
        Instruction.Unary(oParser, gUplus);
    }

    static void Not(CalcParser oParser) {
        Instruction.Unary(oParser, gNot);
    }

    static void Deref(CalcParser oParser) {
        Instruction.Unary(oParser, gDeref);
    }

    static void Noop(CalcParser oParser) {
        Instruction.Unary(oParser, gNoop);
    }

    static void Asgn(CalcParser oParser) {
        Instruction.Assign(oParser, gAsgn);
    }

    static void Asgn2(CalcParser oParser) {
        Instruction.Assign(oParser, gAsgn2);
    }

    static void Dot(CalcParser oParser) {
        Instruction.Concat(oParser, gDot);
    }

    static void Dotdot(CalcParser oParser) {
        Instruction.Concat(oParser, gDotdot);
    }

    static void Dothash(CalcParser oParser) {
        Instruction.Concat(oParser, gDothash);
    }

    static void Dotstar(CalcParser oParser) {
        CalcSymbol lSym = oParser.mStack.pop();
        CalcSymbol oRetSym = null;
        try {
            if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                oParser.getExceptions(lSym);
                oRetSym = new CalcSymbol(0);
            } else {
                String lContainer = lSym.getType() == 6 ? "#0" : lSym.getName();
                StringBuilder sResult = new StringBuilder(lContainer.length() + 2);
                sResult.append(lContainer);
                sResult.append('.');
                sResult.append('*');
                oRetSym = new CalcSymbol();
                oRetSym.setName(sResult.toString());
                if (lSym.getType() == 6) {
                    oRetSym.setObjValue(lSym.getObjValue());
                }
                oRetSym.setType(9);
            }
        }
        catch (CalcException e) {
            oParser.mbInThrow = true;
            oRetSym = e.getSymbol();
        }
        CalcSymbol.delete(lSym, oParser);
        oParser.mStack.push(oRetSym);
    }

    static void Index(CalcParser oParser) {
        CalcSymbol rSym = oParser.mStack.pop();
        CalcSymbol lSym = oParser.mStack.pop();
        CalcSymbol oRetSym = null;
        try {
            if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                oParser.getExceptions(rSym);
                oParser.getExceptions(lSym);
                oRetSym = new CalcSymbol(0);
            } else {
                String lAccessor = lSym.getName();
                CalcSymbol oSym = new CalcSymbol(rSym);
                StringBuilder rIndex = new StringBuilder();
                block10: while (true) {
                    String sStr = null;
                    switch (oSym.getType()) {
                        case 9: {
                            if ("*".equals(oSym.getName())) {
                                rIndex.append('*');
                                break block10;
                            }
                            CalcSymbol oTmpSym = oParser.getOneValue(oSym);
                            CalcSymbol.delete(oSym, oParser);
                            oSym = oTmpSym;
                            continue block10;
                        }
                        case 6: {
                            CalcSymbol oTmpSym = oParser.getRefValue(oSym);
                            CalcSymbol.delete(oSym, oParser);
                            oSym = oTmpSym;
                            continue block10;
                        }
                        case 3: {
                            int nIndex = (int)oParser.getNumeric(oSym);
                            rIndex.append(nIndex);
                            break block10;
                        }
                        case 2: 
                        case 5: {
                            sStr = oSym.getStringValue();
                            if (sStr != null && FormCalcUtil.strIsNumeric(sStr)) {
                                rIndex.append(sStr);
                                int nRadix = rIndex.indexOf(".");
                                if (nRadix < 0) break block10;
                                rIndex.setLength(nRadix);
                                break block10;
                            }
                            int nIndex = (int)oParser.getNumeric(oSym);
                            rIndex.append(nIndex);
                            break block10;
                        }
                        case 1: {
                            rIndex.append('0');
                            break block10;
                        }
                        case 0: 
                        case 10: {
                            CalcException e = new CalcException(oSym);
                            CalcSymbol.delete(oSym, oParser);
                            throw e;
                        }
                    }
                    break;
                }
                CalcSymbol.delete(oSym, oParser);
                StringBuilder sResult = new StringBuilder(lAccessor.length() + 2 + rIndex.length());
                sResult.append(lAccessor);
                sResult.append('[');
                sResult.append((CharSequence)rIndex);
                sResult.append(']');
                oRetSym = new CalcSymbol();
                oRetSym.setName(sResult.toString());
                oRetSym.setType(9);
            }
        }
        catch (CalcException e) {
            oParser.mbInThrow = true;
            oRetSym = e.getSymbol();
        }
        CalcSymbol.delete(rSym, oParser);
        CalcSymbol.delete(lSym, oParser);
        oParser.mStack.push(oRetSym);
    }

    static void Break(CalcParser oParser) {
        CalcSymbol oRetSym = null;
        if (oParser.mStack.getOffset() > 0) {
            CalcSymbol oSym = oParser.mStack.pop();
            try {
                if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                    oParser.getExceptions(oSym);
                    oRetSym = new CalcSymbol(0);
                } else {
                    double dVal = oParser.getNumeric(oSym);
                    oRetSym = new CalcSymbol(dVal);
                }
            }
            catch (CalcException e) {
                oParser.mbInThrow = true;
                oRetSym = e.getSymbol();
            }
            CalcSymbol.delete(oSym, oParser);
            oParser.mStack.push(oRetSym);
        }
        oRetSym = new CalcSymbol(0);
        oParser.mbInBreak = true;
        oParser.mStack.push(oRetSym);
    }

    static void Cont(CalcParser oParser) {
        CalcSymbol oRetSym = null;
        if (oParser.mStack.getOffset() > 0) {
            CalcSymbol oSym = oParser.mStack.pop();
            try {
                if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                    oParser.getExceptions(oSym);
                    oRetSym = new CalcSymbol(0);
                } else {
                    double dVal = oParser.getNumeric(oSym);
                    oRetSym = new CalcSymbol(dVal);
                }
            }
            catch (CalcException e) {
                oParser.mbInThrow = true;
                oRetSym = e.getSymbol();
            }
            CalcSymbol.delete(oSym, oParser);
            oParser.mStack.push(oRetSym);
        }
        oRetSym = new CalcSymbol(0);
        oParser.mbInContinue = true;
        oParser.mStack.push(oRetSym);
    }

    static void Enter(CalcParser oParser) {
        Object oScope = oParser.moCode.moCodeBase[oParser.moCode.mnProgCtr++];
        int nScope = (Integer)oScope;
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            return;
        }
        oParser.moScope.setActive(nScope);
    }

    static void Exit(CalcParser oParser) {
        Object oScope = oParser.moCode.moCodeBase[oParser.moCode.mnProgCtr++];
        int nScope = (Integer)oScope;
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            return;
        }
        oParser.moScope.clearActive(nScope);
    }

    static void Load(CalcParser oParser) {
        Object oObj;
        CalcSymbol oSym;
        if ((oSym = (CalcSymbol)(oObj = oParser.moCode.moCodeBase[oParser.moCode.mnProgCtr++])).getType() == 7) {
            int nStackAddr = oParser.moFrame.peek().getStackAddr();
            int nArgCount = oParser.moFrame.peek().getArgCount();
            int nStackIdx = oSym.getIdxValue();
            oSym = oParser.mStack.peek(nStackAddr - nArgCount + nStackIdx);
            oSym = new CalcSymbol(oSym);
        }
        oParser.mStack.push(oSym);
        if (oParser.mbInterrupted) {
            oParser.mbInterrupted = false;
            oParser.mbInThrow = true;
            oSym = oParser.mStack.pop();
            CalcSymbol.delete(oSym, oParser);
            MsgFormat sErrMsg = new MsgFormat(ResId.FC_ERR_INTERRUPTED);
            oSym = new CalcSymbol(sErrMsg.toString(), true, 0, 0);
            oParser.mStack.push(oSym);
        }
    }

    static void Gbl(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        oParser.moCode.mnProgCtr = oParser.moCode.mnProgCtr >= oParser.moCode.mnProgBase ? nPC + 2 : nPC + (Integer)oParser.moCode.moCodeBase[nPC + 1];
    }

    static void Func(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        if (oParser.moCode.mnProgCtr >= oParser.moCode.mnProgBase) {
            CalcSymbol oSym = (CalcSymbol)oParser.moCode.moCodeBase[nPC + 1];
            CalcSymbol oRetSym = null;
            try {
                oParser.getExceptions(oSym);
                oRetSym = new CalcSymbol(0);
            }
            catch (CalcException e) {
                oParser.mbInThrow = true;
                oRetSym = e.getSymbol();
            }
            oParser.mStack.push(oRetSym);
        }
        oParser.moCode.mnProgCtr = nPC + (Integer)oParser.moCode.moCodeBase[nPC + 2];
    }

    static void Call(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        String sIdent = (String)oParser.moCode.moCodeBase[nPC + 1];
        int nArgs = (Integer)oParser.moCode.moCodeBase[nPC + 2];
        String sFunction = sIdent.toUpperCase(Locale.US);
        CalcSymbol oFuncSym = oParser.mBuiltin.lookup(sFunction);
        if (oFuncSym == null) {
            oFuncSym = oParser.moData.lookup(sIdent);
        }
        if (oFuncSym.getType() == 4) {
            CalcSymbol[] oArgs = new CalcSymbol[nArgs];
            for (int i = nArgs; i > 0; --i) {
                oArgs[i - 1] = oParser.mStack.pop();
            }
            if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                CalcSymbol oRetSym = null;
                try {
                    for (int i = nArgs - 1; i >= 0; --i) {
                        oParser.getExceptions(oArgs[i]);
                    }
                    oRetSym = new CalcSymbol(0);
                }
                catch (CalcException e) {
                    oParser.mbInThrow = true;
                    oRetSym = e.getSymbol();
                }
                oParser.mStack.push(oRetSym);
            } else {
                oFuncSym.getFuncValue(oParser, oArgs);
            }
            for (int i = nArgs - 1; i >= 0; --i) {
                CalcSymbol.delete(oArgs[i], oParser);
            }
            oParser.moCode.mnProgCtr = nPC + 3;
        } else if (oFuncSym.getType() == 8) {
            if (oFuncSym.getCntValue() != nArgs) {
                for (int i = nArgs; i > 0; --i) {
                    CalcSymbol oArg = oParser.mStack.pop();
                    CalcSymbol.delete(oArg, oParser);
                }
                oParser.mbInThrow = true;
                MsgFormat sErr = new MsgFormat(ResId.FC_ERR_PARAMETER);
                CalcSymbol oRetSym = new CalcSymbol(sErr.toString(), true, 0, 0);
                oParser.mStack.push(oRetSym);
                oParser.moCode.mnProgCtr = nPC + 3;
            } else if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                CalcSymbol[] oArgs = new CalcSymbol[nArgs];
                for (int i = nArgs; i > 0; --i) {
                    oArgs[i - 1] = oParser.mStack.pop();
                }
                CalcSymbol oRetSym = null;
                try {
                    for (int i = nArgs - 1; i >= 0; --i) {
                        oParser.getExceptions(oArgs[i]);
                    }
                    oRetSym = new CalcSymbol(0);
                }
                catch (CalcException e) {
                    oParser.mbInThrow = true;
                    oRetSym = e.getSymbol();
                }
                for (int i = nArgs - 1; i >= 0; --i) {
                    CalcSymbol.delete(oArgs[i], oParser);
                }
                oParser.mStack.push(oRetSym);
                oParser.moCode.mnProgCtr = nPC + 3;
            } else {
                Frame oFrame = new Frame();
                oFrame.setFuncSym(oFuncSym);
                oFrame.setStackAddr(oParser.mStack.getOffset() - 1);
                oFrame.setReturnAddr(nPC + 3);
                oParser.moFrame.push(oFrame);
                oParser.moCode.execute(oParser, oFuncSym.getAddr() + 3);
            }
        }
    }

    static void Ret(CalcParser oParser) {
        Frame oFrame = oParser.moFrame.pop();
        int nArgs = oFrame.getArgCount();
        CalcSymbol oRetSym = oParser.mStack.pop();
        for (int i = nArgs; i > 0; --i) {
            CalcSymbol oArg = oParser.mStack.pop();
            CalcSymbol.delete(oArg, oParser);
        }
        oParser.mStack.push(oRetSym);
        oParser.moCode.mnProgCtr = oFrame.getReturnAddr();
    }

    static void Form(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        String sIdent = (String)oParser.moCode.moCodeBase[nPC + 1];
        int nArgs = (Integer)oParser.moCode.moCodeBase[nPC + 2];
        CalcSymbol[] oArgs = new CalcSymbol[nArgs];
        for (int i = nArgs; i > 0; --i) {
            oArgs[i - 1] = oParser.mStack.pop();
        }
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            CalcSymbol oRetSym = null;
            try {
                for (int i = nArgs - 1; i >= 0; --i) {
                    oParser.getExceptions(oArgs[i]);
                }
                oRetSym = new CalcSymbol(0);
            }
            catch (CalcException e) {
                oParser.mbInThrow = true;
                oRetSym = e.getSymbol();
            }
            oParser.mStack.push(oRetSym);
        } else {
            CalcSymbol oRetSym;
            Obj[] oObj = new Obj[nArgs + 1];
            try {
                StringBuilder sFormula = new StringBuilder(sIdent);
                sFormula.append('(');
                for (int i = 0; i < nArgs; ++i) {
                    block16: while (true) {
                        CalcSymbol[] oSyms = null;
                        String sStr = null;
                        switch (oArgs[i].getType()) {
                            case 9: {
                                int nSyms = 0;
                                try {
                                    oSyms = oParser.moScriptHost.getItemValue(oArgs[i].getName(), oArgs[i].getObjValues());
                                    nSyms = oSyms.length;
                                    CalcSymbol.delete(oArgs[i], oParser);
                                    oArgs[i] = oSyms[0];
                                    Builtins.limitExceptionArgs(oSyms);
                                    int j = nSyms - 1;
                                    while (true) {
                                        if (j <= 0) continue block16;
                                        CalcSymbol.delete(oSyms[j], oParser);
                                        --j;
                                    }
                                }
                                catch (CalcException e) {
                                    for (int j = nSyms - 1; j > 0; --j) {
                                        CalcSymbol.delete((CalcSymbol)oSyms[j], oParser);
                                    }
                                    throw e;
                                }
                            }
                            case 6: {
                                sFormula.append('#');
                                sFormula.append((char)(48 + i + 1));
                                oObj[i + 1] = oArgs[i].getObjValue();
                                break block16;
                            }
                            case 2: 
                            case 5: {
                                sStr = oArgs[i].getStringValue();
                                sFormula.append('\"');
                                if (sStr != null) {
                                    String sEsc = FormCalcUtil.strToEscStr(sStr);
                                    sFormula.append(sEsc);
                                }
                                sFormula.append('\"');
                                break block16;
                            }
                            case 3: {
                                sStr = FormCalcUtil.dblToStr(oArgs[i].getNumericValue(), 11);
                                StringBuilder sBuf = new StringBuilder(sStr);
                                FormCalcUtil.trimZeroes(sBuf);
                                FormCalcUtil.trimRadix(sBuf);
                                FormCalcUtil.trimSign(sBuf);
                                sFormula.append('\"');
                                sFormula.append((CharSequence)sBuf);
                                sFormula.append('\"');
                                break block16;
                            }
                            case 1: {
                                sFormula.append("%null%");
                                break block16;
                            }
                            default: {
                                throw new CalcException(oArgs[i]);
                            }
                        }
                        break;
                    }
                    if (i >= nArgs - 1) continue;
                    sFormula.append(',');
                }
                sFormula.append(')');
                oRetSym = new CalcSymbol();
                oRetSym.setName(sFormula.toString());
                oRetSym.setObjValues(oObj);
                oRetSym.setType(9);
            }
            catch (CalcException e) {
                oParser.mbInThrow = true;
                oRetSym = e.getSymbol();
            }
            oParser.mStack.push(oRetSym);
        }
        for (int i = nArgs - 1; i >= 0; --i) {
            CalcSymbol.delete(oArgs[i], oParser);
        }
        oParser.moCode.mnProgCtr = nPC + 3;
    }

    static void IfFunc(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        int nArgs = (Integer)oParser.moCode.moCodeBase[nPC + 1];
        oParser.moCode.execute(oParser, nPC + 4);
        CalcSymbol[] oArgs = new CalcSymbol[nArgs];
        for (int i = nArgs; i > 0; --i) {
            oArgs[i - 1] = oParser.mStack.pop();
        }
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            CalcSymbol oRetSym = null;
            try {
                for (int i = nArgs - 1; i >= 0; --i) {
                    oParser.getExceptions(oArgs[i]);
                }
                oRetSym = new CalcSymbol(0);
            }
            catch (CalcException e) {
                oParser.mbInThrow = true;
                oRetSym = e.getSymbol();
            }
            oParser.mStack.push(oRetSym);
        } else {
            BuiltinLogical.If(oParser, oArgs);
        }
        for (int i = nArgs - 1; i >= 0; --i) {
            CalcSymbol.delete(oArgs[i], oParser);
        }
        oParser.moCode.mnProgCtr = nPC + (Integer)oParser.moCode.moCodeBase[nPC + 3];
    }

    static void While(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            oParser.mStack.push(new CalcSymbol());
        } else {
            oParser.moCode.execute(oParser, nPC + 3);
            CalcSymbol oSym = oParser.mStack.pop();
            CalcSymbol oDoSym = new CalcSymbol(0);
            try {
                double nVal = oParser.getNumeric(oSym);
                while (nVal != 0.0) {
                    oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 1]);
                    CalcSymbol.delete(oSym, oParser);
                    oDoSym = oParser.mStack.pop();
                    String sVal = oParser.getString(oDoSym);
                    CalcSymbol.delete(oSym, oParser);
                    oDoSym = new CalcSymbol(sVal);
                    if (oParser.mbInBreak) break;
                    if (oParser.mbInContinue) {
                        oParser.mbInContinue = false;
                    }
                    oParser.moCode.execute(oParser, nPC + 3);
                    CalcSymbol.delete(oSym, oParser);
                    oSym = oParser.mStack.pop();
                    nVal = oParser.getNumeric(oSym);
                }
                oParser.mStack.push(oDoSym);
            }
            catch (CalcException e) {
                CalcSymbol.delete(oSym, oParser);
                oParser.mStack.push(e.getSymbol());
            }
            CalcSymbol.delete(oSym, oParser);
            if (oParser.mbInBreak) {
                oParser.mbInBreak = false;
            }
        }
        oParser.moCode.mnProgCtr = nPC + (Integer)oParser.moCode.moCodeBase[nPC + 2];
    }

    static void If(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            oParser.mStack.push(new CalcSymbol());
        } else {
            oParser.moCode.execute(oParser, nPC + 4);
            CalcSymbol oSym = oParser.mStack.pop();
            try {
                double nVal = oParser.getNumeric(oSym);
                if (nVal != 0.0) {
                    oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 1]);
                } else if (oParser.moCode.moCodeBase[nPC + 2] != gStop) {
                    oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 2]);
                } else {
                    oParser.mStack.push(new CalcSymbol(0));
                }
            }
            catch (CalcException e) {
                oParser.mbInThrow = true;
                oParser.mStack.push(e.getSymbol());
            }
            CalcSymbol.delete(oSym, oParser);
        }
        oParser.moCode.mnProgCtr = nPC + (Integer)oParser.moCode.moCodeBase[nPC + 3];
    }

    static void For(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            oParser.mStack.push(new CalcSymbol());
        } else {
            oParser.moCode.execute(oParser, nPC + 5);
            oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 1]);
            CalcSymbol oSym = oParser.mStack.pop();
            CalcSymbol oDoSym = new CalcSymbol(0);
            try {
                double nVal = oParser.getNumeric(oSym);
                while (nVal != 0.0) {
                    oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 3]);
                    CalcSymbol.delete(oSym, oParser);
                    oDoSym = oParser.mStack.pop();
                    String sVal = oParser.getString(oDoSym);
                    CalcSymbol.delete(oSym, oParser);
                    oDoSym = new CalcSymbol(sVal);
                    if (oParser.mbInBreak) break;
                    if (oParser.mbInContinue) {
                        oParser.mbInContinue = false;
                    }
                    oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 2]);
                    oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 1]);
                    CalcSymbol.delete(oSym, oParser);
                    oSym = oParser.mStack.pop();
                    nVal = oParser.getNumeric(oSym);
                }
                oParser.mStack.push(oDoSym);
            }
            catch (CalcException e) {
                CalcSymbol.delete(oSym, oParser);
                oParser.mbInThrow = true;
                oParser.mStack.push(e.getSymbol());
            }
            CalcSymbol.delete(oSym, oParser);
            if (oParser.mbInBreak) {
                oParser.mbInBreak = false;
            }
            if (oParser.mbInContinue) {
                oParser.mbInContinue = false;
            }
        }
        oParser.moCode.mnProgCtr = nPC + (Integer)oParser.moCode.moCodeBase[nPC + 4];
    }

    static void Foreach(CalcParser oParser) {
        int nPC = oParser.moCode.mnProgCtr - 1;
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            oParser.mStack.push(new CalcSymbol());
        } else {
            int nInArgs = (Integer)oParser.moCode.moCodeBase[nPC + 1];
            if (nInArgs == 0) {
                ++nInArgs;
            }
            CalcSymbol[] oInSym = new CalcSymbol[nInArgs];
            oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 2]);
            int i = 0;
            while (i < nInArgs) {
                CalcSymbol oArg = oParser.mStack.pop();
                if (oArg.getType() != 9) {
                    oInSym[i++] = oArg;
                    continue;
                }
                CalcSymbol[] oSyms = null;
                try {
                    oSyms = oParser.moScriptHost.getItemValue(oArg.getName(), oArg.getObjValues());
                    int nSyms = oSyms.length;
                    if (nSyms > 1) {
                        CalcSymbol[] oNewSym = new CalcSymbol[nInArgs += nSyms - 1];
                        System.arraycopy(oInSym, 0, oNewSym, 0, nInArgs - nSyms + 1);
                        oInSym = oNewSym;
                        for (int j = 0; j < nSyms; ++j) {
                            oInSym[i++] = oSyms[j];
                        }
                    } else {
                        oInSym[i++] = oSyms[0];
                    }
                }
                catch (CalcException e) {
                    oParser.mbInThrow = true;
                    oInSym[i++] = e.getSymbol();
                }
                CalcSymbol.delete(oArg, oParser);
            }
            CalcSymbol oSym = new CalcSymbol(0);
            CalcSymbol oDoSym = new CalcSymbol(0);
            try {
                for (int i2 = nInArgs - 1; i2 >= 0; --i2) {
                    oParser.mStack.push(oInSym[i2]);
                    oParser.moCode.execute(oParser, nPC + 5);
                    CalcSymbol.delete(oSym, oParser);
                    oSym = oParser.mStack.pop();
                    oParser.getNumeric(oSym);
                    oParser.moCode.execute(oParser, nPC + (Integer)oParser.moCode.moCodeBase[nPC + 3]);
                    CalcSymbol.delete(oDoSym, oParser);
                    oDoSym = oParser.mStack.pop();
                    String sVal = oParser.getString(oDoSym);
                    CalcSymbol.delete(oDoSym, oParser);
                    oDoSym = new CalcSymbol(sVal);
                    if (oParser.mbInBreak) break;
                    if (!oParser.mbInContinue) continue;
                    oParser.mbInContinue = false;
                }
                oParser.mStack.push(oDoSym);
            }
            catch (CalcException e) {
                CalcSymbol.delete(oSym, oParser);
                oParser.mbInThrow = true;
                oParser.mStack.push(e.getSymbol());
            }
            CalcSymbol.delete(oSym, oParser);
            if (oParser.mbInBreak) {
                oParser.mbInBreak = false;
            }
            if (oParser.mbInContinue) {
                oParser.mbInContinue = false;
            }
        }
        oParser.moCode.mnProgCtr = nPC + (Integer)oParser.moCode.moCodeBase[nPC + 4];
    }

    static void Unary(CalcParser oParser, Method oUnop) {
        CalcSymbol oSym = oParser.mStack.pop();
        CalcSymbol oRetSym = new CalcSymbol();
        try {
            if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                oParser.getExceptions(oSym);
                oRetSym = new CalcSymbol(0);
            } else {
                if (oUnop == gUminus) {
                    double nVal = oParser.getNumeric(oSym);
                    if (nVal < 0.0) {
                        oRetSym = new CalcSymbol(-nVal);
                    } else {
                        StringBuilder sVal = new StringBuilder("-");
                        sVal.append(FormCalcUtil.dblToStr(nVal, 11));
                        FormCalcUtil.trimZeroes(sVal);
                        FormCalcUtil.trimRadix(sVal);
                        oRetSym = new CalcSymbol(sVal.toString());
                    }
                } else if (oUnop == gUplus) {
                    double nVal = oParser.getNumeric(oSym);
                    if (nVal < 0.0) {
                        oRetSym = new CalcSymbol(nVal);
                    } else {
                        StringBuilder sVal = new StringBuilder("+");
                        sVal.append(FormCalcUtil.dblToStr(nVal, 11));
                        FormCalcUtil.trimZeroes(sVal);
                        FormCalcUtil.trimRadix(sVal);
                        oRetSym = new CalcSymbol(sVal.toString());
                    }
                } else if (oUnop == gNot) {
                    double nVal = oParser.getNumeric(oSym);
                    oRetSym = new CalcSymbol(nVal == 0.0 ? 1.0 : 0.0);
                } else if (oUnop == gNoop) {
                    oRetSym = new CalcSymbol(oSym);
                } else if (oUnop == gDeref && (oRetSym = new CalcSymbol(oSym)).getType() == 9) {
                    CalcSymbol oTmpSym = oParser.getOneValue(oRetSym);
                    CalcSymbol.delete(oRetSym, oParser);
                    oRetSym = oTmpSym;
                }
                if (oRetSym.getType() == 0) {
                    oParser.mbInThrow = true;
                }
            }
        }
        catch (CalcException e) {
            oParser.mbInThrow = true;
            oRetSym = e.getSymbol();
        }
        CalcSymbol.delete(oSym, oParser);
        oParser.mStack.push(oRetSym);
    }

    private static void Binary(CalcParser oParser, Method oBinop) {
        CalcSymbol rSym = oParser.mStack.pop();
        CalcSymbol lSym = oParser.mStack.pop();
        CalcSymbol oRetSym = null;
        try {
            if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                oParser.getExceptions(lSym);
                oParser.getExceptions(rSym);
                oRetSym = new CalcSymbol(0);
            } else if (oBinop != gList) {
                int rSymType;
                int lSymType = lSym.getType();
                if (lSymType == 9) {
                    CalcSymbol oSym = oParser.getOneValue(lSym);
                    CalcSymbol.delete(lSym, oParser);
                    lSym = oSym;
                    lSymType = lSym.getType();
                }
                if (lSymType == 5 && lSym.getStringValue() == null) {
                    lSymType = 1;
                }
                if ((rSymType = rSym.getType()) == 9) {
                    CalcSymbol oSym = oParser.getOneValue(rSym);
                    CalcSymbol.delete(rSym, oParser);
                    rSym = oSym;
                    rSymType = rSym.getType();
                }
                if (rSymType == 5 && rSym.getStringValue() == null) {
                    rSymType = 1;
                }
                if (lSymType == 1 && rSymType == 1) {
                    oRetSym = new CalcSymbol();
                } else {
                    double lVal = oParser.getNumeric(lSym);
                    double rVal = oParser.getNumeric(rSym);
                    double nRetVal = Double.NaN;
                    if (oBinop == gOr) {
                        nRetVal = lVal != 0.0 || rVal != 0.0 ? 1.0 : 0.0;
                    } else if (oBinop == gAnd) {
                        nRetVal = lVal != 0.0 && rVal != 0.0 ? 1.0 : 0.0;
                    } else if (oBinop == gAdd) {
                        nRetVal = lVal + rVal;
                    } else if (oBinop == gSub) {
                        nRetVal = lVal - rVal;
                    } else if (oBinop == gMul) {
                        nRetVal = lVal * rVal;
                    } else if (oBinop == gDiv) {
                        nRetVal = lVal / rVal;
                    }
                    oRetSym = new CalcSymbol(nRetVal);
                    if (oRetSym.getType() == 0) {
                        oParser.mbInThrow = true;
                    }
                }
            } else {
                oParser.getExceptions(lSym);
                oRetSym = oParser.getOneValue(rSym);
            }
        }
        catch (CalcException e) {
            oParser.mbInThrow = true;
            oRetSym = e.getSymbol();
        }
        CalcSymbol.delete(lSym, oParser);
        CalcSymbol.delete(rSym, oParser);
        oParser.mStack.push(oRetSym);
    }

    private static void Relational(CalcParser oParser, Method oRelop) {
        CalcSymbol rSym = oParser.mStack.pop();
        CalcSymbol lSym = oParser.mStack.pop();
        CalcSymbol oRetSym = null;
        try {
            if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                oParser.getExceptions(rSym);
                oParser.getExceptions(lSym);
                oRetSym = new CalcSymbol(0);
            } else {
                int rActualSymType;
                int lActualSymType;
                int rSymType;
                double nRetVal = 0.0;
                CalcSymbol[] oSymArg = new CalcSymbol[]{lSym, rSym};
                Builtins.limitExceptionArgs(oSymArg);
                int lSymType = lSym.getType();
                if (lSymType == 9) {
                    CalcSymbol oSym = oParser.getOneValue(lSym);
                    CalcSymbol.delete(lSym, oParser);
                    lSym = oSym;
                    lSymType = lSym.getType();
                }
                if ((rSymType = rSym.getType()) == 9) {
                    CalcSymbol oSym = oParser.getOneValue(rSym);
                    CalcSymbol.delete(rSym, oParser);
                    rSym = oSym;
                    rSymType = rSym.getType();
                }
                if (oParser.moLegacyScripting.contains((Object)CalcParser.LegacyVersion.V32_SCRIPTING)) {
                    lActualSymType = lSymType;
                    rActualSymType = rSymType;
                } else {
                    lActualSymType = oParser.getActualType(lSym).getType();
                    rActualSymType = oParser.getActualType(rSym).getType();
                }
                if ((oRelop == gEq || oRelop == gNe) && lSymType == 6 && rSymType == 6) {
                    if (oRelop == gEq) {
                        nRetVal = lSym.getObjValue() == rSym.getObjValue() ? 1.0 : 0.0;
                    } else if (oRelop == gNe) {
                        nRetVal = lSym.getObjValue() != rSym.getObjValue() ? 1.0 : 0.0;
                    }
                } else if (lSym.isNumeric() && rSym.isNumeric()) {
                    double rVal = oParser.getNumeric(rSym);
                    double lVal = oParser.getNumeric(lSym);
                    if (oRelop == gEq) {
                        nRetVal = lVal == rVal ? 1.0 : 0.0;
                    } else if (oRelop == gNe) {
                        nRetVal = lVal != rVal ? 1.0 : 0.0;
                    } else if (oRelop == gGt) {
                        nRetVal = lVal > rVal ? 1.0 : 0.0;
                    } else if (oRelop == gGe) {
                        nRetVal = lVal >= rVal ? 1.0 : 0.0;
                    } else if (oRelop == gLt) {
                        nRetVal = lVal < rVal ? 1.0 : 0.0;
                    } else if (oRelop == gLe) {
                        nRetVal = lVal <= rVal ? 1.0 : 0.0;
                    }
                } else if (!(lSymType != 2 && lSymType != 5 || rSymType != 2 && rSymType != 5)) {
                    String rStr = oParser.getString(rSym);
                    String lStr = oParser.getString(lSym);
                    Collator oCol = Collator.getInstance();
                    if (oRelop == gEq) {
                        nRetVal = oCol.compare(lStr, rStr) == 0 ? 1.0 : 0.0;
                    } else if (oRelop == gNe) {
                        nRetVal = oCol.compare(lStr, rStr) != 0 ? 1.0 : 0.0;
                    } else if (oRelop == gGt) {
                        nRetVal = oCol.compare(lStr, rStr) > 0 ? 1.0 : 0.0;
                    } else if (oRelop == gGe) {
                        nRetVal = oCol.compare(lStr, rStr) >= 0 ? 1.0 : 0.0;
                    } else if (oRelop == gLt) {
                        nRetVal = oCol.compare(lStr, rStr) < 0 ? 1.0 : 0.0;
                    } else if (oRelop == gLe) {
                        nRetVal = oCol.compare(lStr, rStr) <= 0 ? 1.0 : 0.0;
                    }
                } else if (lActualSymType == 1 || rActualSymType == 1) {
                    oParser.getNumeric(rSym);
                    oParser.getNumeric(lSym);
                    if (oRelop == gEq) {
                        nRetVal = lActualSymType == rActualSymType ? 1.0 : 0.0;
                    } else if (oRelop == gNe) {
                        nRetVal = lActualSymType != rActualSymType ? 1.0 : 0.0;
                    } else if (oRelop == gGt) {
                        nRetVal = 0.0;
                    } else if (oRelop == gGe) {
                        nRetVal = lActualSymType == rActualSymType ? 1.0 : 0.0;
                    } else if (oRelop == gLt) {
                        nRetVal = 0.0;
                    } else if (oRelop == gLe) {
                        nRetVal = lActualSymType == rActualSymType ? 1.0 : 0.0;
                    }
                } else {
                    double rVal = oParser.getNumeric(rSym);
                    double lVal = oParser.getNumeric(lSym);
                    if (oRelop == gEq) {
                        nRetVal = lVal == rVal ? 1.0 : 0.0;
                    } else if (oRelop == gNe) {
                        nRetVal = lVal != rVal ? 1.0 : 0.0;
                    } else if (oRelop == gGt) {
                        nRetVal = lVal > rVal ? 1.0 : 0.0;
                    } else if (oRelop == gGe) {
                        nRetVal = lVal >= rVal ? 1.0 : 0.0;
                    } else if (oRelop == gLt) {
                        nRetVal = lVal < rVal ? 1.0 : 0.0;
                    } else if (oRelop == gLe) {
                        nRetVal = lVal <= rVal ? 1.0 : 0.0;
                    }
                }
                oRetSym = new CalcSymbol(nRetVal);
                if (oRetSym.getType() == 0) {
                    oParser.mbInThrow = true;
                }
            }
        }
        catch (CalcException e) {
            oParser.mbInThrow = true;
            oRetSym = e.getSymbol();
        }
        CalcSymbol.delete(rSym, oParser);
        CalcSymbol.delete(lSym, oParser);
        oParser.mStack.push(oRetSym);
    }

    private static void Concat(CalcParser oParser, Method oCatop) {
        CalcSymbol rSym = oParser.mStack.pop();
        CalcSymbol lSym = oParser.mStack.pop();
        CalcSymbol oRetSym = null;
        try {
            if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
                oParser.getExceptions(rSym);
                oParser.getExceptions(lSym);
                oRetSym = new CalcSymbol(0);
            } else {
                if (rSym.getType() == 0) {
                    oParser.mbInThrow = true;
                    throw new CalcException(rSym);
                }
                if (rSym.getType() == 5) {
                    oParser.mbInThrow = true;
                    MsgFormat sFmt = new MsgFormat(ResId.FC_ERR_VAR_USED);
                    sFmt.format(rSym.getName());
                    CalcSymbol oSym = new CalcSymbol(sFmt.toString(), true, 0, 0);
                    throw new CalcException(oSym);
                }
                if (rSym.getType() == 6) {
                    oParser.mbInThrow = true;
                    MsgFormat sFmt = new MsgFormat(ResId.FC_ERR_REF_USED);
                    sFmt.format(rSym.getName());
                    CalcSymbol oSym = new CalcSymbol(sFmt.toString(), true, 0, 0);
                    throw new CalcException(oSym);
                }
                String rContainer = rSym.getName();
                String lContainer = lSym.getType() == 6 ? "#0" : lSym.getName();
                StringBuilder sResult = new StringBuilder(lContainer.length() + 2 + rContainer.length());
                sResult.append(lContainer);
                sResult.append('.');
                if (oCatop == gDotdot) {
                    sResult.append('.');
                } else if (oCatop == gDothash) {
                    sResult.append('#');
                }
                sResult.append(rContainer);
                oRetSym = new CalcSymbol();
                oRetSym.setName(sResult.toString());
                if (lSym.getType() == 9) {
                    if (rSym.getObjs() > 1) {
                        Obj[] oObj = rSym.getObjValues();
                        oObj[0] = lSym.getObjValue();
                        oRetSym.setObjValues(oObj);
                    } else {
                        oRetSym.setObjValue(lSym.getObjValue());
                    }
                } else if (lSym.getType() == 6) {
                    if (rSym.getObjs() > 1) {
                        Obj[] oObj = rSym.getObjValues();
                        oObj[0] = lSym.getObjValue();
                        oRetSym.setObjValues(oObj);
                    } else {
                        oRetSym.setObjValue(lSym.getObjValue());
                    }
                }
                oRetSym.setType(9);
            }
        }
        catch (CalcException e) {
            oParser.mbInThrow = true;
            oRetSym = e.getSymbol();
        }
        CalcSymbol.delete(rSym, oParser);
        CalcSymbol.delete(lSym, oParser);
        oParser.mStack.push(oRetSym);
    }

    private static void Assign(CalcParser oParser, Method oAsgnop) {
        CalcSymbol rSym = new CalcSymbol();
        CalcSymbol lSym = new CalcSymbol();
        if (oAsgnop == gAsgn) {
            rSym = oParser.mStack.pop();
            lSym = oParser.mStack.pop();
        } else if (oAsgnop == gAsgn2) {
            lSym = oParser.mStack.pop();
            rSym = oParser.mStack.pop();
        }
        CalcSymbol oRetSym = null;
        if (oParser.mbInThrow || oParser.mbInBreak || oParser.mbInContinue) {
            try {
                oParser.getExceptions(rSym);
                oParser.getExceptions(lSym);
                oRetSym = new CalcSymbol(0);
            }
            catch (CalcException e) {
                oParser.mbInThrow = true;
                oRetSym = e.getSymbol();
            }
        } else {
            oRetSym = new CalcSymbol(rSym);
            block24: while (true) {
                CalcSymbol oVarSym = null;
                switch (oRetSym.getType()) {
                    case 9: {
                        CalcSymbol oTmpSym = oParser.getOneValue(oRetSym);
                        CalcSymbol.delete(oRetSym, oParser);
                        oRetSym = oTmpSym;
                        continue block24;
                    }
                    case 3: {
                        oRetSym.setTypeToString();
                        break block24;
                    }
                    case 2: {
                        break block24;
                    }
                    case 5: {
                        oVarSym = oParser.moData.lookup(oRetSym);
                        if (oVarSym == oRetSym) break block24;
                        oRetSym.setStringValue(oVarSym.getStringValue());
                        break block24;
                    }
                    case 10: {
                        break block24;
                    }
                    case 1: {
                        break block24;
                    }
                    case 0: {
                        break block24;
                    }
                    case 6: {
                        break block24;
                    }
                }
                break;
            }
            switch (oRetSym.getType()) {
                case 3: 
                case 9: {
                    break;
                }
                case 0: 
                case 10: {
                    oParser.mbInThrow = true;
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    if (lSym.getType() == 6) {
                        try {
                            if (lSym.getObjValue() != null) {
                                oParser.moScriptHost.putItem(lSym.getObjValues(), oRetSym);
                                break;
                            }
                            oParser.mbInThrow = true;
                            MsgFormat sFmt = new MsgFormat(ResId.FC_ERR_REF_NULL);
                            sFmt.format(lSym.getName());
                            oRetSym = new CalcSymbol(sFmt.toString(), true, 0, 0);
                        }
                        catch (CalcException e) {
                            CalcSymbol.delete(oRetSym, oParser);
                            oParser.mbInThrow = true;
                            oRetSym = e.getSymbol();
                        }
                        break;
                    }
                    if (lSym.getType() == 9) {
                        if (oRetSym.getType() == 5) {
                            oRetSym.setTypeToString();
                        } else if (oRetSym.getType() == 3) {
                            oRetSym.setTypeToString();
                        } else if (oRetSym.getType() == 2) {
                            oRetSym.setTypeToString();
                        }
                        try {
                            oParser.moScriptHost.putItemValue(lSym.getName(), lSym.getObjValues(), oRetSym);
                        }
                        catch (CalcException e) {
                            CalcSymbol.delete(oRetSym, oParser);
                            oParser.mbInThrow = true;
                            oRetSym = e.getSymbol();
                        }
                        break;
                    }
                    if (lSym.getType() == 5) {
                        lSym.setStringValue(oRetSym.getStringValue());
                        break;
                    }
                    if (lSym.getType() != 0) break;
                    CalcSymbol.delete(oRetSym, oParser);
                    oRetSym = lSym;
                    break;
                }
                case 6: {
                    if (lSym.getType() == 9) {
                        try {
                            CalcSymbol oTmpSym = oParser.getRefValue(oRetSym);
                            CalcSymbol.delete(oRetSym, oParser);
                            oRetSym = oTmpSym;
                            oParser.moScriptHost.putItemValue(lSym.getName(), lSym.getObjValues(), oRetSym);
                        }
                        catch (CalcException e) {
                            CalcSymbol.delete(oRetSym, oParser);
                            oParser.mbInThrow = true;
                            oRetSym = e.getSymbol();
                        }
                        break;
                    }
                    if (lSym.getType() == 5) {
                        lSym.setScope(0);
                        lSym.setStringValue(null);
                        lSym.setObjValue(oRetSym.getObjValue());
                        lSym.setType(6);
                        break;
                    }
                    if (lSym.getType() != 6) break;
                    Obj oObj = oRetSym.getObjValue();
                    lSym.setObjValue(oObj);
                    if (oObj != null) break;
                    lSym.setScope(oParser.moScope.getScope());
                    lSym.setStringValue("");
                    lSym.setType(5);
                    break;
                }
            }
        }
        CalcSymbol.delete(rSym, oParser);
        CalcSymbol.delete(lSym, oParser);
        oParser.mStack.push(oRetSym);
    }
}

