/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.ScriptDispatcher;
import com.adobe.xfa.form.FormDependencyTracker;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.ResourceLoader;
import com.adobe.xfa.ut.StringUtils;

class ValidateDispatcher
extends ScriptDispatcher {
    private final int meRunAt;
    private final String msBarcodeType;

    ValidateDispatcher(Element scriptContextNode, String sEventContext, int nEventID, EventManager eventManager, String sScript, String sContentType, String sBarcodeType, int eRunAt) {
        super(scriptContextNode, sEventContext, nEventID, eventManager, sScript, sContentType);
        this.meRunAt = eRunAt;
        this.msBarcodeType = sBarcodeType;
    }

    public boolean validate(Element node) {
        if (node == null) {
            return false;
        }
        assert (node instanceof FormField || node instanceof FormSubform || node instanceof FormExclGroup);
        Container container = (Container)node;
        Container.ValidationState eValidationState = container.getValidationState();
        boolean bValidateResult = this.validateInternal(container);
        if (eValidationState != container.getValidationState()) {
            FormModel formModel = (FormModel)node.getModel();
            formModel.addValidationStateChanged(container);
        }
        return bValidateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateInternal(Container node) {
        FormModel.Validate validate;
        boolean bBarcodeTest;
        String sScript = this.getScript();
        String sContentType = this.getContentType();
        FormModel formModel = (FormModel)node.getModel();
        if (!formModel.getValidationsEnabled()) {
            return true;
        }
        int eModelRunAtSetting = formModel.getRunScripts();
        int eRunAt = this.getRunAt();
        if (eModelRunAtSetting == 1080754179) {
            return true;
        }
        if (eModelRunAtSetting == 1080754177 && eRunAt == 1079836672) {
            return true;
        }
        if (eModelRunAtSetting == 1080754176 && eRunAt == 1079836673) {
            return true;
        }
        Arg returnCode = new Arg();
        node.setErrorText("");
        node.setValidationState(Container.ValidationState.VALIDATIONSTATE_VALID);
        Element validateNode = node.getElement(404, true, 0, false, false);
        boolean bNullTest = false;
        boolean bFormatTest = false;
        boolean bScriptTest = false;
        boolean bl = bBarcodeTest = !StringUtils.isEmpty(this.msBarcodeType);
        if (validateNode != null) {
            bNullTest = validateNode.getEnum(578) != 0x380000;
            bFormatTest = validateNode.getEnum(507) != 0x380000;
            boolean bl2 = bScriptTest = validateNode.getEnum(638) != 0x380000;
        }
        if (node instanceof FormField || node instanceof FormExclGroup) {
            formModel.removeDependency(node, false);
            FormDependencyTracker tracker = new FormDependencyTracker(node, false);
            try {
                if (bScriptTest && !StringUtils.isEmpty(sScript)) {
                    returnCode = node.evaluate(sScript, sContentType, 2, true);
                }
                tracker.addDependency(node);
            }
            finally {
                tracker.dispose();
            }
        } else if (!StringUtils.isEmpty(sScript)) {
            returnCode = node.evaluate(sScript, sContentType, 2, true);
        }
        if ((validate = formModel.getValidate()) == null) {
            validate = formModel.getDefaultValidate();
        }
        if (validate != null) {
            FormField formField;
            String sValue;
            if (formModel.isActivityExcluded("validate")) {
                return true;
            }
            if (formModel.isActivityExcluded("scriptTest")) {
                bScriptTest = false;
            } else {
                boolean bl3 = bScriptTest = bScriptTest && validate.isScriptTestEnabled() && !node.getIsNull();
            }
            if (formModel.isActivityExcluded("nullTest")) {
                bNullTest = false;
            } else {
                boolean bl4 = bNullTest = bNullTest && validate.isNullTestEnabled() && node.getIsNull();
            }
            if (formModel.isActivityExcluded("formatTest")) {
                bFormatTest = false;
            } else {
                boolean bl5 = bFormatTest = bFormatTest && validate.isFormatTestEnabled() && !node.getIsNull() && node instanceof FormField;
            }
            bBarcodeTest = formModel.isActivityExcluded("barcodeTest") ? false : bBarcodeTest && validate.isBarcodeTestEnabled() && !node.getIsNull();
            boolean bOldDisableValidate = false;
            if (validateNode != null && validateNode.isPropertySpecified(483, true, 0)) {
                bOldDisableValidate = validateNode.getEnum(483) == 0x40040001;
            }
            BooleanHolder bDisableValidate = new BooleanHolder(bOldDisableValidate);
            if (bBarcodeTest && !validate.validateBarcode(node, this.msBarcodeType, sValue = ((FormField)node).getRawValue())) {
                FormField formField2 = (FormField)node;
                int oResId = 0;
                oResId = StringUtils.isEmpty(sValue) ? ResId.NullBarcodeValue : ResId.InvalidBarcodeValue;
                MsgFormatPos error = new MsgFormatPos(oResId);
                if (!StringUtils.isEmpty(sValue)) {
                    error.format(sValue);
                }
                error.format(this.msBarcodeType);
                String sMessage = error.toString();
                node.setErrorText(sMessage);
                node.setValidationState(Container.ValidationState.VALIDATIONSTATE_BARCODETEST);
                if (!validate.onValidateBarcodeTestFailed(formField2, sMessage)) {
                    return false;
                }
            }
            if (bNullTest) {
                String sMessage = FormModel.getValidationMessage(validateNode, "nullTest");
                boolean bRetVal = validate.onValidateNullTestFailed(node, sMessage, bDisableValidate);
                if (bDisableValidate.value && bDisableValidate.value != bOldDisableValidate) {
                    this.updateDisableAll(node);
                }
                if (StringUtils.isEmpty(sMessage)) {
                    sMessage = ResourceLoader.loadResource(ResId.ValidationFailed);
                }
                node.setErrorText(sMessage);
                node.setValidationState(Container.ValidationState.VALIDATIONSTATE_NULLTEST);
                if (!bRetVal) {
                    return false;
                }
            }
            if (bFormatTest && !(formField = (FormField)node).hasValidFormattedValue()) {
                String sMessage = FormModel.getValidationMessage(validateNode, "formatTest");
                boolean bRetVal = validate.onValidateFormatTestFailed(formField, sMessage, bDisableValidate);
                if (bDisableValidate.value && bDisableValidate.value != bOldDisableValidate) {
                    this.updateDisableAll(node);
                }
                if (StringUtils.isEmpty(sMessage)) {
                    sMessage = ResourceLoader.loadResource(ResId.ValidationFailed);
                }
                node.setErrorText(sMessage);
                node.setValidationState(Container.ValidationState.VALIDATIONSTATE_FORMATTEST);
                if (!bRetVal) {
                    return false;
                }
            }
            boolean bRet = true;
            if (bScriptTest) {
                boolean bValidate;
                if (StringUtils.isEmpty(sScript)) {
                    return true;
                }
                boolean bl6 = bValidate = returnCode.getArgType() == 1 || returnCode.getArgType() == 2 || returnCode.getAsBool(false) != false;
                if (!bValidate) {
                    validateNode = node.getElement(404, 0);
                    String sMessage = FormModel.getValidationMessage(validateNode, "scriptTest");
                    validate.onValidateScriptFailed(node, sScript, sContentType, sMessage, bDisableValidate);
                    if (bDisableValidate.value && bDisableValidate.value != bOldDisableValidate) {
                        this.updateDisableAll(node);
                    }
                    if (StringUtils.isEmpty(sMessage)) {
                        sMessage = ResourceLoader.loadResource(ResId.ValidationFailed);
                    }
                    node.setErrorText(sMessage);
                    node.setValidationState(Container.ValidationState.VALIDATIONSTATE_SCRIPTTEST);
                    bRet = false;
                }
            }
            return bRet;
        }
        return true;
    }

    private void updateDisableAll(Element node) {
        Element validate;
        assert (node != null);
        if (node != null && (validate = node.getElement(404, 0)) != null) {
            validate.setAttribute(EnumValue.getEnum(483, 0x40040001), 483);
        }
    }

    @Override
    public void dispatch() {
        Container poContainerImpl;
        int ePresence;
        TemplateModel templateModel;
        Element node = this.getActionContextNode();
        if (node == null) {
            return;
        }
        AppModel appModel = node.getAppModel();
        if (appModel != null && (templateModel = TemplateModel.getTemplateModel(appModel, false)) != null && templateModel.getOriginalXFAVersion() >= 30 && node instanceof Container && 1076494339 == (ePresence = (poContainerImpl = (Container)node).getRuntimePresence(0))) {
            return;
        }
        this.validate(node);
    }

    @Override
    public String getDispatcherType() {
        return "validate";
    }

    int getRunAt() {
        return this.meRunAt;
    }

    @Override
    public void updateFromPeer(Object peerNode, int eventType, String arg1, Object arg2) {
        Element node = this.getActionContextNode();
        if (node == null) {
            return;
        }
        if (peerNode == node && node instanceof Container && eventType == 1 && arg1.equals("presence")) {
            FormModel formModel = (FormModel)node.getModel();
            formModel.queueCalculatesAndValidates(node, true);
        }
    }
}

