/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Chars;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Comment;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Delta;
import com.adobe.xfa.Dispatcher;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.EventPseudoModel;
import com.adobe.xfa.Generator;
import com.adobe.xfa.HostPseudoModel;
import com.adobe.xfa.Int;
import com.adobe.xfa.ListBase;
import com.adobe.xfa.LogMessenger;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Packet;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.RichTextNode;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.XMLMultiSelectNode;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.data.DataWindow;
import com.adobe.xfa.form.CalculateDispatcher;
import com.adobe.xfa.form.ExecuteDispatcher;
import com.adobe.xfa.form.FormChoiceListField;
import com.adobe.xfa.form.FormDataListener;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormInstanceManager;
import com.adobe.xfa.form.FormItemsDataListener;
import com.adobe.xfa.form.FormListener;
import com.adobe.xfa.form.FormModelScript;
import com.adobe.xfa.form.FormSchema;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.form.FormSubformSet;
import com.adobe.xfa.form.ScriptRunAtDispatcher;
import com.adobe.xfa.form.SignDispatcher;
import com.adobe.xfa.form.SubmitDispatcher;
import com.adobe.xfa.form.ValidateDispatcher;
import com.adobe.xfa.service.storage.XMLStorage;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.Value;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.PageArea;
import com.adobe.xfa.template.containers.PageSet;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.containers.SubformSet;
import com.adobe.xfa.ut.Base64;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.ut.PictureFmt;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.trace.Trace;
import com.adobe.xfa.ut.trace.TraceHandler;
import com.adobe.xfa.ut.trace.TraceTimer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class FormModel
extends Model {
    private static final ConnectHandler mConnectExportHandler = new ConnectHandler(){

        @Override
        public boolean handleConnect(Node formNode, String sConnectionRootRef, String sConnectRef, String sConnectPicture, Object handlerData, ObjectHolder<DataNode> ioRecursingData) {
            Model formModel = formNode.getModel();
            assert (formModel != null);
            AppModel appModel = (AppModel)formModel.getXFAParent();
            DataNode dataNode = null;
            DataNode connectionDataNode = (DataNode)appModel.resolveNode(sConnectionRootRef, false, false, true);
            assert (connectionDataNode != null);
            DataNode parentNode = (DataNode)ioRecursingData.value;
            NodeList nodes = parentNode != null ? parentNode.resolveNodes(sConnectRef, true, false, true) : connectionDataNode.resolveNodes(sConnectRef, true, false, true);
            boolean bMultiple = FormModel.isSomMultiple(sConnectRef);
            int nLen = nodes.length();
            for (int i = 0; i < nLen; ++i) {
                Node resolvedNode = (Node)nodes.item(i);
                if (bMultiple && resolvedNode.isMapped() || dataNode != null) continue;
                dataNode = (DataNode)resolvedNode;
                break;
            }
            if (dataNode == null) {
                DataModel dataModel = DataModel.getDataModel(appModel, false, false);
                boolean bUseDV = FormModel.useDV(formNode);
                dataNode = parentNode != null ? (DataNode)dataModel.resolveRef(sConnectRef, parentNode, bUseDV, false) : (DataNode)dataModel.resolveRef(sConnectRef, connectionDataNode, bUseDV, false);
            }
            if (dataNode != null) {
                if (dataNode.getIsDDPlaceholder()) {
                    dataNode.setIsDDPlaceholder(false);
                }
                if (formNode instanceof FormField) {
                    ((FormField)formNode).setDataNode(dataNode, true, false, sConnectPicture, true);
                    ((FormModel)formModel).consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
                } else if (formNode instanceof FormExclGroup) {
                    ((FormExclGroup)formNode).setDataNode(dataNode, true, false);
                    ((FormModel)formModel).consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
                } else if (formNode instanceof FormSubform) {
                    ((FormModel)formModel).consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
                    ioRecursingData.value = dataNode;
                }
            }
            return true;
        }
    };
    private static final ConnectHandler mConnectImportHandler = new ConnectHandler(){

        @Override
        public boolean handleConnect(Node formNode, String sConnectionRootRef, String sConnectRef, String sConnectPicture, Object handlerData, ObjectHolder<DataNode> ioRecursingData) {
            FormModel formModel = (FormModel)formNode.getModel();
            assert (formModel != null);
            AppModel appModel = formNode.getModel().getAppModel();
            DataNode parentNode = (DataNode)ioRecursingData.value;
            String sDataRef = sConnectRef;
            boolean bMultiple = FormModel.isSomMultiple(sDataRef);
            NodeList resolvedDataNodes = parentNode != null ? parentNode.resolveNodes(sDataRef, true, false, true) : appModel.resolveNodes(sDataRef, true, false, true);
            if (resolvedDataNodes.length() != 0) {
                DataNode dataNode = null;
                for (int i = 0; i < resolvedDataNodes.length(); ++i) {
                    DataNode item = (DataNode)resolvedDataNodes.item(i);
                    if (bMultiple && item.isMapped()) continue;
                    dataNode = item;
                    break;
                }
                if (dataNode != null) {
                    if (formNode instanceof FormField) {
                        ((FormField)formNode).setDataNode(dataNode, false, false, sConnectPicture, false);
                        formModel.consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
                    } else if (formNode instanceof FormExclGroup) {
                        ((FormExclGroup)formNode).setDataNode(dataNode, false, false);
                        formModel.consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
                    } else if (formNode instanceof FormSubform) {
                        formModel.consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
                        ioRecursingData.value = dataNode;
                    }
                    if (formNode instanceof Container) {
                        ((FormModel)formNode.getModel()).setConnectionDataContextInfo((Container)formNode, dataNode);
                    }
                }
            }
            return true;
        }
    };
    private static final ConnectHandler mConnectImportPermCheckHandler = new ConnectHandler(){

        @Override
        public boolean handleConnect(Node formNode, String sConnectionRootRef, String sConnectRef, String sConnectPicture, Object handlerData, ObjectHolder<DataNode> ioRecursingData) {
            assert (handlerData != null);
            BooleanHolder overallResult = (BooleanHolder)handlerData;
            AppModel appModel = formNode.getModel().getAppModel();
            Node parentNode = (Node)ioRecursingData.value;
            String sDataRef = sConnectRef;
            boolean bMultiple = FormModel.isSomMultiple(sDataRef);
            NodeList resolvedDataNodes = parentNode != null ? parentNode.resolveNodes(sDataRef, true, false, true) : appModel.resolveNodes(sDataRef, true, false, true);
            if (resolvedDataNodes.length() != 0) {
                DataNode dataNode = null;
                for (int i = 0; i < resolvedDataNodes.length(); ++i) {
                    DataNode item = (DataNode)resolvedDataNodes.item(i);
                    if (bMultiple && item.isMapped()) continue;
                    dataNode = item;
                    break;
                }
                if (dataNode != null) {
                    if (formNode instanceof FormSubform) {
                        ioRecursingData.value = dataNode;
                    }
                    if (!formNode.checkPerms() || !formNode.checkAncestorPerms()) {
                        overallResult.value = false;
                    }
                }
            }
            return overallResult.value;
        }
    };
    private static final FormSchema gsFormSchema = new FormSchema();
    static final int XFAEVENTTYPE_EVENTS = 1;
    static final int XFAEVENTTYPE_CALCULATE = 2;
    static final int XFAEVENTTYPE_VALIDATE = 4;
    static final int XFAEVENTTYPE_ALL = 7;
    private static final int CYCLE_MAX = 10;
    private static final Boolean UPDATE_DATA = true;
    private boolean mbWeightedData;
    private boolean mbAdjustData;
    private boolean mbEmptyMerge;
    private boolean mbMergeComplete = true;
    private boolean mbAllowNewNodes;
    private boolean mbExchangingDataWithServer;
    private boolean mbRegisterNewEvents = true;
    private boolean mbValidateBeforeSubmit;
    private boolean mbValidateBeforeExecute;
    private DataModel mDataModel;
    private TemplateModel mTemplateModel;
    private DataNode mStartNode;
    private final List<DataNode> mGlobalDataNodes = new ArrayList<DataNode>();
    private final List<Element> mExplicitMatchNodes = new ArrayList<Element>();
    private int mnCalcEventId;
    private int mnValidateEventId;
    private int mnValidationStateEventId;
    private boolean mbRecursiveIndexChange;
    private boolean mbEnableIncrementalMerge = true;
    private boolean mbWasIncrementalMerge;
    private final List<Node> mPendingCalculateNodes = new ArrayList<Node>();
    private int mnNextPendingCalculateNode;
    private final List<Node> mPendingValidateNodes = new ArrayList<Node>();
    private int mnNextPendingValidateNode;
    private final List<Node> mNewValidateNodes = new ArrayList<Node>();
    private Validate mValidate;
    private Validate mDefaultValidate;
    private final List<Container> moValidationStateChanges = new ArrayList<Container>();
    private int mnValidationRecursionDepth;
    private final List<LayoutContentInfo> mLayoutContent = new ArrayList<LayoutContentInfo>();
    private Subform mRootSubform;
    private FormSubform mRootFormSubform;
    private Element mCurrentPageSet;
    private DataNode mDataDescription;
    private String msLocale = "";
    private boolean mbMatchDescendantsOnly = false;
    private String msSubmitURL;
    private String[] mExcludeList;
    private int meRunAtSetting = 1080754178;
    private ServerExchange mServerExchange;
    private Submit mSubmit;
    private Execute mExecute;
    private HostPseudoModel mHostPseudoModel;
    private EventPseudoModel mEventPseudoModel;
    private boolean mbIgnoreCalcEnabledFlag;
    private boolean mbIgnoreValidationsEnabledFlag;
    private String msConnectionName;
    private boolean mbConnectionMerge;
    private boolean mbFormStateUsage;
    private boolean mbFormStateRemoved;
    private boolean mbOverlayDataMergeUsage;
    private int mnPanel;
    private boolean mbIsXFAF;
    private FormField mActiveField;
    private FormField mPrevActiveField;
    private FormSubform mDeltasSubform;
    private boolean mbRestoreDeltas;
    private boolean mbForceRestore;
    private boolean mbIsCalculating;
    private boolean mbDisableRemerge = false;
    private boolean mbSkipCyclicAndDuplicateCheck = false;
    private boolean mbGlobalConsumption = true;
    private PostMergeHandler mPostMergeHandler;
    private Object mPostMergeHandlerClientData;

    private static boolean getConnectSOMStrings(Node node, String strConnectionName, int eUsage, StringHolder outConnectionRootRef, StringHolder outConnectRef, StringHolder sConnectPicture) {
        Element connectNode = null;
        if (node instanceof Field || node instanceof ExclGroup || node instanceof Subform) {
            connectNode = ((Container)node).getConnectNode(strConnectionName, eUsage, false);
        }
        if (connectNode != null) {
            TextNode textNode;
            Element picture;
            outConnectRef.value = connectNode.getAttribute(392).toString();
            outConnectionRootRef.value = "!connectionData." + strConnectionName;
            if (sConnectPicture != null && (picture = connectNode.getElement(242, true, 0, false, false)) != null && (textNode = picture.getText(true, false, false)) != null) {
                sConnectPicture.value = textNode.getValue();
            }
            return true;
        }
        return false;
    }

    static DataNode getDataNode(Node formNode) {
        if (null != formNode) {
            if (formNode instanceof FormField) {
                return ((FormField)formNode).getDataNode();
            }
            if (formNode instanceof FormChoiceListField) {
                return ((FormChoiceListField)formNode).getDataNode();
            }
            if (formNode instanceof FormSubform) {
                return ((FormSubform)formNode).getDataNode();
            }
            if (formNode instanceof FormExclGroup) {
                return ((FormExclGroup)formNode).getDataNode();
            }
        }
        return null;
    }

    public static FormModel getFormModel(AppModel appModel, boolean bCreateIfNotFound) {
        FormModel form = null;
        if (appModel != null) {
            TemplateModel template = null;
            for (Node child = appModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (child instanceof FormModel) {
                    form = (FormModel)child;
                    continue;
                }
                if (!(child instanceof TemplateModel)) continue;
                template = (TemplateModel)child;
            }
            if (bCreateIfNotFound && form == null && template != null) {
                FormModel newFormModel = new FormModel(appModel, null);
                newFormModel.setDocument(Document.createDocument(appModel));
                newFormModel.setXmlPeer(new ModelPeer(newFormModel.getDocument(), null, "http://www.xfa.org/schema/xfa-form/2.8/", "form", "form", null, newFormModel));
                appModel.notifyPeers(4, "form", newFormModel);
                return FormModel.getFormModel(appModel, false);
            }
        }
        return form;
    }

    static Element getMappedParent(Node formNode) {
        if (formNode == null) {
            return null;
        }
        Element parent = formNode.getXFAParent();
        if (parent == null) {
            return parent;
        }
        if (parent.isMapped()) {
            DataNode dataNode = FormModel.getDataNode(parent);
            if (dataNode == null) {
                return FormModel.getMappedParent(parent);
            }
            return parent;
        }
        return FormModel.getMappedParent(parent);
    }

    private static Schema getModelSchema() {
        return gsFormSchema;
    }

    static String getValidationMessage(Element validateNode, String aType) {
        return TemplateModel.getValidationMessage(validateNode, aType);
    }

    private static boolean incrementalMergeCheckDataDescription(Node dataDescriptionNode) {
        if (dataDescriptionNode instanceof Element) {
            String sModel;
            boolean bVariableOccurrence;
            String sMaxOccur;
            String sMinOccur;
            Element element = (Element)dataDescriptionNode;
            int nMinOccur = 1;
            int nMaxOccur = 1;
            int index = element.findAttr("http://ns.adobe.com/data-description/", "minOccur");
            if (index != -1 && !StringUtils.isEmpty(sMinOccur = element.getAttrVal(index))) {
                try {
                    nMinOccur = Integer.parseInt(sMinOccur);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if ((index = element.findAttr("http://ns.adobe.com/data-description/", "maxOccur")) != -1 && !StringUtils.isEmpty(sMaxOccur = element.getAttrVal(index))) {
                try {
                    nMaxOccur = Integer.parseInt(sMaxOccur);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            boolean bl = bVariableOccurrence = nMinOccur != nMaxOccur || nMinOccur == -1 || nMaxOccur == -1;
            if (bVariableOccurrence) {
                return false;
            }
            index = element.findAttr("http://ns.adobe.com/data-description/", "model");
            if (index != -1 && ((sModel = element.getAttrVal(index)).equals("choice") || sModel.equals("unordered"))) {
                return false;
            }
            for (Node child = element.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (FormModel.incrementalMergeCheckDataDescription(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static void recurseConnectOnNode(Node node, String strConnectionName, int eUsage, ConnectHandler handler, Object handlerData) {
        ObjectHolder<DataNode> recursingData = new ObjectHolder<DataNode>();
        FormModel.recurseConnectOnNodeHelper(node, strConnectionName, eUsage, handler, handlerData, recursingData);
    }

    private static boolean recurseConnectOnNodeHelper(Node node, String strConnectionName, int eUsage, ConnectHandler handler, Object handlerData, ObjectHolder<DataNode> recursingData) {
        StringHolder strConnectionRootRef = new StringHolder();
        StringHolder strConnectRef = new StringHolder();
        StringHolder strConnectPictureRef = new StringHolder();
        ObjectHolder<DataNode> tempioRecursingData = new ObjectHolder<DataNode>();
        boolean bContinue = true;
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            strConnectionRootRef.value = null;
            strConnectRef.value = null;
            strConnectPictureRef.value = "";
            tempioRecursingData.value = recursingData.value;
            if (child instanceof Container) {
                Container.FormInfo formInfo;
                if (FormModel.getConnectSOMStrings(child, strConnectionName, eUsage, strConnectionRootRef, strConnectRef, strConnectPictureRef)) {
                    bContinue = handler.handleConnect(child, strConnectionRootRef.value, strConnectRef.value, strConnectPictureRef.value, handlerData, tempioRecursingData);
                }
                if (bContinue && eUsage == 6225921 && (child instanceof FormSubform || child instanceof FormField || child instanceof FormExclGroup)) {
                    ((FormModel)child.getModel()).setDynamicProperties((Container)child, strConnectionName, false);
                }
                if (bContinue) {
                    bContinue = FormModel.recurseConnectOnNodeHelper(child, strConnectionName, eUsage, handler, handlerData, tempioRecursingData);
                }
                if ((formInfo = ((Container)child).getFormInfo()) != null) {
                    ((Container)child).setFormInfo(null);
                }
            }
            if (!bContinue) break;
        }
        return bContinue;
    }

    static void setValidationMessage(Element validateNode, String sMessage, String aType) {
        TemplateModel.setValidationMessage(validateNode, sMessage, aType);
    }

    static boolean isSomMultiple(String sSom) {
        if (sSom.indexOf(42) != -1) {
            return true;
        }
        if (sSom.contains(".[")) {
            return true;
        }
        return sSom.contains(".(");
    }

    public FormModel(Element parent, Node prevSibling) {
        super(parent, prevSibling, "http://www.xfa.org/schema/xfa-form/2.8/", "form", "form", "$form", 144, "form", FormModel.getModelSchema());
    }

    void addScriptDependency(Element node, Obj dependsOn, boolean bIsCalculate) {
        List<FormListener> listenerTable = null;
        if (node instanceof FormField) {
            listenerTable = ((FormField)node).getFormListeners(true);
        } else if (node instanceof FormExclGroup) {
            listenerTable = ((FormExclGroup)node).getFormListeners(true);
        } else if (node instanceof FormSubform) {
            listenerTable = ((FormSubform)node).getFormListeners(true);
        }
        if (listenerTable != null && dependsOn instanceof Obj) {
            FormListener listener = new FormListener(this, node, dependsOn, bIsCalculate);
            listenerTable.add(listener);
        }
    }

    @Override
    public void addUseNode(Element useNode) {
        if (this.isLoading() || this.mbAllowNewNodes || useNode.isContainer() || this.mTemplateModel == null || this.mTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V27_SCRIPTING)) {
            return;
        }
        super.addUseNode(useNode);
    }

    void addValidationStateChanged(Container container) {
        this.moValidationStateChanges.add(container);
    }

    @Override
    public void addUseHRefNode(Element useHRefNode) {
    }

    private void adjustData(Element formParent, Element dataParent) {
        for (Node formChild = formParent.getFirstXFAChild(); formChild != null; formChild = formChild.getNextXFASibling()) {
            Element dataChild = null;
            boolean bAdjustChild = true;
            int eMergeType = this.mergeType(formChild, "", null);
            switch (eMergeType) {
                case 0x1F0001: {
                    if (formChild instanceof FormSubform && ((FormSubform)formChild).isLayoutNode()) {
                        assert (false);
                        break;
                    }
                    if (formChild.isMapped()) {
                        dataChild = FormModel.getDataNode(formChild);
                    }
                    if (dataChild != null) {
                        if (dataParent == null) break;
                        boolean bMove = false;
                        if (dataParent != dataChild.getXFAParent()) {
                            bMove = true;
                        } else if (formParent instanceof FormSubformSet && -2144600063 == formParent.getEnum(620)) {
                            bMove = true;
                        }
                        if (!bMove || dataChild.getClassTag() == 82 && ((DataNode)dataChild).isAttribute()) break;
                        dataParent.appendChild(dataChild, true);
                        break;
                    }
                    dataChild = dataParent == null ? this.createDataNode((Container)formChild, this.mStartNode, eMergeType, false) : this.createDataNode((Container)formChild, dataParent, eMergeType, false);
                    this.bindNodes(formChild, (DataNode)dataChild, true);
                    this.consumeDataNode(null, dataChild, DatasetSelector.MAIN_DATASET);
                    break;
                }
                case 2031618: 
                case 2031619: 
                case 2031620: {
                    bAdjustChild = false;
                    break;
                }
            }
            if (!bAdjustChild || !formChild.isContainer()) continue;
            if (dataChild == null) {
                dataChild = dataParent;
            }
            if (formChild instanceof ExclGroup && dataChild.getClassTag() == 82) continue;
            this.adjustData((Element)formChild, dataChild);
        }
    }

    private boolean allowNewNodes(boolean bAllow) {
        boolean bOldValue = this.mbAllowNewNodes;
        this.mbAllowNewNodes = bAllow;
        return bOldValue;
    }

    void bindNodes(Node formNode, DataNode dataNode, boolean bUpdateData) {
        if (dataNode == null) {
            return;
        }
        boolean bPeer = true;
        if (this.mbConnectionMerge) {
            for (Element parentDataNode = dataNode.getXFAParent(); parentDataNode != null && !(parentDataNode instanceof DataModel); parentDataNode = parentDataNode.getXFAParent()) {
                if (parentDataNode.getClassTag() != 77 || parentDataNode.getName() != "connectionData") continue;
                bPeer = false;
                break;
            }
        }
        if (bUpdateData) {
            FormField formField;
            Field templateField;
            if (this.mergeMode() == 0x8C0000 && dataNode.isMapped()) {
                bUpdateData = false;
            }
            if (this.mergeMode() == 9175041 && formNode instanceof FormField && StringUtils.isEmpty((templateField = (Field)(formField = (FormField)formNode).getProto()).getRawValue())) {
                bUpdateData = false;
            }
        }
        if (dataNode instanceof DataNode && dataNode.getIsDDPlaceholder()) {
            dataNode.setIsDDPlaceholder(false);
            bUpdateData = true;
        }
        if (formNode instanceof FormField) {
            ((FormField)formNode).setDataNode(dataNode, bUpdateData, bPeer, "", true);
        } else if (formNode instanceof FormSubform) {
            ((FormSubform)formNode).setDataNode(dataNode, true);
        } else if (formNode instanceof FormExclGroup) {
            ((FormExclGroup)formNode).setDataNode(dataNode, bUpdateData, bPeer);
        } else {
            return;
        }
        FormModel.outputTraceMessage(ResId.FormNodeMatchedTrace, formNode, dataNode, "");
    }

    boolean calculationsPending() {
        return this.mPendingCalculateNodes.size() > 0;
    }

    private boolean canBeQueued(Node node, boolean bCalculate) {
        int nStart;
        Container container;
        int ePresence;
        if (node.getXFAParent() == null) {
            return false;
        }
        if (this.mTemplateModel != null && this.mTemplateModel.getOriginalXFAVersion() >= 30 && node instanceof Container && 1076494339 == (ePresence = (container = (Container)node).getRuntimePresence(0))) {
            return false;
        }
        List<Node> list = bCalculate ? this.mPendingCalculateNodes : this.mPendingValidateNodes;
        int n = nStart = bCalculate ? this.mnNextPendingCalculateNode : this.mnNextPendingValidateNode;
        if (!this.mbSkipCyclicAndDuplicateCheck) {
            int nCycleCount = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != node) continue;
                if (i < nStart) {
                    if (++nCycleCount <= 10) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    private void checkForItems(FormField field, Node dataMatch) {
        Node currentUI;
        Element ui = field.getElement(331, true, 0, false, false);
        if (ui != null && (currentUI = ui.getOneOfChild(true, false)) != null && currentUI.isSameClass(47)) {
            NodeList dataChildren = dataMatch.getNodes();
            int nNodes = dataChildren.length();
            boolean bFoundItems = false;
            Node itemsDataNode = null;
            for (int i = 0; i < nNodes; ++i) {
                itemsDataNode = (Node)dataChildren.item(i);
                String sName = itemsDataNode.getName();
                if (sName.compareToIgnoreCase("items") != 0) continue;
                bFoundItems = true;
                break;
            }
            if (!bFoundItems || itemsDataNode == null) {
                return;
            }
            this.consumeDataNode(null, itemsDataNode, DatasetSelector.MAIN_DATASET);
            NodeList dataItemsChildren = itemsDataNode.getNodes();
            int n = dataItemsChildren.length();
            Field.ItemPair itemPair = new Field.ItemPair();
            field.getItemLists(false, itemPair, true);
            Items displayItems = itemPair.mDisplayItems;
            Items saveItems = itemPair.mSaveItems;
            if (displayItems != null) {
                displayItems.clearItems(false);
            }
            if (saveItems != null) {
                saveItems.clearItems(false);
            }
            int i = 0;
            while (i < n) {
                Node dataChild = (Node)dataItemsChildren.item(i);
                this.consumeDataNode(null, dataChild, DatasetSelector.MAIN_DATASET);
                String aChildName = dataChild.getName();
                if (aChildName == null) {
                    ++i;
                    continue;
                }
                String sSaveValue = ((DataNode)dataChild).getValue();
                Node displayChild = (Node)dataItemsChildren.item(++i);
                this.consumeDataNode(null, displayChild, DatasetSelector.MAIN_DATASET);
                String aDisplayChildName = displayChild.getName();
                String sDisplayValue = aDisplayChildName == "save" ? sSaveValue : ((DataNode)displayChild).getValue();
                if (displayItems != null) {
                    displayItems.addItem(sDisplayValue, false);
                }
                if (saveItems != null && saveItems != displayItems) {
                    saveItems.addItem(sSaveValue, false);
                }
                ++i;
            }
        }
    }

    void cleanupLayoutNodes() {
        while (this.mLayoutContent.size() > 0) {
            Element parent;
            Element last = this.mLayoutContent.get((int)(this.mLayoutContent.size() - 1)).mNode;
            this.mLayoutContent.remove(this.mLayoutContent.size() - 1);
            if (null == last || (parent = last.getXFAParent()) == null || ((Node)parent).getModel() == null) continue;
            if (parent.isSameClass(298)) {
                ((SubformSet)parent).reset();
            } else if (parent.isSameClass(297)) {
                ((Subform)parent).reset();
            }
            last.remove();
            this.removeReferencesImpl(last, false);
        }
        this.mCurrentPageSet = null;
    }

    void cleanupLayoutNodes(Node node) {
        Node child = node.getFirstXFAChild();
        while (child != null) {
            Node nextChild = child.getNextXFASibling();
            if (child.isContainer() && !child.isSameClass(102) && !child.isSameClass(133)) {
                if (child instanceof FormSubform && ((FormSubform)child).isLayoutNode()) {
                    if (node.getModel() != null) {
                        child.remove();
                        this.removeReferences(child);
                    }
                } else {
                    this.cleanupLayoutNodes(child);
                }
            }
            child = nextChild;
        }
    }

    public void clearFocus() {
        this.mPrevActiveField = this.mActiveField;
        this.mActiveField = null;
    }

    private String computeCheckSum() {
        return this.computeCheckSum(true);
    }

    private String computeCheckSum(boolean bCanonicalizeNamespaceOrder) {
        MessageDigest md;
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        DOMSaveOptions formStateOptions = new DOMSaveOptions();
        formStateOptions.setExcludePreamble(true);
        formStateOptions.setExpandElement(true);
        formStateOptions.setDisplayFormat(0);
        if (bCanonicalizeNamespaceOrder) {
            formStateOptions.setCanonicalizeNamespaceOrder(true);
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            assert (false);
            return "";
        }
        this.mTemplateModel.saveXML(tempStream, formStateOptions);
        md.update(tempStream.toByteArray());
        tempStream.reset();
        this.mDataModel.saveXML(tempStream, formStateOptions);
        md.update(tempStream.toByteArray());
        tempStream = null;
        byte[] hash = md.digest();
        return Base64.encode(hash, false);
    }

    private int countOverlayDataChild(Node formNode, Node dataParent) {
        int nCount = 0;
        for (Node dataChild = dataParent.getFirstXFAChild(); dataChild != null; dataChild = dataChild.getNextXFASibling()) {
            if (!FormModel.isMappableForOverlayData(formNode, dataChild, false)) continue;
            ++nCount;
        }
        return nCount;
    }

    void createAndMatchChildren(Element templateNode, DataNode dataNode, Element formNode, Element connectionDataParent) {
        if (formNode.isContainer() && connectionDataParent != null) {
            this.setConnectionDataContextInfo((Container)formNode, connectionDataParent);
        }
        if (!formNode.isContainer() || formNode.isSameClass(133) || formNode.isSameClass(102)) {
            return;
        }
        boolean bMatchDescendantsOnly = this.getMatchDescendantsOnly();
        if (!bMatchDescendantsOnly) {
            int eMergeType = this.mergeType(templateNode, "", null);
            switch (eMergeType) {
                case 2031618: 
                case 2031619: 
                case 2031620: {
                    this.setMatchDescendantsOnly(true);
                }
            }
        }
        for (Node templateChild = templateNode.getFirstXFAChild(); templateChild != null; templateChild = templateChild.getNextXFASibling()) {
            Element templateElement;
            if (!(templateChild instanceof Element) || !this.mapChild(templateElement = (Element)templateChild, formNode)) continue;
            this.createAndMatchNode(templateElement, dataNode, formNode, connectionDataParent);
        }
        this.setMatchDescendantsOnly(bMatchDescendantsOnly);
    }

    int createAndMatchNode(Element templateNode, DataNode dataParent, Element formParent, Element connectionDataParent) {
        int nNumCreated = 0;
        if (templateNode instanceof Subform) {
            Element formNode;
            FormInstanceManager instanceManager = this.createInstanceManager(templateNode, formParent);
            int nMax = this.getOccurAttribute(templateNode, 555);
            if (nMax != -1 && nMax < 1) {
                return 0;
            }
            int nRequired = this.getOccurAttribute(templateNode, 566);
            Container.FormInfo formInfo = this.getFormInfo(templateNode, dataParent, connectionDataParent);
            DataNode dataMatch = this.findMatch(formInfo, true, DatasetSelector.MAIN_DATASET);
            while (dataMatch != null) {
                ++nNumCreated;
                if (!formInfo.bConnectDataRef) {
                    formNode = this.createFormNode(templateNode, formParent, instanceManager);
                    this.bindNodes(formNode, dataMatch, false);
                    this.consumeDataNode(formInfo, dataMatch, DatasetSelector.MAIN_DATASET);
                    this.resetLocalConsumptionContext(templateNode);
                    this.createAndMatchChildren(templateNode, dataMatch, formNode, connectionDataParent);
                } else {
                    Element formNode2;
                    this.consumeDataNode(formInfo, dataMatch, DatasetSelector.MAIN_DATASET);
                    DataNode actualDataMatch = this.findMatch(formInfo, true, DatasetSelector.ALT_DATASET);
                    if (actualDataMatch != null) {
                        formNode2 = this.createFormNode(templateNode, formParent, instanceManager);
                        this.resetLocalConsumptionContext(templateNode);
                        this.createAndMatchChildren(templateNode, actualDataMatch, formNode2, dataMatch);
                        this.bindNodes(formNode2, actualDataMatch, UPDATE_DATA);
                        this.consumeDataNode(formInfo, actualDataMatch, DatasetSelector.ALT_DATASET);
                    } else {
                        formNode2 = this.createFormNode(templateNode, formParent, instanceManager);
                        this.resetLocalConsumptionContext(templateNode);
                        this.createAndMatchChildren(templateNode, dataParent, formNode2, dataMatch);
                    }
                }
                if (nMax != -1 && nNumCreated == nMax) {
                    return nNumCreated;
                }
                formInfo = this.getFormInfo(templateNode, dataParent, connectionDataParent);
                dataMatch = this.findMatch(formInfo, true, DatasetSelector.MAIN_DATASET);
            }
            if (formInfo.eMergeType == 0x1F0000 || this.mergeMode() == 0x8C0000) {
                while (this.hasDescendantMatch(templateNode, dataParent, connectionDataParent, formInfo.eMergeType, false, null)) {
                    formNode = this.createFormNode(templateNode, formParent, instanceManager);
                    this.createAndMatchChildren(templateNode, dataParent, formNode, connectionDataParent);
                    if (nMax == -1 || ++nNumCreated != nMax) continue;
                    break;
                }
            }
            if (nNumCreated == 0) {
                nRequired = this.getOccurAttribute(templateNode, 524);
            }
            while (nNumCreated < nRequired) {
                if (this.mergeMode() == 0x8C0000) {
                    this.createEmptyFormNode(templateNode, formParent, connectionDataParent, instanceManager);
                } else {
                    formNode = this.createFormNode(templateNode, formParent, instanceManager);
                    dataMatch = null;
                    if (!formInfo.bAssociation) {
                        if (formInfo.eMergeType == 0x1F0000) {
                            dataMatch = dataParent;
                        } else if (this.mapChild(templateNode, formParent)) {
                            dataMatch = this.createDataNode(formNode, dataParent, formInfo.eMergeType, true);
                            this.bindNodes(formNode, dataMatch, UPDATE_DATA);
                            this.consumeDataNode(null, dataMatch, DatasetSelector.MAIN_DATASET);
                        }
                    }
                    this.createAndMatchChildren(templateNode, dataMatch, formNode, connectionDataParent);
                }
                ++nNumCreated;
            }
        } else if (templateNode instanceof Field) {
            FormField formNode = (FormField)this.createFormNode(templateNode, formParent, null);
            Container.FormInfo formInfo = this.getFormInfo(templateNode, dataParent, connectionDataParent);
            assert (formInfo != null);
            DataNode dataMatch = this.findMatch(formInfo, false, DatasetSelector.MAIN_DATASET);
            if (formInfo.bConnectDataRef && dataMatch != null) {
                formNode.setDataNode(dataMatch, false, false, "", true);
                this.consumeDataNode(formInfo, dataMatch, DatasetSelector.MAIN_DATASET);
                this.setConnectionDataContextInfo(formNode, dataMatch);
                DataNode actualDataMatch = this.findMatch(formInfo, false, DatasetSelector.ALT_DATASET);
                if (actualDataMatch != null) {
                    this.bindNodes(formNode, actualDataMatch, UPDATE_DATA);
                    this.consumeDataNode(formInfo, actualDataMatch, DatasetSelector.ALT_DATASET);
                }
            } else {
                if (dataMatch == null && (formInfo.eMergeType == 0x1F0001 || formInfo.eMergeType == 2031620)) {
                    dataMatch = this.findNestedAttrMatch(formNode, dataParent, formInfo.eMergeType);
                }
                if (dataMatch != null || this.mergeMode() == 0x8C0000) {
                    this.bindNodes(formNode, dataMatch, false);
                    this.consumeDataNode(formInfo, dataMatch, DatasetSelector.MAIN_DATASET);
                } else {
                    dataMatch = this.createDataNode(formNode, dataParent, formInfo.eMergeType, true);
                    this.bindNodes(formNode, dataMatch, UPDATE_DATA);
                    this.consumeDataNode(null, dataMatch, DatasetSelector.MAIN_DATASET);
                }
            }
            ++nNumCreated;
        } else if (templateNode instanceof SubformSet) {
            nNumCreated += this.mapSubformSet(templateNode, formParent, dataParent, connectionDataParent);
        } else if (templateNode instanceof ExclGroup) {
            Container.FormInfo formInfo = this.getFormInfo(templateNode, dataParent, null);
            if (formInfo.eMergeType == 0x1F0000) {
                Element formNode = this.createFormNode(templateNode, formParent, null);
                this.createAndMatchChildren(templateNode, dataParent, formNode, connectionDataParent);
            } else {
                Element formNode;
                DataNode dataMatch = this.findMatch(formInfo, false, DatasetSelector.MAIN_DATASET);
                if (dataMatch == null) {
                    if (this.mergeMode() == 0x8C0000) {
                        this.createEmptyFormNode(templateNode, formParent, connectionDataParent, null);
                    } else {
                        formNode = this.createEmptyFormNode(templateNode, formParent, connectionDataParent, null);
                        dataMatch = this.createDataNode(formNode, dataParent, formInfo.eMergeType, true);
                        this.bindNodes(formNode, dataMatch, UPDATE_DATA);
                        this.consumeDataNode(null, dataMatch, DatasetSelector.MAIN_DATASET);
                    }
                } else if (dataMatch.getClassTag() == 77) {
                    formNode = this.createFormNode(templateNode, formParent, null);
                    this.bindNodes(formNode, dataMatch, false);
                    this.consumeDataNode(formInfo, dataMatch, DatasetSelector.MAIN_DATASET);
                    this.resetLocalConsumptionContext(templateNode);
                    this.createAndMatchChildren(templateNode, dataMatch, formNode, connectionDataParent);
                } else {
                    formNode = this.createEmptyFormNode(templateNode, formParent, connectionDataParent, null);
                    this.bindNodes(formNode, dataMatch, false);
                    this.consumeDataNode(formInfo, dataMatch, DatasetSelector.MAIN_DATASET);
                }
            }
            ++nNumCreated;
        } else {
            Element formNode = this.createFormNode(templateNode, formParent, null);
            this.createAndMatchChildren(templateNode, dataParent, formNode, connectionDataParent);
            ++nNumCreated;
        }
        return nNumCreated;
    }

    DataNode createDataNode(Element formNode, Element dataParent, int eMergeType, boolean bSearchForNewlyCreatedFirst) {
        DataNode newDataNode = null;
        if (eMergeType == 0x1F0000) {
            return null;
        }
        if (eMergeType == 2031618) {
            boolean bUseDV = FormModel.useDV(formNode);
            newDataNode = (DataNode)this.resolveCreateGlobal(formNode, bSearchForNewlyCreatedFirst, bUseDV);
        } else if (eMergeType == 2031619) {
            String sRef = this.getDataRef(formNode, "", null);
            boolean bUseDV = FormModel.useDV(formNode);
            if (this.mergeMode() == 9175041) {
                if (FormModel.somIsStar(sRef) && formNode instanceof FormSubform) {
                    FormSubform formSubform = (FormSubform)formNode;
                    sRef = sRef.substring(0, sRef.length() - 3);
                    sRef = sRef + "[" + formSubform.getInstanceIndex(null) + "]";
                }
                if (this.getMatchDescendantsOnly() && FormModel.somIsRelative(sRef) && sRef.charAt(0) != '$') {
                    sRef = "$." + sRef;
                }
            }
            if ((newDataNode = this.resolveCreateDataRef(sRef, dataParent, bSearchForNewlyCreatedFirst, bUseDV)) != null && !FormModel.isMappable(formNode, newDataNode, false, false)) {
                MsgFormatPos msg = new MsgFormatPos(ResId.FormInvalidDataRef);
                msg.format(sRef);
                msg.format(formNode.getName());
                msg.format(newDataNode.getClassAtom());
                throw new ExFull(msg);
            }
        } else if (eMergeType == 0x1F0001 || eMergeType == 2031620) {
            String aName = formNode.getName();
            if (aName == "") {
                return null;
            }
            boolean bUseDV = FormModel.useDV(formNode);
            if (dataParent != null) {
                if (this.mDataDescription != null) {
                    int nDot;
                    StringBuilder sTemp = new StringBuilder(aName);
                    int fromIndex = 0;
                    while ((nDot = sTemp.indexOf(".", fromIndex)) != -1) {
                        sTemp.insert(nDot, '\\');
                        fromIndex = nDot + 2;
                    }
                    StringBuilder sName = new StringBuilder();
                    if (this.getMatchDescendantsOnly()) {
                        sName.append("$.");
                    }
                    sName.append((CharSequence)sTemp);
                    if (this.mergeMode() == 0x8C0000) {
                        sName.append("[*]");
                    } else {
                        sName.append("[" + formNode.getIndex(true) + "]");
                    }
                    newDataNode = this.resolveCreateDataRef(sName.toString(), dataParent, bSearchForNewlyCreatedFirst, bUseDV);
                } else {
                    newDataNode = bUseDV ? (DataNode)this.mDataModel.createNode(82, dataParent, aName, null, true) : (DataNode)this.mDataModel.createNode(77, dataParent, aName, null, true);
                    if (!this.mbAdjustData) {
                        newDataNode.makeDefault();
                    }
                }
            }
        }
        if (newDataNode != null) {
            FormModel.outputTraceMessage(ResId.NodeCreatedTrace, newDataNode, null, "");
        } else if (eMergeType != 0x1F0000) {
            FormModel.outputTraceMessage(ResId.UnmappedNode, formNode, null, "");
        }
        if (this.mbMergeComplete && newDataNode != null && newDataNode.getXFAParent() != null) {
            newDataNode.getXFAParent().notifyPeers(4, newDataNode.getClassAtom(), newDataNode);
        }
        return newDataNode;
    }

    Element createEmptyFormNode(Element templateNode, Element formParent, Element connectionDataParent, FormInstanceManager instanceManager) {
        boolean bMatchDescendantsOnly;
        int eRelation;
        Element formNode = null;
        DataNode dataNode = null;
        int eMergeType = this.mergeType(templateNode, "", null);
        if (this.mapChild(templateNode, formParent)) {
            if (!(eMergeType != 2031618 || this.mergeMode() != 0x8C0000 || (dataNode = this.resolveGlobal(templateNode, true)) == null || templateNode.isSameClass(127) && dataNode.isSameClass(82))) {
                formNode = this.createFormNode(templateNode, formParent, instanceManager);
                this.bindNodes(formNode, dataNode, false);
                this.consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
                this.resetLocalConsumptionContext(templateNode);
                this.createAndMatchChildren(templateNode, dataNode, formNode, connectionDataParent);
                return formNode;
            }
        } else {
            return null;
        }
        formNode = this.createFormNode(templateNode, formParent, instanceManager);
        if (!templateNode.isContainer() || formNode.isSameClass(133) || formNode.isSameClass(102)) {
            return formNode;
        }
        boolean bChoice = false;
        if (templateNode instanceof SubformSet && (eRelation = ((EnumValue)((SubformSet)templateNode).getAttribute(620)).getInt()) == -2144600062) {
            bChoice = true;
        }
        if (!(bMatchDescendantsOnly = this.getMatchDescendantsOnly())) {
            switch (eMergeType) {
                case 2031618: 
                case 2031619: 
                case 2031620: {
                    this.setMatchDescendantsOnly(true);
                }
            }
        }
        int nRequired = 1;
        for (Node templateChild = templateNode.getFirstXFAChild(); templateChild != null; templateChild = templateChild.getNextXFASibling()) {
            if (!(templateChild instanceof Element)) continue;
            Element templateElement = (Element)templateChild;
            FormInstanceManager newInstanceManager = this.createInstanceManager(templateElement, formNode);
            nRequired = this.getOccurAttribute(templateElement, 524);
            for (int nCount = 0; nCount < nRequired; ++nCount) {
                this.createEmptyFormNode(templateElement, formNode, connectionDataParent, newInstanceManager);
            }
            if (bChoice && templateChild.isContainer()) break;
        }
        if (dataNode != null) {
            this.bindNodes(formNode, dataNode, false);
            this.consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
        }
        this.setMatchDescendantsOnly(bMatchDescendantsOnly);
        return formNode;
    }

    public int mergeMode() {
        return this.mbGlobalConsumption ? 0x8C0000 : 9175041;
    }

    Element createFormNode(Element templateNode, Element formParent, FormInstanceManager instanceManager) {
        Element newFormNode;
        assert (templateNode.getModel() instanceof TemplateModel);
        boolean bProtoChildren = !templateNode.isContainer();
        boolean bNodeCanHaveEvents = false;
        if (templateNode.isSameClass(133)) {
            Element fieldElement = templateNode;
            boolean bIsMultiSelect = false;
            if (this.mTemplateModel.validateGlobalField(fieldElement)) {
                EnumAttr eOpen;
                Node currentUI;
                Element ui = fieldElement.getElement(331, true, 0, false, false);
                if (ui != null && (currentUI = ui.getOneOfChild(true, false)) != null && currentUI.isSameClass(47) && (eOpen = EnumAttr.getEnum(((Element)currentUI).getEnum(584))).getInt() == 0x230003) {
                    bIsMultiSelect = true;
                }
                newFormNode = bIsMultiSelect ? new FormChoiceListField(formParent, null) : new FormField(formParent, null);
            } else {
                throw new ExFull(new MsgFormat(ResId.XFAGlobalFieldConflictException, templateNode.getName()));
            }
            bProtoChildren = true;
            bNodeCanHaveEvents = true;
        } else if (templateNode.isSameClass(297)) {
            newFormNode = new FormSubform(formParent, null);
            if (templateNode == this.mRootSubform) {
                this.mRootFormSubform = newFormNode;
                String sLocale = this.getAmbientLocale();
                if (!StringUtils.isEmpty(sLocale)) {
                    StringAttr oLocaleProp = new StringAttr("locale", sLocale);
                    ((FormSubform)newFormNode).setAttribute(oLocaleProp, 382);
                }
            }
            if (instanceManager != null) {
                instanceManager.addInstance(newFormNode, false);
            }
            bNodeCanHaveEvents = true;
        } else if (templateNode.isSameClass(298)) {
            newFormNode = new FormSubformSet(formParent, null);
            if (instanceManager != null) {
                instanceManager.addInstance(newFormNode, false);
            }
        } else if (templateNode.isSameClass(127)) {
            newFormNode = new FormExclGroup(formParent, null);
            bNodeCanHaveEvents = true;
        } else {
            newFormNode = (Element)this.createNode(templateNode.getClassTag(), formParent, "", "", true);
        }
        if (newFormNode != null) {
            String aNodeName = templateNode.getName();
            if (aNodeName != null && "" != aNodeName) {
                newFormNode.privateSetName(aNodeName);
            }
            FormModel.outputTraceMessage(ResId.NodeCreatedTrace, newFormNode, null, "");
            if (bProtoChildren) {
                ((ProtoableNode)newFormNode).resolveProto((ProtoableNode)templateNode, false, false, false);
            } else {
                ((ProtoableNode)newFormNode).setProto((ProtoableNode)templateNode);
            }
            newFormNode.makeDefault();
            if (this.mergeMode() == 0x8C0000) {
                int eMergeType = this.mergeType(templateNode, "", null);
                switch (eMergeType) {
                    case 2031618: 
                    case 2031619: 
                    case 2031620: {
                        this.mExplicitMatchNodes.add(newFormNode);
                    }
                }
            }
            if (this.mbRegisterNewEvents && (newFormNode.isSameClass(124) || bNodeCanHaveEvents)) {
                this.registerEvents(newFormNode, 7);
            }
        }
        return newFormNode;
    }

    private void createFormState() {
        if (!this.getFormStateUsage()) {
            return;
        }
        Element formState = (Element)this.getAppModel().locateChildByName("formState", 0);
        if (formState == null) {
            AppModel appModel = (AppModel)this.getXFAParent();
            formState = new Packet(appModel, null);
            new ModelPeer((Element)appModel.getXmlPeer(), null, null, "formState", "formState", null, formState);
        } else {
            ModelPeer formStateDomPeer = (ModelPeer)((Packet)formState).getXmlPeer();
            Node node = formStateDomPeer.getFirstXFAChild();
            while (node != null) {
                Node oNext = node.getNextXFASibling();
                node.remove();
                node = oNext;
            }
        }
        for (Node node = this.getFirstXFAChild(); node != null; node = node.getNextXFASibling()) {
            if (!(node instanceof Element)) continue;
            this.createFormState((Element)node, formState);
        }
    }

    private void createFormState(Element formNode, Element oFormState) {
        Document domDoc = oFormState.getOwnerDocument();
        for (Node formChild = formNode.getFirstXFAChild(); formChild != null; formChild = formChild.getNextXFASibling()) {
            if (formChild instanceof FormField) {
                Node currentUI;
                FormField field = (FormField)formChild;
                Element ui = field.getElement(331, true, 0, false, false);
                if (ui == null || (currentUI = ui.getOneOfChild(true, false)) == null || !currentUI.isSameClass(47)) continue;
                Field.ItemPair itemPair = new Field.ItemPair();
                field.getItemLists(true, itemPair, false);
                Items saveItem = itemPair.mSaveItems;
                Items displayItem = itemPair.mDisplayItems;
                boolean bModifiedList = false;
                NodeList saveItems = new ArrayNodeList();
                int nSaveItems = 0;
                if (saveItem != null) {
                    if (!((Node)saveItem).isDefault(false) && saveItem.getXFAParent() == field) {
                        bModifiedList = true;
                    }
                    saveItems = ((Node)saveItem).getNodes();
                    nSaveItems = saveItems.length();
                }
                NodeList displayItems = new ArrayNodeList();
                int nDisplayItems = 0;
                if (displayItem != null) {
                    if (!((Node)displayItem).isDefault(false) && displayItem.getXFAParent() == field) {
                        bModifiedList = true;
                    }
                    displayItems = ((Node)displayItem).getNodes();
                    nDisplayItems = displayItems.length();
                }
                if (!bModifiedList) continue;
                int nValues = 0;
                nValues = nSaveItems != 0 && nDisplayItems != 0 && nSaveItems != nDisplayItems ? (nSaveItems < nDisplayItems ? nSaveItems : nDisplayItems) : nSaveItems;
                if (nValues == 0) continue;
                Element newState = domDoc.createElementNS("", "state", oFormState);
                String sRef = field.getSOMExpression(this, false);
                newState.setAttribute("", "ref", "ref", sRef);
                Element newItems = domDoc.createElementNS("", "items", newState);
                String sDisplay = "";
                String sSave = "";
                for (int k = 0; k < nValues; ++k) {
                    TextNode textNode;
                    if (saveItems.item(k) instanceof TextNode) {
                        textNode = (TextNode)saveItems.item(k);
                        sSave = textNode.getValue();
                    }
                    if (displayItems.item(k) instanceof TextNode) {
                        textNode = (TextNode)displayItems.item(k);
                        sDisplay = textNode.getValue();
                    }
                    Element save = domDoc.createElementNS("", "save", newItems);
                    new TextNode(save, null, sSave);
                    Element display = domDoc.createElementNS("", "display", newItems);
                    new TextNode(display, null, sDisplay);
                }
                continue;
            }
            if (!formNode.isContainer()) continue;
            this.createFormState((Element)formChild, oFormState);
        }
    }

    private FormInstanceManager createInstanceManager(Element templateNode, Element formParent) {
        if (this.mbIsXFAF && (!(templateNode instanceof Subform) || templateNode.getXFAParent() != this.mRootSubform)) {
            return null;
        }
        if ((templateNode instanceof Subform || templateNode instanceof SubformSet) && (formParent instanceof FormSubform || formParent instanceof FormSubformSet || formParent.isSameClass(222))) {
            FormInstanceManager formInstanceManager = new FormInstanceManager(formParent, null);
            formInstanceManager.setTemplateNode((ProtoableNode)templateNode);
            formInstanceManager.setMatchDescendantsOnly(this.getMatchDescendantsOnly());
            formInstanceManager.makeDefault();
            return formInstanceManager;
        }
        return null;
    }

    private ProtoableNode createLayoutNode(ProtoableNode staticContent, Element parent) {
        assert (staticContent != null);
        assert (staticContent instanceof PageSet || staticContent instanceof Subform || staticContent instanceof SubformSet);
        Element newStaticContent = this.importNode(staticContent, parent, !(staticContent instanceof PageSet));
        if (parent != null) {
            this.mLayoutContent.add(new LayoutContentInfo(newStaticContent));
        }
        if (newStaticContent instanceof FormSubform) {
            ((FormSubform)newStaticContent).setLayoutNode();
        } else if (newStaticContent instanceof FormSubformSet) {
            this.setLayoutNodes((FormSubformSet)newStaticContent);
        }
        return (ProtoableNode)newStaticContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node createLeaderTrailer(String sReference, Container container, boolean bPeek) {
        this.mbRegisterNewEvents = !bPeek;
        try {
            ProtoableNode protoableContainer;
            Container containerTemplateContext = container;
            for (protoableContainer = container; protoableContainer != null && !(protoableContainer.getModel() instanceof TemplateModel); protoableContainer = protoableContainer.getProto()) {
            }
            containerTemplateContext = protoableContainer;
            assert (containerTemplateContext != null);
            ProtoableNode templateSF = null;
            if (containerTemplateContext != null) {
                templateSF = this.mTemplateModel.createLeaderTrailer(sReference, containerTemplateContext, bPeek);
            }
            if (templateSF != null) {
                ProtoableNode newNode = bPeek ? this.createLayoutNode(templateSF, null) : this.createLayoutNode(templateSF, container);
                ProtoableNode protoableNode = newNode;
                return protoableNode;
            }
            Node node = null;
            return node;
        }
        finally {
            this.mbRegisterNewEvents = true;
        }
    }

    @Override
    public Node createNode(int eClassTag, Element parent, String aNodeName, String aNS, boolean bDoVersionCheck) {
        assert (aNodeName != null);
        assert (aNS != null);
        Element newFormNode = null;
        if (!(this.mbAllowNewNodes || eClassTag != 133 && eClassTag != 297 && eClassTag != 298 && eClassTag != 127 && eClassTag != 102 && eClassTag != 21 && eClassTag != 222 && eClassTag != 225)) {
            return newFormNode;
        }
        assert (eClassTag != 2);
        newFormNode = eClassTag == 133 ? new FormField(parent, null) : (eClassTag == 297 ? new FormSubform(parent, null) : (eClassTag == 127 ? new FormExclGroup(parent, null) : (eClassTag == 298 ? new FormSubformSet(parent, null) : this.getSchema().getInstance(eClassTag, this, parent, null, bDoVersionCheck))));
        if (newFormNode != null && aNodeName != "") {
            newFormNode.privateSetName(aNodeName);
        }
        return newFormNode;
    }

    private void createOverlayData(Node formNode) {
        Element overlayDataNode = null;
        for (Node node = this.mDataModel.getFirstXFAChild(); node != null; node = node.getNextXFASibling()) {
            if (node.getName() != "overlayData") continue;
            overlayDataNode = (Element)node;
            break;
        }
        if (overlayDataNode != null) {
            // empty if block
        }
        overlayDataNode = (Element)this.mDataModel.createNode(77, this.mDataModel, "overlayData", this.mDataModel.getNS(), true);
        Element panelDataNode = null;
        if (formNode instanceof FormSubform) {
            String aName = formNode.getName();
            panelDataNode = aName == "" ? overlayDataNode : (Element)this.mDataModel.createNode(77, overlayDataNode, aName, "", true);
        }
        this.createOverlayData(formNode, panelDataNode);
    }

    private void createOverlayData(Node form, Element dataParent) {
        Node formChild = form.getFirstXFAChild();
        while (formChild != null) {
            DataNode rawValue;
            Element newDataNode;
            String sRawValue;
            String aChildName = formChild.getName();
            if (formChild instanceof FormField) {
                Node currentUI;
                Element ui;
                String sFormattedValue;
                FormField field = (FormField)formChild;
                sRawValue = field.getRawValue();
                newDataNode = (Element)this.mDataModel.createNode(77, dataParent, aChildName, "", true);
                if (form instanceof FormChoiceListField) {
                    Value value;
                    Node valueContent;
                    if (formChild.isPropertySpecified(405, true, 0) && (valueContent = (value = (Value)((FormChoiceListField)formChild).getElement(405, 0)).getOneOfChild()) instanceof ExDataValue) {
                        ArrayList<String> selectionList = new ArrayList<String>();
                        Node node = ((ExDataValue)valueContent).getOneOfChild();
                        if (node instanceof XMLMultiSelectNode) {
                            XMLMultiSelectNode multiSelect = (XMLMultiSelectNode)node;
                            multiSelect.getValues(selectionList);
                            int nNumberSelected = selectionList.size();
                            for (int j = 0; j < nNumberSelected; ++j) {
                                sRawValue = (String)selectionList.get(j);
                                DataNode rawValue2 = (DataNode)this.mDataModel.createNode(82, newDataNode, "value", "", true);
                                rawValue2.setValue(sRawValue, true);
                            }
                        }
                    }
                } else {
                    rawValue = (DataNode)this.mDataModel.createNode(82, newDataNode, "value", "", true);
                    rawValue.setValue(sRawValue, true);
                }
                if (!(sFormattedValue = field.getFormattedValue()).equals(sRawValue)) {
                    DataNode oFormattedValue = (DataNode)this.mDataModel.createNode(82, newDataNode, "formattedValue", "", true);
                    oFormattedValue.setValue(sFormattedValue, true);
                }
                if ((ui = field.getElement(331, true, 0, false, false)) != null && (currentUI = ui.getOneOfChild(true, false)) != null && currentUI.isSameClass(47)) {
                    int nDisplayItems;
                    NodeList displayItems;
                    int nSaveItems;
                    NodeList saveItems;
                    Field.ItemPair itemPair = new Field.ItemPair();
                    field.getItemLists(true, itemPair, false);
                    Items displayItem = itemPair.mDisplayItems;
                    Items saveItem = itemPair.mSaveItems;
                    if (saveItem != null) {
                        saveItems = ((Node)saveItem).getNodes();
                        nSaveItems = saveItems.length();
                    } else {
                        saveItems = new ArrayNodeList();
                        nSaveItems = 0;
                    }
                    if (displayItem != null) {
                        displayItems = ((Node)displayItem).getNodes();
                        nDisplayItems = displayItems.length();
                    } else {
                        displayItems = new ArrayNodeList();
                        nDisplayItems = 0;
                    }
                    int nValues = nSaveItems != 0 && nDisplayItems != 0 && nSaveItems != nDisplayItems ? Math.min(nSaveItems, nDisplayItems) : nSaveItems;
                    if (nValues != 0) {
                        Element items = (Element)this.mDataModel.createNode(77, newDataNode, "items", "", true);
                        String sDisplayValue = "";
                        String sSaveValue = "";
                        for (int k = 0; k < nValues; ++k) {
                            TextValue textNode;
                            if (saveItems.item(k) instanceof TextNode) {
                                textNode = (TextValue)saveItems.item(k);
                                sSaveValue = textNode.getValue();
                            }
                            if (displayItems.item(k) instanceof TextNode) {
                                textNode = (TextValue)displayItems.item(k);
                                sDisplayValue = textNode.getValue();
                            }
                            DataNode save = (DataNode)this.mDataModel.createNode(82, items, "save", "", true);
                            save.setValue(sSaveValue, true);
                            DataNode display = (DataNode)this.mDataModel.createNode(82, items, "display", "", true);
                            display.setValue(sDisplayValue, true);
                        }
                    }
                }
            } else if (formChild instanceof FormExclGroup) {
                FormExclGroup group = (FormExclGroup)formChild;
                newDataNode = (Element)this.mDataModel.createNode(77, dataParent, aChildName, "", true);
                sRawValue = group.getRawValue();
                rawValue = (DataNode)this.mDataModel.createNode(82, newDataNode, "value", "", true);
                rawValue.setValue(sRawValue, true);
            } else if (formChild instanceof FormSubform) {
                newDataNode = aChildName == "" ? dataParent : (Element)this.mDataModel.createNode(77, dataParent, aChildName, "", true);
                this.createOverlayData(formChild, newDataNode);
            }
            formChild = form.getNextXFASibling();
        }
    }

    PageArea createPage(PageArea page) {
        assert (this.mCurrentPageSet != null);
        return (PageArea)this.importNode(page, this.mCurrentPageSet, true);
    }

    PageSet createPageSet(PageSet pageSet) {
        Element pageSetParent = pageSet.getXFAParent();
        Element parent = this.mCurrentPageSet;
        if (parent == null) {
            parent = this.mRootFormSubform;
        }
        while (parent instanceof PageSet && ((PageSet)parent).getProto() != pageSetParent) {
            parent = parent.getXFAParent();
        }
        assert (parent.isSameClass(pageSetParent));
        this.mCurrentPageSet = this.createLayoutNode(pageSet, parent);
        return (PageSet)this.mCurrentPageSet;
    }

    public void createPanelOverlayData(int nPanel) {
        Node topSubform = this.getFirstXFAChild();
        Node targetSubform = null;
        int nCnt = 0;
        for (Node child = topSubform.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof FormSubform)) continue;
            if (nCnt == nPanel) {
                targetSubform = child;
                break;
            }
            ++nCnt;
        }
        if (targetSubform != null) {
            this.createOverlayData(targetSubform);
        }
    }

    private void doBindItems(Element bindItems, FormField field, String sRequestConnectionName) {
        String sConnection = "";
        Attribute connection = bindItems.getAttribute(371, true, false);
        if (connection != null) {
            sConnection = connection.toString();
        }
        String sRef = "";
        Attribute ref = bindItems.getAttribute(392, true, false);
        if (ref != null) {
            sRef = ref.toString();
        }
        if (sRef.length() != 0 && sConnection.length() != 0) {
            if (sRequestConnectionName.equals(sConnection)) {
                field.setItemsDataListener(null);
                field.updateItemsFromData(bindItems, true);
            }
        } else if ((sRef.length() == 0 || sConnection.length() == 0) && sRequestConnectionName.length() == 0) {
            FormItemsDataListener listener = new FormItemsDataListener(field, bindItems);
            field.setItemsDataListener(listener);
            field.updateItemsFromData(bindItems, false);
        }
    }

    @Override
    protected Node doLoadNode(Element parent, Node node, Generator genTag) {
        assert (node instanceof Element || node instanceof Chars);
        if (parent instanceof ExDataValue && node instanceof Element) {
            boolean bCreate = false;
            int eNewNodeTag = 1;
            if (((Element)node).getNS() == "http://www.w3.org/1999/xhtml") {
                bCreate = true;
            } else {
                String sContent = parent.getAttribute(457).toString();
                if (sContent.equals("text/xml")) {
                    eNewNodeTag = 2;
                    bCreate = true;
                }
            }
            if (bCreate) {
                return this.importContent(parent, node, eNewNodeTag);
            }
            MsgFormatPos msg = new MsgFormatPos(ResId.InvalidNodeTypeException, ((Element)node).getLocalName());
            this.addErrorList(new ExFull(msg), 3, null);
            return null;
        }
        return super.doLoadNode(parent, node, genTag);
    }

    private Node importContent(Element parent, Node node, int eType) {
        if (node instanceof Chars) {
            return new TextNode(parent, null, ((Chars)node).getText());
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            Element newElement = null;
            if (eType == 1) {
                newElement = new RichTextNode(parent, null);
            } else if (eType == 2) {
                newElement = new XMLMultiSelectNode(parent, null);
            } else assert (false);
            newElement.setDOMProperties(element.getNS(), element.getLocalName(), element.getXMLName(), null);
            for (int i = 0; i < element.getNumAttrs(); ++i) {
                Attribute attr = element.getAttr(i);
                newElement.setAttribute(attr.getNS(), attr.getName(), attr.getLocalName(), attr.getAttrValue(), false);
            }
            for (Node child = element.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                this.importContent(newElement, child, eType);
            }
            return newElement;
        }
        if (node instanceof Comment) {
            return new Comment(parent, null, ((Comment)node).getData());
        }
        if (node instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)node;
            return new ProcessingInstruction(parent, null, pi.getName(), pi.getData());
        }
        MsgFormatPos msg = new MsgFormatPos(ResId.InvalidNodeTypeException, node.getClassName());
        this.addErrorList(new ExFull(msg), 3, null);
        return null;
    }

    private void doSetProperty(Element setProperty, Container container, boolean bIsConnectionBind) {
        TextNode textNode;
        Attribute ref = setProperty.getAttribute(392, true, false);
        Attribute target = setProperty.getAttribute(670, true, false);
        if (ref == null || target == null) {
            return;
        }
        String sRef = ref.toString();
        String sTarget = target.toString();
        if (sRef.length() == 0 || sTarget.length() == 0) {
            return;
        }
        Element dataNode = null;
        if (bIsConnectionBind) {
            for (Element node = container; node != null; node = node.getXFAParent()) {
                if (node instanceof Container && node.getFormInfo() != null) {
                    dataNode = node.getFormInfo().connectionDataNode;
                }
                if (dataNode == null) {
                    continue;
                }
                break;
            }
        } else {
            dataNode = FormModel.getDataNode(container);
        }
        NodeList refNodes = dataNode != null ? dataNode.resolveNodes(sRef, true, false, true) : this.mDataModel.resolveNodes(sRef, true, false, true);
        Node refNode = null;
        if (refNodes.length() > 0) {
            refNode = (Node)refNodes.item(0);
        }
        if (refNode == null || !refNode.isSameClass(82)) {
            return;
        }
        String sSetValue = ((DataNode)refNode).getValue();
        StringHolder sTargetProperty = new StringHolder();
        Node targetNode = this.resolveSetPropertyTarget(container, sTarget, sTargetProperty);
        if (!(targetNode instanceof Element)) {
            return;
        }
        if (!FormModel.isValidSetPropertyTarget(targetNode, container)) {
            return;
        }
        Element targetElement = (Element)targetNode;
        if (!StringUtils.isEmpty(sTargetProperty.value)) {
            targetElement.setProperty((Object)new StringAttr(sTargetProperty.value, sSetValue), sTargetProperty.value);
        } else if (targetNode instanceof TextValue) {
            ((TextValue)targetNode).setValue(sSetValue);
        } else if (targetElement.isPropertyValid(0) && (textNode = targetElement.getText(false, true, false)) != null) {
            textNode.setValue(sSetValue, true, false);
        }
    }

    void enableIncrementalMerge(boolean bEnableIncrementalMerge) {
        this.mbEnableIncrementalMerge = bEnableIncrementalMerge;
    }

    void enumerateScripts(List<com.adobe.xfa.ScriptInfo> scripts, String sSingleLanguage) {
        TemplateModel.enumerateScripts(this, this, scripts, sSingleLanguage);
    }

    private boolean legacyEventOccurred(EventManager em, int nEventId, int eReason, Element container, boolean recursiveCall) {
        boolean bEventsDispatched = false;
        bEventsDispatched |= this.preExecEvent(em, nEventId, eReason, container, recursiveCall);
        bEventsDispatched |= this.execEvent(em, nEventId, eReason, container);
        return bEventsDispatched |= this.postExecEvent(em, nEventId, eReason, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean eventOccurred(EventManager em, int nEventId, int eReason, Element container, boolean recursiveCall) {
        if (this.mTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
            return this.legacyEventOccurred(em, nEventId, eReason, container, recursiveCall);
        }
        EventPseudoModel.EventInfo retrieve = null;
        try {
            if (this.mEventPseudoModel != null) {
                retrieve = this.mEventPseudoModel.getEventInfo();
                this.mEventPseudoModel.reset();
                this.mEventPseudoModel.setTarget(container);
                this.mEventPseudoModel.setName(eReason);
            }
            boolean bl = this.legacyEventOccurred(em, nEventId, eReason, container, recursiveCall);
            return bl;
        }
        finally {
            if (this.mEventPseudoModel != null) {
                this.mEventPseudoModel.setEventInfo(retrieve);
            }
        }
    }

    public boolean eventOccurred(String sActivity, Obj container) {
        Element node;
        int eReason = ScriptHandler.stringToExecuteReason(sActivity);
        EventManager em = this.getEventManager();
        int nId = em.getEventID(sActivity);
        if (container instanceof Element && (node = (Element)container).getModel() == this) {
            return this.eventOccurred(em, nId, eReason, node, false);
        }
        return em.eventOccurred(nId, container);
    }

    private boolean execEvent(EventManager em, int nEventId, int eReason, Node node) {
        int ePresence;
        Container container;
        int eAccess;
        if (eReason == 15 && !node.isSameClass(297)) {
            return false;
        }
        if (eReason > 22 && eReason < 32 && this.mTemplateModel != null && !this.mTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V27_EVENTMODEL) && node instanceof Container && ((Container)node).isValidAttr(409, false, null) && (eAccess = (container = (Container)node).getRuntimeAccess(0)) == 65536) {
            return false;
        }
        if (this.mTemplateModel != null && this.mTemplateModel.getOriginalXFAVersion() >= 30 && node instanceof Container && 1076494339 == (ePresence = (container = (Container)node).getRuntimePresence(0))) {
            return false;
        }
        return em.eventOccurred(nEventId, node);
    }

    public void exportConnectionData(String strConnectionName, String sDataDescriptionName) {
        Node old;
        AppModel appModel = (AppModel)this.getXFAParent();
        this.mDataModel = DataModel.getDataModel(appModel, false, false);
        DataNode connectionDataNode = (DataNode)this.resolveNode("!connectionData");
        if (connectionDataNode == null) {
            connectionDataNode = (DataNode)this.mDataModel.createChild(false, "connectionData");
        }
        if ((old = connectionDataNode.resolveNode(strConnectionName, false, false, true)) != null) {
            old.remove();
        }
        DataNode exportDataRoot = new DataNode(connectionDataNode, null);
        String internedConnectionName = strConnectionName.intern();
        exportDataRoot.setDOMProperties(null, internedConnectionName, internedConnectionName, null);
        Node dataDescription = null;
        for (Node dataModelChild = this.mDataModel.getFirstXFAChild(); dataModelChild != null; dataModelChild = dataModelChild.getNextXFASibling()) {
            int index;
            Element dataModelChildElement;
            if (!(dataModelChild instanceof Element) || (dataModelChildElement = (Element)dataModelChild).getNS() != "http://ns.adobe.com/data-description/" || dataModelChildElement.getName() != "dataDescription" || (index = dataModelChildElement.findAttr("http://ns.adobe.com/data-description/", "name")) == -1 || !dataModelChildElement.getAttrVal(index).equals(sDataDescriptionName)) continue;
            dataDescription = dataModelChild;
            break;
        }
        if (dataDescription == null) {
            return;
        }
        DataNode dataDescriptionRoot = (DataNode)dataDescription.resolveNode(strConnectionName, false, false, true);
        if (dataDescriptionRoot == null) {
            return;
        }
        exportDataRoot.setDataDescription(dataDescriptionRoot);
        this.mDataModel.initFromDataDescription(exportDataRoot);
        FormModel.recurseConnectOnNode(this, strConnectionName, 0x5F0000, mConnectExportHandler, null);
        DataModel.removeDDPlaceholderFlags(exportDataRoot, true);
    }

    private Element findDescendantMatch(List<Container> list, Element dataParent, Element connectionDataParent) {
        if (!this.mbWeightedData && this.mStartNode != null) {
            this.mStartNode.setWeight(1);
            this.mbWeightedData = true;
        }
        Container targetNode = null;
        int nWeight = 0;
        int nCount = list.size();
        for (int i = 0; i < nCount; ++i) {
            Container templateNode = list.get(i);
            Container.FormInfo formInfo = this.getFormInfo(templateNode, dataParent, connectionDataParent);
            int nNewWeight = 0;
            DataNode dataNode = this.findMatch(formInfo, true, DatasetSelector.MAIN_DATASET);
            if (dataNode != null) {
                nNewWeight = dataNode.getWeight();
            } else if (formInfo.eMergeType == 0x1F0000 || this.mbGlobalConsumption) {
                IntegerHolder newWeight = new IntegerHolder(nNewWeight);
                this.hasDescendantMatch(templateNode, dataParent, connectionDataParent, formInfo.eMergeType, false, newWeight);
                nNewWeight = newWeight.value;
            }
            if (nNewWeight <= 0 || nWeight != 0 && nNewWeight >= nWeight) continue;
            nWeight = nNewWeight;
            targetNode = templateNode;
        }
        return targetNode;
    }

    private Node findGlobalNode(Element templateNode, Element dataParent, IntegerHolder nCount, DataWindow dataWindow) {
        Node match = null;
        for (Node dataChild = dataParent.getFirstXFAChild(); dataChild != null; dataChild = dataChild.getNextXFASibling()) {
            if (FormModel.isMappable(templateNode, dataChild, true, false)) {
                ++nCount.value;
                match = dataChild;
            }
            if (dataChild.getClassTag() == 77) {
                if (dataWindow != null && dataWindow.isRecordGroup((DataNode)dataChild)) continue;
                Node temp = this.findGlobalNode(templateNode, (DataNode)dataChild, nCount, dataWindow);
                if (temp != null) {
                    match = temp;
                }
            }
            if (match != null && (dataWindow == null || dataWindow.recordAbsIndex(0) == nCount.value)) break;
        }
        return match;
    }

    DataNode findMatch(Container.FormInfo formInfo, boolean bUnMappedOnly, DatasetSelector eDataset) {
        if (formInfo == null || formInfo.eMergeType == 0x1F0000) {
            return null;
        }
        if (formInfo.eMergeType == 2031618 && bUnMappedOnly) {
            return null;
        }
        NodeList list = null;
        switch (eDataset) {
            case MAIN_DATASET: {
                list = formInfo.dataNodes;
                break;
            }
            case ALT_DATASET: {
                list = formInfo.altDataNodes;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Container templateNode = formInfo.templateContainerNode;
        while (list.length() > 0) {
            DataNode dataNode = (DataNode)list.item(0);
            if (this.mergeMode() == 0x8C0000) {
                if (formInfo.bRemoveAfterUse && dataNode.isMapped() || !FormModel.isMappable(templateNode, dataNode, false, false)) {
                    list.remove(dataNode);
                    continue;
                }
                if (bUnMappedOnly && !dataNode.isMapped() || !bUnMappedOnly) {
                    return dataNode;
                }
                return null;
            }
            if (this.mergeMode() != 9175041) continue;
            return dataNode;
        }
        if (formInfo.eMergeType == 0x1F0001) {
            Element parent;
            boolean bAdded = false;
            while (!bAdded && formInfo.scopeData != null && this.mDataModel != (parent = formInfo.scopeData.getXFAParent())) {
                formInfo.scopeData = parent;
                if (formInfo.scopeData == null || formInfo.scopeData.getModel() != this.mDataModel) break;
                if (FormModel.getAssociation(parent, templateNode.getName(), list)) continue;
                for (Node dataChild = formInfo.scopeData.getFirstXFAChild(); dataChild != null; dataChild = dataChild.getNextXFASibling()) {
                    DataWindow dataWindow;
                    if (!FormModel.isMappable(templateNode, dataChild, true, true) || dataChild.getClassTag() == 77 && (dataWindow = this.mDataModel.getDataWindow()) != null && dataWindow.isRecordGroup((DataNode)dataChild)) continue;
                    list.append(dataChild);
                    bAdded = true;
                }
            }
            if (bAdded) {
                return this.findMatch(formInfo, bUnMappedOnly, eDataset);
            }
        }
        return null;
    }

    private Node findUnMappedOverlayDataChild(Node dormNode, Node dataParent) {
        for (Node dataChild = dataParent.getFirstXFAChild(); dataChild != null; dataChild = dataChild.getNextXFASibling()) {
            if (!FormModel.isMappableForOverlayData(dormNode, dataChild, true)) continue;
            return dataChild;
        }
        return null;
    }

    public boolean getAdjustData() {
        return this.mbAdjustData;
    }

    public String getAmbientLocale() {
        return this.msLocale;
    }

    @Override
    public String getBaseNS() {
        return "http://www.xfa.org/schema/xfa-form/";
    }

    ScriptInfo getCalculateInfo(ProtoableNode node) {
        assert (node != null);
        Element calcProp = node.getElement(36, true, 0, false, false);
        if (calcProp == null) {
            return null;
        }
        return this.getScriptInfo(node, calcProp);
    }

    public boolean getCalculationsEnabled() {
        if (this.mbIgnoreCalcEnabledFlag) {
            return true;
        }
        if (this.mHostPseudoModel != null) {
            return this.mHostPseudoModel.getCalculationsEnabled();
        }
        return true;
    }

    String getConnectionName() {
        return this.msConnectionName;
    }

    private String getDataRef(Element node, String sConnect, BooleanHolder bIsConnect) {
        Element bind;
        String sDataRef = "";
        if (bIsConnect != null) {
            bIsConnect.value = false;
        }
        if ((bind = node.getElement(364, true, 0, false, false)) != null) {
            sDataRef = bind.getAttribute(392).toString();
        }
        if (!StringUtils.isEmpty(sConnect)) {
            StringHolder strConnectionRootRef = new StringHolder();
            StringHolder strConnectRef = new StringHolder();
            if (FormModel.getConnectSOMStrings(node, this.msConnectionName, 6225921, strConnectionRootRef, strConnectRef, null)) {
                sDataRef = strConnectRef.value;
            }
            if (bIsConnect != null && !StringUtils.isEmpty(strConnectRef.value)) {
                bIsConnect.value = true;
            }
        }
        return sDataRef;
    }

    public Validate getDefaultValidate() {
        return this.mDefaultValidate;
    }

    @Override
    public Obj getDelta(Element node, String sSOM) {
        Element delta = null;
        FormSubform deltaSubform = this.getDeltaSubform();
        if (deltaSubform != null) {
            String sSOM2 = node.getSOMExpression(this.mRootFormSubform, false);
            delta = (Element)deltaSubform.resolveNode(sSOM2, true, false, false);
        }
        return new Delta(node, delta, sSOM);
    }

    public Obj getDeltas(Element node) {
        String sSOM;
        Element delta;
        XFAList list = new XFAList();
        FormSubform deltaSubform = this.getDeltaSubform();
        if (deltaSubform != null && (delta = (Element)deltaSubform.resolveNode(sSOM = node.getSOMExpression(this.mRootFormSubform, false), true, false, false)) != null && delta.isSameClass(node)) {
            node.getDeltas(delta, list);
        }
        return list;
    }

    FormSubform getDeltaSubform() {
        return this.mDeltasSubform;
    }

    boolean getMatchDescendantsOnly() {
        return this.mbMatchDescendantsOnly;
    }

    boolean getEmptyMerge() {
        return this.mbEmptyMerge;
    }

    public Execute getExecute() {
        return this.mExecute;
    }

    ExecuteInfo getExecuteInfo(ProtoableNode node, Node eventNode) {
        Node executeNode = null;
        String sEventContext = "$";
        if (!eventNode.isSameClass(124)) {
            return null;
        }
        Element eventElement = (Element)eventNode;
        executeNode = eventElement.getOneOfChild(true, false);
        sEventContext = eventElement.getAttribute(392).toString();
        if (executeNode == null || !executeNode.isSameClass(130)) {
            return null;
        }
        return new ExecuteInfo(sEventContext, node);
    }

    public FormField getFocus() {
        return this.mActiveField;
    }

    Container.FormInfo getFormInfo(Node templateNode, Element dataParent, Element connectionDataParent) {
        if (templateNode == null) {
            return null;
        }
        if (dataParent != null && dataParent.getModel() != this.mDataModel) {
            return null;
        }
        if (templateNode instanceof Container) {
            Container container = (Container)templateNode;
            Container.FormInfo formInfo = container.getFormInfo();
            if (formInfo != null && formInfo.dataParent == dataParent && formInfo.connectionDataParent == connectionDataParent) {
                return formInfo;
            }
            BooleanHolder bAssociation = new BooleanHolder(false);
            boolean bConnectDataRef = false;
            int eMergeType = this.mergeType(container, this.msConnectionName, null);
            if (eMergeType == 0x1F0001 || eMergeType == 2031620) {
                ArrayNodeList list = new ArrayNodeList();
                if (dataParent != null) {
                    if (this.mergeMode() == 9175041 && FormModel.getAssociation(dataParent, container.getName(), list)) {
                        bAssociation.value = true;
                    } else {
                        boolean bMatchAll = true;
                        int nTargetIndex = 0;
                        if (this.mergeMode() == 9175041 && templateNode.getSibling(1, true, false) != null) {
                            bMatchAll = false;
                            nTargetIndex = templateNode.getIndex(true);
                        }
                        int nCurrIndex = 0;
                        for (Node dataChild = dataParent.getFirstXFAChild(); dataChild != null; dataChild = dataChild.getNextXFASibling()) {
                            if (!FormModel.isMappable(container, dataChild, true, true)) continue;
                            if (bMatchAll || nCurrIndex == nTargetIndex) {
                                ((ListBase)list).append(dataChild);
                                continue;
                            }
                            ++nCurrIndex;
                        }
                    }
                }
                this.setFormInfo(container, dataParent, list, bAssociation.value, eMergeType, true, bConnectDataRef, connectionDataParent, null);
            } else if (eMergeType == 2031619) {
                int eDataMergeType;
                boolean bSomIsAbsolute;
                BooleanHolder bConnectDataRef2 = new BooleanHolder();
                String sSom = this.getDataRef(container, this.msConnectionName, bConnectDataRef2);
                boolean bl = bSomIsAbsolute = !FormModel.somIsRelative(sSom);
                if (formInfo != null && bSomIsAbsolute) {
                    return formInfo;
                }
                NodeList dataNodes = new ArrayNodeList();
                Element resolveContext = null;
                resolveContext = bConnectDataRef2.value ? connectionDataParent : dataParent;
                if (resolveContext == null && bSomIsAbsolute && this.mergeMode() == 9175041) {
                    resolveContext = this.mStartNode;
                }
                if (resolveContext != null) {
                    dataNodes = resolveContext.resolveNodes(sSom, true, false, true, null, bAssociation);
                }
                if (this.mergeMode() == 9175041) {
                    for (int i = dataNodes.length() - 1; i >= 0; --i) {
                        Node candidate = (Node)dataNodes.item(i);
                        if (FormModel.isMappable(container, candidate, false, false)) continue;
                        dataNodes.remove(candidate);
                    }
                }
                ArrayNodeList altDataNodes = new ArrayNodeList();
                if (bConnectDataRef2.value && ((eDataMergeType = this.mergeType(container, "", null)) == 0x1F0001 || eDataMergeType == 2031620) && dataParent != null) {
                    if (this.mergeMode() == 9175041 && FormModel.getAssociation(dataParent, container.getName(), altDataNodes)) {
                        bAssociation.value = true;
                    } else {
                        for (Node dataChild = dataParent.getFirstXFAChild(); dataChild != null; dataChild = dataChild.getNextXFASibling()) {
                            if (!FormModel.isMappable(container, dataChild, true, true)) continue;
                            ((ListBase)altDataNodes).append(dataChild);
                        }
                    }
                }
                this.setFormInfo(container, dataParent, dataNodes, bAssociation.value, eMergeType, FormModel.isSomMultiple(sSom), bConnectDataRef2.value, connectionDataParent, altDataNodes);
            } else if (eMergeType == 2031618) {
                if (formInfo == null) {
                    boolean bUseDV = FormModel.useDV(templateNode);
                    ArrayNodeList dataNodes = new ArrayNodeList();
                    DataNode dataNode = this.resolveGlobal(container, bUseDV);
                    if (dataNode != null) {
                        ((ListBase)dataNodes).append(dataNode);
                    }
                    this.setFormInfo(container, dataParent, dataNodes, bAssociation.value, eMergeType, false, false, null, null);
                }
            } else if (eMergeType == 0x1F0000) {
                this.setFormInfo(container, dataParent, null, bAssociation.value, eMergeType, false, false, connectionDataParent, null);
            }
            Container.FormInfo ret = container.getFormInfo();
            assert (ret != null);
            return ret;
        }
        return null;
    }

    NodeList getFormNodes(Node dataNode) {
        ArrayNodeList ret = new ArrayNodeList();
        if (dataNode != null) {
            int nPeer = 0;
            Peer peer = dataNode.getPeer(nPeer);
            while (peer != null) {
                Element formNode;
                if (peer instanceof FormDataListener && (formNode = ((FormDataListener)peer).getFormNode()) != null) {
                    ((ListBase)ret).append(formNode);
                }
                peer = dataNode.getPeer(++nPeer);
            }
        }
        return ret;
    }

    public boolean getFormStateRemoved() {
        return this.mbFormStateRemoved;
    }

    boolean getFormStateUsage() {
        return this.mbFormStateUsage;
    }

    public String getFriendlyName(Element formNode) {
        assert (formNode instanceof FormSubform || formNode instanceof FormField || formNode instanceof FormExclGroup);
        String sReturnVal = "";
        if (formNode instanceof FormSubform || formNode instanceof FormField || formNode instanceof FormExclGroup) {
            Element assist = null;
            int ePriority = 0x5E0000;
            boolean bDisableSpeak = false;
            if (formNode.isPropertySpecified(22, true, 0) && (assist = formNode.getElement(22, true, 0, false, false)) != null && assist.isPropertySpecified(288, true, 0)) {
                Element speak = assist.peekElement(288, false, 0);
                if (speak != null && speak.isPropertySpecified(482, true, 0) && speak.getEnum(482) == 0x40040001) {
                    bDisableSpeak = true;
                }
                if (speak != null && speak.isPropertySpecified(611, true, 0) && speak.isPropertySpecified(611, true, 0)) {
                    ePriority = speak.getEnum(611);
                }
            }
            int[] props = new int[4];
            if (ePriority == 0x5E0000) {
                props[0] = 288;
                props[1] = 320;
                props[2] = 41;
                props[3] = 574;
            } else if (ePriority == 6160385) {
                props[0] = 320;
                props[1] = 288;
                props[2] = 41;
                props[3] = 574;
            } else if (ePriority == 6160386) {
                props[0] = 41;
                props[1] = 288;
                props[2] = 320;
                props[3] = 574;
            } else {
                props[0] = 574;
                props[1] = 288;
                props[2] = 320;
                props[3] = 41;
            }
            for (int nIndex = 0; nIndex < 4; ++nIndex) {
                TextNode text;
                int nProp = props[nIndex];
                if (nProp == 288 && !bDisableSpeak) {
                    ProtoableNode speak;
                    if (assist == null || !assist.isPropertySpecified(288, true, 0) || (speak = (ProtoableNode)assist.peekElement(288, false, 0)) == null || (text = speak.getText(true, false, false)) == null) continue;
                    sReturnVal = text.getValue();
                    break;
                }
                if (nProp == 320) {
                    ProtoableNode tooltip;
                    if (assist == null || !assist.isPropertySpecified(320, true, 0) || (tooltip = (ProtoableNode)assist.peekElement(320, false, 0)) == null || (text = tooltip.getText(true, false, false)) == null) continue;
                    sReturnVal = text.getValue();
                    break;
                }
                if (nProp == 41) {
                    Content captionContent;
                    Value value;
                    Element caption = formNode.getElement(41, true, 0, false, false);
                    if (caption == null || (value = (Value)caption.peekElement(405, false, 0)) == null || (captionContent = (Content)value.getOneOfChild(true, false)) == null) continue;
                    if (captionContent.getClassTag() == 125) {
                        sReturnVal = ((ExDataValue)captionContent).getValue(false, false, false);
                        break;
                    }
                    TextNode text2 = captionContent.getText(true, false, false);
                    if (text2 == null) continue;
                    sReturnVal = text2.getValue();
                    break;
                }
                if (nProp != 574) continue;
                sReturnVal = formNode.getAttribute(574).toString();
                break;
            }
        }
        return sReturnVal;
    }

    @Override
    public String getHeadNS() {
        return "http://www.xfa.org/schema/xfa-form/2.8/";
    }

    public HostPseudoModel getHost() {
        return this.mHostPseudoModel;
    }

    private int getOccurAttribute(Element templateNode, int eTag) {
        int nValue = 1;
        if (this.mbIsXFAF ? !(templateNode instanceof Subform) || templateNode.getXFAParent() != this.mRootSubform : !(templateNode instanceof Subform) && !(templateNode instanceof SubformSet)) {
            return nValue;
        }
        Element occur = templateNode.getElement(208, true, 0, false, false);
        if (occur != null) {
            Int value = (Int)occur.getAttribute(eTag);
            nValue = value.getValue();
        }
        return nValue;
    }

    public boolean getOverlayDataMergeUsage() {
        return this.mbOverlayDataMergeUsage;
    }

    public int getPanelToMergeAgainst() {
        return this.mnPanel;
    }

    void getPanelSubforms(Node container, NodeList panelSFList) {
        if (container != null) {
            if (container instanceof Subform == container.getXFAParent() instanceof FormModel) {
                for (Node child = container.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (child == null) continue;
                    if (child instanceof Subform) {
                        panelSFList.append(child);
                        continue;
                    }
                    if (!(child instanceof SubformSet)) continue;
                    this.getPanelSubforms(child, panelSFList);
                }
            } else assert (false);
        }
    }

    void getPanelSubforms(NodeList panelSFList) {
        for (Node topSubform = this.getFirstXFAChild(); topSubform != null; topSubform = topSubform.getNextXFASibling()) {
            if (!(topSubform instanceof Subform)) continue;
            this.getPanelSubforms(topSubform, panelSFList);
            break;
        }
    }

    public PostMergeHandler getPostMergeHandler() {
        return this.mPostMergeHandler;
    }

    @Override
    public List<ProtoableNode> getProtoList() {
        return this.mTemplateModel.getProtoList();
    }

    public int getRunScripts() {
        return this.meRunAtSetting;
    }

    ScriptInfo getScriptInfo(ProtoableNode node, Element eventNode) {
        Element scriptNode = null;
        if (eventNode == null) {
            return null;
        }
        String sEventContext = "$";
        if (eventNode.isSameClass(124)) {
            scriptNode = (Element)eventNode.getOneOfChild(true, false);
            sEventContext = eventNode.getAttribute(392).toString();
        } else {
            scriptNode = eventNode.getElement(394, true, 0, false, false);
        }
        if (scriptNode == null || !scriptNode.isSameClass(394)) {
            return null;
        }
        String sBinding = scriptNode.getAttribute(435).toString();
        if (!StringUtils.isEmpty(sBinding) && !sBinding.equals("XFA")) {
            return null;
        }
        Attribute oRunAt = scriptNode.getAttribute(634);
        int eRunAt = ((EnumValue)oRunAt).getInt();
        String sScriptType = scriptNode.getAttribute(457).toString();
        TextNode scriptText = scriptNode.getText(true, false, false);
        if (scriptText == null) {
            return null;
        }
        String sScriptText = scriptText.getValue();
        return new ScriptInfo(sScriptText, sScriptType, sEventContext, eRunAt, node);
    }

    @Override
    public ScriptTable getScriptTable() {
        return FormModelScript.getScriptTable();
    }

    public ServerExchange getServerExchange() {
        return this.mServerExchange;
    }

    public Submit getSubmit() {
        return this.mSubmit;
    }

    private SubmitInfo getSubmitInfo(ProtoableNode node, Node eventNode) {
        Element submitNode = null;
        String sEventContext = "$";
        if (!eventNode.isSameClass(124)) {
            return null;
        }
        Element eventElement = (Element)eventNode;
        submitNode = (Element)eventElement.getOneOfChild(true, false);
        sEventContext = eventElement.getAttribute(392).toString();
        if (submitNode == null || !submitNode.isSameClass(301)) {
            return null;
        }
        return new SubmitInfo(sEventContext, node);
    }

    public String getSubmitURL() {
        return this.msSubmitURL;
    }

    Validate getValidate() {
        return this.mValidate;
    }

    private ValidateInfo getValidateInfo(ProtoableNode node) {
        Attribute attr;
        Node currentUI;
        Element ui;
        if (this.getOverlayDataMergeUsage()) {
            int nPanel = this.getPanelToMergeAgainst();
            if (node.isSameClass(133) || node.isSameClass(297) || node.isSameClass(127)) {
                boolean bIsTopSubform;
                Node topSubform = this.getFirstXFAChild();
                boolean bl = bIsTopSubform = node == topSubform;
                if (!bIsTopSubform) {
                    int nIndex;
                    Element panelSubform = null;
                    if (node.isSameClass(297)) {
                        panelSubform = node;
                    }
                    for (Element parent = node.getXFAParent(); parent != null && parent != topSubform; parent = parent.getXFAParent()) {
                        if (!parent.isSameClass(297)) continue;
                        panelSubform = parent;
                    }
                    if (panelSubform != null && (nIndex = panelSubform.getClassIndex()) != nPanel) {
                        return null;
                    }
                }
            }
        }
        Element validateNode = node.getElement(404, true, 0, false, false);
        String sBarcodeType = "";
        if (validateNode == null && node.isSameClass(133) && (ui = node.getElement(331, true, 0, false, false)) != null && (currentUI = ui.getOneOfChild(true, false)) != null && currentUI.isSameClass(24) && (attr = ((Element)currentUI).getAttribute(402)) != null) {
            sBarcodeType = attr.toString();
        }
        if (validateNode == null && !StringUtils.isEmpty(sBarcodeType)) {
            return new ValidateInfo(null, null, "$", sBarcodeType, 1079836672, node);
        }
        if (validateNode == null) {
            return null;
        }
        Element scriptNode = validateNode.getElement(394, true, 0, false, false);
        Element pictureNode = validateNode.getElement(242, true, 0, false, false);
        boolean bNullTest = validateNode.getEnum(578) != 0x380000;
        boolean bFormatTest = validateNode.getEnum(507) != 0x380000 && pictureNode != null;
        String sScriptType = null;
        String sScriptText = null;
        int eRunAt = 1079836674;
        if (scriptNode != null && scriptNode.isSameClass(394)) {
            TextNode scriptTextNode;
            Attribute runAt = scriptNode.getAttribute(634);
            eRunAt = ((EnumValue)runAt).getInt();
            sScriptType = scriptNode.getAttribute(457).toString();
            String sBinding = scriptNode.getAttribute(435).toString();
            if ((StringUtils.isEmpty(sBinding) || sBinding.equals("XFA")) && (scriptTextNode = scriptNode.getText(true, false, false)) != null) {
                sScriptText = scriptTextNode.getValue();
            }
        }
        if (sScriptText == null && !bNullTest && !bFormatTest) {
            return null;
        }
        return new ValidateInfo(sScriptText, sScriptType, "$", null, eRunAt, node);
    }

    public boolean getValidationsEnabled() {
        if (this.mbIgnoreValidationsEnabledFlag) {
            return true;
        }
        if (this.mHostPseudoModel != null) {
            return this.mHostPseudoModel.getValidationsEnabled();
        }
        return true;
    }

    private boolean hasDescendantMatch(Element templateNode, Element dataParent, Element connectionDataParent, int eMergeType, boolean bConnectOnly, IntegerHolder weight) {
        if (templateNode instanceof Field || templateNode instanceof Draw || templateNode instanceof ExclGroup && eMergeType != 0x1F0000) {
            return false;
        }
        if (eMergeType == 2031618 || eMergeType == 2031619) {
            bConnectOnly = true;
        }
        if (bConnectOnly && StringUtils.isEmpty(this.msConnectionName)) {
            return false;
        }
        if (bConnectOnly) {
            dataParent = null;
        }
        boolean bMatchFound = false;
        for (Node templateChild = templateNode.getFirstXFAChild(); templateChild != null; templateChild = templateChild.getNextXFASibling()) {
            Container.FormInfo info = this.getFormInfo(templateChild, dataParent, connectionDataParent);
            if (info == null) continue;
            DataNode dataNode = this.findMatch(info, true, DatasetSelector.MAIN_DATASET);
            if (dataNode != null && (!bConnectOnly || info.bConnectDataRef)) {
                int nNewWeight;
                if (weight != null && (nNewWeight = dataNode.getWeight()) > 0 && (weight.value == 0 || nNewWeight < weight.value)) {
                    weight.value = nNewWeight;
                }
                bMatchFound = true;
            } else if (info.eMergeType == 0x1F0000 || this.mbGlobalConsumption) {
                bMatchFound |= this.hasDescendantMatch((Element)templateChild, dataParent, connectionDataParent, info.eMergeType, bConnectOnly, weight);
            }
            if (weight == null && bMatchFound) break;
        }
        return bMatchFound;
    }

    public void importConnectionData(String strConnectionName) {
        BooleanHolder allowed = new BooleanHolder(true);
        FormModel.recurseConnectOnNode(this, strConnectionName, 6225921, mConnectImportPermCheckHandler, allowed);
        if (!allowed.value) {
            MsgFormatPos message = new MsgFormatPos(ResId.PermissionsViolationExceptionMethod);
            message.format("execute");
            throw new ExFull(message);
        }
        FormModel.recurseConnectOnNode(this, strConnectionName, 6225921, mConnectImportHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element importNode(ProtoableNode templateNode, Element formParent, boolean bFull) {
        boolean bWasAllowingNewNodes = this.allowNewNodes(true);
        boolean bOldAdjustData = this.mbAdjustData;
        if (formParent == null) {
            this.mbAdjustData = false;
        }
        ProtoableNode newFormNode = (ProtoableNode)this.createNode(templateNode.getClassTag(), formParent, "", "", true);
        String aNodeName = templateNode.getName();
        if (aNodeName != null && "" != aNodeName) {
            newFormNode.privateSetName(aNodeName);
        }
        FormModel.outputTraceMessage(ResId.NodeCreatedTrace, newFormNode, null, "");
        newFormNode.setProto(templateNode);
        if (bFull) {
            Element mappedParent = FormModel.getMappedParent(newFormNode);
            DataNode dataParent = null;
            if (mappedParent != null) {
                dataParent = FormModel.getDataNode(mappedParent);
            }
            if (dataParent == null) {
                dataParent = this.mDataModel.getDataRoot();
            }
            for (Node templateChild = templateNode.getFirstXFAChild(); templateChild != null; templateChild = templateChild.getNextXFASibling()) {
                if (!(templateChild instanceof Element)) continue;
                Element templateChildElement = (Element)templateChild;
                FormInstanceManager newInstanceManager = this.createInstanceManager(templateChildElement, newFormNode);
                if (this.mbEmptyMerge) {
                    this.createEmptyFormNode(templateChildElement, newFormNode, null, newInstanceManager);
                    continue;
                }
                this.createAndMatchNode(templateChildElement, dataParent, newFormNode, null);
            }
            this.mergeSecondPass(newFormNode, dataParent);
            FormSubform deltaSubform = this.getDeltaSubform();
            if (deltaSubform != null) {
                this.isLoading(true);
                try {
                    String sSOM = newFormNode.getSOMExpression(this.mRootFormSubform, false);
                    Element delta = (Element)deltaSubform.resolveNode(sSOM, true, false, false);
                    XFAList list = new XFAList();
                    if (delta != null && delta.isSameClass(newFormNode)) {
                        if (this.mbRestoreDeltas) {
                            newFormNode.getDeltas(delta, list);
                        } else {
                            newFormNode.getDeltas(delta, null);
                        }
                        int nLen = list.length();
                        for (int i = 0; i < nLen; ++i) {
                            Delta deltaNode = (Delta)list.item(i);
                            deltaNode.restore();
                        }
                    }
                }
                finally {
                    this.isLoading(false);
                }
            }
            if (newFormNode instanceof Container) {
                this.setDynamicProperties((Container)newFormNode, "", true);
            }
        }
        this.mbAdjustData = bOldAdjustData;
        this.allowNewNodes(bWasAllowingNewNodes);
        return newFormNode;
    }

    private boolean incrementalMerge() {
        DataNode newRecord;
        if (this.mDataModel == null || this.mRootSubform == null) {
            return false;
        }
        if (this.mDataDescription == null) {
            return false;
        }
        if (!FormModel.incrementalMergeCheckDataDescription(this.mDataDescription)) {
            return false;
        }
        DataWindow dataWindow = this.mDataModel.getDataWindow();
        if (dataWindow == null || !dataWindow.isDefined()) {
            return false;
        }
        DataNode previousRecord = FormModel.getDataNode(this.mRootFormSubform);
        if (previousRecord == (newRecord = dataWindow.record(0))) {
            return false;
        }
        return this.incrementalMergeUpdateTree(previousRecord, newRecord);
    }

    private boolean incrementalMergeUpdateTree(DataNode prevDataNode, DataNode newDataNode) {
        if (!prevDataNode.isSameClass(newDataNode)) {
            return false;
        }
        if (prevDataNode.getName() != newDataNode.getName()) {
            return false;
        }
        int nPeer = 0;
        Peer peer = prevDataNode.getPeer(nPeer);
        while (peer != null) {
            if (peer instanceof FormDataListener) {
                FormDataListener listener = (FormDataListener)peer;
                Element formNode = listener.getFormNode();
                assert (newDataNode != listener.getDataNode());
                if (formNode != null) {
                    listener.setDataNode(newDataNode);
                    if (this.mergeMode() == 0x8C0000) {
                        newDataNode.setMapped(true);
                    }
                }
            }
            peer = prevDataNode.getPeer(++nPeer);
        }
        int nPrevDataChildren = this.dataNodeChildrenCount(prevDataNode);
        int nNewDataChildren = this.dataNodeChildrenCount(newDataNode);
        if (nNewDataChildren > nPrevDataChildren) {
            return false;
        }
        List<DataNode> prevDataChildren = this.dataNodeChildren(prevDataNode);
        List<DataNode> newDataChildren = this.dataNodeChildren(newDataNode);
        int nPrev = 0;
        int nNew = 0;
        while (nPrev < nPrevDataChildren) {
            DataNode newDataChild;
            DataNode prevDataChild = prevDataChildren.get(nPrev);
            if (nPrev == nNewDataChildren) {
                if (prevDataChild.getClassTag() != 82) {
                    return false;
                }
                DataNode prevDataNodeChild = prevDataChild;
                if (prevDataChild.isDefault(false)) {
                    newDataChildren.add(prevDataChild);
                    --nPrev;
                    --nPrevDataChildren;
                } else {
                    newDataChildren.add((DataNode)prevDataNodeChild.clone(newDataNode, true));
                    assert (++nNewDataChildren == nPrev + 1);
                }
            }
            if (!this.incrementalMergeUpdateTree(prevDataChild, newDataChild = newDataChildren.get(nNew))) {
                return false;
            }
            nPrevDataChildren = prevDataNode.getXFAChildCount();
            ++nPrev;
            ++nNew;
        }
        return true;
    }

    private int dataNodeChildrenCount(Node node) {
        int count = 0;
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof DataNode)) continue;
            ++count;
        }
        return count;
    }

    private List<DataNode> dataNodeChildren(Node node) {
        ArrayList<DataNode> nodeList = new ArrayList<DataNode>();
        for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof DataNode)) continue;
            nodeList.add((DataNode)child);
        }
        return nodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() {
        boolean bRet = false;
        if (this.mRootFormSubform != null) {
            String sInitialize = EnumAttr.getString(0x4B0000);
            EventManager em = this.getEventManager();
            int nID = em.getEventID(sInitialize);
            bRet = this.eventOccurred(em, nID, 3, this.mRootFormSubform, false);
            try {
                this.mbRecursiveIndexChange = true;
                String sIndexChange = EnumAttr.getString(4915221);
                nID = em.getEventID(sIndexChange);
                bRet |= this.eventOccurred(em, nID, 15, this.mRootFormSubform, false);
            }
            finally {
                this.mbRecursiveIndexChange = false;
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initializeNewContentNodes() {
        boolean bEventsDispatched = false;
        String sInitialize = EnumAttr.getString(0x4B0000);
        EventManager em = this.getEventManager();
        int nInitID = em.getEventID(sInitialize);
        int nIndexChangeID = em.getEventID(sInitialize);
        for (int i = 0; i < this.mLayoutContent.size(); ++i) {
            LayoutContentInfo layoutContentInfo = this.mLayoutContent.get(i);
            if (layoutContentInfo.mbInitializeOccurred) continue;
            layoutContentInfo.mbInitializeOccurred = true;
            bEventsDispatched |= this.eventOccurred(em, nInitID, 3, layoutContentInfo.mNode, false);
            try {
                this.mbRecursiveIndexChange = true;
                bEventsDispatched |= this.eventOccurred(em, nIndexChangeID, 15, layoutContentInfo.mNode, false);
                continue;
            }
            finally {
                this.mbRecursiveIndexChange = false;
            }
        }
        return bEventsDispatched;
    }

    boolean isActivityExcluded(String activity) {
        if (this.mExcludeList != null) {
            for (int i = 0; i < this.mExcludeList.length; ++i) {
                if (!this.mExcludeList[i].equals(activity)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCompatibleNS(String aNS) {
        return Model.checkforCompatibleNS(aNS, "http://www.xfa.org/schema/xfa-template/") || Model.checkforCompatibleNS(aNS, "http://www.xfa.org/schema/xfa-form/");
    }

    private static boolean isMappable(Element formNode, Node dataNode, boolean bCheckNames, boolean bUnMapped) {
        FormModel.outputTraceMessage(ResId.NodeComparedTrace, formNode, dataNode, "");
        if (bUnMapped && dataNode.isMapped()) {
            return false;
        }
        if (bCheckNames) {
            if (formNode.getName() == "") {
                return false;
            }
            if (formNode.getName() != dataNode.getName()) {
                return false;
            }
        }
        if (formNode instanceof Field && dataNode.getClassTag() != 82) {
            Node currentUI;
            boolean bIsMultiSelect = false;
            Element ui = ((Field)formNode).getElement(331, true, 0, false, false);
            if (ui != null && (currentUI = ui.getOneOfChild(true, false)) != null && currentUI.getClassAtom() == "choiceList" && ((Element)currentUI).getEnum(584) == 0x230003) {
                bIsMultiSelect = true;
            }
            if (!bIsMultiSelect) {
                return false;
            }
            if (bIsMultiSelect && dataNode.getClassTag() != 77) {
                return false;
            }
        }
        return !(formNode instanceof Subform) || dataNode.getClassTag() == 77;
    }

    private static boolean isMappableForOverlayData(Node formNode, Node dataNode, boolean bUnMapped) {
        if (bUnMapped && dataNode.isMapped()) {
            return false;
        }
        if (formNode.getName() == "") {
            return false;
        }
        if (formNode.getName() != dataNode.getName()) {
            return false;
        }
        return !(formNode instanceof Subform) || dataNode.getClassTag() == 77;
    }

    private static boolean isValidSetPropertyTarget(Node target, Container container) {
        if (target == null) {
            return false;
        }
        for (Node parent = target; parent != null; parent = parent.getXFAParent()) {
            if (!(parent instanceof Container) || parent != container) continue;
            return true;
        }
        return false;
    }

    private void loadDeltas() {
        Node subformChild;
        if (!this.mbForceRestore) {
            this.mbRestoreDeltas = this.mbRestoreDeltas && this.mRootSubform.getEnum(624) == 7864321;
        }
        AppModel appModel = this.getAppModel();
        Node formNode = null;
        for (Node child = appModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getName() != "form" || !child.isSameClass(220)) continue;
            formNode = (Packet)child;
        }
        if (formNode == null) {
            return;
        }
        formNode.remove();
        String sCheckSum = ((Packet)formNode).getAttribute("checksum");
        if (StringUtils.isEmpty(sCheckSum)) {
            return;
        }
        if (!this.computeCheckSum().equals(sCheckSum) && !this.computeCheckSum(false).equals(sCheckSum)) {
            return;
        }
        for (subformChild = ((Element)formNode).getFirstXMLChild(); !(subformChild == null || subformChild instanceof Element && ((Element)subformChild).getLocalName() == "subform"); subformChild = subformChild.getNextXMLSibling()) {
        }
        if (subformChild == null) {
            return;
        }
        this.mDeltasSubform = new FormSubform(null, null);
        this.mDeltasSubform.setModel(this);
        this.mDeltasSubform.setNS(((Element)subformChild).getNS());
        this.doLoadAttributes((Element)subformChild, this.mDeltasSubform);
        this.isLoading(true);
        Generator genTag = new Generator("", "");
        for (Node child = subformChild.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element) && !(child instanceof Chars)) continue;
            this.doLoadNode(this.mDeltasSubform, child, genTag);
        }
        this.isLoading(false);
    }

    @Override
    protected void loadXMLImpl(Element parent, InputStream is, boolean bIgnoreAggregatingTag, Element.ReplaceContent eReplaceContent) {
        MsgFormatPos oMessage = new MsgFormatPos(ResId.UnsupportedOperationException);
        oMessage.format("loadXML");
        oMessage.format(parent.getClassAtom());
        throw new ExFull(oMessage);
    }

    boolean mapChild(Element templateNode, Element formParent) {
        if (templateNode.isSameClass(251) || templateNode.isSameClass(225) || templateNode.isSameClass(222) || formParent == null || this.mbIsXFAF && templateNode.isSameClass(298)) {
            return false;
        }
        ChildReln reln = formParent.getChildReln(templateNode.getClassTag());
        return reln.getMax() == -1;
    }

    private int mapOrderedSubformSet(Element templateNode, Element formParent, DataNode dataParent, Element connectionDataParent, FormInstanceManager instanceManager) {
        int nMax = this.getOccurAttribute(templateNode, 555);
        if (nMax != -1 && nMax < 1) {
            return 0;
        }
        int nRequired = this.getOccurAttribute(templateNode, 566);
        int nCreated = 0;
        while (this.hasDescendantMatch(templateNode, dataParent, connectionDataParent, this.mergeType(templateNode, "", null), false, null)) {
            Element formNode = this.createFormNode(templateNode, formParent, instanceManager);
            this.createAndMatchChildren(templateNode, dataParent, formNode, connectionDataParent);
            if (nMax == -1 || ++nCreated != nMax) continue;
            break;
        }
        if (nCreated == 0) {
            nRequired = this.getOccurAttribute(templateNode, 524);
        }
        nRequired -= nCreated;
        for (int nCount = 0; nCount < nRequired; ++nCount) {
            if (this.mergeMode() == 0x8C0000) {
                this.createEmptyFormNode(templateNode, formParent, connectionDataParent, instanceManager);
            } else {
                Element formNode = this.createFormNode(templateNode, formParent, instanceManager);
                this.createAndMatchChildren(templateNode, dataParent, formNode, connectionDataParent);
            }
            ++nCreated;
        }
        return nCreated;
    }

    private int mapSubformSet(Element templateNode, Element formParent, DataNode dataParent, Element connectionDataParent) {
        boolean bSaveMatchDescendantsOnly = this.mbMatchDescendantsOnly;
        if (!this.mbGlobalConsumption) {
            this.mbMatchDescendantsOnly = true;
        }
        int nCreated = 0;
        int eRelation = ((EnumValue)templateNode.getAttribute(620)).getInt();
        FormInstanceManager instanceManager = this.createInstanceManager(templateNode, formParent);
        nCreated = eRelation == -2144600064 ? this.mapOrderedSubformSet(templateNode, formParent, dataParent, connectionDataParent, instanceManager) : (eRelation == -2144600062 ? this.mapUnorderedSubformSet(templateNode, formParent, dataParent, connectionDataParent, instanceManager, true) : this.mapUnorderedSubformSet(templateNode, formParent, dataParent, connectionDataParent, instanceManager, false));
        this.mbMatchDescendantsOnly = bSaveMatchDescendantsOnly;
        return nCreated;
    }

    private int mapUnorderedSubformSet(Element templateNode, Element formParent, DataNode dataParent, Element connectionDataParent, FormInstanceManager instanceManager, boolean bIsChoice) {
        Element subChild;
        int nMax = this.getOccurAttribute(templateNode, 555);
        if (nMax != -1 && nMax < 1) {
            return 0;
        }
        int nRequired = this.getOccurAttribute(templateNode, 566);
        int nCreated = 0;
        ArrayList<Container> unusedChildren = new ArrayList<Container>();
        for (Node templateChild = templateNode.getFirstXFAChild(); templateChild != null; templateChild = templateChild.getNextXFASibling()) {
            if (!(templateChild instanceof Subform) && !(templateChild instanceof SubformSet)) continue;
            unusedChildren.add((Container)templateChild);
        }
        Element targetProto = this.findDescendantMatch(unusedChildren, dataParent, connectionDataParent);
        while (targetProto != null) {
            ++nCreated;
            Element subformSet = this.createFormNode(templateNode, formParent, instanceManager);
            this.createAndMatchNode(targetProto, dataParent, subformSet, connectionDataParent);
            unusedChildren.remove(targetProto);
            if (!bIsChoice && unusedChildren.size() > 0) {
                while (unusedChildren.size() > 0 && (targetProto = this.findDescendantMatch(unusedChildren, dataParent, connectionDataParent)) != null) {
                    this.createAndMatchNode(targetProto, dataParent, subformSet, connectionDataParent);
                    unusedChildren.remove(targetProto);
                }
                for (int i = 0; i < unusedChildren.size(); ++i) {
                    subChild = (Element)unusedChildren.get(i);
                    if (this.mergeMode() == 0x8C0000) {
                        this.createInstanceManager(subChild, subformSet);
                        int nRequired2 = this.getOccurAttribute(subChild, 566);
                        for (int nCount = 0; nCount < nRequired2; ++nCount) {
                            this.createEmptyFormNode(subChild, subformSet, connectionDataParent, instanceManager);
                        }
                    } else {
                        this.createAndMatchNode(subChild, dataParent, subformSet, connectionDataParent);
                    }
                    unusedChildren.remove(targetProto);
                }
            }
            if (nMax != -1 && nCreated == nMax) break;
            ArrayList<Container> newList = new ArrayList<Container>();
            for (Node templateChild = templateNode.getFirstXFAChild(); templateChild != null; templateChild = templateChild.getNextXFASibling()) {
                if (!(templateChild instanceof Subform) && !(templateChild instanceof SubformSet)) continue;
                newList.add((Container)templateChild);
            }
            unusedChildren = newList;
            targetProto = this.findDescendantMatch(unusedChildren, dataParent, connectionDataParent);
        }
        if (nCreated == 0) {
            nRequired = this.getOccurAttribute(templateNode, 524);
        }
        nRequired -= nCreated;
        for (int nCount = 0; nCount < nRequired; ++nCount) {
            if (this.mergeMode() == 0x8C0000) {
                this.createEmptyFormNode(templateNode, formParent, connectionDataParent, instanceManager);
            } else {
                Element subformSet = this.createFormNode(templateNode, formParent, instanceManager);
                if (bIsChoice) {
                    subChild = (Container)unusedChildren.get(0);
                    this.createAndMatchNode(subChild, dataParent, subformSet, connectionDataParent);
                } else {
                    this.createAndMatchChildren(templateNode, dataParent, subformSet, connectionDataParent);
                }
            }
            ++nCreated;
        }
        return nCreated;
    }

    public void merge(boolean bEmptyMerge, boolean bAdjustData, boolean bInitialize, boolean bRestoreDeltas, boolean bForceRestore) {
        this.merge(bEmptyMerge, bAdjustData, "", bInitialize, bRestoreDeltas, bForceRestore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(boolean bEmptyMerge, boolean bAdjustData, String sConnectionName, boolean bInitialize, boolean bRestoreDeltas, boolean bForceRestore) {
        TraceTimer timer;
        block33: {
            TraceTimer mergeOnlyTimer = new TraceTimer(TraceHandler.TimingType.XFA_MERGE_ONLY_TIMING);
            try {
                if (!this.mbEnableIncrementalMerge) {
                    FormModel.outputTraceMessage(ResId.IncrementalMergeDisabledTrace, null, null, "");
                }
                this.mbWasIncrementalMerge = false;
                if (this.mbEnableIncrementalMerge && this.mbAdjustData == bAdjustData && this.mbEmptyMerge == bEmptyMerge && this.incrementalMerge()) {
                    if (bInitialize && !this.mbExchangingDataWithServer && this.getRunScripts() != 1080754179) {
                        if (this.getXFAParent() != null && this.getEventManager() != null) {
                            this.getEventManager().reset();
                        }
                        TraceTimer timer2 = new TraceTimer(TraceHandler.TimingType.XFAPA_MERGE_CALC_TIMING);
                        try {
                            this.initialize();
                        }
                        finally {
                            timer2.stopTiming();
                        }
                    }
                    this.notifyPeers(0, "", null);
                    FormModel.outputTraceMessage(ResId.IncrementalMergeSucceededTrace, null, null, "");
                    this.mbWasIncrementalMerge = true;
                    return;
                }
                if (this.mbEnableIncrementalMerge) {
                    FormModel.outputTraceMessage(ResId.IncrementalMergeFullMergeTrace, null, null, "");
                }
                this.mActiveField = null;
                this.mPrevActiveField = null;
                if (this.mbMergeComplete) {
                    this.reset();
                }
                this.mbAdjustData = bAdjustData;
                this.mbEmptyMerge = bEmptyMerge;
                this.mbRestoreDeltas = bRestoreDeltas;
                this.mbForceRestore = bForceRestore;
                this.preMerge(sConnectionName);
                this.mergeFirstPass();
                this.mergeSecondPass(this, null);
                FormSubform deltaSubform = this.getDeltaSubform();
                if (deltaSubform == null) break block33;
                this.isLoading(true);
                try {
                    XFAList list = new XFAList();
                    if (this.mbRestoreDeltas) {
                        this.mRootFormSubform.getDeltas(deltaSubform, list);
                    } else {
                        this.mRootFormSubform.getDeltas(deltaSubform, null);
                    }
                    int nLen = list.length();
                    for (int i = 0; i < nLen; ++i) {
                        Delta delta = (Delta)list.item(i);
                        delta.restore();
                    }
                }
                finally {
                    this.isLoading(false);
                }
            }
            finally {
                mergeOnlyTimer.stopTiming();
            }
        }
        if (this.mPostMergeHandler != null) {
            this.mPostMergeHandler.handlePostMerge(this.mPostMergeHandlerClientData);
        }
        if (bInitialize && !this.mbExchangingDataWithServer && this.getRunScripts() != 1080754179) {
            timer = new TraceTimer(TraceHandler.TimingType.XFAPA_MERGE_CALC_TIMING);
            try {
                this.initialize();
            }
            finally {
                timer.stopTiming();
            }
        }
        this.updateFromFormState();
        this.mergeOverlayData();
        this.setDynamicProperties(this.mRootFormSubform, sConnectionName, true);
        this.mbMergeComplete = true;
        if (this.getRunScripts() != 1080754179) {
            timer = new TraceTimer(TraceHandler.TimingType.XFAPA_MERGE_CALC_TIMING);
            try {
                this.runExecEvents();
            }
            finally {
                timer.stopTiming();
            }
        }
        if (this.getFormStateUsage()) {
            this.createFormState();
        } else {
            Node formState = this.getAppModel().locateChildByName("formState", 0);
            if (formState != null) {
                for (Node stateChild = formState.getFirstXMLChild(); stateChild != null; stateChild = stateChild.getNextXMLSibling()) {
                    if (!(stateChild instanceof Element)) continue;
                    this.mbFormStateRemoved = true;
                    break;
                }
                formState.remove();
            }
        }
        this.notifyPeers(0, "", null);
    }

    private void mergeOverlayData() {
        if (this.getOverlayDataMergeUsage()) {
            int nPanel = this.getPanelToMergeAgainst();
            Node overlayData = null;
            for (Node child = this.mDataModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (child.getName() != "overlayData") continue;
                overlayData = child;
                break;
            }
            if (overlayData != null) {
                Node topSubform = this.getFirstXFAChild();
                Node targetSubform = null;
                int nCnt = 0;
                Node subformChild = topSubform.getFirstXFAChild();
                while (subformChild != null) {
                    if (subformChild instanceof FormSubform) {
                        if (nCnt == nPanel) {
                            targetSubform = subformChild;
                            break;
                        }
                        ++nCnt;
                    }
                    subformChild.getNextXFASibling();
                }
                if (targetSubform != null) {
                    this.mergeOverlayData(targetSubform, overlayData);
                    this.mDataModel.getNodes().remove(overlayData);
                } else {
                    MsgFormatPos formatError = new MsgFormatPos(ResId.OverlayDataSubformNotFound);
                    throw new ExFull(formatError);
                }
            }
        }
    }

    public void mergeOverlayData(Node formNode, Node overlayData) {
        Node formChild;
        for (formChild = formNode.getFirstXFAChild(); formChild != null; formChild = formChild.getNextXFASibling()) {
            if (!(formChild instanceof FormSubform)) continue;
            FormSubform subform = (FormSubform)formChild;
            FormInstanceManager manager = subform.getInstanceManager();
            int nCount = this.countOverlayDataChild(formChild, overlayData);
            int nInstances = manager.getCount();
            int nMin = manager.getMin();
            int nMax = manager.getMax();
            if (nCount == nInstances || nCount < nMin || nCount > nMax && nMax != -1) continue;
            manager.setInstances(nCount, true);
        }
        block1: for (formChild = formNode.getFirstXFAChild(); formChild != null; formChild = formChild.getNextXFASibling()) {
            Node dataMatch;
            if (formChild instanceof FormSubform) {
                Node dataMatch2 = this.findUnMappedOverlayDataChild(formChild, overlayData);
                if (dataMatch2 != null) {
                    this.consumeDataNode(null, dataMatch2, DatasetSelector.MAIN_DATASET);
                    this.mergeOverlayData(formChild, dataMatch2);
                    continue;
                }
                this.mergeOverlayData(formChild, overlayData);
                continue;
            }
            if (formChild instanceof FormField) {
                Node currentUI;
                FormField field = (FormField)formChild;
                dataMatch = this.findUnMappedOverlayDataChild(formChild, overlayData);
                if (dataMatch != null) {
                    this.consumeDataNode(null, dataMatch, DatasetSelector.MAIN_DATASET);
                    NodeList dataChildren = dataMatch.getNodes();
                    int nNodes = dataChildren.length();
                    if (formChild instanceof FormChoiceListField) {
                        StringBuilder sValue = new StringBuilder();
                        for (int i = 0; i < nNodes; ++i) {
                            Node dataChildNode = (Node)dataChildren.item(i);
                            String aName = dataChildNode.getName();
                            if (aName != "value") continue;
                            sValue.append(((DataNode)dataChildNode).getValue());
                            sValue.append('\n');
                        }
                        field.setRawValue(sValue.toString());
                        break;
                    }
                    for (int i = 0; i < nNodes; ++i) {
                        String sValue;
                        Node dataChildNode = (Node)dataChildren.item(i);
                        String aName = dataChildNode.getName();
                        if (aName == "value") {
                            sValue = ((DataNode)dataChildNode).getValue();
                            field.setRawValue(sValue);
                            continue;
                        }
                        if (aName != "formattedValue") continue;
                        sValue = ((DataNode)dataChildNode).getValue();
                        Element valueNode = field.getElement(405, true, 0, true, false);
                        Node contentNode = null;
                        if (valueNode != null) {
                            contentNode = valueNode.getOneOfChild(false, true);
                        }
                        StringHolder sCanon = new StringHolder();
                        if (!StringUtils.isEmpty(sValue) && contentNode != null && (contentNode.isSameClass(164) || contentNode.isSameClass(137) || contentNode.isSameClass(92))) {
                            int nWidth;
                            int nPrec;
                            LcData data2;
                            int nOptn;
                            String sPict;
                            String sLocale = field.getInstalledLocale();
                            LcData data = new LcData(sLocale);
                            if (StringUtils.isEmpty(sCanon.value)) {
                                sPict = data.getNumberFormat(0, 0);
                                PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanon);
                            }
                            if (StringUtils.isEmpty(sCanon.value)) {
                                sPict = data.getNumberFormat(0, 1);
                                PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanon);
                            }
                            if (StringUtils.isEmpty(sCanon.value)) {
                                nOptn = 0;
                                data2 = new LcData(sLocale);
                                nPrec = data2.getNumberPrecision(sValue);
                                nOptn |= LcData.withPrecision(nPrec | 0x80);
                                nWidth = sValue.length();
                                if (nWidth > 0) {
                                    nOptn |= LcData.withWidth(nWidth);
                                }
                                sPict = data2.getNumberFormat(1, nOptn);
                                PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanon);
                            }
                            if (StringUtils.isEmpty(sCanon.value)) {
                                nOptn = 1;
                                data2 = new LcData(sLocale);
                                nPrec = data2.getNumberPrecision(sValue);
                                nOptn |= LcData.withPrecision(nPrec | 0x80);
                                nWidth = sValue.length();
                                if (nWidth > 0) {
                                    nOptn |= LcData.withWidth(nWidth);
                                }
                                sPict = data2.getNumberFormat(1, nOptn);
                                PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanon);
                            }
                        }
                        if (!StringUtils.isEmpty(sCanon.value)) {
                            field.setRawValue(sCanon.value);
                            continue;
                        }
                        field.setFormattedValue(sValue);
                    }
                    this.checkForItems(field, dataMatch);
                    continue;
                }
                Element ui = field.getElement(331, true, 0, false, false);
                if (ui == null || (currentUI = ui.getOneOfChild(true, false)) == null || !currentUI.isSameClass(46) && !currentUI.isSameClass(47)) continue;
                field.setOn(false);
                continue;
            }
            if (formChild instanceof FormExclGroup) {
                FormExclGroup group = (FormExclGroup)formChild;
                dataMatch = this.findUnMappedOverlayDataChild(group, overlayData);
                if (dataMatch == null) continue;
                String sValue = "";
                NodeList dataChildren = dataMatch.getNodes();
                int nDataNodes = dataChildren.length();
                for (int i = 0; i < nDataNodes; ++i) {
                    Node dataChildNode = (Node)dataChildren.item(i);
                    String aName = dataChildNode.getName();
                    if (aName != "value") continue;
                    sValue = ((DataNode)dataChildNode).getValue();
                }
                NodeList exclGroupChildren = formChild.getNodes();
                int nNodes = exclGroupChildren.length();
                for (int j = 0; j < nNodes; ++j) {
                    String sSub;
                    Node childNode = (Node)exclGroupChildren.item(j);
                    if (!(childNode instanceof FormField)) continue;
                    String sSom = childNode.getSOMExpression();
                    int nFoundAt = sSom.indexOf(46);
                    boolean bFound = nFoundAt != -1;
                    int saveFoundAt = nFoundAt;
                    if (bFound) {
                        while (true) {
                            boolean bFound2;
                            boolean bl = bFound2 = (nFoundAt = sSom.indexOf(".", saveFoundAt + 1)) != -1;
                            if (!bFound2) break;
                            saveFoundAt = nFoundAt;
                        }
                        nFoundAt = saveFoundAt;
                    }
                    if (!(sSub = !bFound ? sSom : sSom.substring(nFoundAt + 1)).equals(sValue)) continue;
                    String sOn = ((FormField)childNode).getOnValue();
                    group.setRawValue(sOn);
                    continue block1;
                }
                continue;
            }
            if (!formNode.isContainer()) continue;
            this.mergeOverlayData(formChild, overlayData);
        }
    }

    int mergeType(Node node, String sConnect, BooleanHolder bIsConnect) {
        String sDataRef;
        EnumValue eScope;
        if (!(node.isSameClass(297) || node.isSameClass(133) || node.isSameClass(127))) {
            return 0x1F0000;
        }
        if (node.isSameClass(297) && (eScope = (EnumValue)((Element)node).getAttribute(637)).getInt() == 5963777) {
            return 0x1F0000;
        }
        boolean bCheckForRef = !StringUtils.isEmpty(sConnect);
        int eRetValue = 0x1F0001;
        Container container = (Container)node;
        Element bind = container.getElement(364, true, 0, false, false);
        if (bind != null) {
            EnumValue eType = (EnumValue)bind.getAttribute(554, true, false);
            if (eType != null) {
                eRetValue = eType.getInt();
            } else {
                bCheckForRef = true;
            }
        }
        if (bCheckForRef && !StringUtils.isEmpty(sDataRef = this.getDataRef(container, this.msConnectionName, bIsConnect))) {
            eRetValue = 2031619;
        }
        if (eRetValue == 2031619) {
            return eRetValue;
        }
        if (node.getName() == "") {
            return 0x1F0000;
        }
        if (eRetValue == 0x1F0001) {
            if (this.mergeMode() == 9175041) {
                eRetValue = 2031620;
            } else if (this.getMatchDescendantsOnly()) {
                eRetValue = 2031620;
            }
        }
        return eRetValue;
    }

    String metaData(int nOutputType) {
        return this.mHostPseudoModel != null ? this.mHostPseudoModel.metaData(nOutputType) : "";
    }

    @Override
    public void normalizeNameSpaces() {
        this.setNameSpaceURI("http://www.xfa.org/schema/xfa-form/2.8/", false, false, false);
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element)) continue;
            super.normalizeNameSpaces((Element)child, "http://www.xfa.org/schema/xfa-form/2.8/");
        }
    }

    private static void outputTraceMessage(int nResId, Node inputNode1, Node inputNode2, String sInput) {
        if (!Trace.isEnabled("merge", 1)) {
            return;
        }
        MsgFormatPos msg = new MsgFormatPos(nResId);
        int nTraceLevel = 0;
        if (nResId == ResId.StartMergeDataGroup) {
            assert (inputNode1 != null);
            msg.format("'" + inputNode1.getSOMExpression() + "'");
            nTraceLevel = 1;
        } else if (nResId == ResId.FormNodeMatchedTrace) {
            assert (inputNode1 != null);
            assert (inputNode2 != null);
            msg.format(inputNode1.getClassAtom());
            msg.format("'" + inputNode1.getSOMExpression() + "'");
            msg.format(inputNode2.getClassAtom());
            msg.format("'" + inputNode2.getSOMExpression() + "'");
            nTraceLevel = 1;
        } else if (nResId == ResId.IncrementalMergeDisabledTrace) {
            nTraceLevel = 1;
        } else if (nResId == ResId.IncrementalMergeSucceededTrace) {
            nTraceLevel = 1;
        } else if (nResId == ResId.IncrementalMergeFullMergeTrace) {
            nTraceLevel = 1;
        }
        if (Trace.isEnabled("merge", 2)) {
            nTraceLevel = 2;
            if (nResId == ResId.NodeCreatedTrace) {
                assert (inputNode1 != null);
                msg.format(inputNode1.getClassAtom());
                msg.format("'" + inputNode1.getSOMExpression() + "'");
            } else if (nResId == ResId.DataNodeMoved) {
                assert (inputNode1 != null);
                assert (!StringUtils.isEmpty(sInput));
                msg.format(inputNode1.getClassAtom());
                msg.format("'" + sInput + "'");
                msg.format("'" + inputNode1.getSOMExpression() + "'");
            } else if (nResId == ResId.UnmappedNode) {
                assert (inputNode1 != null);
                msg.format(inputNode1.getClassAtom());
                msg.format("'" + inputNode1.getSOMExpression() + "'");
            }
        }
        if (Trace.isEnabled("merge", 3)) {
            nTraceLevel = 3;
            if (nResId == ResId.NodeComparedTrace) {
                assert (inputNode1 != null);
                assert (inputNode2 != null);
                msg.format("'" + inputNode1.getSOMExpression() + "'");
                msg.format("'" + inputNode2.getSOMExpression() + "'");
            }
        }
        if (nTraceLevel > 0) {
            Trace.trace("merge", nTraceLevel, msg);
        }
    }

    boolean performPreEventValidations() {
        boolean bValidationSucceeded = true;
        Validate validate = null;
        if (this.getDefaultValidate() != null) {
            validate = this.getDefaultValidate().clone();
        }
        if (validate != null) {
            validate.setFormatTestEnabled(true);
            validate.setNullTestEnabled(true);
            validate.setScriptTestEnabled(true);
        }
        this.recalculate(false, validate, true);
        this.validate(validate, null, true, true);
        if (validate != null && validate.getFailCount() != 0) {
            bValidationSucceeded = false;
        }
        return bValidationSucceeded;
    }

    private boolean postExecEvent(EventManager em, int nEventId, int eReason, Element container) {
        Validate validate;
        return container != null && eReason == 24 && (container instanceof FormSubform || container instanceof FormExclGroup) ? this.validate(validate = this.getDefaultValidate().clone(), container, false, false) : container != null && eReason == 3 && (container.isSameClass(297) || container.isSameClass(133) || container.isSameClass(127)) && this.fireValidationStateEvent((Container)container);
    }

    @Override
    protected void postLoad() {
    }

    void mergeSecondPass(Element formParent, Element dataParent) {
        this.msConnectionName = "";
        this.mbConnectionMerge = false;
        if (this.mergeMode() == 0x8C0000) {
            if (this.mbAdjustData && this.mDataDescription == null) {
                this.adjustData(formParent, dataParent);
            }
            this.findOrCreateMissingData();
        }
        if (this.mbMergeComplete || dataParent == null) {
            FormModel.recursiveDeleteFormInfos(this.mRootSubform);
            this.mExplicitMatchNodes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean preExecEvent(EventManager em, int nEventId, int eReason, Node container, boolean recursiveCall) {
        Element parent;
        boolean bNotifyParent;
        boolean bRecursive;
        if (container == null || !container.isContainer() || container.getModel() == null) {
            return false;
        }
        boolean bEventDispatched = false;
        boolean bl = bRecursive = eReason == 2 || eReason == 1 || eReason == 3 || this.mbRecursiveIndexChange || eReason == 15 && !container.isSameClass(297);
        if (bRecursive && container.getClassTag() != 102 && container.getClassTag() != 133) {
            NodeList children = (NodeList)container.getNodes().clone();
            for (int i = 0; i < children.length(); ++i) {
                Node child = (Node)children.item(i);
                if (child == null || !child.isContainer() || child.getModel() == null || !this.eventOccurred(em, nEventId, eReason, (Element)child, true)) continue;
                bEventDispatched = true;
            }
        }
        boolean bl2 = bNotifyParent = (parent = container.getXFAParent()) != null && parent.isSameClass(127) && !recursiveCall && (eReason == 27 || eReason == 28 || eReason == 29);
        if (bNotifyParent) {
            bEventDispatched |= this.eventOccurred(em, nEventId, eReason, parent, false);
        }
        if (eReason == 23) {
            int i;
            ArrayList<Container> exitNodes = new ArrayList<Container>();
            ArrayList<Container> enterNodes = new ArrayList<Container>();
            FormField prevField = this.mPrevActiveField;
            if (prevField != null) {
                for (Element prevAncestor = prevField.getXFAParent(); prevAncestor != null; prevAncestor = prevAncestor.getXFAParent()) {
                    if (!(prevAncestor instanceof FormSubform) && !(prevAncestor instanceof FormExclGroup)) continue;
                    exitNodes.add((Container)prevAncestor);
                }
            }
            if (container.isSameClass(133)) {
                if (this.mActiveField != container) {
                    return bEventDispatched;
                }
                for (Element ancestor = container.getXFAParent(); ancestor != null; ancestor = ancestor.getXFAParent()) {
                    if (!ancestor.isSameClass(297) && !ancestor.isSameClass(127)) continue;
                    enterNodes.add((Container)ancestor);
                }
            }
            boolean bDone = false;
            while (0 < exitNodes.size() && 0 < enterNodes.size() && !bDone) {
                if (exitNodes.get(exitNodes.size() - 1) == enterNodes.get(enterNodes.size() - 1)) {
                    exitNodes.remove(exitNodes.size() - 1);
                    enterNodes.remove(exitNodes.size() - 1);
                    continue;
                }
                bDone = true;
            }
            String sExitEvent = EnumAttr.getString(4915202);
            int nExitEventId = em.getEventID(sExitEvent);
            this.mPrevActiveField = null;
            boolean bLegacyV32Scripting = this.mTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING);
            for (i = 0; i < exitNodes.size(); ++i) {
                if (bLegacyV32Scripting) {
                    EventPseudoModel.EventInfo eventInfo = null;
                    if (this.mEventPseudoModel != null) {
                        eventInfo = this.mEventPseudoModel.getEventInfo();
                    }
                    try {
                        if (this.mEventPseudoModel != null) {
                            this.mEventPseudoModel.reset();
                            this.mEventPseudoModel.setTarget((Obj)exitNodes.get(i));
                            this.mEventPseudoModel.setName(24);
                        }
                        bEventDispatched |= this.legacyEventOccurred(em, nExitEventId, 24, (Element)exitNodes.get(i), false);
                        continue;
                    }
                    finally {
                        if (this.mEventPseudoModel != null) {
                            this.mEventPseudoModel.setEventInfo(eventInfo);
                        }
                    }
                }
                bEventDispatched |= this.eventOccurred(em, nExitEventId, 24, (Element)exitNodes.get(i), false);
            }
            if (0 < enterNodes.size()) {
                for (i = 0; i < enterNodes.size(); ++i) {
                    int nIndex = enterNodes.size() - 1 - i;
                    if (bLegacyV32Scripting) {
                        EventPseudoModel.EventInfo eventInfo = null;
                        if (this.mEventPseudoModel != null) {
                            eventInfo = this.mEventPseudoModel.getEventInfo();
                        }
                        try {
                            if (this.mEventPseudoModel != null) {
                                this.mEventPseudoModel.reset();
                                this.mEventPseudoModel.setTarget((Obj)enterNodes.get(nIndex));
                                this.mEventPseudoModel.setName(eReason);
                            }
                            bEventDispatched |= this.legacyEventOccurred(em, nEventId, eReason, (Element)enterNodes.get(nIndex), false);
                            continue;
                        }
                        finally {
                            if (this.mEventPseudoModel != null) {
                                this.mEventPseudoModel.setEventInfo(eventInfo);
                            }
                        }
                    }
                    bEventDispatched |= this.eventOccurred(em, nEventId, eReason, (Element)enterNodes.get(nIndex), false);
                }
            }
        }
        return bEventDispatched;
    }

    private void preMerge(String sConnectionName) {
        DataWindow dataWindow;
        boolean bUseEmpty = false;
        if (this.mDataModel == null) {
            AppModel appModel = (AppModel)this.getXFAParent();
            this.mDataModel = DataModel.getDataModel(appModel, true, false);
            bUseEmpty = true;
        }
        if ((dataWindow = this.mDataModel.getDataWindow()) != null && dataWindow.isDefined()) {
            this.mStartNode = dataWindow.record(0);
        }
        this.mRootSubform = null;
        this.mRootFormSubform = null;
        this.setCurrentVersion(this.mTemplateModel.getCurrentVersion());
        this.mbIsXFAF = this.mTemplateModel.getEnum(430) == 7602177;
        for (Node templateNode = this.mTemplateModel.getFirstXFAChild(); templateNode != null; templateNode = templateNode.getNextXFASibling()) {
            if (!templateNode.isSameClass(297)) continue;
            if (this.mRootSubform == null) {
                this.mRootSubform = (Subform)templateNode;
            }
            if (this.mStartNode == null || templateNode.getName() != this.mStartNode.getName()) continue;
            this.mRootSubform = (Subform)templateNode;
            break;
        }
        if (this.mRootSubform != null) {
            this.mDataDescription = this.mDataModel.getDataDescriptionRoot(this.mRootSubform.getName());
            this.mbGlobalConsumption = this.mRootSubform.getEnum(565) == 0x8C0000;
        }
        boolean bAppendNewNode = false;
        if (this.mStartNode == null && this.mRootSubform != null) {
            bUseEmpty = true;
            if (this.mDataDescription != null) {
                this.mStartNode = this.mDataModel.createDataRootElement(this.mDataDescription);
                if (this.mStartNode != null) {
                    bAppendNewNode = true;
                }
            }
        }
        if (this.mRootSubform != null && bUseEmpty) {
            if (this.mStartNode == null) {
                this.mStartNode = (DataNode)this.mDataModel.createNode(77, null, this.mRootSubform.getName(), "", true);
                bAppendNewNode = this.mbAdjustData;
            }
            if (bAppendNewNode) {
                Element data = this.mDataModel.getAliasNode();
                if (data.getFirstXFAChild() != null) {
                    Node ref = data.getFirstXFAChild();
                    data.insertChild(this.mStartNode, ref, true);
                } else {
                    data.appendChild(this.mStartNode, true);
                }
            }
            dataWindow.addRecordGroup(this.mStartNode);
            dataWindow.updateAfterLoad();
        }
        if (this.mRootSubform == null || this.mStartNode == null) {
            MsgFormatPos msg = new MsgFormatPos(ResId.RootSubformMergeFailure);
            throw new ExFull(msg);
        }
        if (this.mDataDescription != null) {
            this.setMatchDescendantsOnly(true);
        } else {
            this.setMatchDescendantsOnly(false);
        }
        FormModel.recursiveDeleteFormInfos(this.mRootSubform);
        this.mbEmptyMerge = bUseEmpty;
        this.msConnectionName = sConnectionName;
        this.mbConnectionMerge = !StringUtils.isEmpty(this.msConnectionName);
        this.loadDeltas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preSave(boolean bSaveXMLScript) {
        boolean previousWillDirty = this.getWillDirty();
        this.setWillDirty(false);
        try {
            if (!bSaveXMLScript) {
                String sCheckSum = this.computeCheckSum();
                if (!StringUtils.isEmpty(sCheckSum)) {
                    this.setAttribute(new StringAttr("checksum", sCheckSum), 446);
                }
                this.preSave(this.mRootFormSubform, null);
            }
            this.normalizeNameSpaces();
        }
        finally {
            this.setWillDirty(previousWillDirty);
        }
    }

    private void preSave(Node formNode, Element dataParent) {
        block20: {
            block19: {
                FormInstanceManager manager;
                block21: {
                    String sLocale;
                    if (formNode == null) {
                        return;
                    }
                    DataNode dataNode = FormModel.getDataNode(formNode);
                    if (dataNode != null && dataNode.getXFAParent() != null && !dataNode.isDefault(false)) {
                        if (formNode.isSameClass(133)) {
                            Element value = ((Element)formNode).getElement(405, 0);
                            if (value.getEnum(593) == 0x40040001) {
                                value.getOneOfChild().isTransient(true, false);
                                value.isTransient(false, false);
                                value.makeNonDefault(false);
                            } else {
                                value.isTransient(true, false);
                            }
                        }
                        dataParent = dataNode;
                    }
                    if (formNode.isSameClass(133)) {
                        Node currentUI;
                        Element fieldElement = (Element)formNode;
                        Element value = fieldElement.getElement(405, 0);
                        Element ui = fieldElement.getElement(331, true, 0, false, false);
                        if (ui != null && (currentUI = ui.getOneOfChild(true, false)) != null && currentUI.isSameClass(233)) {
                            value.isTransient(true, false);
                        }
                    }
                    if (!formNode.isContainer()) break block19;
                    Element container = (Element)formNode;
                    Attribute oLocale = container.getAttribute(382, true, false);
                    if (oLocale != null && (sLocale = oLocale.toString()).equals("ambient")) {
                        formNode.mute();
                        container.setAttribute(new StringAttr("locale", this.getCachedLocale()), 382);
                        formNode.unMute();
                    }
                    ArrayList<Node> nameList = new ArrayList<Node>();
                    for (Node child = formNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                        this.preSave(child, dataParent);
                        nameList.add(child);
                    }
                    if (formNode.isDefault(false)) break block20;
                    boolean bClearDefault = false;
                    int nFirst = 0;
                    int nCount = nameList.size();
                    Node[] nodes = nameList.toArray(new Node[nCount]);
                    Arrays.sort(nodes, new Comparator<Node>(){

                        @Override
                        public int compare(Node node1, Node node2) {
                            int result = node1.getName().compareTo(node2.getName());
                            if (result != 0) {
                                return result;
                            }
                            return node1.getClassTag() < node2.getClassTag() ? -1 : (node1.getClassTag() > node2.getClassTag() ? 1 : 0);
                        }
                    });
                    nameList = null;
                    for (int i = 1; i < nCount; ++i) {
                        Node node1 = nodes[i - 1];
                        Node node2 = nodes[i];
                        if (node1.getName() != node2.getName() || !node1.isSameClass(node2)) {
                            if (bClearDefault) {
                                while (nFirst < i) {
                                    Node child = nodes[nFirst];
                                    child.makeNonDefault(false);
                                    ++nFirst;
                                }
                                bClearDefault = false;
                            }
                            nFirst = i;
                            continue;
                        }
                        bClearDefault |= !node1.isDefault(false) || !node2.isDefault(false);
                    }
                    if (bClearDefault) {
                        while (nFirst < nCount) {
                            Node child = nodes[nFirst];
                            child.makeNonDefault(false);
                            ++nFirst;
                        }
                    }
                    if (!formNode.isSameClass(297)) break block21;
                    FormInstanceManager manager2 = ((FormSubform)formNode).getInstanceManager();
                    if (manager2 != null) {
                        manager2.makeNonDefault(false);
                    }
                    break block20;
                }
                if (!formNode.isSameClass(298) || (manager = ((FormSubformSet)formNode).getInstanceManager()) == null) break block20;
                manager.makeNonDefault(false);
                break block20;
            }
            if ((formNode.isSameClass("border") || formNode.isSameClass("rectangle")) && !formNode.isDefault(true)) {
                Node formChild = formNode.getFirstXFAChild();
                while (formNode != null) {
                    if (!formChild.isDefault(true) && (formChild.isSameClass(106) || formChild.isSameClass(71))) {
                        formChild.makeNonDefault(false);
                    }
                    formNode = formNode.getNextXFASibling();
                }
            }
        }
    }

    private void mergeFirstPass() {
        String name;
        Node node;
        Node connectData;
        this.allowNewNodes(true);
        Element connectDataRoot = null;
        if (this.mbConnectionMerge && (connectData = this.mDataModel.locateChildByName("connectionData", 0)) != null && (node = connectData.locateChildByName(name = this.msConnectionName.intern(), 0)) instanceof Element) {
            connectDataRoot = (Element)node;
        }
        if (this.mbEmptyMerge && this.mergeMode() == 0x8C0000) {
            this.mRootFormSubform = (FormSubform)this.createEmptyFormNode(this.mRootSubform, this, connectDataRoot, null);
            this.bindNodes(this.mRootFormSubform, this.mStartNode, false);
            this.consumeDataNode(null, this.mStartNode, DatasetSelector.MAIN_DATASET);
        } else {
            this.mRootFormSubform = (FormSubform)this.createFormNode(this.mRootSubform, this, null);
            this.bindNodes(this.mRootFormSubform, this.mStartNode, false);
            this.consumeDataNode(null, this.mStartNode, DatasetSelector.MAIN_DATASET);
            this.createAndMatchChildren(this.mRootSubform, this.mStartNode, this.mRootFormSubform, connectDataRoot);
        }
        this.allowNewNodes(false);
    }

    private DataNode findNestedAttrMatch(Node field, Node dataParent, int eMergeType) {
        assert (eMergeType == 0x1F0001 || eMergeType == 2031620);
        if (dataParent == null) {
            return null;
        }
        for (Node dvParent = dataParent.getFirstXFAChild(); dvParent != null; dvParent = dvParent.getNextXFASibling()) {
            if (dvParent.getClassTag() != 82) continue;
            for (Node dataChild = dvParent.getFirstXFAChild(); dataChild != null; dataChild = dataChild.getNextXFASibling()) {
                DataNode value;
                if (dataChild.getClassTag() != 82 || (value = (DataNode)dataChild).isMapped() || !value.isAttribute() || value.getName() != field.getName()) continue;
                return value;
            }
        }
        return null;
    }

    boolean queueCalculate(Element node) {
        if (this.isActivityExcluded("calculate")) {
            return false;
        }
        List<Node> list = this.mPendingCalculateNodes;
        if (!this.canBeQueued(node, true)) {
            return false;
        }
        Element action = node.getElement(36, true, 0, false, false);
        Element scriptNode = null;
        if (action != null) {
            scriptNode = action.getElement(394, true, 0, false, false);
        }
        if (scriptNode != null) {
            list.add(node);
            return true;
        }
        return false;
    }

    void queueCalculatesAndValidates(Element node, boolean bRecursive) {
        if (node instanceof FormField || node instanceof FormExclGroup) {
            this.queueCalculate(node);
            this.queueValidate(node);
        } else if (node.isContainer()) {
            if (bRecursive) {
                for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (!(child instanceof Element)) continue;
                    this.queueCalculatesAndValidates((Element)child, bRecursive);
                }
            }
            if (node instanceof FormSubform) {
                this.queueCalculate(node);
                this.queueValidate(node);
            }
        }
        if (node instanceof FormModel) {
            for (int i = 0; i < this.mLayoutContent.size(); ++i) {
                this.queueCalculatesAndValidates(this.mLayoutContent.get((int)i).mNode, bRecursive);
            }
        }
    }

    private boolean queueValidate(Element node) {
        Node currentUI;
        Element ui;
        if (this.isActivityExcluded("validate")) {
            return false;
        }
        boolean bValidateScriptTest = true;
        boolean bValidateFormatTest = true;
        boolean bValidateNullTest = true;
        boolean bValidateBarcode = false;
        List<Node> list = this.mPendingValidateNodes;
        if (!this.canBeQueued(node, false)) {
            return false;
        }
        Element action = node.getElement(404, true, 0, false, false);
        Element scriptNode = null;
        Element pictureNode = null;
        boolean bNullTest = false;
        if (action != null) {
            int eNullTest;
            int eFormatTest;
            scriptNode = action.getElement(394, true, 0, false, false);
            int eScriptTest = action.getEnum(638);
            if (eScriptTest == 0x380000 || this.isActivityExcluded("scriptTest") || !bValidateScriptTest) {
                scriptNode = null;
            }
            if ((eFormatTest = action.getEnum(507)) != 0x380000 && !this.isActivityExcluded("formatTest") && bValidateFormatTest) {
                pictureNode = action.getElement(242, true, 0, false, false);
            }
            if ((eNullTest = action.getEnum(578)) != 0x380000 && !this.isActivityExcluded("nullTest") && bValidateNullTest) {
                bNullTest = true;
            }
        }
        if (node instanceof FormField && (action == null || scriptNode == null && pictureNode == null && !bNullTest) && (ui = node.getElement(331, true, 0, false, false)) != null && (currentUI = ui.getOneOfChild(true, false)) != null) {
            bValidateBarcode = currentUI.isSameClass(24);
        }
        if (scriptNode != null || pictureNode != null || bNullTest || bValidateBarcode) {
            list.add(node);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recalculate(boolean bFullRecalculate, Validate validate, boolean bIgnoreCalcEnabledFlag) {
        if (this.mbIsCalculating) {
            return false;
        }
        this.mbIsCalculating = true;
        this.mbIgnoreCalcEnabledFlag = bIgnoreCalcEnabledFlag;
        this.mValidate = validate;
        ++this.mnValidationRecursionDepth;
        try {
            boolean bCalcOrValidateFired;
            boolean bRet = false;
            if (bFullRecalculate) {
                this.removeQueuedCalculates();
                this.removeQueuedValidates();
                this.removeQueuedNewValidates();
                boolean oBoolReset = this.mbSkipCyclicAndDuplicateCheck;
                try {
                    this.mbSkipCyclicAndDuplicateCheck = true;
                    this.queueCalculatesAndValidates(this, true);
                }
                finally {
                    this.mbSkipCyclicAndDuplicateCheck = oBoolReset;
                }
            }
            EventManager eventManager = this.getEventManager();
            this.preValidate(validate, this.mnValidationRecursionDepth > 1);
            do {
                Node node;
                int i;
                boolean bFireEvent;
                bCalcOrValidateFired = false;
                do {
                    bFireEvent = false;
                    if (!this.getCalculationsEnabled()) continue;
                    for (i = this.mnNextPendingCalculateNode; i < this.mPendingCalculateNodes.size(); ++i) {
                        node = this.mPendingCalculateNodes.get(i);
                        try {
                            if (eventManager.eventOccurred(this.mnCalcEventId, node)) {
                                bRet = true;
                            }
                        }
                        catch (ExFull oEx) {
                            MsgFormatPos error = new MsgFormatPos(ResId.UnsupportedOperationException);
                            error.format("calculate").format(node.getSOMExpression());
                            error.format(". " + oEx.toString());
                            this.addErrorList(new ExFull(error), 3, null);
                        }
                        ++this.mnNextPendingCalculateNode;
                        bFireEvent = true;
                        bCalcOrValidateFired = true;
                    }
                } while (bFireEvent);
                if (this.getValidationsEnabled()) {
                    boolean bOldNullTest = false;
                    if (this.mValidate != null) {
                        bOldNullTest = this.mValidate.isNullTestEnabled();
                        this.mValidate.setNullTestEnabled(false);
                    }
                    for (Node node2 : this.mNewValidateNodes) {
                        if (!eventManager.eventOccurred(this.mnValidateEventId, node2)) continue;
                        bRet = true;
                    }
                    if (this.mValidate != null) {
                        this.mValidate.setNullTestEnabled(bOldNullTest);
                    }
                    this.removeQueuedNewValidates();
                }
                do {
                    bFireEvent = false;
                    if (!this.getValidationsEnabled()) continue;
                    for (i = this.mnNextPendingValidateNode; i < this.mPendingValidateNodes.size(); ++i) {
                        node = this.mPendingValidateNodes.get(i);
                        if (eventManager.eventOccurred(this.mnValidateEventId, node)) {
                            bRet = true;
                        }
                        ++this.mnNextPendingValidateNode;
                        bFireEvent = true;
                        bCalcOrValidateFired = true;
                    }
                } while (bFireEvent);
            } while (bCalcOrValidateFired);
            this.postValidate(validate, this.mnValidationRecursionDepth > 1);
            if (this.getCalculationsEnabled()) {
                this.removeQueuedCalculates();
            }
            if (this.getValidationsEnabled()) {
                this.removeQueuedValidates();
            }
            this.mnNextPendingCalculateNode = 0;
            this.mnNextPendingValidateNode = 0;
            if (this.ready(bFullRecalculate)) {
                bRet = true;
            }
            if (eventManager.eventOccurred(eventManager.getEventID("overlay"), this)) {
                bRet = true;
            }
            boolean bl = bRet;
            return bl;
        }
        finally {
            this.mbIgnoreCalcEnabledFlag = false;
            this.mbIsCalculating = false;
            this.mValidate = null;
            --this.mnValidationRecursionDepth;
        }
    }

    private boolean getRegistered(Node node, int eActivity) {
        if (node instanceof FormField) {
            return ((FormField)node).getRegistered(eActivity);
        }
        if (node instanceof FormSubform) {
            return ((FormSubform)node).getRegistered(eActivity);
        }
        if (node instanceof FormExclGroup) {
            return ((FormExclGroup)node).getRegistered(eActivity);
        }
        return false;
    }

    private void setRegistered(Node node, int eActivity) {
        if (node instanceof FormField) {
            FormField oField = (FormField)node;
            oField.setRegistered(eActivity);
        } else if (node instanceof FormSubform) {
            FormSubform oSubform = (FormSubform)node;
            oSubform.setRegistered(eActivity);
        } else if (node instanceof FormExclGroup) {
            FormExclGroup oExclGroup = (FormExclGroup)node;
            oExclGroup.setRegistered(eActivity);
        }
    }

    void registerEvents(Element element, int nEventTypes) {
        boolean bValidate;
        assert (element != null);
        if (!this.mbRegisterNewEvents) {
            return;
        }
        EventManager eventManager = this.getEventManager();
        if (eventManager == null) {
            return;
        }
        boolean bEvents = (nEventTypes & 1) != 0;
        boolean bCalculate = (nEventTypes & 2) != 0 && !this.getRegistered(element, 36);
        boolean bl = bValidate = (nEventTypes & 4) != 0 && !this.getRegistered(element, 404);
        if (element.isSameClass(133) || element.isSameClass(297) || element.isSameClass(127)) {
            ValidateInfo validateInfo;
            ScriptInfo calculateInfo;
            ProtoableNode container = (ProtoableNode)element;
            if (bCalculate && !this.isActivityExcluded("calculate") && (calculateInfo = this.getCalculateInfo(container)) != null) {
                CalculateDispatcher cd = new CalculateDispatcher(calculateInfo.mScriptContextNode, calculateInfo.msEventContext, this.mnCalcEventId, eventManager, calculateInfo.msScript, calculateInfo.msScriptLanguage, calculateInfo.meRunAt);
                eventManager.registerEvents(cd);
                this.mPendingCalculateNodes.add(container);
                this.setRegistered(element, 36);
            }
            if (bValidate && !this.isActivityExcluded("validate") && (validateInfo = this.getValidateInfo(container)) != null) {
                ValidateDispatcher vd = new ValidateDispatcher(validateInfo.mScriptContextNode, validateInfo.msEventContext, this.mnValidateEventId, eventManager, validateInfo.msScript, validateInfo.msScriptLanguage, validateInfo.msBarcodeType, validateInfo.meRunAt);
                eventManager.registerEvents(vd);
                this.mNewValidateNodes.add(container);
                this.setRegistered(element, 404);
            }
            if (element.isSameClass(133)) {
                for (Node child = element.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (!child.isSameClass(124)) continue;
                    this.registerEvents((Element)child, nEventTypes);
                }
            }
        } else if (bEvents && element.isSameClass(124)) {
            ExecuteInfo executeInfo;
            SubmitInfo submitInfo;
            Element eventOneOfChild = (Element)element.getOneOfChild();
            ProtoableNode parent = (ProtoableNode)element.getXFAParent();
            String sActivity = element.getAttribute(412).toString();
            if (StringUtils.isEmpty(sActivity) || this.isActivityExcluded(sActivity)) {
                return;
            }
            int nEventId = eventManager.getEventID(sActivity);
            String sRef = element.getAttribute(392).toString();
            Dispatcher dispatcher = null;
            if (eventOneOfChild.isSameClass(280)) {
                dispatcher = new SignDispatcher(parent, eventOneOfChild, sRef, nEventId, eventManager);
            } else {
                ScriptInfo scriptInfo = this.getScriptInfo(parent, element);
                if (scriptInfo != null) {
                    dispatcher = new ScriptRunAtDispatcher(scriptInfo.mScriptContextNode, scriptInfo.msEventContext, nEventId, eventManager, scriptInfo.msScript, scriptInfo.msScriptLanguage, scriptInfo.meRunAt, scriptInfo.msTarget);
                }
            }
            if (dispatcher == null && (submitInfo = this.getSubmitInfo(parent, element)) != null) {
                dispatcher = new SubmitDispatcher(submitInfo.mSubmitContextNode, submitInfo.msEventContext, nEventId, eventManager, eventOneOfChild, this.mbValidateBeforeSubmit);
            }
            if (dispatcher == null && (executeInfo = this.getExecuteInfo(parent, element)) != null) {
                dispatcher = new ExecuteDispatcher(executeInfo.mExecuteContextNode, executeInfo.msEventContext, nEventId, eventManager, eventOneOfChild, this.mbValidateBeforeExecute);
            }
            if (dispatcher != null) {
                int eListen = element.getEnum(548);
                dispatcher.setListenToDescendents(eListen == 1082720257);
                eventManager.registerEvents(dispatcher);
            }
        }
    }

    public boolean registerNewEvents(boolean bAllow) {
        boolean bOldValue = this.mbRegisterNewEvents;
        this.mbRegisterNewEvents = bAllow;
        return bOldValue;
    }

    public void remerge() {
        if (this.mbDisableRemerge) {
            return;
        }
        Node context = this.getAppModel().getContext();
        if (context != null && context.getModel() == this) {
            this.getAppModel().setContext(this);
        }
        this.merge(this.mbEmptyMerge, this.mbAdjustData, true, false, false);
    }

    @Override
    public void remove() {
        this.reset();
        super.remove();
    }

    void removeDependency(Node node, boolean bForCalc) {
        List<FormListener> listenerTable = null;
        if (node instanceof FormField) {
            listenerTable = ((FormField)node).getFormListeners(false);
        } else if (node instanceof FormExclGroup) {
            listenerTable = ((FormExclGroup)node).getFormListeners(false);
        } else if (node instanceof FormSubform) {
            listenerTable = ((FormSubform)node).getFormListeners(false);
        }
        if (listenerTable != null) {
            for (int i = 0; i < listenerTable.size(); ++i) {
                FormListener formListener = listenerTable.get(i);
                assert (null != formListener);
                if (null == formListener || bForCalc != formListener.isCalculate()) continue;
                listenerTable.remove(i);
                --i;
            }
        }
    }

    private void removeQueuedCalculates() {
        this.mPendingCalculateNodes.clear();
        this.mnNextPendingCalculateNode = 0;
    }

    private void removeQueuedNewValidates() {
        this.mNewValidateNodes.clear();
    }

    private void removeQueuedValidates() {
        this.mPendingValidateNodes.clear();
        this.mnNextPendingValidateNode = 0;
    }

    @Override
    public void removeReferences(Node node) {
        this.removeReferencesImpl(node, true);
    }

    private void removeReferencesImpl(Node node, boolean bResetLayoutNode) {
        if (node != null) {
            boolean bCleanUpLayout = false;
            if (node instanceof FormField) {
                if (node == this.mActiveField) {
                    this.mActiveField = null;
                }
                if (node == this.mPrevActiveField) {
                    this.mPrevActiveField = null;
                }
                ((FormField)node).cleanupListeners();
            } else if (node instanceof FormSubform) {
                ((FormSubform)node).cleanupListeners();
                if (bResetLayoutNode && ((FormSubform)node).isLayoutNode()) {
                    bCleanUpLayout = true;
                }
            } else if (bResetLayoutNode && node instanceof FormSubformSet && ((FormSubformSet)node).isLayoutNode()) {
                bCleanUpLayout = true;
            } else if (bResetLayoutNode && node instanceof PageSet) {
                bCleanUpLayout = true;
            } else if (node instanceof FormExclGroup) {
                ((FormExclGroup)node).cleanupListeners();
            }
            if (bCleanUpLayout) {
                for (int i = this.mLayoutContent.size(); i > 0; --i) {
                    if (this.mLayoutContent.get((int)(i - 1)).mNode != node) continue;
                    this.mLayoutContent.remove(i - 1);
                    break;
                }
            }
            super.removeReferences(node);
        }
    }

    public void reset() {
        Obj signature;
        Obj event;
        DataWindow dataWindow;
        if (this.getXFAParent() != null && this.getEventManager() != null) {
            this.getEventManager().reset();
        }
        EventManager.resetEventTable(this.getEventTable(false));
        this.removeQueuedCalculates();
        this.removeQueuedValidates();
        this.removeQueuedNewValidates();
        this.mValidate = null;
        this.mbMergeComplete = false;
        this.mbWeightedData = false;
        this.mGlobalDataNodes.clear();
        this.mExplicitMatchNodes.clear();
        this.mLayoutContent.clear();
        this.mCurrentPageSet = null;
        int nChildren = this.getXFAChildCount();
        while (nChildren > 0) {
            Node child = this.getXFAChild(--nChildren);
            child.remove();
            this.removeReferencesImpl(child, false);
        }
        if (this.mStartNode != null && this.mStartNode.getXFAParent() == null && (dataWindow = this.mDataModel.getDataWindow()).removeRecordGroup(this.mStartNode)) {
            dataWindow.updateAfterLoad();
        }
        this.mStartNode = null;
        this.mRootSubform = null;
        this.mbConnectionMerge = false;
        this.msConnectionName = "";
        this.mActiveField = null;
        this.mPrevActiveField = null;
        this.mDataModel = null;
        this.mTemplateModel = null;
        this.mHostPseudoModel = null;
        this.mEventPseudoModel = null;
        AppModel appModel = (AppModel)this.getXFAParent();
        Obj host = appModel.lookupPseudoModel("$host");
        if (host != null) {
            this.mHostPseudoModel = (HostPseudoModel)host;
        }
        if ((event = appModel.lookupPseudoModel("$event")) != null) {
            this.mEventPseudoModel = (EventPseudoModel)event;
        }
        if ((signature = appModel.lookupPseudoModel("$signature")) != null) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "FormModel#reset - $signature");
        }
        this.mDataModel = DataModel.getDataModel(appModel, false, false);
        this.mTemplateModel = TemplateModel.getTemplateModel(appModel, false);
        EventManager em = this.getEventManager();
        this.mnCalcEventId = em.getEventID("calculate");
        this.mnValidateEventId = em.getEventID("validate");
        this.mnValidationStateEventId = em.getEventID("validationState");
    }

    public void resetData(Obj container) {
        if (container == null) {
            if (this.mRootFormSubform != null) {
                this.resetData(this.mRootFormSubform);
            }
            return;
        }
        if (!(container instanceof Container)) {
            return;
        }
        if (container instanceof FormField) {
            ((FormField)container).resetData();
            return;
        }
        for (Node child = ((Container)container).getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Container)) continue;
            this.resetData(child);
        }
    }

    private DataNode resolveCreateDataRef(String sSom, Element dataParent, boolean bSearch, boolean bUseDV) {
        if (dataParent == null && !this.mbGlobalConsumption) {
            if (FormModel.somIsRelative(sSom)) {
                return null;
            }
            dataParent = this.mStartNode;
        }
        DataNode dataNode = null;
        if (bSearch) {
            if (dataParent == null) {
                dataParent = this.mStartNode;
            }
            boolean bMultiple = FormModel.isSomMultiple(sSom);
            if (this.mergeMode() == 0x8C0000 || !bMultiple) {
                NodeList oNodes = dataParent.resolveNodes(sSom, true, false, true);
                int nLen = oNodes.length();
                for (int i = 0; i < nLen; ++i) {
                    DataNode dNode = (DataNode)oNodes.item(i);
                    if (bMultiple && dNode.isMapped()) continue;
                    dataNode = dNode;
                    break;
                }
            }
        }
        if (dataNode == null) {
            DataModel dataModel = DataModel.getDataModel(this.getAppModel(), false, false);
            int nFoundAt = sSom.indexOf(".[");
            int nTruncateLen = 0;
            if (nFoundAt != -1) {
                nTruncateLen = nFoundAt;
            }
            if ((nFoundAt = sSom.indexOf(".(")) != -1 && (nTruncateLen == 0 || nFoundAt < nTruncateLen)) {
                nTruncateLen = nFoundAt;
            }
            if (nTruncateLen > 0) {
                sSom = sSom.substring(0, nTruncateLen);
                sSom = sSom + "[*]";
            }
            dataNode = (DataNode)dataModel.resolveRef(sSom, dataParent, bUseDV, !this.mbAdjustData);
            assert (this.mTemplateModel != null);
            if (this.mTemplateModel.getLegacySetting(AppModel.XFA_PATCH_W_2393121)) {
                // empty if block
            }
            DataModel.removeDDPlaceholderFlags(dataNode, false);
        }
        return dataNode;
    }

    private DataNode resolveGlobal(Element formNode, boolean bUseDV) {
        Element parent;
        DataNode node = null;
        for (DataNode global : this.mGlobalDataNodes) {
            if (!FormModel.isMappable(formNode, global, true, false)) continue;
            return global;
        }
        DataWindow dataWindow = this.mDataModel.getDataWindow();
        IntegerHolder nCount = new IntegerHolder();
        if (dataWindow.isDefined()) {
            parent = dataWindow.record(0);
            node = (DataNode)this.findGlobalNode(formNode, parent, nCount, null);
        }
        if (node == null) {
            parent = this.mDataModel.getAliasNode();
            node = (DataNode)this.findGlobalNode(formNode, parent, nCount, dataWindow);
        }
        if (node != null) {
            this.mGlobalDataNodes.add(node);
        }
        return node;
    }

    private Node resolveCreateGlobal(Element formNode, boolean bSearch, boolean bUseDV) {
        DataNode node = null;
        if (bSearch) {
            node = this.resolveGlobal(formNode, bUseDV);
        }
        if (node == null) {
            DataModel dataModel;
            DataNode dataParent;
            String aName = formNode.getName();
            DataNode global = null;
            if (this.mbAdjustData && (dataParent = this.mStartNode) != null && (dataModel = (DataModel)dataParent.getModel()) != null) {
                int nDot;
                StringBuilder sName = new StringBuilder(aName);
                int fromIndex = 0;
                while ((nDot = sName.indexOf(".", fromIndex)) != -1) {
                    sName.insert(nDot, '\\');
                    fromIndex = nDot + 2;
                }
                node = (DataNode)dataModel.resolveRef(sName.toString(), dataParent, bUseDV, !this.mbAdjustData);
            }
            if (node == null) {
                int eTag = 82;
                if (!bUseDV) {
                    eTag = 77;
                }
                node = global = (DataNode)this.mDataModel.createNode(eTag, null, aName, "", true);
            }
            if (node != null) {
                this.mGlobalDataNodes.add(node);
            }
        } else if (node != null) {
            this.mGlobalDataNodes.add(node);
        }
        return node;
    }

    @Override
    public void resolveProtos(boolean bForceExternalProtoResolve) {
        if (this.isLoading() || this.mbAllowNewNodes) {
            return;
        }
        super.resolveProtos(false);
    }

    private Node resolveSetPropertyTarget(Container container, String sTarget, StringHolder sTargetProperty) {
        Element validate;
        SOMParser parser = new SOMParser(null);
        ArrayList<SOMParser.SomResultInfo> result = new ArrayList<SOMParser.SomResultInfo>();
        Node targetNode = null;
        sTargetProperty.value = "";
        if (parser.resolve(container, sTarget, result) && result.size() > 0) {
            SOMParser.SomResultInfo oResultInfo = (SOMParser.SomResultInfo)result.get(0);
            if (oResultInfo.object instanceof Node) {
                sTargetProperty.value = oResultInfo.propertyName;
                targetNode = (Node)oResultInfo.object;
            }
            return targetNode;
        }
        String sPrefix = "";
        String sSuffix = "";
        for (int i = sTarget.length(); i > 0; --i) {
            if (sTarget.charAt(i - 1) != '.') continue;
            sPrefix = sTarget.substring(0, i - 1);
            sSuffix = sTarget.substring(i);
            break;
        }
        if (sPrefix.length() == 0 || sSuffix.length() == 0) {
            return targetNode;
        }
        ArrayList<SOMParser.SomResultInfo> tmpResult = new ArrayList<SOMParser.SomResultInfo>();
        if (!parser.resolve(container, sPrefix, tmpResult) || tmpResult.size() == 0) {
            return targetNode;
        }
        SOMParser.SomResultInfo checkResult = (SOMParser.SomResultInfo)tmpResult.get(0);
        if (checkResult.object == null || !(checkResult.object instanceof Node)) {
            return targetNode;
        }
        if (checkResult.object.isSameClass(384) && (validate = ((Node)checkResult.object).getXFAParent()) != null && validate.isSameClass(404)) {
            Element message = (Element)checkResult.object;
            Element text = message.getModel().createElement("text", sSuffix, message);
            targetNode = text;
        }
        return targetNode;
    }

    public void restoreValidateDisableAll(Element formNode, Node delta) {
        Attribute disableAllDelta;
        Element deltaValidate;
        assert (this.isLoading() && (formNode instanceof FormSubform || formNode instanceof FormField || formNode instanceof FormExclGroup));
        if (this.isLoading() && formNode != null && delta != null && formNode.isSameClass(delta) && formNode.getName() == delta.getName() && (deltaValidate = ((Element)delta).getElement(404, true, 0, false, false)) != null && (disableAllDelta = deltaValidate.getAttribute(483, true, false)) != null) {
            Element validate = formNode.getElement(404, 0);
            assert (validate != null);
            if (validate != null) {
                validate.setAttribute(disableAllDelta, 483);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExecEvents() {
        Node node = this.getAppModel().locateChildByName("execEvent", 0);
        if (!(node instanceof Element)) {
            return;
        }
        Element execEvent = (Element)node;
        execEvent.remove();
        String sContextNodeSOM = "";
        Node contextNode = null;
        int index = execEvent.findAttr("", "context");
        if (index != -1) {
            int nFoundAt;
            sContextNodeSOM = execEvent.getAttrVal(index);
            if (sContextNodeSOM.startsWith("xfa[0].form[") && (nFoundAt = sContextNodeSOM.indexOf(93, 12)) != -1) {
                sContextNodeSOM = "$" + sContextNodeSOM.substring(nFoundAt + 1);
            }
            contextNode = this.resolveNode(sContextNodeSOM);
        }
        String sActivity = "";
        index = execEvent.findAttr("", "activity");
        if (index != -1) {
            sActivity = execEvent.getAttrVal(index);
        }
        if (contextNode == null) {
            MsgFormatPos msg = new MsgFormatPos(ResId.ContextNodeNotFound);
            msg.format(sContextNodeSOM);
            msg.format(execEvent.getSOMExpression());
            if (sActivity.equals("preSubmit")) {
                this.addErrorList(new ExFull(msg), 3, null);
                return;
            }
            throw new ExFull(msg);
        }
        if (contextNode instanceof FormSubform || contextNode instanceof FormField || contextNode instanceof FormExclGroup || contextNode instanceof FormModel) {
            EventPseudoModel.EventInfo eventInfo = null;
            if (this.mEventPseudoModel != null) {
                eventInfo = this.mEventPseudoModel.getEventInfo();
            }
            try {
                int eReason = ScriptHandler.stringToExecuteReason(sActivity);
                if (this.mEventPseudoModel != null) {
                    this.mEventPseudoModel.reset();
                    this.mEventPseudoModel.setName(eReason);
                    this.mEventPseudoModel.setTarget(contextNode);
                }
                EventManager em = this.getEventManager();
                int nID = em.getEventID(sActivity);
                this.eventOccurred(em, nID, eReason, (Container)contextNode, false);
            }
            finally {
                if (this.mEventPseudoModel != null) {
                    this.mEventPseudoModel.setEventInfo(eventInfo);
                }
            }
        }
    }

    void serverExchange(Node contextNode, String sActivity) {
        block13: {
            int nChildCount;
            if (this.mServerExchange == null) {
                return;
            }
            if (this.mDataModel == null) {
                return;
            }
            if (!(sActivity.equals("enter") || sActivity.equals("exit") || sActivity.equals("mouseEnter") || sActivity.equals("mouseExit") || sActivity.equals("change") || sActivity.equals("click") || sActivity.equals("mouseUp") || sActivity.equals("mouseDown"))) {
                return;
            }
            if ((sActivity.equals("enter") || sActivity.equals("exit")) && !contextNode.isSameClass(133)) {
                return;
            }
            if (this.mbExchangingDataWithServer) {
                throw new ExFull(ResId.SOFTWARE_FAILURE, "Recursive call to FormModel.serverExchange unexpected.");
            }
            AppModel appModel = (AppModel)this.getXFAParent();
            Packet execEvent = (Packet)appModel.createNode(220, this, "execEvent", "", false);
            execEvent.setDOMProperties(null, "execEvent", "execEvent", null);
            appModel.appendChild(execEvent, false);
            execEvent.setAttribute(contextNode.getSOMExpression(this, false), "context");
            execEvent.setAttribute(sActivity, "activity");
            XMLStorage xml = new XMLStorage();
            ByteArrayOutputStream streamFileOut = new ByteArrayOutputStream();
            ArrayNodeList nodesToSave = new ArrayNodeList();
            ((ListBase)nodesToSave).append(this.mDataModel);
            ((ListBase)nodesToSave).append(execEvent);
            xml.saveAggregate("", streamFileOut, nodesToSave, "");
            byte[] request = streamFileOut.toByteArray();
            streamFileOut = null;
            byte[] response = this.mServerExchange.sendToServer(request);
            request = null;
            execEvent.remove();
            AppModel tempAppModel = new AppModel(new LogMessenger());
            xml.loadModel(tempAppModel, new ByteArrayInputStream(response), "", null);
            response = null;
            Element tempDatasets = (Element)tempAppModel.resolveNode("$.datasets");
            assert (tempDatasets != null);
            if (tempDatasets == null) break block13;
            ByteArrayOutputStream streamFileTemp = new ByteArrayOutputStream();
            tempDatasets.saveXML(streamFileTemp, null);
            assert (this.mDataModel.getAliasNode().getName() == "data");
            this.mDataModel.removeChild(this.mDataModel.getAliasNode());
            int nChildCountBeforeLoad = this.mDataModel.getXFAChildCount();
            byte[] bytes = streamFileTemp.toByteArray();
            streamFileTemp = null;
            this.mDataModel.loadXML((InputStream)new ByteArrayInputStream(bytes), true, false);
            bytes = null;
            for (int i = nChildCount = this.mDataModel.getXFAChildCount(); i > nChildCountBeforeLoad; --i) {
                Attribute aDDNameAttr;
                DataNode pDDRoot;
                Node pDataModelChild = this.mDataModel.getXFAChild(i - 1);
                if (!pDataModelChild.getName().equals("dataDescription") || (pDDRoot = this.mDataModel.getDataDescriptionRoot((aDDNameAttr = ((Element)pDataModelChild).getAttributeByName("name", false)).getAttrValue())) == pDataModelChild) continue;
                this.mDataModel.removeChild(pDataModelChild);
            }
            Element tempFormState = (Element)tempAppModel.resolveNode("$.formState");
            if (tempFormState != null) {
                ByteArrayOutputStream streamFormState = new ByteArrayOutputStream();
                tempFormState.saveXML(streamFormState, null);
                bytes = streamFormState.toByteArray();
                streamFormState = null;
                this.getAppModel().loadXML((InputStream)new ByteArrayInputStream(bytes), false, false);
            }
            this.mDataModel.getDataWindow().resetRecordDepth();
            this.mbExchangingDataWithServer = true;
            try {
                this.mServerExchange.remerge();
            }
            catch (ExFull ex) {
                this.mbExchangingDataWithServer = false;
                throw ex;
            }
        }
        this.mbExchangingDataWithServer = false;
    }

    public void setAdjustData(boolean bAdjustData) {
        this.mbAdjustData = bAdjustData;
    }

    void setAllowNewNodes(boolean bAllowNewNodes) {
        this.mbAllowNewNodes = bAllowNewNodes;
    }

    public void setAmbientLocale(String sLocale) {
        this.msLocale = sLocale;
    }

    void setConnectionDataContextInfo(Container formContainer, Element connectionDataNode) {
        assert (formContainer.getFormInfo() == null);
        Container.FormInfo formInfo = new Container.FormInfo(connectionDataNode);
        formContainer.setFormInfo(formInfo);
    }

    public void setDefaultValidate(Validate validate) {
        this.mDefaultValidate = validate.clone();
    }

    void setMatchDescendantsOnly(boolean bDescendantsOnly) {
        this.mbMatchDescendantsOnly = bDescendantsOnly;
    }

    void setDynamicProperties(Container container, String sConnectionName, boolean bRecurse) {
        Container.FormInfo formInfo;
        if (container == null) {
            return;
        }
        boolean bSupportsBinding = false;
        if (container instanceof Field || container instanceof Subform || container instanceof ExclGroup || container instanceof Draw) {
            bSupportsBinding = true;
        }
        if (!bSupportsBinding && !bRecurse) {
            Container.FormInfo formInfo2 = container.getFormInfo();
            if (formInfo2 != null) {
                container.setFormInfo(null);
            }
            return;
        }
        ProtoableNode parent = container;
        if (container instanceof Draw) {
            parent = container.getProto();
        }
        if (parent != null) {
            for (Node child = ((Node)parent).getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (bSupportsBinding) {
                    if (child.isSameClass(278)) {
                        Element childElement = (Element)child;
                        String sConnection = "";
                        Attribute attr = childElement.getAttribute(371, true, false);
                        if (attr != null) {
                            sConnection = attr.toString();
                        }
                        if (sConnection.equals(sConnectionName)) {
                            this.doSetProperty(childElement, container, !StringUtils.isEmpty(sConnection));
                        }
                    } else if (child.isSameClass(31) && container instanceof FormField) {
                        this.doBindItems((Element)child, (FormField)container, sConnectionName);
                    }
                }
                if (!bRecurse || !(child instanceof Container)) continue;
                this.setDynamicProperties((Container)child, sConnectionName, true);
            }
        }
        if (bRecurse && (formInfo = container.getFormInfo()) != null) {
            container.setFormInfo(null);
        }
    }

    public void setEmptyMerge(boolean bEmptyMerge) {
        this.mbEmptyMerge = bEmptyMerge;
    }

    public void setExcludedActivities(String sExclude) {
        this.mExcludeList = sExclude.split("\\s");
    }

    public void setExecute(Execute execute) {
        if (this.mExecute != null) {
            this.mExecute = null;
        }
        if (execute != null) {
            this.mExecute = (Execute)execute.clone();
        }
    }

    public void setFocus(FormField field) {
        if (this.mActiveField != null) {
            this.clearFocus();
        }
        this.mActiveField = field;
    }

    private void setFormInfo(Container templateContainerNode, Element dataParent, NodeList dataNodes, boolean bAssociation, int eMergeType, boolean bRemoveAfterUse, boolean bConnectDataRef, Element connectionDataParent, NodeList altDataNodes) {
        Container.FormInfo formInfo = templateContainerNode.getFormInfo();
        if (formInfo == null) {
            formInfo = new Container.FormInfo(templateContainerNode, eMergeType);
            templateContainerNode.setFormInfo(formInfo);
        } else assert (formInfo.eMergeType == eMergeType && formInfo.templateContainerNode == templateContainerNode && formInfo.connectionDataNode == null);
        if (dataNodes != null) {
            formInfo.dataNodes = dataNodes;
        }
        if (altDataNodes != null) {
            formInfo.altDataNodes = altDataNodes;
        }
        formInfo.dataParent = dataParent;
        formInfo.scopeData = dataParent;
        formInfo.bAssociation = bAssociation;
        formInfo.bRemoveAfterUse = bRemoveAfterUse;
        formInfo.bConnectDataRef = bConnectDataRef;
        formInfo.connectionDataParent = connectionDataParent;
    }

    void setFormStateUsage(boolean bFormStateUsage) {
        this.mbFormStateUsage = bFormStateUsage;
    }

    void setLayoutNodes(FormSubformSet ss) {
        if (ss != null) {
            ss.setLayoutNode();
            for (Node child = ss.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (child instanceof FormSubform) {
                    ((FormSubform)child).setLayoutNode();
                    continue;
                }
                if (!(child instanceof FormSubformSet)) continue;
                this.setLayoutNodes((FormSubformSet)child);
            }
        }
    }

    void setOverlayDataMergeUsage(boolean bOverlayDataMergeUsage, int nPanel) {
        this.mbOverlayDataMergeUsage = bOverlayDataMergeUsage;
        this.mnPanel = nPanel;
    }

    public void setPostMergeHandler(PostMergeHandler handler, Object clientData) {
        this.mPostMergeHandler = handler;
        this.mPostMergeHandlerClientData = clientData;
    }

    public void setRunScripts(int eRunAtSetting) {
        this.meRunAtSetting = eRunAtSetting;
    }

    public void setServerExchange(ServerExchange serverExchange) {
        this.mServerExchange = serverExchange;
    }

    public void setSubmit(Submit submit) {
        if (this.mSubmit != null) {
            this.mSubmit = null;
        }
        if (submit != null) {
            this.mSubmit = (Submit)submit.clone();
        }
    }

    public void setSubmitURL(String sSubmitURL) {
        this.msSubmitURL = sSubmitURL;
    }

    public void setValidateBeforeExecute(boolean bValidate) {
        this.mbValidateBeforeExecute = bValidate;
    }

    public void setValidateBeforeSubmit(boolean bValidate) {
        this.mbValidateBeforeSubmit = bValidate;
    }

    /*
     * Unable to fully structure code
     */
    private void updateFromFormState() {
        formState = this.getAppModel().locateChildByName("formState", 0);
        if (formState == null) {
            return;
        }
        stateChild = formState.getFirstXMLChild();
        while (stateChild != null) {
            block33: {
                if (!(stateChild instanceof Element)) break block33;
                if (stateChild.getName() != "state") {
                    stateChild = stateChild.getNextXMLSibling();
                    continue;
                }
                stateChildElement = (Element)stateChild;
                sContextNodeSOM = "";
                contextNode = null;
                index = stateChildElement.findAttr("", "ref");
                if (index != -1) {
                    sContextNodeSOM = stateChildElement.getAttrVal(index);
                    contextNode = this.resolveNode(sContextNodeSOM);
                }
                if (contextNode == null) {
                    msg = new MsgFormatPos(ResId.FormStateContextNodeNotFound);
                    msg.format(sContextNodeSOM);
                    msg.format(formState.getSOMExpression());
                    this.addErrorList(new ExFull(msg), 3, stateChildElement);
                    stateChild = stateChild.getNextXMLSibling();
                    continue;
                }
                if (!(contextNode instanceof FormField)) {
                    return;
                }
                contextFormField = (FormField)contextNode;
                ui = contextFormField.getElement(331, true, 0, false, false);
                if (ui == null) ** GOTO lbl39
                currentUI = ui.getOneOfChild(true, false);
                if (currentUI != null) {
                    if (!currentUI.isSameClass(47)) {
                        stateChild = stateChild.getNextXMLSibling();
                        continue;
                    }
                } else {
                    stateChild = stateChild.getNextXMLSibling();
                    continue;
lbl39:
                    // 1 sources

                    stateChild = stateChild.getNextXMLSibling();
                    continue;
                }
                contextFormField.clearItems();
                itemChild = stateChild.getFirstXMLChild();
                saveValuesList = new ArrayList<String>();
                displayValuesList = new ArrayList<String>();
                while (itemChild != null) {
                    if (itemChild instanceof Element) {
                        if (((Element)itemChild).getName() != "items") {
                            itemChild = itemChild.getNextXMLSibling();
                            continue;
                        }
                        for (child = itemChild.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                            if (!(child instanceof Element)) continue;
                            aName = ((Element)child).getName();
                            if (aName == "save") {
                                domNode = child.getFirstXMLChild();
                                if (domNode instanceof TextNode) {
                                    domText = (TextNode)domNode;
                                    saveValuesList.add(domText.getText());
                                    continue;
                                }
                                saveValuesList.add("");
                                continue;
                            }
                            if (aName != "display") continue;
                            domNode = child.getFirstXMLChild();
                            if (domNode instanceof TextNode) {
                                domText = (TextNode)domNode;
                                displayValuesList.add(domText.getText());
                                continue;
                            }
                            displayValuesList.add("");
                        }
                    }
                    itemChild = itemChild.getNextXMLSibling();
                }
                nSaveValues = saveValuesList.size();
                nDisplayValues = displayValuesList.size();
                if (nSaveValues != 0 || nDisplayValues != 0) {
                    itemPair = new Field.ItemPair();
                    contextFormField.getItemLists(false, itemPair, true);
                    displayItems = itemPair.mDisplayItems;
                    saveItems = itemPair.mSaveItems;
                    if (displayItems != null) {
                        displayItems.clearItems(false);
                    }
                    if (saveItems != null) {
                        saveItems.clearItems(false);
                    }
                    if (nSaveValues != 0 && nDisplayValues != 0) {
                        if (nDisplayValues != nSaveValues) {
                            if (nSaveValues < nDisplayValues) {
                                nDisplayValues = nSaveValues;
                            } else {
                                nSaveValues = nDisplayValues;
                            }
                        }
                        for (k = 0; k < nSaveValues; ++k) {
                            if (displayItems != null) {
                                displayItems.addItem((String)displayValuesList.get(k), false);
                            }
                            if (saveItems == null || saveItems == displayItems) continue;
                            saveItems.addItem((String)saveValuesList.get(k), false);
                        }
                    } else if (nSaveValues != 0) {
                        for (k = 0; k < nSaveValues; ++k) {
                            if (displayItems != null) {
                                displayItems.addItem((String)saveValuesList.get(k), false);
                            }
                            if (saveItems == null || saveItems == displayItems) continue;
                            saveItems.addItem((String)saveValuesList.get(k), false);
                        }
                    } else if (nDisplayValues != 0) {
                        for (k = 0; k < nSaveValues; ++k) {
                            if (displayItems != null) {
                                displayItems.addItem((String)displayValuesList.get(k), false);
                            }
                            if (saveItems == null || saveItems == displayItems) continue;
                            saveItems.addItem((String)displayValuesList.get(k), false);
                        }
                    }
                }
            }
            stateChild = stateChild.getNextXMLSibling();
        }
    }

    private static boolean useDV(Node formNode) {
        boolean bUseDV = false;
        if (formNode instanceof Subform || formNode instanceof FormChoiceListField) {
            bUseDV = false;
        } else if (formNode instanceof ExclGroup || formNode instanceof Field) {
            bUseDV = true;
        }
        return bUseDV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validate(Validate validate, Element node, boolean bRecursive, boolean bIgnoreValidationsEnabledFlag) {
        this.mbIgnoreValidationsEnabledFlag = bIgnoreValidationsEnabledFlag;
        ++this.mnValidationRecursionDepth;
        try {
            this.preValidate(validate, this.mnValidationRecursionDepth > 1);
            if (node == null) {
                node = this.mRootFormSubform;
            }
            boolean bRet = this.validateNode(validate, node, bRecursive);
            this.postValidate(validate, this.mnValidationRecursionDepth > 1);
            boolean bl = bRet;
            return bl;
        }
        finally {
            this.mbIgnoreValidationsEnabledFlag = false;
            --this.mnValidationRecursionDepth;
        }
    }

    private void preValidate(Validate validate, boolean bIsRecursiveEntry) {
        if (bIsRecursiveEntry) {
            return;
        }
        if (validate != null) {
            validate.resetFailCount();
            validate.onValidateStart();
        }
        this.moValidationStateChanges.clear();
    }

    private void postValidate(Validate validate, boolean bIsRecursiveEntry) {
        if (bIsRecursiveEntry) {
            return;
        }
        if (validate != null) {
            validate.onValidateEnd();
        }
        if (this.moValidationStateChanges.size() > 0) {
            for (int i = 0; i < this.moValidationStateChanges.size(); ++i) {
                Container container = this.moValidationStateChanges.get(i);
                this.fireValidationStateEvent(container);
            }
            this.moValidationStateChanges.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireValidationStateEvent(Container container) {
        EventManager em = this.getEventManager();
        if (!em.getEventIDByIndex((int)this.mnValidationStateEventId).mbDispatcherOrCalloutRegistered) {
            return false;
        }
        EventPseudoModel.EventInfo eventInfo = null;
        if (this.mEventPseudoModel != null) {
            eventInfo = this.mEventPseudoModel.getEventInfo();
        }
        try {
            if (this.mEventPseudoModel != null) {
                this.mEventPseudoModel.reset();
                this.mEventPseudoModel.setTarget(container);
                this.mEventPseudoModel.setName(21);
            }
            boolean bl = em.eventOccurred(this.mnValidationStateEventId, container);
            return bl;
        }
        finally {
            if (this.mEventPseudoModel != null) {
                this.mEventPseudoModel.setEventInfo(eventInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateNode(Validate validate, Node node, boolean bRecursive) {
        assert (node != null);
        if (!this.getValidationsEnabled()) {
            return false;
        }
        boolean bValidationDispatched = false;
        this.mValidate = validate;
        try {
            if (node instanceof FormField) {
                if (this.getEventManager().eventOccurred(this.mnValidateEventId, node)) {
                    bValidationDispatched = true;
                }
            } else if (node instanceof Container) {
                if (bRecursive) {
                    for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                        if (!this.validateNode(validate, child, bRecursive)) continue;
                        bValidationDispatched = true;
                    }
                }
                if (node instanceof FormSubform || node instanceof FormExclGroup) {
                    if (this.mValidate == null) {
                        this.mValidate = validate;
                    }
                    if (node instanceof ExclGroup && !this.mTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
                        this.mValidate.setNullTestEnabled(false);
                    }
                    if (this.getEventManager().eventOccurred(this.mnValidateEventId, node)) {
                        bValidationDispatched = true;
                    }
                }
            }
        }
        finally {
            this.mValidate = null;
        }
        return bValidationDispatched;
    }

    public boolean wasIncrementalMerge() {
        return this.mbWasIncrementalMerge;
    }

    public void setDisableFormRemerge(boolean bDisable) {
        this.mbDisableRemerge = bDisable;
    }

    public boolean getDisableFormRemerge() {
        return this.mbDisableRemerge;
    }

    void consumeDataNode(Container.FormInfo formInfo, Node dataNode, DatasetSelector eDataset) {
        if (dataNode == null) {
            return;
        }
        if (this.mergeMode() == 9175041) {
            if (formInfo != null && formInfo.eMergeType != 2031618) {
                NodeList list = null;
                switch (eDataset) {
                    case MAIN_DATASET: {
                        list = formInfo.dataNodes;
                        break;
                    }
                    case ALT_DATASET: {
                        list = formInfo.altDataNodes;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                list.remove(dataNode);
            }
        } else if (this.mergeMode() == 0x8C0000) {
            dataNode.setMapped(true);
        }
    }

    public void setGlobalConsumption(Boolean bVal) {
        this.mbGlobalConsumption = bVal;
    }

    private static boolean getAssociation(Element dataParent, String aName, NodeList list) {
        BooleanHolder bFoundNullAssociation = new BooleanHolder(false);
        Obj association = DataModel.resolveAssociation(dataParent, aName, bFoundNullAssociation);
        if (association != null) {
            if (association instanceof Node) {
                Node dataChild = (Node)association;
                list.append(dataChild);
            } else if (association instanceof NodeList) {
                NodeList nodes = (NodeList)association;
                int nDataLen = nodes.length();
                for (int i = 0; i < nDataLen; ++i) {
                    Node dataChild = (Node)nodes.item(i);
                    list.append(dataChild);
                }
            }
            return true;
        }
        return bFoundNullAssociation.value;
    }

    private static boolean somIsStar(String sSom) {
        int nLength = sSom.length();
        if (nLength > 3) {
            char cOpen = sSom.charAt(nLength - 3);
            char cStar = sSom.charAt(nLength - 2);
            char cClose = sSom.charAt(nLength - 1);
            return cOpen == '[' && cStar == '*' && cClose == ']';
        }
        return false;
    }

    private static boolean somIsRelative(String sSom) {
        char cFirst = sSom.charAt(0);
        char cSecond = sSom.charAt(1);
        if (cFirst == '!') {
            return false;
        }
        if (cFirst == '$' && cSecond == '.') {
            return true;
        }
        return cFirst != '$' && cFirst != '!';
    }

    private void findOrCreateMissingData() {
        boolean bDescendants = this.getMatchDescendantsOnly();
        this.setMatchDescendantsOnly(true);
        for (int i = 0; i < this.mExplicitMatchNodes.size(); ++i) {
            Element formNode = this.mExplicitMatchNodes.get(i);
            if (formNode.isMapped()) continue;
            int eMergeType = this.mergeType(formNode, "", null);
            Element mappedParent = FormModel.getMappedParent(formNode);
            if (mappedParent instanceof FormExclGroup) continue;
            DataNode dataParent = mappedParent != null ? FormModel.getDataNode(mappedParent) : this.mStartNode;
            if (eMergeType != 2031618 && eMergeType != 2031619 && eMergeType != 2031620) continue;
            DataNode dataNode = this.createDataNode(formNode, dataParent, eMergeType, true);
            this.bindNodes(formNode, dataNode, UPDATE_DATA);
            this.consumeDataNode(null, dataNode, DatasetSelector.MAIN_DATASET);
        }
        this.mExplicitMatchNodes.clear();
        this.setMatchDescendantsOnly(bDescendants);
    }

    private static void recursiveDeleteFormInfos(Element templateNode) {
        if (templateNode instanceof Container) {
            Container container = (Container)templateNode;
            Container.FormInfo formInfo = container.getFormInfo();
            if (formInfo != null) {
                container.setFormInfo(null);
            }
            for (Node child = container.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof Element)) continue;
                FormModel.recursiveDeleteFormInfos((Element)child);
            }
        }
    }

    private void resetLocalConsumptionContext(Element templateNode) {
        if (this.mergeMode() == 9175041) {
            for (Node child = templateNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof Element)) continue;
                FormModel.recursiveDeleteFormInfos((Element)child);
            }
        }
    }

    public static interface PostMergeHandler {
        public void handlePostMerge(Object var1);
    }

    public static enum DatasetSelector {
        MAIN_DATASET,
        ALT_DATASET;

    }

    private static class LayoutContentInfo {
        public final Element mNode;
        public boolean mbInitializeOccurred;

        public LayoutContentInfo(Element node) {
            this.mNode = node;
        }
    }

    private static class ValidateInfo {
        public final String msScript;
        public final String msScriptLanguage;
        public final String msEventContext;
        public final String msBarcodeType;
        public final int meRunAt;
        public final ProtoableNode mScriptContextNode;

        public ValidateInfo(String sScript, String sScriptLanguage, String sEventContext, String sBarcodeType, int eRunAt, ProtoableNode scriptContextNode) {
            this.msScript = sScript;
            this.msScriptLanguage = sScriptLanguage;
            this.msEventContext = sEventContext;
            this.msBarcodeType = sBarcodeType;
            this.meRunAt = eRunAt;
            this.mScriptContextNode = scriptContextNode;
        }
    }

    private static class SubmitInfo {
        public final String msEventContext;
        public final ProtoableNode mSubmitContextNode;

        public SubmitInfo(String sEventContext, ProtoableNode submitContextNode) {
            this.msEventContext = sEventContext;
            this.mSubmitContextNode = submitContextNode;
        }
    }

    private static class ScriptInfo {
        public final String msScript;
        public final String msScriptLanguage;
        public final String msEventContext;
        public final int meRunAt;
        public final ProtoableNode mScriptContextNode;
        public String msTarget = null;

        public ScriptInfo(String sScript, String sScriptLanguage, String sEventContext, int eRunAt, ProtoableNode scriptContextNode) {
            this.msScript = sScript;
            this.msScriptLanguage = sScriptLanguage;
            this.msEventContext = sEventContext;
            this.meRunAt = eRunAt;
            this.mScriptContextNode = scriptContextNode;
        }
    }

    private static class ExecuteInfo {
        public final String msEventContext;
        public final ProtoableNode mExecuteContextNode;

        public ExecuteInfo(String sEventContext, ProtoableNode executeContextNode) {
            this.msEventContext = sEventContext;
            this.mExecuteContextNode = executeContextNode;
        }
    }

    public static class Validate {
        private boolean mbScriptTestEnabled;
        private boolean mbNullTestEnabled;
        private boolean mbFormatTestEnabled;
        private boolean mbBarcodeTestEnabled;
        protected int mnNumFailures;

        public Validate() {
            this.mbScriptTestEnabled = true;
            this.mbNullTestEnabled = true;
            this.mbFormatTestEnabled = true;
            this.mbBarcodeTestEnabled = true;
        }

        public Validate(boolean bScriptTestEnabled, boolean bNullTestEnabled, boolean bFormatTestEnabled, boolean bBarcodeTestEnabled) {
            this.mbScriptTestEnabled = bScriptTestEnabled;
            this.mbNullTestEnabled = bNullTestEnabled;
            this.mbFormatTestEnabled = bFormatTestEnabled;
            this.mbBarcodeTestEnabled = bBarcodeTestEnabled;
        }

        public void onValidateStart() {
        }

        public void onValidateEnd() {
        }

        public Validate clone() {
            return new Validate(this.mbScriptTestEnabled, this.mbNullTestEnabled, this.mbFormatTestEnabled, this.mbBarcodeTestEnabled);
        }

        public boolean isBarcodeTestEnabled() {
            return this.mbBarcodeTestEnabled;
        }

        public void setBarcodeTestEnabled(boolean bEnabled) {
            this.mbBarcodeTestEnabled = bEnabled;
        }

        public boolean isFormatTestEnabled() {
            return this.mbFormatTestEnabled;
        }

        public void setFormatTestEnabled(boolean bEnabled) {
            this.mbFormatTestEnabled = bEnabled;
        }

        public boolean isNullTestEnabled() {
            return this.mbNullTestEnabled;
        }

        public void setNullTestEnabled(boolean bEnabled) {
            this.mbNullTestEnabled = bEnabled;
        }

        public boolean isScriptTestEnabled() {
            return this.mbScriptTestEnabled;
        }

        public void setScriptTestEnabled(boolean bEnabled) {
            this.mbScriptTestEnabled = bEnabled;
        }

        public boolean onValidateBarcodeTestFailed(FormField field, String sValidationMessage) {
            ++this.mnNumFailures;
            return true;
        }

        public boolean onValidateFormatTestFailed(FormField field, String sValidationMessage, BooleanHolder bDisableValidate) {
            ++this.mnNumFailures;
            return true;
        }

        public boolean onValidateNullTestFailed(ProtoableNode node, String sValidationMessage, BooleanHolder bDisableValidate) {
            ++this.mnNumFailures;
            return true;
        }

        public boolean onValidateScriptFailed(ProtoableNode node, String sScript, String sLanguage, String sValidationMessage, BooleanHolder bDisableValidate) {
            ++this.mnNumFailures;
            return true;
        }

        public int getFailCount() {
            return this.mnNumFailures;
        }

        public void resetFailCount() {
            this.mnNumFailures = 0;
        }

        public boolean validateBarcode(Element element, String sBarcodeType, String sValue) {
            return true;
        }
    }

    public static abstract class Submit {
        public abstract Object clone();

        public abstract void submit(SubmitParams var1);

        public abstract void setPacketToIgnore(Node var1);

        public static class SubmitParams {
            private final String[] mPackets;
            private final String msSubmitUrl;
            private final int meFormat;
            private final boolean mbEmbedPDF;
            private String msTextEncoding;
            private String msCertificate;
            private List<SignDispatcher> mSignDispatchers;

            public SubmitParams(String[] packets, String sSubmitUrl, int eFormat, String sTextEncoding, boolean bEmbedPDF) {
                this.mPackets = packets;
                this.msSubmitUrl = sSubmitUrl;
                this.meFormat = eFormat;
                this.msTextEncoding = sTextEncoding;
                this.mbEmbedPDF = bEmbedPDF;
            }

            public String getCertificate() {
                return this.msCertificate;
            }

            public boolean getEmbedPDF() {
                return this.mbEmbedPDF;
            }

            public int getFormat() {
                return this.meFormat;
            }

            public String[] getPackets() {
                return this.mPackets;
            }

            public List<SignDispatcher> getSignDispatchers() {
                return this.mSignDispatchers;
            }

            public String getSubmitUrl() {
                return this.msSubmitUrl;
            }

            public String getTextEncoding() {
                return this.msTextEncoding;
            }

            public void setCertificate(String sCertificate) {
                this.msCertificate = sCertificate;
            }

            public void setSignDispatchers(List<SignDispatcher> poSD) {
                this.mSignDispatchers = poSD;
            }

            public void setTextEncoding(String sTextEncoding) {
                this.msTextEncoding = sTextEncoding;
            }
        }
    }

    public static abstract class ServerExchange {
        public void remerge() {
        }

        public abstract byte[] sendToServer(byte[] var1);
    }

    public static abstract class Execute {
        public abstract Object clone();

        public abstract void execute(String var1, int var2, int var3);
    }

    public static interface ConnectHandler {
        public boolean handleConnect(Node var1, String var2, String var3, String var4, Object var5, ObjectHolder<DataNode> var6);
    }
}

