/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.ut.StringUtils;

final class QNameImpl {
    public static final String XMLNS = "xmlns";
    private final String mNamespace;
    private final String mPrefix;
    private final String mLocalName;
    private final String mQName;

    QNameImpl(String name) {
        this.mNamespace = null;
        this.mPrefix = null;
        this.mQName = this.mLocalName = name.intern();
    }

    QNameImpl(String namespace, String prefix, String localName) {
        this.mPrefix = StringUtils.isEmpty(prefix) ? null : prefix.intern();
        this.mLocalName = localName.intern();
        if (this.mPrefix == null) {
            this.mQName = this.mLocalName;
        } else {
            StringBuilder builder = new StringBuilder(prefix);
            builder.append(':');
            builder.append(localName);
            this.mQName = builder.toString().intern();
        }
        this.mNamespace = StringUtils.isEmpty(namespace) ? null : namespace.intern();
    }

    String getNamespace() {
        return this.mNamespace;
    }

    String getPrefix() {
        return this.mPrefix;
    }

    String getLocalName() {
        return this.mLocalName;
    }

    String getQName() {
        return this.mQName;
    }
}

