/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.connectionset;

import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ObjectHolder;
import com.adobe.xfa.wspolicy.CompoundAssertion;
import com.adobe.xfa.wspolicy.Policy;
import com.adobe.xfa.wspolicy.PrimitiveAssertion;

public class EffectivePolicy
extends ProtoableNode {
    private CompoundAssertion moPolicy;

    public EffectivePolicy(Element oParent, Node oNode, Model oModel) {
        super(oParent, oNode);
    }

    protected EffectivePolicy(Element parent, Node prevSibling, int classTag, String className) {
        super(parent, prevSibling, null, className, className, null, classTag, className);
    }

    @Override
    public Element clone(Element oParent, boolean bDeep) {
        EffectivePolicy oClone = (EffectivePolicy)super.clone(oParent, bDeep);
        return oClone;
    }

    public void getTransportPolicy(BooleanHolder obHTTPS, BooleanHolder obBasic, BooleanHolder obDigest, BooleanHolder obHTTPCert) {
        CompoundAssertion oTransTokenPolicy;
        PrimitiveAssertion oHTTPSToken;
        CompoundAssertion oTransBindingPolicy;
        PrimitiveAssertion oTransToken;
        obHTTPS.value = false;
        obBasic.value = false;
        obDigest.value = false;
        obHTTPCert.value = false;
        if (this.moPolicy == null) {
            this.moPolicy = Policy.resolvePolicy(this);
        }
        if (this.moPolicy == null) {
            return;
        }
        PrimitiveAssertion oTransBinding = this.moPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "TransportBinding", 0);
        if (oTransBinding != null && oTransBinding.hasNestedPolicy() && (oTransToken = (oTransBindingPolicy = oTransBinding.getNestedPolicy()).getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "TransportToken", 0)) != null && oTransToken.hasNestedPolicy() && (oHTTPSToken = (oTransTokenPolicy = oTransToken.getNestedPolicy()).getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HttpsToken", 0)) != null) {
            obHTTPS.value = true;
            CompoundAssertion oHTTPSTokenPolicy = oHTTPSToken.getNestedPolicy();
            if (oHTTPSTokenPolicy != null) {
                PrimitiveAssertion oBasicToken;
                PrimitiveAssertion oDigestToken;
                PrimitiveAssertion oClientCertToken;
                Policy oPolicy = oHTTPSTokenPolicy.getFirstPolicyChild();
                if (oPolicy != null && oPolicy.getAssertionType() == 2) {
                    oHTTPSTokenPolicy = (CompoundAssertion)oPolicy;
                }
                if ((oClientCertToken = oHTTPSTokenPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireClientCertificate", 0)) != null) {
                    obHTTPCert.value = true;
                }
                if ((oDigestToken = oHTTPSTokenPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HttpDigestAuthentication", 0)) != null) {
                    obDigest.value = true;
                }
                if ((oBasicToken = oHTTPSTokenPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HttpBasicAuthentication", 0)) != null) {
                    obBasic.value = true;
                }
            }
        }
    }

    public void getSOAPPolicy(BooleanHolder oUsernameClearPwd, BooleanHolder oUsernameHashPwd, BooleanHolder oSOAPCert) {
        CompoundAssertion oSupTokensPolicy;
        oUsernameClearPwd.value = false;
        oUsernameHashPwd.value = false;
        oSOAPCert.value = false;
        if (this.moPolicy == null) {
            this.moPolicy = Policy.resolvePolicy(this.getXMLParent());
        }
        if (this.moPolicy == null) {
            return;
        }
        PrimitiveAssertion oSupTokens = this.moPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "SupportingTokens", 0);
        if (oSupTokens != null && oSupTokens.hasNestedPolicy() && (oSupTokensPolicy = oSupTokens.getNestedPolicy()) != null) {
            PrimitiveAssertion oX509Token;
            PrimitiveAssertion oHashPwdToken;
            CompoundAssertion oUsernameTokenPolicy;
            PrimitiveAssertion oUsernameToken;
            Policy oPolicy = oSupTokensPolicy.getFirstPolicyChild();
            if (oPolicy != null && oPolicy.getAssertionType() == 2) {
                oSupTokensPolicy = (CompoundAssertion)oPolicy;
            }
            if ((oUsernameToken = oSupTokensPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "UsernameToken", 0)) != null) {
                oUsernameTokenPolicy = oUsernameToken.getNestedPolicy();
                oHashPwdToken = null;
                if (oUsernameTokenPolicy != null) {
                    oHashPwdToken = oUsernameTokenPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HashPassword", 0);
                }
                if (oHashPwdToken == null) {
                    oUsernameClearPwd.value = true;
                } else {
                    oUsernameHashPwd.value = true;
                }
            }
            if ((oUsernameToken = oSupTokensPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "UsernameToken", 1)) != null) {
                oUsernameTokenPolicy = oUsernameToken.getNestedPolicy();
                oHashPwdToken = null;
                if (oUsernameTokenPolicy != null) {
                    oHashPwdToken = oUsernameTokenPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HashPassword", 0);
                }
                if (oHashPwdToken == null) {
                    oUsernameClearPwd.value = true;
                } else {
                    oUsernameHashPwd.value = true;
                }
            }
            if ((oX509Token = oSupTokensPolicy.getPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "X509Token", 0)) != null) {
                oSOAPCert.value = true;
            }
        }
    }

    public void setPolicy(boolean bHTTPS, boolean bBasic, boolean bDigest, boolean bHTTPCert, boolean bUsernameClearPwd, boolean bUsernameHashPwd, boolean bSOAPCert) {
        int count;
        Policy.deletePolicyInfo(this);
        this.moPolicy = null;
        this.makeDefault();
        if (bHTTPS || bBasic || bDigest || bHTTPCert || bUsernameClearPwd || bUsernameHashPwd || bSOAPCert) {
            Document oDoc = this.getOwnerDocument();
            ObjectHolder<Element> oPolicyNode = new ObjectHolder<Element>();
            this.moPolicy = Policy.newPolicy(oDoc, oPolicyNode);
            this.appendChild((Node)oPolicyNode.value);
            this.makeNonDefault(false);
        }
        if (bHTTPS || bBasic || bDigest || bHTTPCert) {
            PrimitiveAssertion oTransBinding = this.moPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "TransportBinding");
            CompoundAssertion oTransBindingPolicy = oTransBinding.addNestedPolicy();
            PrimitiveAssertion oTransToken = oTransBindingPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "TransportToken");
            CompoundAssertion oTransTokenPolicy = oTransToken.addNestedPolicy();
            PrimitiveAssertion oHTTPSToken = oTransTokenPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HttpsToken");
            int count2 = (bBasic ? 1 : 0) + (bDigest ? 1 : 0) + (bHTTPCert ? 1 : 0);
            if (count2 > 0) {
                CompoundAssertion oHTTPSTokenPolicy = oHTTPSToken.addNestedPolicy();
                if (count2 > 1) {
                    oHTTPSTokenPolicy = oHTTPSTokenPolicy.addChoicePolicy();
                }
                if (bBasic) {
                    oHTTPSTokenPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HttpBasicAuthentication");
                }
                if (bDigest) {
                    oHTTPSTokenPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HttpDigestAuthentication");
                }
                if (bHTTPCert) {
                    oHTTPSTokenPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireClientCertificate");
                }
            }
        }
        if ((count = (bUsernameClearPwd ? 1 : 0) + (bUsernameHashPwd ? 1 : 0) + (bSOAPCert ? 1 : 0)) > 0) {
            PrimitiveAssertion oSupTokens = this.moPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "SupportingTokens");
            CompoundAssertion oSupTokensPolicy = oSupTokens.addNestedPolicy();
            if (count > 1) {
                oSupTokensPolicy = oSupTokensPolicy.addChoicePolicy();
            }
            if (bUsernameClearPwd) {
                oSupTokensPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "UsernameToken");
            }
            if (bUsernameHashPwd) {
                PrimitiveAssertion oUsernameToken = oSupTokensPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "UsernameToken");
                CompoundAssertion oUsernameTokenPolicy = oUsernameToken.addNestedPolicy();
                oUsernameTokenPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "HashPassword");
            }
            if (bSOAPCert) {
                oSupTokensPolicy.addPrimitiveAssertion("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "X509Token");
            }
        }
    }
}

