/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Delta;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFAList;
import com.adobe.xfa.XMLMultiSelectNodeScript;
import com.adobe.xfa.service.canonicalize.Canonicalize;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class XMLMultiSelectNode
extends ProtoableNode {
    public XMLMultiSelectNode(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "#xml", "#xml", null, 2, "#xml");
    }

    public void addValue(String sItem, String sItemsName) {
        if (StringUtils.isEmpty(sItem)) {
            return;
        }
        Element oNewItem = new Element(this, null);
        oNewItem.setDOMProperties(null, sItemsName, sItemsName, null);
        Element poParent = this.getXMLParent();
        if (poParent != null) {
            poParent.notifyPeers(2, "", null);
        }
    }

    public void clearValues() {
        Node node = this.getFirstXMLChild();
        while (node != null) {
            Node next = node.getNextXMLSibling();
            this.removeChild(node);
            node = next;
        }
    }

    @Override
    public ProtoableNode createProto(Element pParent, boolean bFull) {
        return (ProtoableNode)this.clone(pParent, true);
    }

    @Override
    public void getDeltas(Element delta, XFAList list) {
        if (this.isSameClass(delta) && list != null) {
            Element parent = this.getXFAParent();
            Element deltaParent = delta.getXFAParent();
            Delta newDelta = new Delta(parent, deltaParent, this, delta, "");
            list.append(newDelta);
        }
    }

    @Override
    public ScriptTable getScriptTable() {
        return XMLMultiSelectNodeScript.getScriptTable();
    }

    public String getValue(boolean bAsFragment, boolean bSuppressPreamble) {
        StringBuilder sReturn = new StringBuilder();
        ArrayList<String> oItems = new ArrayList<String>();
        this.getValuesFromDom(oItems, this, bAsFragment, bSuppressPreamble);
        for (int i = 0; i < oItems.size(); ++i) {
            if (i != 0) {
                sReturn.append('\n');
            }
            sReturn.append((String)oItems.get(i));
        }
        return sReturn.toString();
    }

    public void getValues(List<String> oSelectionList) {
        this.getValuesFromDom(oSelectionList, this, false, false);
    }

    public void getValuesFromDom(List<String> xmlTextValues, Node oDomNode, boolean bAsFragment, boolean bSuppressPreamble) {
        if (bAsFragment) {
            ByteArrayOutputStream oFragmentStream = new ByteArrayOutputStream();
            DOMSaveOptions oOptions = new DOMSaveOptions();
            oOptions.setDisplayFormat(0);
            oOptions.setSaveTransient(true);
            oOptions.setEntityChars("\r");
            oOptions.setRangeMin('\u007f');
            oOptions.setRangeMax('\u00ff');
            oOptions.setExcludePreamble(bSuppressPreamble);
            oDomNode.getOwnerDocument().saveAs(oFragmentStream, oDomNode, oOptions);
            try {
                xmlTextValues.add(oFragmentStream.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            String sValue;
            TextNode oDomText;
            if (oDomNode instanceof TextNode && !(oDomText = (TextNode)oDomNode).isXMLSpace() && !StringUtils.isEmpty(sValue = oDomText.getValue())) {
                String[] tokens;
                String sSeparator = "\n";
                for (String sToken : tokens = sValue.split(sSeparator)) {
                    xmlTextValues.add(sToken);
                }
            }
            for (Node child = oDomNode.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                this.getValuesFromDom(xmlTextValues, child, bAsFragment, bSuppressPreamble);
            }
        }
    }

    public void setValue(String sData) {
        ArrayList<String> oSelectionList = new ArrayList<String>();
        if (!StringUtils.isEmpty(sData)) {
            String[] tokens = sData.split("\n");
            for (int i = 0; i < tokens.length; ++i) {
                oSelectionList.add(tokens[i]);
            }
        }
        this.setValuesToDom(oSelectionList, this);
    }

    public void setValues(List<String> oSelectionList) {
        this.setValuesToDom(oSelectionList, this);
    }

    public void setValuesToDom(List<String> oSelectionList, Element oDomNode) {
        int nNumberSelected = oSelectionList.size();
        Node oChild = this.getFirstXMLChild();
        String aElementName = "";
        if (oChild == null) {
            aElementName = "value";
        } else {
            aElementName = oChild.getName();
            if (aElementName == "") {
                aElementName = "value";
            }
        }
        while (oChild != null) {
            Node oNext = oChild.getNextXMLSibling();
            this.removeChild(oNext);
            oChild = oNext;
        }
        for (int i = 0; i < nNumberSelected; ++i) {
            Element oNewItem = new Element(oDomNode, null);
            oNewItem.setDOMProperties(null, aElementName, aElementName, null);
            this.getModel().createTextNode(oNewItem, null, oSelectionList.get(i));
        }
        this.makeNonDefault(false);
        Element poParent = this.getXMLParent();
        if (poParent != null) {
            poParent.notifyPeers(2, "", null);
        }
    }

    public String toString() {
        return this.getValue(false, false);
    }

    @Override
    protected boolean compareVersions(Node oRollback, Node oContainer, Node.ChangeLogger oChangeLogger, Object oUserData) {
        boolean bMatches = super.compareVersions(oRollback, oContainer, oChangeLogger, oUserData);
        if (!bMatches && oChangeLogger == null) {
            return false;
        }
        if (this.getClassAtom() != oRollback.getClassAtom()) {
            return false;
        }
        String sCanonicalSource = "";
        String sCanonicalRollback = "";
        Canonicalize c = new Canonicalize(this, false, true);
        byte[] pBuffer = c.canonicalize(2, null);
        try {
            sCanonicalSource = new String(pBuffer, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        Canonicalize cRollBack = new Canonicalize(oRollback, false, true);
        pBuffer = cRollBack.canonicalize(2, null);
        try {
            sCanonicalRollback = new String(pBuffer, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        if (!sCanonicalSource.equals(sCanonicalRollback)) {
            bMatches = false;
            if (oChangeLogger != null) {
                this.logValueChangeHelper(oContainer, sCanonicalSource, oChangeLogger, oUserData);
            }
        }
        return bMatches;
    }
}

