/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.ut.StringUtils;

public final class StringAttr
extends Attribute {
    private final String mNS;

    public StringAttr(String NS, String localName, String qName, String value) {
        this(NS, localName, qName, value, true);
    }

    public StringAttr(String qName, String value) {
        super(null, null, qName, value);
        this.mNS = null;
    }

    public StringAttr(String NS, String localName, String qName, String value, boolean internSymbols) {
        super(NS, localName, qName, value, internSymbols);
        if (internSymbols && NS != null) {
            NS = NS.intern();
        }
        this.mNS = NS;
    }

    @Override
    public Attribute newAttribute(String value) {
        return this.newAttribute(this.getNS(), this.getName(), this.getQName(), value, false);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value, boolean internSymbols) {
        boolean bIsEmpty = StringUtils.isEmpty(value);
        if (bIsEmpty) {
            value = this.getAttrValue();
        }
        return new StringAttr(NS, localName, qName, value, internSymbols);
    }

    @Override
    public String getNS() {
        return this.mNS;
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value) {
        return this.newAttribute(NS, localName, qName, value, true);
    }
}

