/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ut.ExFull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ScriptFuncObj {
    private final Class<?> mClass;
    private final String msName;
    private final int meRetType;
    private final int[] meParamTypes;
    private final int mnMinParam;
    private final int mnXFAVersion;
    private final int mnAvailability;
    private final int mnVersionDep;
    private final Method mMethod;
    private final boolean mbHasMethodDep;
    private final Method mPermsMethod;

    public ScriptFuncObj(Class<?> clazz, String name, String sFunc, int eRetType, int[] paramTypes, int minParams, int nVersion, int nAvailability, int nVersionDep) {
        this(clazz, name, sFunc, eRetType, paramTypes, minParams, nVersion, nAvailability, null, nVersionDep);
    }

    public ScriptFuncObj(Class<?> clazz, String sName, String sFunc, int eRetType, int[] paramTypes, int minParams, int nVersion, int nAvailability, String sPermsMethod, int nVersionDep) {
        Method m;
        block14: {
            boolean bHasMethodDep;
            block13: {
                assert (clazz != null);
                assert (sName != null);
                assert (sFunc != null);
                assert (paramTypes != null);
                this.mClass = clazz;
                this.msName = sName;
                this.meRetType = eRetType;
                this.meParamTypes = paramTypes;
                this.mnMinParam = minParams;
                this.mnXFAVersion = nVersion;
                this.mnAvailability = nAvailability;
                this.mnVersionDep = nVersionDep;
                bHasMethodDep = false;
                m = null;
                try {
                    m = this.mClass.getMethod(sFunc, Obj.class, Arg.class, Arg[].class);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                if (m == null) {
                    try {
                        m = this.mClass.getMethod(sFunc, Obj.class, Arg.class, Arg[].class, DependencyTracker.class);
                        bHasMethodDep = true;
                    }
                    catch (NoSuchMethodException ex) {
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError();
                    }
                }
            }
            this.mMethod = m;
            this.mbHasMethodDep = bHasMethodDep;
            m = null;
            if (sPermsMethod != null) {
                try {
                    m = this.mClass.getMethod(sPermsMethod, Obj.class, Arg[].class);
                    assert (m.getReturnType() == Boolean.TYPE);
                }
                catch (NoSuchMethodException ex) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError();
                }
            }
        }
        this.mPermsMethod = m;
    }

    public boolean invoke(Obj scriptThis, Arg retVal, Arg[] parms, DependencyTracker dependencyTracker) {
        boolean bError = false;
        try {
            if (this.hasDependencyTracker()) {
                this.mMethod.invoke((Object)scriptThis, scriptThis, retVal, parms, dependencyTracker);
            } else {
                this.mMethod.invoke((Object)scriptThis, scriptThis, retVal, parms);
            }
        }
        catch (IllegalAccessException e3) {
            bError = true;
        }
        catch (InvocationTargetException e2) {
            Throwable t = e2.getCause();
            if (t instanceof ExFull) {
                ((ExFull)t).resolve();
                throw (ExFull)t;
            }
            bError = true;
        }
        return bError;
    }

    public boolean invokePermsFunc(Obj scriptThis, Arg[] parms) {
        boolean bAllow;
        block5: {
            if (this.mPermsMethod == null) {
                return true;
            }
            bAllow = false;
            try {
                Boolean bResult = (Boolean)this.mPermsMethod.invoke(null, scriptThis, parms);
                bAllow = bResult;
            }
            catch (IllegalAccessException ex) {
                assert (false);
            }
            catch (InvocationTargetException ex) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        return bAllow;
    }

    public int getMinParam() {
        return this.mnMinParam;
    }

    public int[] getParamTypes() {
        return this.meParamTypes;
    }

    public String getName() {
        return this.msName;
    }

    public int getXFAVersion() {
        return this.mnXFAVersion;
    }

    public int getAvailability() {
        return this.mnAvailability;
    }

    public int getVersionDeprecated() {
        return this.mnVersionDep;
    }

    public int getRetType() {
        return this.meRetType;
    }

    public boolean hasDependencyTracker() {
        return this.mbHasMethodDep;
    }
}

