/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.ut.UnitSpan;

public final class Measurement
extends Attribute {
    private UnitSpan mValue;

    public Measurement(String qName, String value) {
        super(null, null, qName, value);
    }

    public Measurement(Attribute attr) {
        super(attr.getNS(), attr.getName(), attr.getQName(), attr.toString());
    }

    private Measurement(String NS, String localName, String qName, String value, boolean internSymbols) {
        super(NS, localName, qName, value, internSymbols);
    }

    public Measurement(UnitSpan unit) {
        super(null, unit.toString());
        this.mValue = unit;
    }

    public int getUnits() {
        if (this.mValue == null) {
            this.mValue = new UnitSpan(this.getAttrValue());
        }
        int eCode = this.mValue.units();
        switch (eCode) {
            case 0: 
            case 3: {
                return 3932161;
            }
            case 1: {
                return 3932162;
            }
            case 17: {
                return 0x3C0003;
            }
            case 19: {
                return 0x3C0000;
            }
            case 35: {
                return 3932164;
            }
            case 51: {
                return 3932165;
            }
        }
        return -1;
    }

    public UnitSpan getUnitSpan() {
        if (this.mValue == null) {
            this.mValue = new UnitSpan(this.getAttrValue());
        }
        return this.mValue;
    }

    public double getValue() {
        return this.getValueAsUnit(this.getUnits());
    }

    public double getValueAsUnit(int units) {
        return Measurement.getValueAsUnit(this.getUnitSpan(), units);
    }

    public static double getValueAsUnit(UnitSpan oSpan, int units) {
        double dRet = 0.0;
        if (units == 3932161) {
            dRet = (double)oSpan.valueAsUnit(3) / 72000.0;
        } else if (units == 0x3C0003) {
            dRet = (double)oSpan.valueAsUnit(17) / 25000.0;
        } else if (units == 0x3C0000) {
            dRet = (double)oSpan.valueAsUnit(19) / 1000.0;
        } else if (units == 3932162) {
            dRet = (double)oSpan.valueAsUnit(1) / 250000.0;
        } else if (units == 3932164) {
            dRet = oSpan.valueAsUnit(35);
        } else if (units == 3932165) {
            dRet = oSpan.valueAsUnit(51);
        }
        return dRet;
    }

    @Override
    public Attribute newAttribute(String value) {
        return this.newAttribute(this.getNS(), this.getLocalName(), this.getQName(), value, false);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value) {
        return this.newAttribute(NS, localName, qName, value, true);
    }

    @Override
    public Attribute newAttribute(String NS, String localName, String qName, String value, boolean internSymbols) {
        return new Measurement(NS, localName, qName, value, internSymbols);
    }

    @Override
    public void normalize() {
        if (this.mValue == null) {
            this.mValue = new UnitSpan(this.getAttrValue());
            this.setAttrValue(this.mValue.toString());
        }
    }

    @Override
    public String toString() {
        if (this.mValue == null) {
            this.mValue = new UnitSpan(this.getAttrValue());
        }
        return this.mValue.toString();
    }
}

