/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Element;
import com.adobe.xfa.LogMessage;
import com.adobe.xfa.LogMessageData;
import com.adobe.xfa.LogMessageHandler;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogMessenger {
    private int meSeverity = 2;
    private final List<LogMessageHandler> mMsgHandlerArray = new ArrayList<LogMessageHandler>();
    private final Map<Integer, Integer> mSeverityMap = new HashMap<Integer, Integer>();
    private final List<LogMessage> mStoredMsgArray = new ArrayList<LogMessage>();

    public LogMessenger() {
    }

    public LogMessenger(LogMessageHandler handler, String sAppContext) {
        handler.setAppContext(sAppContext);
        this.addHandler(handler, "");
    }

    public void addHandler(LogMessageHandler handler, String sAppContext) {
        int n = this.mStoredMsgArray.size();
        for (int i = 0; i < n; ++i) {
            handler.sendMessage(this.mStoredMsgArray.get(i));
        }
        handler.setAppContext(sAppContext);
        this.mMsgHandlerArray.add(handler);
    }

    void checkMessaging(String sContext, Model model, ExFull exFull) {
        boolean bFound = false;
        if (model == null) {
            throw exFull;
        }
        Node messaging = model.resolveNode(sContext + ".messaging");
        if (messaging == null || messaging.getNodes().length() == 0) {
            throw exFull;
        }
        NodeList nodeList = messaging.getNodes();
        for (int nExInd = 0; nExInd < exFull.count(); ++nExInd) {
            Element msgId;
            int nExId = exFull.getResId(nExInd);
            for (int nMsInd = nodeList.length(); nMsInd > 0 && (msgId = (Element)((Element)nodeList.item(nMsInd - 1)).resolveNode("msgId")) != null; --nMsInd) {
                int nMessageId = 0;
                String sValue = msgId.getText(false, false, false).getValue();
                try {
                    nMessageId = Integer.parseInt(sValue);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                if (nMessageId != nExId) continue;
                bFound = true;
                int eSeverity = 6;
                Element severity = (Element)((Node)nodeList.item(nMsInd - 1)).resolveNode("severity");
                if (severity != null) {
                    String sSeverity = severity.getText(false, false, false).getValue();
                    if (sSeverity.equals("ignore")) {
                        eSeverity = 0;
                    } else if (sSeverity.equals("warning")) {
                        eSeverity = 3;
                    } else if (sSeverity.equals("information")) {
                        eSeverity = 2;
                    } else if (sSeverity.equals("error")) {
                        eSeverity = 6;
                    } else if (sSeverity.equals("trace")) {
                        eSeverity = 1;
                    } else if (!StringUtils.isEmpty(sSeverity)) {
                        MsgFormatPos oFormat = new MsgFormatPos(ResId.InvalidOptionValueException);
                        oFormat.format("severity");
                        oFormat.format(sSeverity);
                        throw new ExFull(oFormat);
                    }
                }
                if (eSeverity == 6) {
                    throw exFull;
                }
                if (eSeverity == 0) break;
                LogMessage exceptionMessage = new LogMessage(exFull, eSeverity);
                this.sendMessage(exceptionMessage);
                break;
            }
            if (bFound) continue;
            throw exFull;
        }
    }

    List<LogMessageHandler> enumerateHandlers() {
        return this.mMsgHandlerArray;
    }

    public int getSeverity() {
        return this.meSeverity;
    }

    void removeAll() {
        this.mMsgHandlerArray.clear();
    }

    void removeHandler(int nIndex) {
        if (nIndex < this.mMsgHandlerArray.size()) {
            this.mMsgHandlerArray.remove(nIndex);
        }
    }

    public void removeStoredMessages() {
        this.mStoredMsgArray.clear();
    }

    public void flush() {
        int size = this.mMsgHandlerArray.size();
        for (int i = 0; i < size; ++i) {
            this.mMsgHandlerArray.get(i).flush();
        }
    }

    void sendMessage(ExFull source, int eSeverity) {
        LogMessage oMessage = new LogMessage(source, eSeverity);
        this.sendMessage(oMessage);
    }

    public void sendMessage(int nId, String sText, int eSeverity) {
        LogMessage oMessage = new LogMessage(nId, sText, eSeverity);
        this.sendMessage(oMessage);
    }

    public void sendMessage(LogMessage message) {
        int eMessageSeverity = message.getSeverity();
        int nSize = this.mSeverityMap.size();
        if (nSize > 0) {
            int nUpdatedMessageSeverity = 0;
            int nCount = message.count();
            for (int i = 0; i < nCount; ++i) {
                int nMapSeverity;
                LogMessageData msgLogData = message.get(i);
                int nMsgLogId = msgLogData.getId();
                int nMsgLogSeverity = msgLogData.getSeverity();
                if (!this.mSeverityMap.containsKey(nMsgLogId) && nMsgLogSeverity != (nMapSeverity = this.mSeverityMap.get(nMsgLogId).intValue())) {
                    nMsgLogSeverity = nMapSeverity;
                    msgLogData.setSeverity(nMsgLogSeverity);
                }
                if (nMsgLogSeverity <= nUpdatedMessageSeverity) continue;
                nUpdatedMessageSeverity = nMsgLogSeverity;
            }
            eMessageSeverity = nUpdatedMessageSeverity;
            message.setSeverity(eMessageSeverity);
        }
        if (eMessageSeverity > this.getSeverity()) {
            this.setSeverity(eMessageSeverity);
        }
        if (eMessageSeverity != 0) {
            int size = this.mMsgHandlerArray.size();
            for (int i = 0; i < size; ++i) {
                this.mMsgHandlerArray.get(i).sendMessage(message);
            }
            if (size == 0) {
                this.mStoredMsgArray.add(message);
            }
        }
    }

    void sendMessage(MsgFormatPos source, int eSeverity) {
        LogMessage oMessage = new LogMessage(source, eSeverity);
        this.sendMessage(oMessage);
    }

    private void setSeverity(int eSeverity) {
        this.meSeverity = eSeverity;
    }

    public List<LogMessage> storedMsgArray() {
        return this.mStoredMsgArray;
    }

    public void updateMessaging(Model model) {
        if (model != null) {
            Node messaging;
            Node context = model.getContext();
            if (model == context) {
                context = model.resolveNode("present.common");
            }
            if ((messaging = context.resolveNode("messaging")) != null && messaging.getFirstXFAChild() != null) {
                Node message;
                Element msgId;
                NodeList nodeList = messaging.getNodes();
                for (int i = 0; i < nodeList.length() && (msgId = (Element)(message = (Node)nodeList.item(i)).resolveNode("msgId")) != null; ++i) {
                    int nMessageId = 0;
                    try {
                        TextNode textNode = msgId.getText(true, false, false);
                        if (textNode != null) {
                            nMessageId = Integer.parseInt(textNode.getValue());
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    Element severity = (Element)message.resolveNode("severity");
                    int eSeverity = 0;
                    if (severity != null) {
                        String sSeverity = "";
                        TextNode textNode = severity.getText(true, false, false);
                        if (textNode != null) {
                            sSeverity = textNode.getValue();
                        }
                        if (sSeverity.equals("ignore")) {
                            eSeverity = 0;
                        } else if (sSeverity.equals("warning")) {
                            eSeverity = 3;
                        } else if (sSeverity.equals("information")) {
                            eSeverity = 2;
                        } else if (sSeverity.equals("error")) {
                            eSeverity = 6;
                        } else if (sSeverity.equals("trace")) {
                            eSeverity = 1;
                        } else {
                            MsgFormatPos format = new MsgFormatPos(ResId.InvalidOptionValueException);
                            format.format("severity").format(sSeverity);
                            throw new ExFull(format);
                        }
                    }
                    this.mSeverityMap.put(nMessageId, eSeverity);
                }
            }
        }
    }
}

