/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.ProcessingInstruction;

public final class Generator {
    public static final int XFAGen_Unknown = 0;
    public static final int XFAGen_FF99V250_01 = 1;
    public static final int XFAGen_FF99V310 = 2;
    public static final int XFAGen_JDV530_01 = 3;
    public static final int XFAGen_FF99V40 = 4;
    public static final int XFAGen_FF99V50 = 5;
    public static final int XFAGen_AdobeDesignerV60 = 50;
    public static final int XFAGen_TemplateDesignerV60d = 51;
    public static final int XFAGen_AdobeDesignerV60_SAP = 52;
    public static final int XFAGen_AdobeDesignerV70 = 53;
    public static final int XFAGen_AdobeDesignerV70_SAP = 54;
    public static final int XFAGen_AdobeDesignerV71 = 55;
    public static final int XFAGen_AdobeDesignerV71_SAP = 56;
    public static final int XFAGen_AdobeDesignerV80 = 57;
    public static final int XFAGen_AdobeDesignerV80_SAP = 58;
    public static final int XFAGen_XDCV_1_0 = 100;
    public static final int XFAGen_XDCV_1_1 = 101;
    public static final int XFAGen_XDCV_1_3 = 102;
    public static final int XFAGen_XDCV_2_0 = 103;
    public static final int XFAGen_2_0 = 150;
    public static final int XFAGen_2_4 = 154;
    private int meTag = 0;
    private String msName;
    private String msAPIVersion = "";
    private int mnBuildNumber;

    public Generator(String sGenerator, String sAPIVersion) {
        this.msName = sGenerator;
        this.msAPIVersion = sAPIVersion;
        this.mnBuildNumber = 0;
        this.setEnum();
    }

    public Generator(ProcessingInstruction pi) {
        if (pi.getName() != "xfa") {
            return;
        }
        String[] parameters = pi.getData().split("[\" '=\t]");
        block0: for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].equals("generator")) {
                ++i;
                while (i < parameters.length) {
                    if (parameters[i].length() > 0) {
                        this.msName = parameters[i];
                        ++i;
                        break;
                    }
                    ++i;
                }
            }
            while (i < parameters.length && parameters[i].length() == 0) {
                ++i;
            }
            if (i >= parameters.length || !parameters[i].equals("APIVersion") || i + 1 >= parameters.length) continue;
            ++i;
            while (i < parameters.length) {
                if (parameters[i].length() > 0) {
                    this.msAPIVersion = parameters[i];
                    continue block0;
                }
                ++i;
            }
        }
        this.setEnum();
    }

    private void setEnum() {
        String sGenerator = this.msName;
        this.meTag = sGenerator.equals("FF99V250_01") ? 1 : (sGenerator.equals("FF99V310") ? 2 : (sGenerator.equals("JDV530_01") ? 3 : (sGenerator.equals("FF99V40") ? 4 : (sGenerator.equals("FF99V50") ? 5 : (sGenerator.equals("XDCEDIT_V1.0") ? 100 : (sGenerator.equals("XDCEDIT_V1.1") ? 101 : (sGenerator.equals("XDCEDIT_V1.3") ? 102 : (sGenerator.equals("XDCEDIT_V2.0") ? 103 : (sGenerator.equals("AdobeDesigner_V6.0") ? 50 : (sGenerator.equals("Template_Designer_V6.0d") ? 51 : (sGenerator.equals("AdobeDesigner_V6.0_SAP") ? 52 : (sGenerator.equals("AdobeDesigner_V7.0") ? 53 : (sGenerator.equals("AdobeDesigner_V7.0_SAP") ? 54 : (sGenerator.equals("AdobeDesigner_V7.1") ? 55 : (sGenerator.equals("AdobeDesigner_V7.1_SAP") ? 56 : (sGenerator.equals("AdobeLiveCycleDesigner_V8.0") ? 57 : (sGenerator.equals("AdobeLiveCycleDesigner_V8.0_SAP") ? 58 : (sGenerator.equals("XFA2_0") ? 150 : (sGenerator.equals("XFA2_4") ? 154 : 0)))))))))))))))))));
        int nFoundAt = this.msAPIVersion.indexOf(".");
        if (nFoundAt > 0) {
            ++nFoundAt;
            nFoundAt = this.msAPIVersion.indexOf(".", nFoundAt);
        }
        String sBuildNumber = null;
        if (nFoundAt > 0 && (nFoundAt = (sBuildNumber = this.msAPIVersion.substring(nFoundAt + 1)).indexOf(".")) > 0) {
            sBuildNumber = sBuildNumber.substring(0, nFoundAt);
        }
        if (sBuildNumber != null && sBuildNumber.length() > 0) {
            try {
                this.mnBuildNumber = Integer.parseInt(sBuildNumber);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.msName;
    }

    public String getAPIVersion() {
        return this.msAPIVersion;
    }

    public int getBuildNumber() {
        return this.mnBuildNumber;
    }

    public int generator() {
        return this.meTag;
    }
}

